/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaIdentity;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class YangJavaIdentityTranslator
extends YangJavaIdentity
implements JavaCodeGeneratorInfo,
JavaCodeGenerator {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private transient JavaImportData importData;
    private transient TempJavaCodeFragmentFiles tempFileHandle;

    public YangJavaIdentityTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.getJavaFileInfo().setGeneratedFileTypes(8207);
        this.importData = new JavaImportData();
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("Missing java info in java datamodel node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        try {
            YangJavaModelUtils.updatePackageInfo(this, yangPlugin);
            JavaQualifiedTypeInfoTranslator basePkgInfo = new JavaQualifiedTypeInfoTranslator();
            String className = YangIoUtils.getCapitalCase(this.getJavaFileInfo().getJavaName());
            String path = this.getJavaFileInfo().getPackageFilePath();
            JavaIdentifierSyntax.createPackage(this);
            List<String> imports = null;
            if (this.getBaseNode() != null && this.getBaseNode().getReferredIdentity() != null) {
                if (!(this.getBaseNode().getReferredIdentity() instanceof YangJavaIdentityTranslator)) {
                    throw new TranslatorException("Failed to prepare generate code entry for base node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
                }
                YangJavaIdentityTranslator baseIdentity = (YangJavaIdentityTranslator)this.getBaseNode().getReferredIdentity();
                String baseClassName = YangIoUtils.getCapitalCase(baseIdentity.getJavaFileInfo().getJavaName());
                String basePkg = baseIdentity.getJavaFileInfo().getPackage();
                basePkgInfo.setClassInfo(baseClassName);
                basePkgInfo.setPkgInfo(basePkg);
                boolean isQualified = this.importData.addImportInfo(basePkgInfo, className, this.getJavaFileInfo().getPackage());
                if (!isQualified) {
                    imports = this.importData.getImports();
                }
            }
            File file = JavaFileGeneratorUtils.getFileObject(path, className, JAVA_FILE_EXTENSION, this.getJavaFileInfo());
            JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 2048, imports, this, className);
            file = YangIoUtils.validateLineLength(file);
            FileSystemUtil.closeFile(file, false);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code entry for identity node " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
    }
}

