/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.util.Collections;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.StringGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaCodeSnippetGen {
    private JavaCodeSnippetGen() {
    }

    public static String getFileHeaderComment() {
        return null;
    }

    static String getImportText(JavaQualifiedTypeInfoTranslator importInfo) {
        return StringGenerator.getImportString(importInfo.getPkgInfo(), importInfo.getClassInfo());
    }

    public static String getJavaAttributeDefinition(String typePkg, String attrType, String attrName, boolean isList, String accessType, YangCompilerAnnotation annotation) {
        StringBuilder attrDef = new StringBuilder("    ");
        attrDef.append(accessType).append(" ");
        if (!isList) {
            if (typePkg != null) {
                attrDef.append(typePkg).append(".");
            }
            attrDef.append(attrType).append(" ").append(attrName);
            if (attrName.equals("selectLeafFlags") || attrName.equals("valueLeafFlags")) {
                attrDef.append(" ").append("=").append(" ").append("new").append(" ").append("BitSet").append("()");
            } else if (attrName.equals("yangAugmentedInfoMap")) {
                attrDef.append(" ").append("=").append(" ").append("new").append(" ").append("HashMap").append("<>").append("()");
            }
            attrDef.append(StringGenerator.signatureClose());
        } else {
            JavaCodeSnippetGen.addAttrStartDef(annotation, attrDef);
            if (typePkg != null) {
                attrDef.append(typePkg).append(".");
            }
            attrDef.append(attrType);
            JavaCodeSnippetGen.addAttrEndDef(attrDef, attrName);
        }
        return attrDef.toString();
    }

    private static void addAttrStartDef(YangCompilerAnnotation annotation, StringBuilder attrDef) {
        if (annotation != null && annotation.getYangAppDataStructure() != null) {
            switch (annotation.getYangAppDataStructure().getDataStructure()) {
                case QUEUE: {
                    attrDef.append("Queue").append("<");
                    break;
                }
                case SET: {
                    attrDef.append("Set").append("<");
                    break;
                }
                default: {
                    attrDef.append("List").append("<");
                    break;
                }
            }
        } else {
            attrDef.append("List").append("<");
        }
    }

    private static void addAttrEndDef(StringBuilder attrDef, String attrName) {
        attrDef.append(">").append(" ").append(attrName).append(StringGenerator.signatureClose());
    }

    public static String generateEnumAttributeString(String name, int value) {
        String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(name);
        return JavaDocGen.enumJavaDocForInnerClass(name) + "        " + enumName.toUpperCase() + StringGenerator.getOpenCloseParaWithValue(value + "") + "," + "\n";
    }

    public static String generateEnumAttributeStringWithSchemaName(String name, int value) {
        String enumName = JavaIdentifierSyntax.getEnumJavaAttribute(name);
        String str = value + "," + " " + "\"" + name + "\"";
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ENUM_ATTRIBUTE, name, false, null) + "    " + enumName.toUpperCase() + StringGenerator.getOpenCloseParaWithValue(str) + "," + "\n";
    }

    public static List<String> sortImports(List<String> imports) {
        Collections.sort(imports);
        return imports;
    }

    static String getEventEnumTypeStart() {
        return "\n    " + StringGenerator.getDefaultDefinition("enum", "Type", "public");
    }

    public static void addListenersImport(YangNode curNode, List<String> imports, UtilConstants.Operation operation) {
        TempJavaServiceFragmentFiles tempFiles = ((JavaCodeGeneratorInfo)((Object)curNode)).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String thisImport = tempFiles.getJavaImportData().getListenerServiceImport();
        JavaCodeSnippetGen.performOperationOnImports(imports, thisImport, operation);
    }

    private static List<String> performOperationOnImports(List<String> imports, String curImport, UtilConstants.Operation operation) {
        switch (operation) {
            case ADD: {
                imports.add(curImport);
                break;
            }
            case REMOVE: {
                imports.remove(curImport);
                break;
            }
            default: {
                throw new TranslatorException("Invalid operation type");
            }
        }
        JavaCodeSnippetGen.sortImports(imports);
        return imports;
    }

    static String getEnumsValueAttribute(String className) {
        return JavaCodeSnippetGen.getJavaAttributeDefinition(null, "int", className, false, "private", null) + JavaCodeSnippetGen.getJavaAttributeDefinition(null, "String", "schemaName", false, "private", null) + "\n";
    }

    static String addStaticAttributeIntRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int INT32_MIN_RANGE = -2147483648;\n", "static final int INT32_MAX_RANGE = 2147483647;");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int UINT16_MIN_RANGE = 0;\n", "static final int UINT16_MAX_RANGE = 2147483647;");
    }

    static String addStaticAttributeLongRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final BigInteger INT64_MIN_RANGE = new BigInteger(\"-9223372036854775808\");\n", "static final BigInteger INT64_MAX_RANGE = new BigInteger(\"9223372036854775807\");");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final BigInteger UINT32_MIN_RANGE = new BigInteger(\"0\");\n", "static final BigInteger UINT32_MAX_RANGE = new BigInteger(\"9223372036854775807\");");
    }

    static String addStaticAttributeShortRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int INT16_MIN_RANGE = -32768;\n", "static final int INT16_MAX_RANGE = 32767;");
        }
        return JavaCodeSnippetGen.getTypeConflictAttributeStrings(modifier, "static final int UINT8_MIN_RANGE = 0;\n", "static final int UINT8_MAX_RANGE = 32767;");
    }

    private static String getTypeConflictAttributeStrings(String modifier, String attr1, String att2) {
        return "    " + modifier + " " + attr1 + "    " + modifier + " " + att2 + "\n";
    }

    static String getOperationTypeEnum() {
        return "    /**\n     * Specify the node specific operation in protocols like NETCONF.\n     * Applicable in protocol edit operation, not applicable in query operation\n     */\n    public static enum OnosYangOpType {\n        MERGE,\n        REPLACE,\n        CREATE,\n        DELETE,\n        REMOVE,\n        NONE\n    }\n";
    }

    static String getYangAugmentedMapObjectForConstruct() {
        return "        this.yangAugmentedInfoMap = builderObject.yangAugmentedInfoMap();\n";
    }

    static String getSetValueParaForUnionClass() {
        String[] array = new String[]{"\n", ";"};
        return YangIoUtils.trimAtLast(JavaCodeSnippetGen.getJavaAttributeDefinition(null, "BitSet", "setValue", false, "private", null), array) + " " + "=" + " " + "new" + " " + "BitSet" + "()" + StringGenerator.signatureClose();
    }
}

