/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.utils.BracketType;
import org.onosproject.yangutils.translator.tojava.utils.IndentationType;
import org.onosproject.yangutils.translator.tojava.utils.MethodBodyTypes;
import org.onosproject.yangutils.translator.tojava.utils.MethodClassTypes;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.SubtreeFilteringMethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.ValidatorTypeForUnionTypes;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class StringGenerator {
    private static final Set<YangDataTypes> PRIMITIVE_TYPES = new HashSet<YangDataTypes>(Arrays.asList(YangDataTypes.INT8, YangDataTypes.INT16, YangDataTypes.INT32, YangDataTypes.INT64, YangDataTypes.UINT8, YangDataTypes.UINT16, YangDataTypes.UINT32, YangDataTypes.UINT64, YangDataTypes.DECIMAL64, YangDataTypes.BOOLEAN, YangDataTypes.EMPTY));

    private StringGenerator() {
    }

    static String getCompareToString() {
        return ".compareTo";
    }

    static String getLesserThanCondition() {
        return " <= ";
    }

    static String getGreaterThanCondition() {
        return " >= ";
    }

    static String ifAndAndCondition(String cond1, String cond2) {
        return cond1 + " " + "&" + "&" + " " + cond2;
    }

    static String ifEqualEqualCondition(String cond1, String cond2) {
        return cond1 + " " + "=" + "=" + " " + cond2;
    }

    static String getNewInstance(String returnType, String varName, String space, String value) {
        return space + returnType + " " + varName + " " + "=" + " " + "new" + " " + returnType + StringGenerator.getOpenCloseParaWithValue(value) + StringGenerator.signatureClose();
    }

    static String getReturnString(String value, String space) {
        return space + "return" + " " + value;
    }

    static String getNewLineAndSpace(String space) {
        return "\n" + space;
    }

    public static String methodClose(IndentationType type) {
        switch (type) {
            case EIGHT_SPACE: {
                return "        }\n";
            }
            case TWELVE_SPACE: {
                return "            }\n";
            }
            case SIXTEEN_SPACE: {
                return "                }\n";
            }
            case TWENTY_SPACE: {
                return "                    }\n";
            }
            case TWENTY_EIGHT_SPACE: {
                return "                            }\n";
            }
            case TWENTY_FOUR_SPACE: {
                return "                        }\n";
            }
            case FOUR_SPACE: {
                return "    }\n";
            }
        }
        return "}\n";
    }

    static String methodBody(MethodBodyTypes type, String paraName, String methodName, String space, String prefix, String paramType, boolean isBuilderSetter, String setterVal) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case GETTER: {
                return StringGenerator.getReturnString(paraName, space);
            }
            case SETTER: {
                if (setterVal == null) {
                    setterVal = paraName;
                }
                String body = space + "this" + "." + paraName + " " + "=" + " " + setterVal + StringGenerator.signatureClose();
                builder.append(body);
                if (isBuilderSetter) {
                    body = StringGenerator.getReturnString("this" + StringGenerator.signatureClose(), space);
                    builder.append(body);
                }
                return builder.toString();
            }
            case BUILD: {
                return StringGenerator.getReturnString("new " + paraName + StringGenerator.getOpenCloseParaWithValue("this") + StringGenerator.signatureClose(), space);
            }
            case CONSTRUCTOR: {
                return space + "this" + "." + paraName + " " + "=" + " " + "builder" + "Object" + "." + prefix + methodName + StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET, null, null) + StringGenerator.signatureClose();
            }
            case DEFAULT_CONSTRUCTOR: {
                return "";
            }
            case ADD_TO_LIST: {
                return space + MethodsGenerator.getIfConditionForAddToListMethod(paraName) + space + paraName + StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET, null, null) + "." + "add" + StringGenerator.getOpenCloseParaWithValue("value") + StringGenerator.signatureClose() + StringGenerator.getReturnString("this" + StringGenerator.signatureClose(), space);
            }
            case AUGMENTED_MAP_ADD: {
                return space + "yangAugmentedInfoMap" + "." + "put" + "(" + "class" + "Object" + "," + " " + "value" + ")" + StringGenerator.signatureClose();
            }
            case AUGMENTED_MAP_GET_VALUE: {
                return StringGenerator.getReturnString("yangAugmentedInfoMap.get" + StringGenerator.getOpenCloseParaWithValue("classObject") + StringGenerator.signatureClose(), space);
            }
            case AUGMENTED_MAP_GETTER: {
                return StringGenerator.getReturnString("yangAugmentedInfoMap" + StringGenerator.signatureClose(), space);
            }
            case MANAGER_METHODS: {
                String body = space + "//TODO: YANG utils generated code" + "\n";
                builder.append(body);
                if (paramType != null) {
                    body = StringGenerator.getReturnString(StringGenerator.parseTypeForReturnValue(paramType), space);
                    builder.append(body).append(StringGenerator.signatureClose());
                }
                return builder.toString();
            }
            case OF_METHOD: {
                return StringGenerator.getReturnString("new " + paraName + StringGenerator.getOpenCloseParaWithValue("value") + StringGenerator.signatureClose(), space);
            }
            case TO_STRING: {
                return StringGenerator.getToStringMethodsAddString(space, paraName) + paraName + ")";
            }
        }
        return null;
    }

    static String getToStringMethodsAddString(String space, String paraName) {
        return space + "." + "add" + "(" + StringGenerator.getQuotedString(paraName) + "," + " ";
    }

    static String signatureClose() {
        return ";\n";
    }

    static String valueAssign(String param, String value, String indentation) {
        return indentation + param + " " + "=" + " " + value + StringGenerator.signatureClose();
    }

    static String methodSignatureClose(MethodClassTypes type) {
        switch (type) {
            case INTERFACE_TYPE: {
                return StringGenerator.signatureClose();
            }
            case CLASS_TYPE: {
                return " {\n";
            }
        }
        return null;
    }

    private static String methodParam(String type, String name) {
        return type + " " + name;
    }

    private static String commaWithSpace() {
        return ", ";
    }

    static String brackets(BracketType type, String value, String returnType) {
        String ret = "";
        switch (type) {
            case OPEN_CLOSE_BRACKET: {
                return "()";
            }
            case OPEN_CLOSE_BRACKET_WITH_VALUE: {
                return "(" + value + ")";
            }
            case OPEN_CLOSE_BRACKET_WITH_VALUE_AND_RETURN_TYPE: {
                if (returnType != null) {
                    ret = returnType + " ";
                }
                return "(" + ret + value + ")";
            }
            case OPEN_BRACKET_WITH_VALUE: {
                ret = "";
                if (returnType != null) {
                    ret = returnType + " ";
                }
                return "(" + ret + value + ",";
            }
            case CLOSE_BRACKET_WITH_VALUE: {
                ret = "";
                if (returnType != null) {
                    ret = returnType + " ";
                }
                return " " + ret + value + ")";
            }
            case OPEN_CLOSE_DIAMOND: {
                return "<>";
            }
            case OPEN_CLOSE_DIAMOND_WITH_VALUE: {
                return "<" + value + ">";
            }
        }
        return null;
    }

    static String multiAttrMethodSignature(String methodName, String prefix, String modifier, String methodReturnType, Map<String, String> params, MethodClassTypes type) {
        StringBuilder methodBuilder = new StringBuilder("    ");
        String method = "";
        if (modifier != null) {
            method = modifier + " ";
        }
        methodBuilder.append(method);
        if (prefix == null) {
            prefix = "";
        }
        method = methodReturnType != null ? methodReturnType + " " + prefix + methodName : prefix + methodName;
        methodBuilder.append(method).append("(");
        for (Map.Entry<String, String> param : params.entrySet()) {
            methodBuilder.append(StringGenerator.methodParam(param.getValue(), param.getKey()));
            methodBuilder.append(StringGenerator.commaWithSpace());
        }
        String para = methodBuilder.toString();
        String[] array = new String[]{" ", ","};
        para = YangIoUtils.trimAtLast(para, array);
        methodBuilder = new StringBuilder(para).append(")").append(StringGenerator.methodSignatureClose(type));
        return methodBuilder.toString();
    }

    static String methodSignature(String methodName, String prefix, String modifier, String paraVal, String methodReturnType, String paraReturnType, MethodClassTypes type) {
        StringBuilder methodBuilder = new StringBuilder("    ");
        String method = "";
        if (modifier != null) {
            method = modifier + " ";
        }
        if (prefix == null) {
            prefix = "";
        }
        methodBuilder.append(method);
        method = methodReturnType != null ? methodReturnType + " " + prefix + methodName : prefix + methodName;
        methodBuilder.append(method);
        if (paraVal != null) {
            methodBuilder.append(StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET_WITH_VALUE_AND_RETURN_TYPE, paraVal, paraReturnType));
        } else {
            methodBuilder.append(StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET, null, null));
        }
        methodBuilder.append(StringGenerator.methodSignatureClose(type));
        return methodBuilder.toString();
    }

    static String getListAttribute(String attrType, YangCompilerAnnotation compilerAnnotation) {
        String listAttr;
        if (compilerAnnotation != null && compilerAnnotation.getYangAppDataStructure() != null) {
            switch (compilerAnnotation.getYangAppDataStructure().getDataStructure()) {
                case QUEUE: {
                    listAttr = "Queue<" + attrType + ">";
                    break;
                }
                case SET: {
                    listAttr = "Set<" + attrType + ">";
                    break;
                }
                case LIST: {
                    listAttr = StringGenerator.getListString() + attrType + ">";
                    break;
                }
                default: {
                    listAttr = StringGenerator.getListString() + attrType + ">";
                    break;
                }
            }
        } else {
            listAttr = StringGenerator.getListString() + attrType + ">";
        }
        return listAttr;
    }

    static String getIsValueLeafSet() {
        return "\n    @Override\n    public boolean isLeafValueSet(LeafIdentifier leaf) {\n        return valueLeafFlags.get(leaf.getLeafIndex());\n    }\n\n";
    }

    static String getIsSelectLeafSet() {
        return "    @Override\n    public boolean isSelectLeaf(LeafIdentifier leaf) {\n        return selectLeafFlags.get(leaf.getLeafIndex());\n    }\n";
    }

    static String getValueLeafGetters() {
        return "\n    /**\n     * Returns the valueLeafFlags.\n     *\n     * @return value of valueLeafFlags\n     */\n    public BitSet getValueLeafFlags() {\n        return valueLeafFlags;\n    }\n\n";
    }

    static String getSelectLeafGetters() {
        return "    /**\n     * Returns the selectLeafFlags.\n     *\n     * @return value of selectLeafFlags\n     */\n    public BitSet getSelectLeafFlags() {\n        return selectLeafFlags;\n    }\n\n";
    }

    static String getInterfaceLeafIdEnumMethods() {
        return "\n\n        private int leafIndex;\n\n        public int getLeafIndex() {\n            return leafIndex;\n        }\n\n        LeafIdentifier(int value) {\n            this.leafIndex = value;\n        }\n    }\n";
    }

    static String ifConditionForIntInTypeDefConstructor(ValidatorTypeForUnionTypes type, boolean addFirst, String val) {
        String condition = "        if (validateRange(";
        switch (type) {
            case INT_TYPE_CONFLICT: {
                if (addFirst) {
                    condition = condition + "INT32_MIN_RANGE" + "," + " " + "INT32_MAX_RANGE" + "," + " " + val;
                    break;
                }
                condition = condition + "UINT16_MIN_RANGE" + "," + " " + "UINT16_MAX_RANGE" + "," + " " + val;
                break;
            }
            case LONG_TYPE_CONFLICT: {
                if (addFirst) {
                    condition = condition + "INT64_MIN_RANGE" + "," + " " + "INT64_MAX_RANGE" + "," + " " + val;
                    break;
                }
                condition = condition + "UINT32_MIN_RANGE" + "," + " " + "UINT32_MAX_RANGE" + "," + " " + val;
                break;
            }
            case SHORT_TYPE_CONFLICT: {
                if (addFirst) {
                    condition = condition + "INT16_MIN_RANGE" + "," + " " + "INT16_MAX_RANGE" + "," + " " + val;
                    break;
                }
                condition = condition + "UINT8_MIN_RANGE" + "," + " " + "UINT8_MAX_RANGE" + "," + " " + val;
                break;
            }
            default: {
                return null;
            }
        }
        return condition + ")" + ")" + " " + "{" + "\n";
    }

    static String getParseFromStringMethod(String targetDataType, YangType<?> yangType) {
        YangDataTypes type = yangType.getDataType();
        switch (type) {
            case INT8: {
                return "Byte.parseByte";
            }
            case INT16: {
                return "Short.parseShort";
            }
            case INT32: {
                return "Integer.parseInt";
            }
            case INT64: {
                return "Long.parseLong";
            }
            case UINT8: {
                return "Short.parseShort";
            }
            case UINT16: {
                return "Integer.parseInt";
            }
            case UINT32: {
                return "Long.parseLong";
            }
            case UINT64: {
                return "new BigInteger";
            }
            case DECIMAL64: {
                return "new BigDecimal";
            }
            case INSTANCE_IDENTIFIER: 
            case STRING: 
            case IDENTITYREF: {
                return "";
            }
            case EMPTY: 
            case BOOLEAN: {
                return "Boolean.parseBoolean";
            }
            case ENUMERATION: {
                return targetDataType + "." + "of";
            }
            case DERIVED: 
            case UNION: {
                return targetDataType + "." + "fromString";
            }
        }
        throw new TranslatorException("Given data type is not supported. " + yangType.getDataTypeName() + " in " + yangType.getLineNumber() + " at " + yangType.getCharPosition() + " in " + yangType.getFileName());
    }

    static String getCatchSubString() {
        return "} catch " + StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET_WITH_VALUE_AND_RETURN_TYPE, "e", "Exception") + " " + "{";
    }

    static String getReturnOfSubString() {
        return StringGenerator.getReturnString("of", "            ") + StringGenerator.getOpenCloseParaWithValue("tmpVal") + StringGenerator.signatureClose();
    }

    static String getTrySubString() {
        return "try {";
    }

    static String getOmitNullValueString() {
        return "            .omitNullValues()\n";
    }

    static String getCollectionIteratorForLoopBegin(String indentation, String loopVar, String collection) {
        return indentation + "for" + " " + "(" + loopVar + " " + ":" + " " + collection + ")" + " " + "{" + "\n";
    }

    static String getElseIfConditionBegin(String indentation, String condition) {
        return indentation + "}" + " " + "else" + " " + StringGenerator.getIfConditionBegin("", condition);
    }

    static String getIfConditionBegin(String indentation, String condition) {
        return indentation + "if" + " " + StringGenerator.getOpenCloseParaWithValue(condition) + StringGenerator.methodSignatureClose(MethodClassTypes.CLASS_TYPE);
    }

    public static boolean isPrimitiveDataType(YangDataTypes dataType) {
        return PRIMITIVE_TYPES.contains((Object)dataType);
    }

    private static String getListString() {
        return "List<";
    }

    public static String getOverRideString() {
        return "\n    @Override\n";
    }

    static String getLeafFlagSetString(String name, String flag, String indentation, String prefix) {
        return indentation + flag + "." + prefix + StringGenerator.getOpenCloseParaWithValue("LeafIdentifier." + name.toUpperCase() + ".getLeafIndex()");
    }

    private static String parseTypeForReturnValue(String type) {
        switch (type) {
            case "byte": 
            case "int": 
            case "short": 
            case "long": 
            case "double": {
                return "0";
            }
            case "boolean": {
                return "false";
            }
        }
        return null;
    }

    static String getCheckNotNull(String name) {
        return "        checkNotNull(" + name + "," + " " + name + ")" + ";" + "\n";
    }

    private static String defCloseString() {
        return " {\n";
    }

    static String getDefaultDefinitionWithExtends(String classType, String name, String modifier, String extend) {
        String mod = "";
        if (modifier != null) {
            mod = modifier + " ";
        }
        return mod + classType + " " + name + " " + "extends" + " " + extend + StringGenerator.defCloseString();
    }

    static String getDefaultDefinitionWithImpl(String classType, String name, String modifier, String impl) {
        String mod = "";
        if (modifier != null) {
            mod = modifier + " ";
        }
        return mod + classType + " " + name + " " + "implements" + " " + impl + StringGenerator.defCloseString();
    }

    static String getDefaultDefinition(String classType, String name, String modifier) {
        String mod = "";
        if (modifier != null) {
            mod = modifier + " ";
        }
        return mod + classType + " " + name + StringGenerator.defCloseString();
    }

    static String getEventExtendsString(String name1, String type, String name2) {
        StringBuilder builder = new StringBuilder();
        builder.append(type).append("<").append(name1).append(",").append(" ").append(name2).append(">");
        return builder.toString();
    }

    public static String getImportString(String pkg, String cls) {
        StringBuilder builder = new StringBuilder().append("import ").append(pkg).append(".").append(cls).append(StringGenerator.signatureClose());
        return builder.toString();
    }

    static String getSpecificModifier(String modifier, String keyWord) {
        return modifier + " " + keyWord;
    }

    static String getBuilderImplStringClassDef(String yangName) {
        return yangName + "." + yangName + "Builder";
    }

    static String getDefaultName(String yangName) {
        return "Default" + yangName;
    }

    static String getSuffixedName(String yangName, String suffix) {
        return yangName + suffix;
    }

    static String getErrorMsg(String msg, String name, int line, int position, String fileName) {
        return msg + name + " in " + line + " at " + position + " in " + fileName;
    }

    static String getStringBuilderAttr(String init, String space) {
        StringBuilder builder = new StringBuilder(space);
        builder.append("StringBuilder").append(" ").append("sBuild").append(" ").append("=").append(" ").append("new").append(" ").append("StringBuilder").append(StringGenerator.getOpenCloseParaWithValue(StringGenerator.getQuotedString(init))).append(StringGenerator.signatureClose());
        return builder.toString();
    }

    static String getQuotedString(String name) {
        return "\"" + name + "\"";
    }

    static String getStringBuilderAppendString(String append, String space) {
        return space + "sBuild" + "." + "append" + "(" + append + ")" + StringGenerator.signatureClose();
    }

    static String getPatternQuoteString(String type) {
        return "Pattern.quote" + StringGenerator.getOpenCloseParaWithValue(StringGenerator.getQuotedString(type));
    }

    static String getBitSetAttr(String indentation) {
        StringBuilder builder = new StringBuilder(indentation);
        return builder.append("BitSet").append(" ").append("tmpVal").append(" ").append("=").append(" ").append("new").append(" ").append("BitSet").append("()").append(StringGenerator.signatureClose()).toString();
    }

    static String getForLoopString(String space, String type, String var, String data) {
        return space + "for" + " " + "(" + type + " " + var + " " + ":" + " " + data + ")" + StringGenerator.methodSignatureClose(MethodClassTypes.CLASS_TYPE);
    }

    static String getSetValueParaCondition(int count) {
        return "setValue.get" + StringGenerator.getOpenCloseParaWithValue(count + "");
    }

    static String getMoreObjectAttr(String name) {
        String cls = name + "." + "class";
        StringBuilder attr = new StringBuilder("        ");
        String[] array = new String[]{"\n"};
        attr.append("MoreObjects.ToStringHelper helper = ").append("MoreObjects.toStringHelper").append(StringGenerator.getOpenCloseParaWithValue(cls)).append("\n").append("    ").append(YangIoUtils.trimAtLast(StringGenerator.getOmitNullValueString(), array)).append(StringGenerator.signatureClose());
        return attr.toString();
    }

    static String getToStringCall(String name) {
        return name + "." + "toString" + "()";
    }

    static String getOpenCloseParaWithValue(String name) {
        return StringGenerator.brackets(BracketType.OPEN_CLOSE_BRACKET_WITH_VALUE, name, null);
    }

    static String getTwoParaEqualsString(String para1, String para2) {
        return para1 + "." + "equals" + StringGenerator.getOpenCloseParaWithValue(para2);
    }

    static String getEqualEqualString(String para, String val) {
        return para + " " + "=" + "=" + " " + val;
    }

    static String getAppInstanceAttrString(String name) {
        return "appInstance." + name + "()";
    }

    static String getQualifiedString(String pkg, String cls) {
        return pkg + "." + cls;
    }

    public static List<JavaQualifiedTypeInfoTranslator> getNodesImports(List<YangNode> nodes, YangPluginConfig config) {
        ArrayList<JavaQualifiedTypeInfoTranslator> imports = new ArrayList<JavaQualifiedTypeInfoTranslator>();
        for (YangNode node : nodes) {
            JavaQualifiedTypeInfoTranslator qInfo = SubtreeFilteringMethodsGenerator.getQualifiedInfo(node, config);
            imports.add(qInfo);
        }
        return imports;
    }

    public static List<YangNode> getChoiceChildNodes(YangChoice choice) {
        ArrayList<YangNode> childs = new ArrayList<YangNode>();
        for (YangNode child = choice.getChild(); child != null; child = child.getNextSibling()) {
            childs.add(child);
        }
        List<YangAugment> augments = choice.getAugmentedInfoList();
        for (YangAugment augment : augments) {
            for (YangNode augmentCase = augment.getChild(); augmentCase != null; augmentCase = augmentCase.getNextSibling()) {
                childs.add(augmentCase);
            }
        }
        return childs;
    }
}

