/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.onosproject.yangutils.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yangutils.utils.io.impl.YangFileScanner;

public final class YangPluginConfig {
    private String codeGenDir;
    private YangToJavaNamingConflictUtil conflictResolver;
    private String codeGenerateForSbi;

    public String getCodeGenerateForSbi() {
        return this.codeGenerateForSbi;
    }

    public void setCodeGenerateForSbi(String codeGenerateForSbi) {
        this.codeGenerateForSbi = codeGenerateForSbi;
    }

    public void setCodeGenDir(String codeGenDir) {
        this.codeGenDir = codeGenDir;
    }

    public String getCodeGenDir() {
        return this.codeGenDir;
    }

    public void setConflictResolver(YangToJavaNamingConflictUtil conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public YangToJavaNamingConflictUtil getConflictResolver() {
        return this.conflictResolver;
    }

    public static void compileCode(String dir1) throws IOException {
        String classpath = System.getProperty("java.class.path");
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", classpath));
        List<String> files = YangFileScanner.getJavaFiles(dir1);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> fileObjects = manager.getJavaFileObjectsFromStrings(files);
        JavaCompiler.CompilationTask task = compiler.getTask(null, null, null, optionList, null, fileObjects);
        boolean failOnError = task.call() == false;
        manager.close();
        if (failOnError) {
            throw new IOException("Yang Error : compilation errors in generated code.");
        }
    }
}

