/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

public final class CopyrightHeader {
    private static final int EOF = -1;
    private static final String COPYRIGHT_HEADER_FILE = "CopyrightHeader.txt";
    private static final String COPYRIGHTS_FIRST_LINE = "/*\n * Copyright " + Calendar.getInstance().get(1) + "-present Open Networking Laboratory\n";
    private static final String TEMP_FILE = "temp.txt";
    private static ClassLoader classLoader = CopyrightHeader.class.getClassLoader();
    private static String copyrightHeader;

    private CopyrightHeader() {
    }

    public static String getCopyrightHeader() throws IOException {
        if (copyrightHeader == null) {
            CopyrightHeader.parseCopyrightHeader();
        }
        return copyrightHeader;
    }

    private static void setCopyrightHeader(String header) {
        copyrightHeader = header;
    }

    private static void parseCopyrightHeader() throws IOException {
        File temp = new File(TEMP_FILE);
        try {
            int index;
            InputStream stream = classLoader.getResourceAsStream(COPYRIGHT_HEADER_FILE);
            FileOutputStream out = new FileOutputStream(temp);
            ((OutputStream)out).write(COPYRIGHTS_FIRST_LINE.getBytes());
            while ((index = stream.read()) != -1) {
                ((OutputStream)out).write(index);
            }
            ((OutputStream)out).close();
            stream.close();
            CopyrightHeader.getStringFileContent(temp);
            CopyrightHeader.setCopyrightHeader(CopyrightHeader.getStringFileContent(temp));
        }
        catch (IOException e) {
            throw new IOException("failed to parse the Copyright header");
        }
        finally {
            temp.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFileContent(File toAppend) throws IOException {
        FileReader fileReader = new FileReader(toAppend);
        BufferedReader bufferReader = new BufferedReader(fileReader);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String line = bufferReader.readLine();
            while (line != null) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
                line = bufferReader.readLine();
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            fileReader.close();
            bufferReader.close();
        }
    }
}

