/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io.impl;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public final class YangFileScanner {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String YANG_FILE_EXTENSION = ".yang";

    private YangFileScanner() {
    }

    public static List<String> getJavaFiles(String root) throws IOException {
        return YangFileScanner.getFiles(root, JAVA_FILE_EXTENSION);
    }

    public static List<String> getYangFiles(String root) throws IOException {
        return YangFileScanner.getFiles(root, YANG_FILE_EXTENSION);
    }

    private static List<String> getFiles(String root, String extension) throws IOException {
        LinkedList<String> store = new LinkedList<String>();
        Stack<String> stack = new Stack<String>();
        stack.push(root);
        try {
            while (!stack.empty()) {
                root = (String)stack.pop();
                File file = new File(root);
                File[] fileList = file.listFiles();
                if (fileList == null || fileList.length == 0) continue;
                for (File current : fileList) {
                    if (current.isDirectory()) {
                        stack.push(current.toString());
                        continue;
                    }
                    String yangFile = current.getCanonicalPath();
                    if (!yangFile.endsWith(extension)) continue;
                    store.add(yangFile);
                }
            }
            return store;
        }
        catch (IOException e) {
            throw new IOException("No File found of " + extension + " extension in " + root + " directory.");
        }
    }
}

