/*
 * Copyright 2016 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.yangutils.translator.tojava;

/**
 * Maintain the java qualified access details for an attribute or a class.
 */
public interface JavaQualifiedTypeInfoContainer {

    /**
     * Obtain the java qualified details.
     *
     * @return java qualified type details
     */
    JavaQualifiedTypeInfoTranslator getJavaQualifiedInfo();

    /**
     * Assign the qualified type info.
     *
     * @param typeInfo qualified type information
     */
    void setJavaQualifiedInfo(JavaQualifiedTypeInfoTranslator typeInfo);
}
