/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.linker.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.onosproject.yangutils.datamodel.TraversalType;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangAugmentedInfo;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;

public final class YangLinkerUtils {
    private static final int IDENTIFIER_LENGTH = 64;
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");
    private static final String XML = "xml";

    private YangLinkerUtils() {
    }

    private static void detectCollision(YangNode targetNode, YangAugment augment) {
        YangNode targetNodesChild = targetNode.getChild();
        YangNode augmentsChild = augment.getChild();
        YangNode parent = targetNode;
        if (targetNode instanceof YangAugment) {
            parent = targetNode.getParent();
        } else {
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
        }
        if (!(targetNode instanceof YangChoice)) {
            YangLinkerUtils.detectCollisionInLeaveHolders(targetNode, augment);
            while (augmentsChild != null) {
                YangLinkerUtils.detectCollisionInChildNodes(targetNodesChild, augmentsChild, targetNode.getName(), parent.getName());
                augmentsChild = augmentsChild.getNextSibling();
            }
        }
    }

    private static void detectCollisionInLeaveHolders(YangNode targetNode, YangAugment augment) {
        block8: {
            YangNode parent;
            YangLeavesHolder targetNodesLeavesHolder;
            block7: {
                targetNodesLeavesHolder = (YangLeavesHolder)targetNode;
                parent = targetNode;
                if (targetNode instanceof YangAugment) {
                    parent = targetNode.getParent();
                } else {
                    while (parent.getParent() != null) {
                        parent = parent.getParent();
                    }
                }
                if (augment.getListOfLeaf() == null || augment.getListOfLeaf().size() == 0 || targetNodesLeavesHolder.getListOfLeaf() == null) break block7;
                for (YangLeaf leaf : augment.getListOfLeaf()) {
                    for (YangLeaf targetLeaf : targetNodesLeavesHolder.getListOfLeaf()) {
                        if (!targetLeaf.getName().equals(leaf.getName())) continue;
                        throw new LinkerException("target node " + targetNode.getName() + " contains augmented leaf " + leaf.getName() + " in module " + parent.getName());
                    }
                }
                break block8;
            }
            if (augment.getListOfLeafList() == null || augment.getListOfLeafList().size() == 0 || augment.getListOfLeafList() == null) break block8;
            for (YangLeafList leafList : augment.getListOfLeafList()) {
                for (YangLeafList targetLeafList : targetNodesLeavesHolder.getListOfLeafList()) {
                    if (!targetLeafList.getName().equals(leafList.getName())) continue;
                    throw new LinkerException("target node " + targetNode.getName() + " contains augmented leaf-list" + leafList.getName() + " in module " + parent.getName());
                }
            }
        }
    }

    private static void detectCollisionInChildNodes(YangNode targetNodesChild, YangNode augmentsChild, String targetName, String parentName) {
        while (augmentsChild != null) {
            while (targetNodesChild != null) {
                if (targetNodesChild.getName().equals(augmentsChild.getName())) {
                    throw new LinkerException("target node " + targetName + " contains augmented child node" + augmentsChild.getName() + " in module " + parentName);
                }
                targetNodesChild = targetNodesChild.getNextSibling();
            }
            augmentsChild = augmentsChild.getNextSibling();
        }
    }

    static void detectCollisionForAugmentedNode(YangNode targetNode, YangAugment augment) {
        YangLinkerUtils.detectCollision(targetNode, augment);
        List yangAugmentedInfo = ((YangAugmentableNode)targetNode).getAugmentedInfoList();
        for (YangAugmentedInfo info : yangAugmentedInfo) {
            YangLinkerUtils.detectCollision((YangNode)((YangAugment)info), augment);
        }
    }

    static List<String> getPathWithAugment(YangAugment augment, int remainingAncestors) {
        ArrayList<String> listOfPathName = new ArrayList<String>();
        for (YangAtomicPath atomicPath : augment.getTargetNode()) {
            if (atomicPath.getNodeIdentifier().getPrefix() != null && !atomicPath.getNodeIdentifier().getPrefix().equals("")) {
                listOfPathName.add(atomicPath.getNodeIdentifier().getPrefix() + ":" + atomicPath.getNodeIdentifier().getName());
                continue;
            }
            listOfPathName.add(atomicPath.getNodeIdentifier().getName());
        }
        for (int countOfAncestor = 0; countOfAncestor < remainingAncestors; ++countOfAncestor) {
            listOfPathName.remove(listOfPathName.size() - 1);
        }
        return listOfPathName;
    }

    static YangNode skipInvalidDataNodes(YangNode currentParent, YangLeafRef leafref) throws LinkerException {
        while (currentParent instanceof YangChoice || currentParent instanceof YangCase) {
            if (currentParent.getParent() == null) {
                throw new LinkerException("YANG file error: The target node, in the leafref path " + leafref.getPath() + ", is invalid.");
            }
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    static YangNodeIdentifier getValidNodeIdentifier(String nodeIdentifierString, YangConstructType yangConstruct) {
        String[] tmpData = nodeIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(YangLinkerUtils.getValidIdentifier(tmpData[0], yangConstruct));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(YangLinkerUtils.getValidIdentifier(tmpData[0], yangConstruct));
            nodeIdentifier.setName(YangLinkerUtils.getValidIdentifier(tmpData[1], yangConstruct));
            return nodeIdentifier;
        }
        throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + nodeIdentifierString + " is not valid.");
    }

    public static String getValidIdentifier(String identifier, YangConstructType yangConstruct) {
        if (identifier.length() > 64) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + identifier + " is " + "greater than 64 characters.");
        }
        if (!IDENTIFIER_PATTERN.matcher(identifier).matches()) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + identifier + " is not " + "valid.");
        }
        if (identifier.toLowerCase().startsWith(XML)) {
            throw new LinkerException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " identifier " + identifier + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        }
        return identifier;
    }

    public static void updateFilePriority(Set<YangNode> yangNodeSet) {
        for (YangNode yangNode : yangNodeSet) {
            YangLinkerUtils.updateFilePriorityOfNode(yangNode);
        }
    }

    private static void updateFilePriorityOfNode(YangNode yangNode) {
        int curNodePriority = yangNode.getPriority();
        if (yangNode instanceof YangReferenceResolver) {
            List yangImportList = ((YangReferenceResolver)yangNode).getImportList();
            for (YangImport yangImport : yangImportList) {
                YangNode importedNode = yangImport.getImportedNode();
                if (curNodePriority < importedNode.getPriority()) continue;
                importedNode.setPriority(curNodePriority + 1);
                YangLinkerUtils.updateFilePriorityOfNode(importedNode);
            }
            List yangIncludeList = ((YangReferenceResolver)yangNode).getIncludeList();
            for (YangInclude yangInclude : yangIncludeList) {
                YangNode includedNode = yangInclude.getIncludedNode();
                if (curNodePriority < includedNode.getPriority()) continue;
                includedNode.setPriority(curNodePriority + 1);
                YangLinkerUtils.updateFilePriorityOfNode(includedNode);
            }
        }
    }

    public static void resolveGroupingInDefinationScope(YangReferenceResolver referenceResolver) {
        for (YangNode potentialInterFileGrouping = ((YangNode)referenceResolver).getChild(); potentialInterFileGrouping != null; potentialInterFileGrouping = potentialInterFileGrouping.getNextSibling()) {
            if (!(potentialInterFileGrouping instanceof YangGrouping)) continue;
            YangLinkerUtils.addGroupingResolvableEntitiesToResolutionList((YangGrouping)potentialInterFileGrouping);
        }
    }

    private static void addGroupingResolvableEntitiesToResolutionList(YangGrouping interFileGrouping) {
        YangGrouping curNode = interFileGrouping;
        TraversalType curTraversal = TraversalType.ROOT;
        YangLinkerUtils.addResolvableLeavesToResolutionList((YangLeavesHolder)curNode);
        curTraversal = TraversalType.CHILD;
        curNode = interFileGrouping.getChild();
        if (curNode == null) {
            return;
        }
        while (curNode != interFileGrouping) {
            if (curTraversal != TraversalType.PARENT) {
                YangType type;
                List typeList;
                if (curNode instanceof YangGrouping || curNode instanceof YangUses) {
                    if (curNode.getNextSibling() != null) {
                        curTraversal = TraversalType.SIBILING;
                        curNode = curNode.getNextSibling();
                        continue;
                    }
                    curTraversal = TraversalType.PARENT;
                    curNode = curNode.getParent();
                    continue;
                }
                if (curNode instanceof YangLeavesHolder) {
                    YangLinkerUtils.addResolvableLeavesToResolutionList((YangLeavesHolder)curNode);
                } else if (curNode instanceof YangTypeDef && !(typeList = ((YangTypeDef)curNode).getTypeList()).isEmpty() && (type = (YangType)typeList.get(0)).getDataType() == YangDataTypes.DERIVED && type.getResolvableStatus() != ResolvableStatus.RESOLVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    YangResolutionInfoImpl<YangType> resolutionInfo = new YangResolutionInfoImpl<YangType>(type, (YangNode)curNode, type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo);
                    }
                    catch (DataModelException e) {
                        throw new LinkerException("Failed to add type info in grouping to resolution ");
                    }
                }
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBILING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
    }

    private static void addResolvableLeavesToResolutionList(YangLeavesHolder leavesHolder) {
        YangResolutionInfoImpl<YangIdentityRef> resolutionInfo;
        YangIdentityRef identityRef;
        YangResolutionInfoImpl<YangType> resolutionInfo2;
        YangType type;
        if (leavesHolder.getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty()) {
            for (YangLeaf leaf : leavesHolder.getListOfLeaf()) {
                type = leaf.getDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    resolutionInfo2 = new YangResolutionInfoImpl<YangType>(type, (YangNode)leavesHolder, type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo2);
                        continue;
                    }
                    catch (DataModelException e) {
                        throw new LinkerException("Failed to add leaf type info in grouping, to resolution ");
                    }
                }
                if (type.getDataType() != YangDataTypes.IDENTITYREF) continue;
                identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
                identityRef.setIdentityForInterFileGroupingResolution(true);
                resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)leavesHolder, identityRef.getLineNumber(), identityRef.getCharPosition());
                try {
                    DataModelUtils.addResolutionInfo(resolutionInfo);
                }
                catch (DataModelException e) {
                    throw new LinkerException("Failed to add leaf identity ref info in grouping, to resolution ");
                }
            }
        }
        if (leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty()) {
            for (YangLeafList leafList : leavesHolder.getListOfLeafList()) {
                type = leafList.getDataType();
                if (type.getDataType() == YangDataTypes.DERIVED) {
                    type.setTypeForInterFileGroupingResolution(true);
                    resolutionInfo2 = new YangResolutionInfoImpl<YangType>(type, (YangNode)leavesHolder, type.getLineNumber(), type.getCharPosition());
                    try {
                        DataModelUtils.addResolutionInfo(resolutionInfo2);
                        continue;
                    }
                    catch (DataModelException e) {
                        throw new LinkerException("Failed to add leaf type info in grouping, to resolution ");
                    }
                }
                if (type.getDataType() != YangDataTypes.IDENTITYREF) continue;
                identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
                identityRef.setIdentityForInterFileGroupingResolution(true);
                resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)leavesHolder, identityRef.getLineNumber(), identityRef.getCharPosition());
                try {
                    DataModelUtils.addResolutionInfo(resolutionInfo);
                }
                catch (DataModelException e) {
                    throw new LinkerException("Failed to add leaf identity ref info in grouping, to resolution ");
                }
            }
        }
    }
}

