/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.linker.impl;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.onosproject.yangutils.datamodel.Resolvable;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.TraversalType;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangAugmentedInfo;
import org.onosproject.yangutils.datamodel.YangBase;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangEntityToResolveInfoImpl;
import org.onosproject.yangutils.datamodel.YangFeature;
import org.onosproject.yangutils.datamodel.YangFeatureHolder;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangIfFeature;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangPathArgType;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangRelativePath;
import org.onosproject.yangutils.datamodel.YangResolutionInfo;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.YangXPathResolver;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.linker.YangLinkingPhase;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.YangLinkerUtils;
import org.onosproject.yangutils.linker.impl.YangXpathLinker;

public class YangResolutionInfoImpl<T>
implements YangResolutionInfo<T>,
Serializable {
    private static final long serialVersionUID = 806201658L;
    private YangEntityToResolveInfoImpl<T> entityToResolveInfo;
    private transient int lineNumber;
    private transient int charPosition;
    private transient YangReferenceResolver curReferenceResolver;
    private Stack<YangEntityToResolveInfoImpl<T>> partialResolvedStack;

    private YangResolutionInfoImpl() {
    }

    public YangResolutionInfoImpl(T dataNode, YangNode holderNode, int lineNumber, int charPositionInLine) {
        this.setEntityToResolveInfo(new YangEntityToResolveInfoImpl());
        this.getEntityToResolveInfo().setEntityToResolve(dataNode);
        this.getEntityToResolveInfo().setHolderOfEntityToResolve(holderNode);
        this.setLineNumber(lineNumber);
        this.setCharPosition(charPositionInLine);
        this.setPartialResolvedStack(new Stack<YangEntityToResolveInfoImpl<T>>());
    }

    public void resolveLinkingForResolutionInfo(YangReferenceResolver dataModelRootNode) throws DataModelException {
        this.setCurReferenceResolver(dataModelRootNode);
        Object entityToResolve = this.getEntityToResolveInfo().getEntityToResolve();
        if (entityToResolve instanceof Resolvable) {
            Resolvable resolvable = (Resolvable)entityToResolve;
            if (resolvable.getResolvableStatus() == ResolvableStatus.RESOLVED) {
                return;
            }
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
        }
        this.addInPartialResolvedStack(this.getEntityToResolveInfo());
        this.linkAndResolvePartialResolvedStack();
        this.addDerivedRefTypeToRefTypeResolutionList();
    }

    private void linkAndResolvePartialResolvedStack() throws DataModelException {
        block6: while (this.getPartialResolvedStack().size() != 0) {
            T entityToResolve = this.getCurrentEntityToResolveFromStack();
            if (entityToResolve instanceof Resolvable) {
                Resolvable resolvable = (Resolvable)entityToResolve;
                switch (resolvable.getResolvableStatus()) {
                    case RESOLVED: {
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    case LINKED: {
                        this.resolveTopOfStack(YangLinkingPhase.INTRA_FILE);
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    case INTRA_FILE_RESOLVED: {
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    case UNRESOLVED: {
                        this.linkTopOfStackReferenceUpdateStack();
                        if (resolvable.getResolvableStatus() != ResolvableStatus.UNRESOLVED) continue block6;
                        String errorInfo = resolvable instanceof YangType ? "YANG file error: Unable to find base typedef for given type" : (resolvable instanceof YangUses ? "YANG file error: Unable to find base grouping for given uses" : (resolvable instanceof YangIfFeature ? "YANG file error: Unable to find feature for given if-feature" : (resolvable instanceof YangBase ? "YANG file error: Unable to find base identity for given base" : (resolvable instanceof YangIdentityRef ? "YANG file error: Unable to find base identity for given base" : "YANG file error: Unable to find base leaf/leaf-list for given leafref"))));
                        DataModelException dataModelException = new DataModelException(errorInfo);
                        dataModelException.setLine(this.getLineNumber());
                        dataModelException.setCharPosition(this.getCharPosition());
                        throw dataModelException;
                    }
                    default: {
                        throw new DataModelException("Data Model Exception: Unsupported, linker state");
                    }
                }
                continue;
            }
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/if-feature/leafref/base/identityref");
        }
    }

    private void addDerivedRefTypeToRefTypeResolutionList() throws DataModelException {
        YangNode potentialAncestorWithReferredNode = this.getEntityToResolveInfo().getHolderOfEntityToResolve();
        if (potentialAncestorWithReferredNode instanceof YangTypeDef) {
            return;
        }
        if (!(this.getEntityToResolveInfo().getEntityToResolve() instanceof YangType)) {
            return;
        }
        YangType yangType = (YangType)this.getEntityToResolveInfo().getEntityToResolve();
        if (yangType.getResolvableStatus() != ResolvableStatus.RESOLVED) {
            return;
        }
        YangDerivedInfo derivedInfo = (YangDerivedInfo)yangType.getDataTypeExtendedInfo();
        if (derivedInfo.getEffectiveBuiltInType() != YangDataTypes.LEAFREF && derivedInfo.getEffectiveBuiltInType() != YangDataTypes.IDENTITYREF) {
            return;
        }
        Object extendedInfo = derivedInfo.getReferredTypeDef().getTypeDefBaseType().getDataTypeExtendedInfo();
        while (extendedInfo instanceof YangDerivedInfo) {
            YangDerivedInfo derivedInfoFromTypedef = (YangDerivedInfo)extendedInfo;
            extendedInfo = derivedInfoFromTypedef.getReferredTypeDef().getTypeDefBaseType().getDataTypeExtendedInfo();
        }
        if (derivedInfo.getEffectiveBuiltInType() == YangDataTypes.LEAFREF) {
            YangLeafRef leafRefInTypeDef = (YangLeafRef)extendedInfo;
            yangType.resetYangType();
            yangType.setResolvableStatus(ResolvableStatus.RESOLVED);
            yangType.setDataType(YangDataTypes.LEAFREF);
            yangType.setDataTypeName("leafref");
            yangType.setDataTypeExtendedInfo((Object)leafRefInTypeDef);
            leafRefInTypeDef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
            leafRefInTypeDef.setParentNodeOfLeafref(potentialAncestorWithReferredNode);
            YangResolutionInfoImpl<YangLeafRef> resolutionInfoImpl = new YangResolutionInfoImpl<YangLeafRef>(leafRefInTypeDef, potentialAncestorWithReferredNode, this.getLineNumber(), this.getCharPosition());
            this.getCurReferenceResolver().addToResolutionList(resolutionInfoImpl, ResolvableType.YANG_LEAFREF);
            this.getCurReferenceResolver().resolveSelfFileLinking(ResolvableType.YANG_LEAFREF);
        } else if (derivedInfo.getEffectiveBuiltInType() == YangDataTypes.IDENTITYREF) {
            YangIdentityRef identityRefInTypeDef = (YangIdentityRef)extendedInfo;
            yangType.resetYangType();
            yangType.setResolvableStatus(ResolvableStatus.RESOLVED);
            yangType.setDataType(YangDataTypes.IDENTITYREF);
            yangType.setDataTypeName("identityref");
            yangType.setDataTypeExtendedInfo((Object)identityRefInTypeDef);
            identityRefInTypeDef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
            YangResolutionInfoImpl<YangIdentityRef> resolutionInfoImpl = new YangResolutionInfoImpl<YangIdentityRef>(identityRefInTypeDef, potentialAncestorWithReferredNode, this.getLineNumber(), this.getCharPosition());
            this.getCurReferenceResolver().addToResolutionList(resolutionInfoImpl, ResolvableType.YANG_IDENTITYREF);
            this.getCurReferenceResolver().resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
        }
    }

    private void resolveTopOfStack(YangLinkingPhase linkingPhase) throws DataModelException {
        List entityToResolve = (List)((Resolvable)this.getCurrentEntityToResolveFromStack()).resolve();
        if (entityToResolve != null && !entityToResolve.isEmpty()) {
            ListIterator entityToResolveIterator = entityToResolve.listIterator();
            while (entityToResolveIterator.hasNext()) {
                this.addUnresolvedEntitiesToResolutionList(entityToResolveIterator.next());
            }
        }
        if (((Resolvable)this.getCurrentEntityToResolveFromStack()).getResolvableStatus() != ResolvableStatus.INTRA_FILE_RESOLVED && ((Resolvable)this.getCurrentEntityToResolveFromStack()).getResolvableStatus() != ResolvableStatus.UNDEFINED) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.RESOLVED);
        }
    }

    private void addUnresolvedEntitiesToResolutionList(T entityToResolve) throws DataModelException {
        if (entityToResolve instanceof YangEntityToResolveInfoImpl) {
            YangEntityToResolveInfoImpl entityToResolveInfo = (YangEntityToResolveInfoImpl)entityToResolve;
            if (entityToResolveInfo.getEntityToResolve() instanceof YangLeafRef) {
                YangLeafRef leafref = (YangLeafRef)entityToResolveInfo.getEntityToResolve();
                YangNode parentNodeOfLeafref = entityToResolveInfo.getHolderOfEntityToResolve();
                leafref.setParentNodeOfLeafref(parentNodeOfLeafref);
                if (leafref.getResolvableStatus() == ResolvableStatus.UNRESOLVED) {
                    leafref.setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
                }
            }
            YangResolutionInfoImpl<Object> resolutionInfoImpl = new YangResolutionInfoImpl<Object>(entityToResolveInfo.getEntityToResolve(), entityToResolveInfo.getHolderOfEntityToResolve(), entityToResolveInfo.getLineNumber(), entityToResolveInfo.getCharPosition());
            DataModelUtils.addResolutionInfo(resolutionInfoImpl);
        }
    }

    private void linkTopOfStackReferenceUpdateStack() throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
            return;
        }
        if (!this.isCandidateForSelfFileReference()) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
            return;
        }
        YangNode potentialAncestorWithReferredNode = this.getPartialResolvedStack().peek().getHolderOfEntityToResolve();
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
            this.resolveSelfFileLinkingForIfFeature(potentialAncestorWithReferredNode);
            return;
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef || this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
            this.resolveSelfFileLinkingForBaseAndIdentityref();
            return;
        }
        YangType type = null;
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            type = (YangType)this.getCurrentEntityToResolveFromStack();
        }
        while (potentialAncestorWithReferredNode != null) {
            YangNode potentialReferredNode = potentialAncestorWithReferredNode.getChild();
            if (this.isReferredNodeInSiblingListProcessed(potentialReferredNode)) {
                return;
            }
            potentialAncestorWithReferredNode = potentialAncestorWithReferredNode.getParent();
            if (type == null || potentialAncestorWithReferredNode == null || potentialAncestorWithReferredNode.getParent() != null) continue;
            type.setTypeNotResolvedTillRootNode(true);
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.getCurReferenceResolver().getPrefix())) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private void resolveSelfFileLinkingForBaseAndIdentityref() throws DataModelException {
        boolean referredIdentityFound = false;
        String nodeName = null;
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
            nodeName = ((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).getName();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
            nodeName = ((YangBase)this.getCurrentEntityToResolveFromStack()).getBaseIdentifier().getName();
        }
        if (this.getCurReferenceResolver() instanceof YangModule) {
            YangModule rootNode = (YangModule)this.getCurReferenceResolver();
            referredIdentityFound = this.isIdentityReferenceFound(nodeName, (YangNode)rootNode);
        } else if (this.getCurReferenceResolver() instanceof YangSubModule) {
            YangSubModule rootNode = (YangSubModule)this.getCurReferenceResolver();
            referredIdentityFound = this.isIdentityReferenceFound(nodeName, (YangNode)rootNode);
        }
        if (referredIdentityFound) {
            return;
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.getCurReferenceResolver().getPrefix())) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private YangNode getRootNodeWithAncestorCount(int ancestorCount, YangNode currentParent) throws DataModelException {
        for (int currentParentCount = 1; currentParentCount < ancestorCount; ++currentParentCount) {
            if (currentParent.getParent() == null) {
                throw new DataModelException("YANG file error: The target node of leafref is invalid.");
            }
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    private void resolveSelfFileLinkingForIfFeature(YangNode potentialAncestorWithReferredNode) throws DataModelException {
        YangFeatureHolder featureHolder = this.getFeatureHolder(potentialAncestorWithReferredNode);
        YangNode potentialReferredNode = (YangNode)featureHolder;
        if (this.isReferredNode(potentialReferredNode)) {
            this.addReferredEntityLink(potentialReferredNode, ResolvableStatus.LINKED);
            this.addUnresolvedRecursiveReferenceToStack(potentialReferredNode);
            return;
        }
        if (this.getRefPrefix() == null || this.getRefPrefix().contentEquals(this.getCurReferenceResolver().getPrefix())) {
            ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTRA_FILE_RESOLVED);
        }
    }

    private boolean isIdentityReferenceFound(String nodeName, YangNode ancestorWithTheReferredNode) throws DataModelException {
        if (ancestorWithTheReferredNode.getChild() == null) {
            return false;
        }
        YangNode nodeFound = this.isReferredNodeInSiblingProcessedForIdentity(ancestorWithTheReferredNode = ancestorWithTheReferredNode.getChild(), nodeName);
        if (nodeFound != null) {
            this.addReferredEntityLink(nodeFound, ResolvableStatus.LINKED);
            this.addUnresolvedRecursiveReferenceToStack(nodeFound);
            return true;
        }
        return false;
    }

    private void addUnResolvedLeafRefTypeToStack(T yangleafOrLeafList, YangNode ancestorWithTheReferredNode) {
        if (yangleafOrLeafList instanceof YangLeaf) {
            YangLeaf leaf = (YangLeaf)yangleafOrLeafList;
            YangType referredTypeInLeafOrLeafList = leaf.getDataType();
            if (referredTypeInLeafOrLeafList.getDataType() == YangDataTypes.LEAFREF) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)((YangLeafRef)leaf.getDataType().getDataTypeExtendedInfo()));
                unResolvedEntityInfo.setHolderOfEntityToResolve(ancestorWithTheReferredNode);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            } else if (referredTypeInLeafOrLeafList.getDataType() == YangDataTypes.DERIVED) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)referredTypeInLeafOrLeafList);
                unResolvedEntityInfo.setHolderOfEntityToResolve(ancestorWithTheReferredNode);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            }
        } else {
            YangLeafList leafList = (YangLeafList)yangleafOrLeafList;
            YangType referredTypeInLeafOrLeafList = leafList.getDataType();
            if (referredTypeInLeafOrLeafList.getDataType() == YangDataTypes.LEAFREF) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)((YangLeafRef)leafList.getDataType().getDataTypeExtendedInfo()));
                unResolvedEntityInfo.setHolderOfEntityToResolve(ancestorWithTheReferredNode);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            } else if (referredTypeInLeafOrLeafList.getDataType() == YangDataTypes.DERIVED) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)referredTypeInLeafOrLeafList);
                unResolvedEntityInfo.setHolderOfEntityToResolve(ancestorWithTheReferredNode);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            }
        }
    }

    private YangFeatureHolder getFeatureHolder(YangNode potentialAncestorWithReferredNode) {
        while (potentialAncestorWithReferredNode != null) {
            if (potentialAncestorWithReferredNode instanceof YangFeatureHolder) {
                return (YangFeatureHolder)potentialAncestorWithReferredNode;
            }
            potentialAncestorWithReferredNode = potentialAncestorWithReferredNode.getParent();
        }
        return null;
    }

    private boolean isCandidateForSelfFileReference() throws DataModelException {
        String prefix = this.getRefPrefix();
        return prefix == null || prefix.contentEquals(this.getCurReferenceResolver().getPrefix());
    }

    private YangNode isReferredNodeInSiblingProcessedForLeafref(YangNode potentialReferredNode, String referredNodeName) throws DataModelException {
        while (potentialReferredNode != null) {
            if (potentialReferredNode instanceof YangInput ? referredNodeName.equalsIgnoreCase("input") : potentialReferredNode instanceof YangOutput && referredNodeName.equalsIgnoreCase("output")) {
                return potentialReferredNode;
            }
            if (this.isReferredNodeForLeafref(potentialReferredNode, referredNodeName)) {
                if (potentialReferredNode instanceof YangGrouping || potentialReferredNode instanceof YangTypeDef) {
                    if (potentialReferredNode.getParent() instanceof YangRpc) {
                        potentialReferredNode = potentialReferredNode.getNextSibling();
                    } else {
                        throw new DataModelException("YANG file error: The target node of leafref is invalid.");
                    }
                }
                return potentialReferredNode;
            }
            potentialReferredNode = potentialReferredNode.getNextSibling();
        }
        return null;
    }

    private YangNode isReferredNodeInSiblingProcessedForIdentity(YangNode potentialReferredNode, String referredNodeName) throws DataModelException {
        while (potentialReferredNode != null) {
            if (potentialReferredNode instanceof YangIdentity && this.isReferredNodeForIdentity(potentialReferredNode, referredNodeName)) {
                return potentialReferredNode;
            }
            potentialReferredNode = potentialReferredNode.getNextSibling();
        }
        return null;
    }

    private boolean isReferredNodeForLeafref(YangNode currentReferredNode, String nameOfNodeinPath) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef) {
            return currentReferredNode.getName().contentEquals(nameOfNodeinPath);
        }
        throw new DataModelException("Data Model Exception: Entity to resolved is other than leafref");
    }

    private boolean isReferredNodeForIdentity(YangNode currentReferredNode, String nameOfIdentityRefBase) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef || this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
            return currentReferredNode.getName().contentEquals(nameOfIdentityRefBase);
        }
        throw new DataModelException("Data Model Exception: Entity to resolved is other than identityref");
    }

    private boolean isReferredNodeInSiblingListProcessed(YangNode potentialReferredNode) throws DataModelException {
        while (potentialReferredNode != null) {
            if (this.isReferredNode(potentialReferredNode)) {
                this.addReferredEntityLink(potentialReferredNode, ResolvableStatus.LINKED);
                this.addUnresolvedRecursiveReferenceToStack(potentialReferredNode);
                return true;
            }
            potentialReferredNode = potentialReferredNode.getNextSibling();
        }
        return false;
    }

    private boolean isReferredNode(YangNode potentialReferredNode) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            if (potentialReferredNode instanceof YangTypeDef) {
                return this.isNodeNameSameAsResolutionInfoName(potentialReferredNode);
            }
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            if (potentialReferredNode instanceof YangGrouping) {
                return this.isNodeNameSameAsResolutionInfoName(potentialReferredNode);
            }
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
            if (potentialReferredNode instanceof YangFeatureHolder) {
                return this.isNodeNameSameAsResolutionInfoName(potentialReferredNode);
            }
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangBase || this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
            if (potentialReferredNode instanceof YangIdentity) {
                return this.isNodeNameSameAsResolutionInfoName(potentialReferredNode);
            }
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/base/identityref");
        }
        return false;
    }

    private boolean isNodeNameSameAsResolutionInfoName(YangNode node) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            if (node.getName().contentEquals(((YangType)this.getCurrentEntityToResolveFromStack()).getDataTypeName())) {
                return true;
            }
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            if (node.getName().contentEquals(((YangUses)this.getCurrentEntityToResolveFromStack()).getName())) {
                return true;
            }
        } else {
            if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
                return this.isFeatureDefinedInNode(node);
            }
            if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
                if (node.getName().contentEquals(((YangBase)this.getCurrentEntityToResolveFromStack()).getBaseIdentifier().getName())) {
                    return true;
                }
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
                if (node.getName().contentEquals(((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).getName())) {
                    return true;
                }
            } else {
                throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses");
            }
        }
        return false;
    }

    private boolean isFeatureDefinedInNode(YangNode node) throws DataModelException {
        YangNodeIdentifier ifFeature = ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).getName();
        List featureList = ((YangFeatureHolder)node).getFeatureList();
        if (featureList != null && !featureList.isEmpty()) {
            for (YangFeature feature : featureList) {
                if (!ifFeature.getName().equals(feature.getName())) continue;
                ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).setReferredFeature(feature);
                ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).setReferredFeatureHolder(node);
                return true;
            }
        }
        return false;
    }

    private void addReferredEntityLink(YangNode referredNode, ResolvableStatus linkedStatus) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            YangDerivedInfo derivedInfo = (YangDerivedInfo)((YangType)this.getCurrentEntityToResolveFromStack()).getDataTypeExtendedInfo();
            derivedInfo.setReferredTypeDef((YangTypeDef)referredNode);
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            ((YangUses)this.getCurrentEntityToResolveFromStack()).setRefGroup((YangGrouping)referredNode);
        } else if (!(this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) && !(this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef)) {
            if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
                ((YangBase)this.getCurrentEntityToResolveFromStack()).setReferredIdentity((YangIdentity)referredNode);
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
                ((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).setReferredIdentity((YangIdentity)referredNode);
            } else {
                throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/base/identityref");
            }
        }
        ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(linkedStatus);
    }

    private void addUnresolvedRecursiveReferenceToStack(YangNode referredNode) throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            if (((YangTypeDef)referredNode).getTypeDefBaseType().getDataType() == YangDataTypes.DERIVED) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)((YangTypeDef)referredNode).getTypeDefBaseType());
                unResolvedEntityInfo.setHolderOfEntityToResolve(referredNode);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            }
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            this.addUnResolvedUsesToStack(referredNode);
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
            this.addUnResolvedIfFeatureToStack(referredNode);
        } else {
            if (this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef) {
                throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses");
            }
            if (this.getCurrentEntityToResolveFromStack() instanceof YangBase || this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
                this.addUnResolvedBaseToStack(referredNode);
            } else {
                throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/base/identityref");
            }
        }
    }

    private void addUnResolvedUsesToStack(YangNode node) {
        TraversalType curTraversal = TraversalType.ROOT;
        YangNode curNode = node.getChild();
        while (curNode != null) {
            if (curNode.getName().equals(node.getName())) {
                return;
            }
            if (curNode instanceof YangUses) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)((YangUses)curNode));
                unResolvedEntityInfo.setHolderOfEntityToResolve(node);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            }
            if (curTraversal != TraversalType.PARENT && curNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                curNode = curNode.getChild();
                continue;
            }
            if (curNode.getNextSibling() != null) {
                curTraversal = TraversalType.SIBILING;
                curNode = curNode.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            curNode = curNode.getParent();
        }
    }

    private void addUnResolvedIfFeatureToStack(YangNode node) {
        YangFeature refFeature = ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).getReferredFeature();
        List ifFeatureList = refFeature.getIfFeatureList();
        if (ifFeatureList != null && !ifFeatureList.isEmpty()) {
            for (YangIfFeature ifFeature : ifFeatureList) {
                YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
                unResolvedEntityInfo.setEntityToResolve((Object)ifFeature);
                unResolvedEntityInfo.setHolderOfEntityToResolve(node);
                this.addInPartialResolvedStack(unResolvedEntityInfo);
            }
        }
    }

    private void addUnResolvedBaseToStack(YangNode node) {
        YangIdentity curNode = (YangIdentity)node;
        if (curNode.getBaseNode() != null && curNode.getBaseNode().getResolvableStatus() != ResolvableStatus.RESOLVED) {
            YangEntityToResolveInfoImpl unResolvedEntityInfo = new YangEntityToResolveInfoImpl();
            unResolvedEntityInfo.setEntityToResolve((Object)curNode.getBaseNode());
            unResolvedEntityInfo.setHolderOfEntityToResolve(node);
            this.addInPartialResolvedStack(unResolvedEntityInfo);
        }
    }

    private Stack<YangEntityToResolveInfoImpl<T>> getPartialResolvedStack() {
        return this.partialResolvedStack;
    }

    private void setPartialResolvedStack(Stack<YangEntityToResolveInfoImpl<T>> partialResolvedStack) {
        this.partialResolvedStack = partialResolvedStack;
    }

    private void addInPartialResolvedStack(YangEntityToResolveInfoImpl<T> partialResolvedInfo) {
        this.getPartialResolvedStack().push(partialResolvedInfo);
    }

    private T getCurrentEntityToResolveFromStack() {
        return (T)this.getPartialResolvedStack().peek().getEntityToResolve();
    }

    public YangEntityToResolveInfoImpl<T> getEntityToResolveInfo() {
        return this.entityToResolveInfo;
    }

    private void setEntityToResolveInfo(YangEntityToResolveInfoImpl<T> entityToResolveInfo) {
        this.entityToResolveInfo = entityToResolveInfo;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharPosition() {
        return this.charPosition;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setCharPosition(int charPositionInLine) {
        this.charPosition = charPositionInLine;
    }

    private YangReferenceResolver getCurReferenceResolver() {
        return this.curReferenceResolver;
    }

    private void setCurReferenceResolver(YangReferenceResolver curReferenceResolver) {
        this.curReferenceResolver = curReferenceResolver;
    }

    public void linkInterFile(YangReferenceResolver dataModelRootNode) throws DataModelException {
        this.setCurReferenceResolver(dataModelRootNode);
        Object entityToResolve = this.getEntityToResolveInfo().getEntityToResolve();
        if (entityToResolve instanceof Resolvable) {
            Resolvable resolvable = (Resolvable)entityToResolve;
            if (resolvable.getResolvableStatus() == ResolvableStatus.RESOLVED) {
                return;
            }
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is not Resolvable");
        }
        if (entityToResolve instanceof YangXPathResolver && !(entityToResolve instanceof YangLeafRef)) {
            this.processXPathLinking(entityToResolve, dataModelRootNode);
        } else {
            this.addInPartialResolvedStack(this.getEntityToResolveInfo());
            this.linkInterFileAndResolve();
            this.addDerivedRefTypeToRefTypeResolutionList();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processXPathLinking(T entityToResolve, YangReferenceResolver root) {
        YangXpathLinker xPathLinker = new YangXpathLinker();
        if (entityToResolve instanceof YangAugment) {
            YangNode targetNode = null;
            YangAugment augment = (YangAugment)entityToResolve;
            targetNode = xPathLinker.processAugmentXpathLinking(augment.getTargetNode(), (YangNode)root);
            if (targetNode == null) throw new LinkerException("Failed to link " + augment.getName());
            if (!(targetNode instanceof YangAugmentableNode)) throw new LinkerException("Invalid target node type " + targetNode.getNodeType() + " for " + augment.getName());
            YangLinkerUtils.detectCollisionForAugmentedNode(targetNode, augment);
            ((YangAugmentableNode)targetNode).addAugmentation((YangAugmentedInfo)augment);
            ((YangAugmentableNode)targetNode).setIsAugmented(true);
            augment.setAugmentedNode(targetNode);
            Resolvable resolvable = (Resolvable)entityToResolve;
            resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
            return;
        } else if (entityToResolve instanceof YangCompilerAnnotation) {
            YangCompilerAnnotation ca = (YangCompilerAnnotation)entityToResolve;
            YangNode targetNode = xPathLinker.processAugmentXpathLinking(ca.getAtomicPathList(), (YangNode)root);
            if (targetNode == null) throw new LinkerException("Failed to link compiler annotation " + ca.getPath());
            if (!(targetNode instanceof YangList)) throw new LinkerException("Invalid target node type " + targetNode.getNodeType() + " for compiler" + " annotation " + ca.getPath());
            ((YangList)targetNode).setCompilerAnnotation((YangCompilerAnnotation)entityToResolve);
            Resolvable resolvable = (Resolvable)entityToResolve;
            resolvable.setResolvableStatus(ResolvableStatus.RESOLVED);
            return;
        } else {
            if (!(entityToResolve instanceof YangLeafRef)) return;
            YangLeafRef leafRef = (YangLeafRef)entityToResolve;
            Object target = xPathLinker.processLeafRefXpathLinking(leafRef.getAtomicPath(), (YangNode)root, leafRef);
            if (target != null) {
                YangLeaf leaf = null;
                YangLeafList leafList = null;
                leafRef.setReferredLeafOrLeafList(target);
                if (target instanceof YangLeaf) {
                    leaf = (YangLeaf)target;
                    leafRef.setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
                    this.addUnResolvedLeafRefTypeToStack(leaf, this.getEntityToResolveInfo().getHolderOfEntityToResolve());
                    return;
                } else {
                    leafList = (YangLeafList)target;
                    leafRef.setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
                    this.addUnResolvedLeafRefTypeToStack(leafList, this.getEntityToResolveInfo().getHolderOfEntityToResolve());
                }
                return;
            } else {
                LinkerException linkerException = new LinkerException("YANG file error: Unable to find base leaf/leaf-list for given leafref path " + leafRef.getPath());
                linkerException.setCharPosition(leafRef.getCharPosition());
                linkerException.setLine(leafRef.getLineNumber());
                throw linkerException;
            }
        }
    }

    private String getRefPrefix() throws DataModelException {
        String refPrefix;
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            refPrefix = ((YangType)this.getCurrentEntityToResolveFromStack()).getPrefix();
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            refPrefix = ((YangUses)this.getCurrentEntityToResolveFromStack()).getPrefix();
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
            refPrefix = ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).getPrefix();
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
            refPrefix = ((YangBase)this.getCurrentEntityToResolveFromStack()).getBaseIdentifier().getPrefix();
        } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
            refPrefix = ((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).getPrefix();
        } else {
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/base/identityref");
        }
        return refPrefix;
    }

    private void linkInterFileAndResolve() throws DataModelException {
        while (this.getPartialResolvedStack().size() != 0) {
            T entityToResolve = this.getCurrentEntityToResolveFromStack();
            if (entityToResolve instanceof Resolvable) {
                Resolvable resolvable = (Resolvable)entityToResolve;
                switch (resolvable.getResolvableStatus()) {
                    case RESOLVED: {
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    case INTER_FILE_LINKED: {
                        this.resolveTopOfStack(YangLinkingPhase.INTER_FILE);
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    case INTRA_FILE_RESOLVED: {
                        this.linkInterFileTopOfStackRefUpdateStack();
                        break;
                    }
                    case UNDEFINED: {
                        this.getPartialResolvedStack().pop();
                        break;
                    }
                    default: {
                        throw new DataModelException("Data Model Exception: Unsupported, linker state");
                    }
                }
                continue;
            }
            throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses");
        }
    }

    private void linkInterFileTopOfStackRefUpdateStack() throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef) {
            this.setAbsolutePathFromRelativePathInLeafref(this.getCurrentEntityToResolveFromStack());
            this.processXPathLinking(this.getCurrentEntityToResolveFromStack(), this.getCurReferenceResolver());
            return;
        }
        T referredNode = this.getRefNode();
        if (referredNode == null) {
            if (this.getRefPrefix() != null && !this.getRefPrefix().contentEquals(this.getCurReferenceResolver().getPrefix()) ? this.resolveWithImport() : this.resolveWithInclude()) {
                return;
            }
            if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
                ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.UNDEFINED);
                return;
            }
            String errorInfo = this.getCurrentEntityToResolveFromStack() instanceof YangType ? "YANG file error: Unable to find base typedef for given type" : (this.getCurrentEntityToResolveFromStack() instanceof YangUses ? "YANG file error: Unable to find base grouping for given uses" : (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature ? "YANG file error: Unable to find feature for given if-feature" : (this.getCurrentEntityToResolveFromStack() instanceof YangBase ? "YANG file error: Unable to find base identity for given base" : (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef ? "YANG file error: Unable to find base identity for given base" : "YANG file error: Unable to find base leaf/leaf-list for given leafref"))));
            DataModelException dataModelException = new DataModelException(errorInfo);
            dataModelException.setLine(this.getLineNumber());
            dataModelException.setCharPosition(this.getCharPosition());
            throw dataModelException;
        }
        ((Resolvable)this.getCurrentEntityToResolveFromStack()).setResolvableStatus(ResolvableStatus.INTER_FILE_LINKED);
        this.addUnresolvedRecursiveReferenceToStack((YangNode)referredNode);
    }

    public void setAbsolutePathFromRelativePathInLeafref(T resolutionInfo) throws DataModelException {
        if (resolutionInfo instanceof YangLeafRef) {
            YangNode parentOfLeafref = ((YangLeafRef)resolutionInfo).getParentNodeOfLeafref();
            YangLeafRef leafref = (YangLeafRef)resolutionInfo;
            if (leafref.getPathType() == YangPathArgType.RELATIVE_PATH) {
                YangRelativePath relativePath = leafref.getRelativePath();
                List absoluteInRelative = relativePath.getAtomicPathList();
                int numberOfAncestors = relativePath.getAncestorNodeCount();
                T nodeOrAugmentList = this.getRootNodeWithAncestorCountForLeafref(numberOfAncestors, parentOfLeafref, leafref);
                if (nodeOrAugmentList instanceof YangNode) {
                    String pathNameToBePrefixed = "";
                    YangNode rootNode = (YangNode)nodeOrAugmentList;
                    while (!(rootNode instanceof YangReferenceResolver)) {
                        pathNameToBePrefixed = rootNode.getName() + "/" + pathNameToBePrefixed;
                        if ((rootNode = rootNode.getParent()) != null) continue;
                        throw new DataModelException("Internal datamodel error: Datamodel tree is not correct");
                    }
                    this.fillAbsolutePathValuesInLeafref(leafref, pathNameToBePrefixed, absoluteInRelative);
                } else {
                    List listOfAugment = (List)nodeOrAugmentList;
                    ListIterator listOfAugmentIterator = listOfAugment.listIterator();
                    String augment = "";
                    while (listOfAugmentIterator.hasNext()) {
                        augment = augment + "/" + (String)listOfAugmentIterator.next();
                    }
                    this.fillAbsolutePathValuesInLeafref(leafref, augment, absoluteInRelative);
                }
            }
        }
    }

    private void fillAbsolutePathValuesInLeafref(YangLeafRef leafref, String pathNameToBePrefixed, List<YangAtomicPath> atomicPathsInRelative) throws DataModelException {
        leafref.setPathType(YangPathArgType.ABSOLUTE_PATH);
        String[] pathName = new String[]{};
        if (pathNameToBePrefixed != "" && pathNameToBePrefixed != null) {
            pathName = pathNameToBePrefixed.split("/");
        }
        LinkedList<YangAtomicPath> finalListForAbsolute = new LinkedList<YangAtomicPath>();
        for (String value : pathName) {
            if (value == null || value.isEmpty() || value == "") continue;
            YangNodeIdentifier nodeIdentifier = YangLinkerUtils.getValidNodeIdentifier(value, YangConstructType.PATH_DATA);
            YangAtomicPath atomicPath = new YangAtomicPath();
            atomicPath.setNodeIdentifier(nodeIdentifier);
            finalListForAbsolute.add(atomicPath);
        }
        if (atomicPathsInRelative != null && !atomicPathsInRelative.isEmpty()) {
            ListIterator<YangAtomicPath> atomicPathIterator = atomicPathsInRelative.listIterator();
            while (atomicPathIterator.hasNext()) {
                YangAtomicPath yangAtomicPath = (YangAtomicPath)atomicPathIterator.next();
                finalListForAbsolute.add(yangAtomicPath);
            }
        } else {
            DataModelException dataModelException = new DataModelException("YANG file error: The target node, in the leafref path " + leafref.getPath() + ", is invalid.");
            dataModelException.setCharPosition(leafref.getCharPosition());
            dataModelException.setLine(leafref.getLineNumber());
            throw dataModelException;
        }
        leafref.setAtomicPath(finalListForAbsolute);
    }

    private T getRootNodeWithAncestorCountForLeafref(int ancestorCount, YangNode currentParent, YangLeafRef leafref) throws DataModelException {
        int currentParentCount = 1;
        if ((currentParent = YangLinkerUtils.skipInvalidDataNodes(currentParent, leafref)) instanceof YangAugment) {
            YangAugment augment = (YangAugment)currentParent;
            List<String> valueInAugment = YangLinkerUtils.getPathWithAugment(augment, ancestorCount - currentParentCount);
            return (T)valueInAugment;
        }
        while (currentParentCount < ancestorCount) {
            YangNode currentSkippedParent = YangLinkerUtils.skipInvalidDataNodes(currentParent, leafref);
            if (currentSkippedParent == currentParent) {
                if (currentParent.getParent() == null) {
                    throw new DataModelException("YANG file error: The target node, in the leafref path " + leafref.getPath() + ", is invalid.");
                }
            } else {
                currentParent = currentSkippedParent;
                continue;
            }
            currentParent = currentParent.getParent();
            ++currentParentCount;
            if (!(currentParent instanceof YangAugment)) continue;
            YangAugment augment = (YangAugment)currentParent;
            List<String> valueInAugment = YangLinkerUtils.getPathWithAugment(augment, ancestorCount - currentParentCount);
            return (T)valueInAugment;
        }
        return (T)currentParent;
    }

    private boolean resolveWithInclude() throws DataModelException {
        for (YangInclude yangInclude : this.getCurReferenceResolver().getIncludeList()) {
            YangNode linkedNode = null;
            if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
                linkedNode = this.findRefTypedef(yangInclude.getIncludedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
                linkedNode = this.findRefGrouping(yangInclude.getIncludedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
                linkedNode = this.findRefFeature(yangInclude.getIncludedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
                linkedNode = this.findRefIdentity(yangInclude.getIncludedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
                linkedNode = this.findRefIdentityRef(yangInclude.getIncludedNode());
            }
            if (linkedNode == null) continue;
            this.addReferredEntityLink(linkedNode, ResolvableStatus.INTER_FILE_LINKED);
            this.addUnresolvedRecursiveReferenceToStack(linkedNode);
            return true;
        }
        return false;
    }

    private boolean resolveWithImport() throws DataModelException {
        for (YangImport yangImport : this.getCurReferenceResolver().getImportList()) {
            if (!yangImport.getPrefixId().contentEquals(this.getRefPrefix())) continue;
            YangNode linkedNode = null;
            if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
                linkedNode = this.findRefTypedef(yangImport.getImportedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
                linkedNode = this.findRefGrouping(yangImport.getImportedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
                linkedNode = this.findRefFeature(yangImport.getImportedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
                linkedNode = this.findRefIdentity(yangImport.getImportedNode());
            } else if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
                linkedNode = this.findRefIdentityRef(yangImport.getImportedNode());
            }
            if (linkedNode == null) break;
            this.addReferredEntityLink(linkedNode, ResolvableStatus.INTER_FILE_LINKED);
            this.addUnresolvedRecursiveReferenceToStack(linkedNode);
            return true;
        }
        return false;
    }

    private T getRefNode() throws DataModelException {
        if (this.getCurrentEntityToResolveFromStack() instanceof YangType) {
            YangDerivedInfo derivedInfo = (YangDerivedInfo)((YangType)this.getCurrentEntityToResolveFromStack()).getDataTypeExtendedInfo();
            return (T)derivedInfo.getReferredTypeDef();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangUses) {
            return (T)((YangUses)this.getCurrentEntityToResolveFromStack()).getRefGroup();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIfFeature) {
            return (T)((YangIfFeature)this.getCurrentEntityToResolveFromStack()).getReferredFeatureHolder();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangLeafRef) {
            return (T)((YangLeafRef)this.getCurrentEntityToResolveFromStack()).getReferredLeafOrLeafList();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangBase) {
            return (T)((YangBase)this.getCurrentEntityToResolveFromStack()).getReferredIdentity();
        }
        if (this.getCurrentEntityToResolveFromStack() instanceof YangIdentityRef) {
            return (T)((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).getReferredIdentity();
        }
        throw new DataModelException("Data Model Exception: Entity to resolved is other than type/uses/base/identityref");
    }

    private YangNode findRefGrouping(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangGrouping) || !tmpNode.getName().equals(((YangUses)this.getCurrentEntityToResolveFromStack()).getName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefFeature(YangNode refNode) {
        YangNodeIdentifier ifFeature = ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).getName();
        List featureList = ((YangFeatureHolder)refNode).getFeatureList();
        if (featureList != null && !featureList.isEmpty()) {
            for (YangFeature feature : featureList) {
                if (!ifFeature.getName().equals(feature.getName())) continue;
                ((YangIfFeature)this.getCurrentEntityToResolveFromStack()).setReferredFeature(feature);
                return refNode;
            }
        }
        return null;
    }

    private YangNode findRefTypedef(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangTypeDef) || !tmpNode.getName().equals(((YangType)this.getCurrentEntityToResolveFromStack()).getDataTypeName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefIdentity(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangIdentity) || !tmpNode.getName().equals(((YangBase)this.getCurrentEntityToResolveFromStack()).getBaseIdentifier().getName())) continue;
            return tmpNode;
        }
        return null;
    }

    private YangNode findRefIdentityRef(YangNode refNode) {
        for (YangNode tmpNode = refNode.getChild(); tmpNode != null; tmpNode = tmpNode.getNextSibling()) {
            if (!(tmpNode instanceof YangIdentity) || !tmpNode.getName().equals(((YangIdentityRef)this.getCurrentEntityToResolveFromStack()).getBaseIdentity().getName())) continue;
            return tmpNode;
        }
        return null;
    }
}

