/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.linker.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangInclude;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.PrefixResolverType;

public class YangXpathLinker<T> {
    private List<YangAtomicPath> absPaths = new ArrayList<YangAtomicPath>();
    private YangNode rootNode;
    private Map<YangAtomicPath, PrefixResolverType> prefixResolverTypes;
    private String curPrefix;

    private Map<YangAtomicPath, PrefixResolverType> getPrefixResolverTypes() {
        return this.prefixResolverTypes;
    }

    private void setPrefixResolverTypes(Map<YangAtomicPath, PrefixResolverType> prefixResolverTypes) {
        this.prefixResolverTypes = prefixResolverTypes;
    }

    private void addToPrefixResolverList(PrefixResolverType type, YangAtomicPath path) {
        this.getPrefixResolverTypes().put(path, type);
    }

    private List<YangAtomicPath> getAbsPaths() {
        return this.absPaths;
    }

    private void setAbsPaths(List<YangAtomicPath> absPaths) {
        this.absPaths = absPaths;
    }

    private void addAbsPaths(YangAtomicPath absPaths) {
        this.getAbsPaths().add(absPaths);
    }

    private String getCurPrefix() {
        return this.curPrefix;
    }

    private void setCurPrefix(String curPrefix) {
        this.curPrefix = curPrefix;
    }

    private YangNode getRootNode() {
        return this.rootNode;
    }

    private void setRootNode(YangNode rootNode) {
        this.rootNode = rootNode;
    }

    private void addToResolvedNodes(YangAtomicPath path, YangNode node) {
        path.setResolvedNode(node);
    }

    public List<YangAugment> getListOfYangAugment(YangNode node) {
        ArrayList<YangAugment> augments = new ArrayList<YangAugment>();
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof YangAugment)) continue;
            augments.add((YangAugment)node);
        }
        return augments;
    }

    T processLeafRefXpathLinking(List<YangAtomicPath> atomicPaths, YangNode root, YangLeafRef leafref) {
        YangNode targetNode;
        this.setRootNode(root);
        this.setPrefixResolverTypes(new HashMap<YangAtomicPath, PrefixResolverType>());
        this.parsePrefixResolverList(atomicPaths);
        YangAtomicPath leafRefPath = atomicPaths.get(atomicPaths.size() - 1);
        if (atomicPaths.size() == 1) {
            targetNode = this.getTargetNodewhenSizeIsOne(atomicPaths);
        } else {
            for (YangAtomicPath atomicPath : atomicPaths) {
                if (atomicPath == leafRefPath) continue;
                this.addAbsPaths(atomicPath);
            }
            targetNode = this.parseData(root);
        }
        if (targetNode == null) {
            targetNode = this.searchInSubModule(root);
        }
        this.validateInvalidNodesInThePath(leafref);
        if (targetNode != null) {
            YangLeaf targetLeaf = this.searchReferredLeaf(targetNode, leafRefPath.getNodeIdentifier().getName());
            if (targetLeaf == null) {
                YangLeafList targetLeafList = this.searchReferredLeafList(targetNode, leafRefPath.getNodeIdentifier().getName());
                if (targetLeafList != null) {
                    return (T)targetLeafList;
                }
                LinkerException linkerException = new LinkerException("YANG file error: Unable to find base leaf/leaf-list for given leafref path " + leafref.getPath());
                linkerException.setCharPosition(leafref.getCharPosition());
                linkerException.setLine(leafref.getLineNumber());
                throw linkerException;
            }
            return (T)targetLeaf;
        }
        return null;
    }

    private void validateInvalidNodesInThePath(YangLeafRef leafref) {
        for (YangAtomicPath absolutePath : leafref.getAtomicPath()) {
            YangNode nodeInPath = absolutePath.getResolvedNode();
            if (!(nodeInPath instanceof YangGrouping) && !(nodeInPath instanceof YangUses) && !(nodeInPath instanceof YangTypeDef) && !(nodeInPath instanceof YangCase) && !(nodeInPath instanceof YangChoice)) continue;
            LinkerException linkerException = new LinkerException("YANG file error: The target node, in the leafref path " + leafref.getPath() + ", is invalid.");
            linkerException.setCharPosition(leafref.getCharPosition());
            linkerException.setLine(leafref.getLineNumber());
            throw linkerException;
        }
    }

    private YangNode getTargetNodewhenSizeIsOne(List<YangAtomicPath> absPaths) {
        if (absPaths.get(0).getNodeIdentifier().getPrefix() != null && !absPaths.get(0).getNodeIdentifier().getPrefix().equals(this.getRootsPrefix(this.getRootNode()))) {
            return this.getImportedNode(this.getRootNode(), absPaths.get(0).getNodeIdentifier());
        }
        return this.getRootNode();
    }

    public YangNode processAugmentXpathLinking(List<YangAtomicPath> absPaths, YangNode root) {
        this.setAbsPaths(absPaths);
        this.setRootNode(root);
        this.setPrefixResolverTypes(new HashMap<YangAtomicPath, PrefixResolverType>());
        this.parsePrefixResolverList(absPaths);
        YangNode targetNode = this.parseData(root);
        if (targetNode == null) {
            targetNode = this.searchInSubModule(root);
        }
        return targetNode;
    }

    private YangLeaf searchReferredLeaf(YangNode targetNode, String leafName) {
        if (!(targetNode instanceof YangLeavesHolder)) {
            throw new LinkerException("Refered node " + targetNode.getName() + "should be of type leaves holder ");
        }
        YangLeavesHolder holder = (YangLeavesHolder)targetNode;
        List leaves = holder.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leaf.getName().equals(leafName)) continue;
                return leaf;
            }
        }
        return null;
    }

    private YangLeafList searchReferredLeafList(YangNode targetNode, String leafListName) {
        if (!(targetNode instanceof YangLeavesHolder)) {
            throw new LinkerException("Refered node " + targetNode.getName() + "should be of type leaves holder ");
        }
        YangLeavesHolder holder = (YangLeavesHolder)targetNode;
        List leavesList = holder.getListOfLeafList();
        if (leavesList != null && !leavesList.isEmpty()) {
            for (YangLeafList leafList : leavesList) {
                if (!leafList.getName().equals(leafListName)) continue;
                return leafList;
            }
        }
        return null;
    }

    private YangNode parseData(YangNode root) {
        String rootPrefix = this.getRootsPrefix(root);
        Iterator<YangAtomicPath> pathIterator = this.getAbsPaths().iterator();
        YangAtomicPath path = pathIterator.next();
        if (path.getNodeIdentifier().getPrefix() != null && !path.getNodeIdentifier().getPrefix().equals(rootPrefix)) {
            return this.parsePath(this.getImportedNode(root, path.getNodeIdentifier()));
        }
        return this.parsePath(root);
    }

    private YangNode parsePath(YangNode root) {
        YangNode tempNode = root;
        Stack<YangNode> linkerStack = new Stack<YangNode>();
        Iterator<YangAtomicPath> pathIterator = this.getAbsPaths().iterator();
        YangAtomicPath tempPath = pathIterator.next();
        this.setCurPrefix(tempPath.getNodeIdentifier().getPrefix());
        int index = 0;
        do {
            YangNode tempAugment;
            if ((tempAugment = tempPath.getNodeIdentifier().getPrefix() == null ? this.resolveIntraFileAugment(tempPath, root) : this.resolveInterFileAugment(tempPath, root)) != null) {
                linkerStack.push(tempNode);
                tempNode = tempAugment;
            }
            if ((tempNode = this.searchTargetNode(tempNode, tempPath.getNodeIdentifier())) == null && linkerStack.size() != 0) {
                tempNode = (YangNode)linkerStack.peek();
                linkerStack.pop();
                tempNode = this.searchTargetNode(tempNode, tempPath.getNodeIdentifier());
            }
            if (tempNode != null) {
                this.addToResolvedNodes(tempPath, tempNode);
            }
            if (index == this.getAbsPaths().size() - 1) break;
            tempPath = pathIterator.next();
        } while (this.validate(tempNode, ++index));
        return tempNode;
    }

    private YangNode resolveIntraFileAugment(YangAtomicPath tempPath, YangNode root) {
        if (this.getCurPrefix() != tempPath.getNodeIdentifier().getPrefix()) {
            root = this.getIncludedNode(this.getRootNode(), tempPath.getNodeIdentifier().getName());
            if (root == null && (root = this.getIncludedNode(this.getRootNode(), this.getAugmentNodeIdentifier(tempPath.getNodeIdentifier(), this.absPaths, this.getRootNode()))) == null) {
                root = this.getRootNode();
            }
        } else if (this.getCurPrefix() != null) {
            root = this.getImportedNode(root, tempPath.getNodeIdentifier());
        }
        this.setCurPrefix(tempPath.getNodeIdentifier().getPrefix());
        YangNode tempAugment = this.getAugment(tempPath.getNodeIdentifier(), root, this.getAbsPaths());
        if (tempAugment == null) {
            tempAugment = this.getAugment(tempPath.getNodeIdentifier(), this.getRootNode(), this.getAbsPaths());
        }
        return tempAugment;
    }

    private YangNode resolveInterFileAugment(YangAtomicPath tempPath, YangNode root) {
        YangNode tempAugment;
        if (!tempPath.getNodeIdentifier().getPrefix().equals(this.getCurPrefix())) {
            this.setCurPrefix(tempPath.getNodeIdentifier().getPrefix());
            root = this.getImportedNode(this.getRootNode(), tempPath.getNodeIdentifier());
        }
        if ((tempAugment = this.getAugment(tempPath.getNodeIdentifier(), root, this.getAbsPaths())) == null) {
            return this.resolveInterToInterFileAugment(root);
        }
        return tempAugment;
    }

    private YangNode resolveInterToInterFileAugment(YangNode root) {
        List<YangAugment> augments = this.getListOfYangAugment(root);
        ArrayList<YangAtomicPath> absPaths = new ArrayList<YangAtomicPath>();
        for (YangAugment augment : augments) {
            int index = 0;
            for (YangAtomicPath path : augment.getTargetNode()) {
                if (!this.searchForAugmentInImportedNode(path.getNodeIdentifier(), index)) {
                    absPaths.clear();
                    break;
                }
                absPaths.add(path);
                ++index;
            }
            if (!absPaths.isEmpty() && absPaths.size() == this.getAbsPaths().size() - 1) {
                return augment;
            }
            absPaths.clear();
        }
        return null;
    }

    private boolean searchForAugmentInImportedNode(YangNodeIdentifier nodeId, int index) {
        if (index == this.getAbsPaths().size()) {
            return false;
        }
        YangNodeIdentifier tempNodeId = this.getAbsPaths().get(index).getNodeIdentifier();
        return nodeId.getName().equals(tempNodeId.getName());
    }

    private YangNode getAugment(YangNodeIdentifier tempNodeId, YangNode root, List<YangAtomicPath> absPaths) {
        String augmentName = this.getAugmentNodeIdentifier(tempNodeId, absPaths, root);
        if (augmentName != null) {
            return this.searchAugmentNode(root, augmentName);
        }
        return null;
    }

    private YangNode getImportedNode(YangNode root, YangNodeIdentifier nodeId) {
        List importList = root instanceof YangModule ? ((YangModule)root).getImportList() : ((YangSubModule)root).getImportList();
        for (YangImport imported : importList) {
            if (!imported.getPrefixId().equals(nodeId.getPrefix())) continue;
            return imported.getImportedNode();
        }
        return root;
    }

    private YangNode searchInSubModule(YangNode root) {
        List includeList = root instanceof YangModule ? ((YangModule)root).getIncludeList() : ((YangSubModule)root).getIncludeList();
        for (YangInclude included : includeList) {
            YangNode tempNode = this.parseData(included.getIncludedNode());
            if (tempNode == null) continue;
            return tempNode;
        }
        return null;
    }

    private YangNode getIncludedNode(YangNode root, String tempPathName) {
        List includeList = root instanceof YangModule ? ((YangModule)root).getIncludeList() : ((YangSubModule)root).getIncludeList();
        for (YangInclude included : includeList) {
            if (!this.verifyChildNode(included.getIncludedNode(), tempPathName)) continue;
            return included.getIncludedNode();
        }
        return null;
    }

    private boolean verifyChildNode(YangNode node, String name) {
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!node.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getAugmentNodeIdentifier(YangNodeIdentifier nodeId, List<YangAtomicPath> absPaths, YangNode root) {
        Iterator<YangAtomicPath> nodeIdIterator = absPaths.iterator();
        StringBuilder builder = new StringBuilder();
        while (nodeIdIterator.hasNext()) {
            YangAtomicPath tempNodeId = nodeIdIterator.next();
            if (!tempNodeId.getNodeIdentifier().equals(nodeId)) {
                String id;
                PrefixResolverType type = this.getPrefixResolverTypes().get(tempNodeId);
                switch (type) {
                    case INTER_TO_INTRA: {
                        id = "/" + tempNodeId.getNodeIdentifier().getName();
                        break;
                    }
                    case INTRA_TO_INTER: {
                        if (!this.getRootsPrefix(root).equals(tempNodeId.getNodeIdentifier().getPrefix())) {
                            id = "/" + tempNodeId.getNodeIdentifier().getPrefix() + ":" + tempNodeId.getNodeIdentifier().getName();
                            break;
                        }
                        id = "/" + tempNodeId.getNodeIdentifier().getName();
                        break;
                    }
                    case INTER_TO_INTER: {
                        id = "/" + tempNodeId.getNodeIdentifier().getPrefix() + ":" + tempNodeId.getNodeIdentifier().getName();
                        break;
                    }
                    case NO_PREFIX_CHANGE_FOR_INTRA: {
                        id = "/" + tempNodeId.getNodeIdentifier().getName();
                        break;
                    }
                    case NO_PREFIX_CHANGE_FOR_INTER: {
                        if (!this.getRootsPrefix(root).equals(tempNodeId.getNodeIdentifier().getPrefix())) {
                            id = "/" + tempNodeId.getNodeIdentifier().getPrefix() + ":" + tempNodeId.getNodeIdentifier().getName();
                            break;
                        }
                        id = "/" + tempNodeId.getNodeIdentifier().getName();
                        break;
                    }
                    default: {
                        id = "/" + tempNodeId.getNodeIdentifier().getName();
                    }
                }
                builder.append(id);
                continue;
            }
            return builder.toString();
        }
        return null;
    }

    private YangNode searchAugmentNode(YangNode node, String tempNodeId) {
        for (node = node.getChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof YangAugment) || !node.getName().equals(tempNodeId)) continue;
            return node;
        }
        return null;
    }

    private boolean validate(YangNode tempNode, int index) {
        int size = this.getAbsPaths().size();
        if (tempNode != null && index != size) {
            return true;
        }
        if (tempNode != null) {
            return false;
        }
        return index != size;
    }

    private YangNode searchTargetNode(YangNode node, YangNodeIdentifier curNodeId) {
        if (node != null) {
            node = node.getChild();
        }
        while (node != null) {
            if (node instanceof YangInput ? curNodeId.getName().equalsIgnoreCase("input") : node instanceof YangOutput && curNodeId.getName().equalsIgnoreCase("output")) {
                return node;
            }
            if (node.getName().equals(curNodeId.getName())) {
                return node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    private String getRootsPrefix(YangNode root) {
        if (root instanceof YangModule) {
            return ((YangModule)root).getPrefix();
        }
        return ((YangSubModule)root).getPrefix();
    }

    private void parsePrefixResolverList(List<YangAtomicPath> absolutePaths) {
        Iterator<YangAtomicPath> pathIterator = absolutePaths.iterator();
        String curPrefix = null;
        while (pathIterator.hasNext()) {
            String prePrefix = curPrefix;
            YangAtomicPath absPath = pathIterator.next();
            curPrefix = absPath.getNodeIdentifier().getPrefix();
            if (curPrefix != null) {
                if (!curPrefix.equals(prePrefix)) {
                    if (prePrefix != null) {
                        this.addToPrefixResolverList(PrefixResolverType.INTER_TO_INTER, absPath);
                        continue;
                    }
                    this.addToPrefixResolverList(PrefixResolverType.INTRA_TO_INTER, absPath);
                    continue;
                }
                this.addToPrefixResolverList(PrefixResolverType.NO_PREFIX_CHANGE_FOR_INTER, absPath);
                continue;
            }
            if (prePrefix != null) {
                this.addToPrefixResolverList(PrefixResolverType.INTER_TO_INTRA, absPath);
                continue;
            }
            this.addToPrefixResolverList(PrefixResolverType.NO_PREFIX_CHANGE_FOR_INTRA, absPath);
        }
    }
}

