/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.util.List;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangUses;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class AugmentListener {
    private AugmentListener() {
    }

    public static void processAugmentEntry(TreeWalkListener listener, GeneratedYangParser.AugmentStatementContext ctx) {
        YangAugment yangAugment;
        YangNode curNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY);
        List<YangAtomicPath> targetNodes = ListenerUtil.getValidAbsoluteSchemaNodeId(ctx.augment().getText(), YangConstructType.AUGMENT_DATA, ctx);
        AugmentListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, "", YangConstructType.AUGMENT_DATA);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangUses) {
            curNode = (YangNode)curData;
            yangAugment = YangDataModelFactory.getYangAugmentNode(GeneratedLanguage.JAVA_GENERATION);
            yangAugment.setTargetNode(targetNodes);
            yangAugment.setName(ListenerUtil.removeQuotesAndHandleConcat(ctx.augment().getText()));
            try {
                curNode.addChild((YangNode)yangAugment);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push((Parsable)yangAugment);
        YangResolutionInfoImpl<YangAugment> resolutionInfo = new YangResolutionInfoImpl<YangAugment>(yangAugment, curNode, line, charPositionInLine);
        AugmentListener.addToResolutionList(resolutionInfo, ctx);
    }

    public static void processAugmentExit(TreeWalkListener listener, GeneratedYangParser.AugmentStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangAugment)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.AugmentStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.whenStatement(), YangConstructType.WHEN_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText());
        ListenerValidation.validateCardinalityEitherOne(ctx.dataDefStatement(), YangConstructType.DATA_DEF_DATA, ctx.caseStatement(), YangConstructType.CASE_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ctx);
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangAugment> resolutionInfo, GeneratedYangParser.AugmentStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.AUGMENT_DATA, ctx.augment().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

