/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangContainer;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class ChoiceListener {
    private ChoiceListener() {
    }

    public static void processChoiceEntry(TreeWalkListener listener, GeneratedYangParser.ChoiceStatementContext ctx) {
        YangChoice choiceNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.CHOICE_DATA, ctx);
        ChoiceListener.validateSubStatementsCardinality(ctx);
        Parsable curData = listener.getParsedDataStack().peek();
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.CHOICE_DATA);
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangCase || curData instanceof YangGrouping || curData instanceof YangAugment || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangNotification) {
            choiceNode = YangDataModelFactory.getYangChoiceNode(GeneratedLanguage.JAVA_GENERATION);
            choiceNode.setName(identifier);
            if (ctx.configStatement().isEmpty()) {
                boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
                choiceNode.setConfig(parentConfig);
            }
            YangNode curNode = (YangNode)curData;
            try {
                curNode.addChild((YangNode)choiceNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push((Parsable)choiceNode);
    }

    public static void processChoiceExit(TreeWalkListener listener, GeneratedYangParser.ChoiceStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangChoice) {
            YangChoice choiceNode = (YangChoice)listener.getParsedDataStack().peek();
            try {
                choiceNode.validateDataOnExit();
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CONTENT, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.CHOICE_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.ChoiceStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.whenStatement(), YangConstructType.WHEN_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.defaultStatement(), YangConstructType.DEFAULT_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.mandatoryStatement(), YangConstructType.MANDATORY_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.CHOICE_DATA, ctx.identifier().getText());
    }
}

