/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangEnumeration;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaEnumerationTranslator;

public final class EnumerationListener {
    private static final String ENUMERATION_CLASS_SUFFIX = "_enum";

    private EnumerationListener() {
    }

    public static void processEnumerationEntry(TreeWalkListener listener, GeneratedYangParser.EnumSpecificationContext ctx) {
        Parsable typeData;
        YangJavaEnumerationTranslator enumerationNode;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY);
        if (listener.getParsedDataStack().peek() instanceof YangType) {
            enumerationNode = YangDataModelFactory.getYangEnumerationNode(GeneratedLanguage.JAVA_GENERATION);
            typeData = listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY);
            Parsable tmpData = listener.getParsedDataStack().peek();
            switch (tmpData.getYangConstructType()) {
                case LEAF_DATA: {
                    enumerationNode.setName(((YangLeaf)tmpData).getName() + ENUMERATION_CLASS_SUFFIX);
                    Parsable leaf = listener.getParsedDataStack().pop();
                    EnumerationListener.addChildToParentNode(listener, (YangEnumeration)enumerationNode);
                    listener.getParsedDataStack().push(leaf);
                    break;
                }
                case LEAF_LIST_DATA: {
                    enumerationNode.setName(((YangLeafList)tmpData).getName() + ENUMERATION_CLASS_SUFFIX);
                    Parsable leafList = listener.getParsedDataStack().pop();
                    EnumerationListener.addChildToParentNode(listener, (YangEnumeration)enumerationNode);
                    listener.getParsedDataStack().push(leafList);
                    break;
                }
                case UNION_DATA: {
                    YangUnion yangUnion = (YangUnion)tmpData;
                    enumerationNode.setName(yangUnion.getName() + ENUMERATION_CLASS_SUFFIX + yangUnion.getChildUnionNumber());
                    yangUnion.setChildUnionNumber(yangUnion.getChildUnionNumber() + 1);
                    EnumerationListener.addChildToParentNode(listener, (YangEnumeration)enumerationNode);
                    break;
                }
                case TYPEDEF_DATA: {
                    YangTypeDef typeDef = (YangTypeDef)tmpData;
                    enumerationNode.setName(typeDef.getName() + ENUMERATION_CLASS_SUFFIX);
                    EnumerationListener.addChildToParentNode(listener, (YangEnumeration)enumerationNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPE_DATA, ((YangType)typeData).getDataTypeName(), ListenerErrorLocation.ENTRY));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push((Parsable)enumerationNode);
    }

    public static void processEnumerationExit(TreeWalkListener listener, GeneratedYangParser.EnumSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT);
        Parsable tmpEnumerationNode = listener.getParsedDataStack().peek();
        if (tmpEnumerationNode instanceof YangEnumeration) {
            YangEnumeration enumerationNode = (YangEnumeration)tmpEnumerationNode;
            listener.getParsedDataStack().pop();
            ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT);
            Parsable tmpNode = listener.getParsedDataStack().peek();
            switch (tmpNode.getYangConstructType()) {
                case TYPE_DATA: {
                    YangType typeNode = (YangType)tmpNode;
                    typeNode.setDataTypeExtendedInfo((Object)enumerationNode);
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.EXIT));
        }
    }

    private static void addChildToParentNode(TreeWalkListener listener, YangEnumeration enumerationNode) {
        if (!(listener.getParsedDataStack().peek() instanceof YangNode)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangNode curNode = (YangNode)listener.getParsedDataStack().peek();
        try {
            curNode.addChild((YangNode)enumerationNode);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.ENUMERATION_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

