/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangDecimal64;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class FractionDigitsListener {
    private FractionDigitsListener() {
    }

    public static void processFractionDigitsEntry(TreeWalkListener listener, GeneratedYangParser.FractionDigitStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.FRACTION_DIGITS_DATA, ctx.fraction().getText(), ListenerErrorLocation.ENTRY);
        int value = FractionDigitsListener.getValidFractionDigits(ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangType)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.FRACTION_DIGITS_DATA, ctx.fraction().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType typeNode = (YangType)tmpNode;
        YangDecimal64 decimal64Node = (YangDecimal64)typeNode.getDataTypeExtendedInfo();
        decimal64Node.setFractionDigit(value);
    }

    public static int getValidFractionDigits(GeneratedYangParser.FractionDigitStatementContext ctx) {
        String value = ctx.fraction().getText().trim();
        int fractionDigits = Integer.parseInt(value);
        if (fractionDigits >= 1 && fractionDigits <= 18) {
            return fractionDigits;
        }
        ParserException parserException = new ParserException("YANG file error : fraction-digits value should be between 1 and 18.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }
}

