/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class IdentityrefListener {
    private IdentityrefListener() {
    }

    public static void processIdentityrefEntry(TreeWalkListener listener, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        Parsable typeData;
        YangIdentityRef identityRef;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.IDENTITYREF_DATA, "", ListenerErrorLocation.ENTRY);
        if (listener.getParsedDataStack().peek() instanceof YangType) {
            identityRef = new YangIdentityRef();
            typeData = listener.getParsedDataStack().pop();
            YangDataTypes yangDataTypes = ((YangType)typeData).getDataType();
            YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(ctx.baseStatement().string().getText(), YangConstructType.BASE_DATA, ctx);
            identityRef.setBaseIdentity(nodeIdentifier);
            ((YangType)typeData).setDataTypeExtendedInfo((Object)identityRef);
            int errorLine = ctx.getStart().getLine();
            int errorPosition = ctx.getStart().getCharPositionInLine();
            Parsable tmpData = listener.getParsedDataStack().peek();
            switch (tmpData.getYangConstructType()) {
                case LEAF_DATA: {
                    Parsable leaf = listener.getParsedDataStack().pop();
                    Parsable parentNodeOfLeaf = listener.getParsedDataStack().peek();
                    listener.getParsedDataStack().push(leaf);
                    if (!(parentNodeOfLeaf instanceof YangNode)) {
                        throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
                    }
                    identityRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                    if (listener.getGroupingDepth() != 0) break;
                    YangResolutionInfoImpl<YangIdentityRef> resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)parentNodeOfLeaf, errorLine, errorPosition);
                    IdentityrefListener.addToResolutionList(resolutionInfo, ctx);
                    break;
                }
                case LEAF_LIST_DATA: {
                    Parsable leafList = listener.getParsedDataStack().pop();
                    Parsable parentNodeOfLeafList = listener.getParsedDataStack().peek();
                    listener.getParsedDataStack().push(leafList);
                    if (!(parentNodeOfLeafList instanceof YangNode)) {
                        throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
                    }
                    identityRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                    if (listener.getGroupingDepth() != 0) break;
                    YangResolutionInfoImpl<YangIdentityRef> resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)parentNodeOfLeafList, errorLine, errorPosition);
                    IdentityrefListener.addToResolutionList(resolutionInfo, ctx);
                    break;
                }
                case UNION_DATA: {
                    Parsable parentNodeOfUnionNode = listener.getParsedDataStack().peek();
                    if (!(parentNodeOfUnionNode instanceof YangNode)) {
                        throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
                    }
                    identityRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                    if (listener.getGroupingDepth() != 0) break;
                    YangResolutionInfoImpl<YangIdentityRef> resolutionInfo = new YangResolutionInfoImpl<YangIdentityRef>(identityRef, (YangNode)parentNodeOfUnionNode, errorLine, errorPosition);
                    IdentityrefListener.addToResolutionList(resolutionInfo, ctx);
                    break;
                }
                case TYPEDEF_DATA: {
                    break;
                }
                default: {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push((Parsable)identityRef);
    }

    public static void processIdentityrefExit(TreeWalkListener listener, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT);
        Parsable parsableType = listener.getParsedDataStack().pop();
        if (!(parsableType instanceof YangIdentityRef)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.EXIT));
        }
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangIdentityRef> resolutionInfo, GeneratedYangParser.IdentityrefSpecificationContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.IDENTITYREF_DATA, ctx.getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

