/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class KeyListener {
    private KeyListener() {
    }

    public static void processKeyEntry(TreeWalkListener listener, GeneratedYangParser.KeyStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.KEY_DATA, ctx.key().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (listener.getParsedDataStack().peek() instanceof YangList) {
            YangList yangList = (YangList)tmpData;
            String tmpKeyValue = ListenerUtil.removeQuotesAndHandleConcat(ctx.key().getText());
            if (tmpKeyValue.contains(" ")) {
                String[] keyValues;
                for (String keyValue : keyValues = tmpKeyValue.split(" ")) {
                    try {
                        yangList.addKey(keyValue);
                    }
                    catch (DataModelException e) {
                        throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.KEY_DATA, ctx.key().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
                    }
                }
            } else {
                try {
                    yangList.addKey(tmpKeyValue);
                }
                catch (DataModelException e) {
                    throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.KEY_DATA, ctx.key().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
                }
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.KEY_DATA, ctx.key().getText(), ListenerErrorLocation.ENTRY));
        }
    }
}

