/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangResolutionInfo;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.ResolvableStatus;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class LeafrefListener {
    private LeafrefListener() {
    }

    public static void processLeafrefEntry(TreeWalkListener listener, GeneratedYangParser.LeafrefSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        YangLeafRef leafRef = new YangLeafRef();
        leafRef.setLineNumber(errorLine);
        leafRef.setCharPosition(errorPosition);
        Parsable typeData = listener.getParsedDataStack().pop();
        if (!(typeData instanceof YangType)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)typeData;
        type.setDataTypeExtendedInfo((Object)leafRef);
        leafRef.setRequireInstance(true);
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_DATA: {
                YangLeaf leaf = (YangLeaf)listener.getParsedDataStack().pop();
                Parsable parentNodeOfLeaf = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push((Parsable)leaf);
                if (!(parentNodeOfLeaf instanceof YangNode)) {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY));
                }
                leafRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                leafRef.setParentNodeOfLeafref((YangNode)parentNodeOfLeaf);
                if (listener.getGroupingDepth() != 0) break;
                YangResolutionInfoImpl<YangLeafRef> resolutionInfo = new YangResolutionInfoImpl<YangLeafRef>(leafRef, (YangNode)parentNodeOfLeaf, errorLine, errorPosition);
                LeafrefListener.addToResolutionList(resolutionInfo);
                break;
            }
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)listener.getParsedDataStack().pop();
                Parsable parentNodeOfLeafList = listener.getParsedDataStack().peek();
                listener.getParsedDataStack().push((Parsable)leafList);
                if (!(parentNodeOfLeafList instanceof YangNode)) {
                    throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY));
                }
                leafRef.setResolvableStatus(ResolvableStatus.UNRESOLVED);
                leafRef.setParentNodeOfLeafref((YangNode)parentNodeOfLeafList);
                if (listener.getGroupingDepth() != 0) break;
                YangResolutionInfoImpl<YangLeafRef> resolutionInfoImpl = new YangResolutionInfoImpl<YangLeafRef>(leafRef, (YangNode)parentNodeOfLeafList, errorLine, errorPosition);
                LeafrefListener.addToResolutionList(resolutionInfoImpl);
                break;
            }
            case TYPEDEF_DATA: {
                Parsable parentNodeOfLeafref = listener.getParsedDataStack().peek();
                leafRef.setParentNodeOfLeafref((YangNode)parentNodeOfLeafref);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY));
            }
        }
        listener.getParsedDataStack().push(typeData);
        listener.getParsedDataStack().push((Parsable)leafRef);
    }

    public static void processLeafrefExit(TreeWalkListener listener, GeneratedYangParser.LeafrefSpecificationContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.EXIT);
        Parsable parsableType = listener.getParsedDataStack().pop();
        if (!(parsableType instanceof YangLeafRef)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.EXIT));
        }
    }

    private static void addToResolutionList(YangResolutionInfoImpl resolutionInfo) {
        try {
            DataModelUtils.addResolutionInfo((YangResolutionInfo)resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.LEAFREF_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
        }
    }
}

