/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangContainer;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class ListListener {
    private ListListener() {
    }

    public static void processListEntry(TreeWalkListener listener, GeneratedYangParser.ListStatementContext ctx) {
        Parsable curData;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.LIST_DATA, ctx);
        ListListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.LIST_DATA);
        YangList yangList = YangDataModelFactory.getYangListNode(GeneratedLanguage.JAVA_GENERATION);
        yangList.setName(identifier);
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            yangList.setConfig(parentConfig);
        }
        if ((curData = listener.getParsedDataStack().peek()) instanceof YangModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangCase || curData instanceof YangNotification || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangAugment || curData instanceof YangGrouping || curData instanceof YangSubModule) {
            YangNode curNode = (YangNode)curData;
            try {
                curNode.addChild((YangNode)yangList);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push((Parsable)yangList);
    }

    public static void processListExit(TreeWalkListener listener, GeneratedYangParser.ListStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangList) {
            YangList yangList = (YangList)listener.getParsedDataStack().peek();
            try {
                yangList.validateDataOnExit();
                ListenerUtil.validateUniqueInList(yangList, ctx);
            }
            catch (DataModelException e) {
                ParserException parserException = new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.ListStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.keyStatement(), YangConstructType.KEY_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.maxElementsStatement(), YangConstructType.MAX_ELEMENT_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.minElementsStatement(), YangConstructType.MIN_ELEMENT_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityNonZero(ctx.dataDefStatement(), YangConstructType.DATA_DEF_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ctx);
    }
}

