/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangMinElement;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class MinElementsListener {
    private MinElementsListener() {
    }

    public static void processMinElementsEntry(TreeWalkListener listener, GeneratedYangParser.MinElementsStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MIN_ELEMENT_DATA, ctx.minValue().getText(), ListenerErrorLocation.ENTRY);
        int minElementValue = ListenerUtil.getValidNonNegativeIntegerValue(ctx.minValue().getText(), YangConstructType.MIN_ELEMENT_DATA, ctx);
        Parsable tmpData = listener.getParsedDataStack().peek();
        switch (tmpData.getYangConstructType()) {
            case LEAF_LIST_DATA: {
                YangLeafList leafList = (YangLeafList)tmpData;
                YangMinElement minLeafListElement = new YangMinElement();
                minLeafListElement.setMinElement(minElementValue);
                leafList.setMinElements(minLeafListElement);
                break;
            }
            case LIST_DATA: {
                YangList yangList = (YangList)tmpData;
                YangMinElement minElement = new YangMinElement();
                minElement.setMinElement(minElementValue);
                yangList.setMinElements(minElement);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MIN_ELEMENT_DATA, ctx.minValue().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }
}

