/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import java.net.URI;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class NamespaceListener {
    private NamespaceListener() {
    }

    public static void processNamespaceEntry(TreeWalkListener listener, GeneratedYangParser.NamespaceStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.NAMESPACE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        if (!NamespaceListener.validateUriValue(ctx.string().getText())) {
            ParserException parserException = new ParserException("YANG file error: Invalid namespace URI");
            parserException.setLine(ctx.string().STRING(0).getSymbol().getLine());
            parserException.setCharPosition(ctx.string().STRING(0).getSymbol().getCharPositionInLine());
            throw parserException;
        }
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case MODULE_DATA: {
                YangModule module = (YangModule)tmpNode;
                module.setNameSpace(ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText()));
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.NAMESPACE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }

    private static boolean validateUriValue(String uri) {
        uri = uri.replace("\"", "");
        try {
            URI.create(uri);
        }
        catch (Exception e1) {
            return false;
        }
        return true;
    }
}

