/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class OutputListener {
    private static final String OUTPUT_KEYWORD = "_output";

    private OutputListener() {
    }

    public static void processOutputEntry(TreeWalkListener listener, GeneratedYangParser.OutputStatementContext ctx) {
        YangOutput yangOutput;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangRpc) {
            yangOutput = YangDataModelFactory.getYangOutputNode(GeneratedLanguage.JAVA_GENERATION);
            yangOutput.setName(((YangRpc)curData).getName() + OUTPUT_KEYWORD);
            YangNode curNode = (YangNode)curData;
            try {
                curNode.addChild((YangNode)yangOutput);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push((Parsable)yangOutput);
    }

    public static void processOutputExit(TreeWalkListener listener, GeneratedYangParser.OutputStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangOutput)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.OUTPUT_DATA, "", ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

