/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangBit;
import org.onosproject.yangutils.datamodel.YangBits;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class PositionListener {
    private PositionListener() {
    }

    public static void processPositionEntry(TreeWalkListener listener, GeneratedYangParser.PositionStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.POSITION_DATA, ctx.position().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case BIT_DATA: {
                YangBit bitNode = (YangBit)tmpNode;
                int positionValue = PositionListener.getValidBitPosition(listener, ctx);
                bitNode.setPosition(positionValue);
                break;
            }
            default: {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.POSITION_DATA, ctx.position().getText(), ListenerErrorLocation.ENTRY));
            }
        }
    }

    private static int getValidBitPosition(TreeWalkListener listener, GeneratedYangParser.PositionStatementContext ctx) {
        Parsable bitNode = listener.getParsedDataStack().pop();
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.POSITION_DATA, ctx.position().getText(), ListenerErrorLocation.ENTRY);
        int positionValue = ListenerUtil.getValidNonNegativeIntegerValue(ctx.position().getText(), YangConstructType.POSITION_DATA, ctx);
        Parsable tmpNode = listener.getParsedDataStack().peek();
        switch (tmpNode.getYangConstructType()) {
            case BITS_DATA: {
                YangBits yangBits = (YangBits)tmpNode;
                listener.getParsedDataStack().push(bitNode);
                if (yangBits.isBitPositionExists(Integer.valueOf(positionValue))) {
                    ParserException parserException = new ParserException("YANG file error: Duplicate value of position is invalid.");
                    parserException.setLine(ctx.getStart().getLine());
                    parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                    throw parserException;
                }
                return positionValue;
            }
        }
        listener.getParsedDataStack().push(bitNode);
        throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.POSITION_DATA, ctx.position().getText(), ListenerErrorLocation.ENTRY));
    }
}

