/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangDecimal64;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangRangeRestriction;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.RestrictionResolver;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypeUtils;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class RangeRestrictionListener {
    private RangeRestrictionListener() {
    }

    public static void processRangeRestrictionEntry(TreeWalkListener listener, GeneratedYangParser.RangeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData.getYangConstructType() != YangConstructType.TYPE_DATA) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.ENTRY));
        }
        YangType type = (YangType)tmpData;
        RangeRestrictionListener.setRangeRestriction(listener, type, ctx);
    }

    private static void setRangeRestriction(TreeWalkListener listener, YangType type, GeneratedYangParser.RangeStatementContext ctx) {
        if (type.getDataType() == YangDataTypes.DERIVED) {
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setRangeRestrictionString(ctx.range().getText());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setLineNumber(ctx.getStart().getLine());
            ((YangDerivedInfo)type.getDataTypeExtendedInfo()).setCharPosition(ctx.getStart().getCharPositionInLine());
            return;
        }
        if (!YangDataTypeUtils.isOfRangeRestrictedType((YangDataTypes)type.getDataType()) && type.getDataType() != YangDataTypes.DECIMAL64) {
            ParserException parserException = new ParserException("YANG file error: Range restriction can't be applied to a given type");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        YangRangeRestriction rangeRestriction = null;
        try {
            if (type.getDataType() == YangDataTypes.DECIMAL64) {
                YangDecimal64 yangDecimal64 = (YangDecimal64)type.getDataTypeExtendedInfo();
                rangeRestriction = RestrictionResolver.processRangeRestriction((YangRangeRestriction)yangDecimal64.getDefaultRangeRestriction(), (int)ctx.getStart().getLine(), (int)ctx.getStart().getCharPositionInLine(), (boolean)true, (String)ctx.range().getText(), (YangDataTypes)type.getDataType());
            } else {
                rangeRestriction = RestrictionResolver.processRangeRestriction(null, (int)ctx.getStart().getLine(), (int)ctx.getStart().getCharPositionInLine(), (boolean)false, (String)ctx.range().getText(), (YangDataTypes)type.getDataType());
            }
        }
        catch (DataModelException e) {
            ParserException parserException = new ParserException(e.getMessage());
            parserException.setCharPosition(e.getCharPositionInLine());
            parserException.setLine(e.getLineNumber());
            throw parserException;
        }
        if (rangeRestriction != null) {
            if (type.getDataType() == YangDataTypes.DECIMAL64) {
                ((YangDecimal64)type.getDataTypeExtendedInfo()).setRangeRestrictedExtendedInfo((Object)rangeRestriction);
            } else {
                type.setDataTypeExtendedInfo((Object)rangeRestriction);
            }
        }
        listener.getParsedDataStack().push((Parsable)rangeRestriction);
    }

    public static void processRangeRestrictionExit(TreeWalkListener listener, GeneratedYangParser.RangeStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.EXIT);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangRangeRestriction) {
            listener.getParsedDataStack().pop();
        } else if (!(tmpData instanceof YangType) || ((YangType)tmpData).getDataType() != YangDataTypes.DERIVED) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.RANGE_DATA, ctx.range().getText(), ListenerErrorLocation.EXIT));
        }
    }
}

