/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangStatus;
import org.onosproject.yangutils.datamodel.YangStatusType;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;

public final class StatusListener {
    private static final String CURRENT_KEYWORD = "current";
    private static final String DEPRECATED_KEYWORD = "deprecated";
    private static final String OBSOLETE_KEYWORD = "obsolete";

    private StatusListener() {
    }

    public static void processStatusEntry(TreeWalkListener listener, GeneratedYangParser.StatusStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.STATUS_DATA, "", ListenerErrorLocation.ENTRY);
        YangStatusType status = StatusListener.getValidStatus(ctx);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (!(tmpData instanceof YangStatus)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.STATUS_DATA, "", ListenerErrorLocation.ENTRY));
        }
        YangStatus yangStatus = (YangStatus)tmpData;
        yangStatus.setStatus(status);
    }

    private static YangStatusType getValidStatus(GeneratedYangParser.StatusStatementContext ctx) {
        YangStatusType status;
        String value;
        switch (value = ListenerUtil.removeQuotesAndHandleConcat(ctx.status().getText())) {
            case "current": {
                status = YangStatusType.CURRENT;
                break;
            }
            case "deprecated": {
                status = YangStatusType.DEPRECATED;
                break;
            }
            case "obsolete": {
                status = YangStatusType.OBSOLETE;
                break;
            }
            default: {
                ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)YangConstructType.STATUS_DATA) + " " + ctx.status().getText() + " is not valid.");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        }
        return status;
    }
}

