/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.listeners;

import org.onosproject.yangutils.datamodel.YangContainer;
import org.onosproject.yangutils.datamodel.YangGrouping;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.YangRpc;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yangutils.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;

public final class TypeDefListener {
    private TypeDefListener() {
    }

    public static void processTypeDefEntry(TreeWalkListener listener, GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.TYPEDEF_DATA, ctx);
        TypeDefListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.TYPEDEF_DATA);
        YangTypeDef typeDefNode = YangDataModelFactory.getYangTypeDefNode(GeneratedLanguage.JAVA_GENERATION);
        typeDefNode.setName(identifier);
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangNotification || curData instanceof YangRpc || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangGrouping) {
            YangNode curNode = (YangNode)curData;
            try {
                curNode.addChild((YangNode)typeDefNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push((Parsable)typeDefNode);
    }

    public static void processTypeDefExit(TreeWalkListener listener, GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangTypeDef) {
            YangTypeDef typeDefNode = (YangTypeDef)listener.getParsedDataStack().peek();
            try {
                typeDefNode.validateDataOnExit();
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CONTENT, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.unitsStatement(), YangConstructType.UNITS_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.defaultStatement(), YangConstructType.DEFAULT_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityEqualsOne(ctx.typeStatement(), YangConstructType.TYPE_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ctx);
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
    }
}

