/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.parserutils;

import java.util.ArrayList;
import java.util.List;
import org.onosproject.yangutils.datamodel.CollisionDetector;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.TreeWalkListener;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class AugmentListenerUtil {
    private static final String AUGMENTED = "Augmented";
    private static int occurrenceCount = 1;
    private static List<String> augmentJavaFileNameList = new ArrayList<String>();
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;

    private AugmentListenerUtil() {
    }

    private static void setAugmentJavaFileNameList(List<String> nameList) {
        augmentJavaFileNameList = nameList;
    }

    public static List<String> getAugmentJavaFileNameList() {
        return augmentJavaFileNameList;
    }

    private static void setOccurrenceCount(int occurrence) {
        occurrenceCount = occurrence;
    }

    private static int getOccurrenceCount() {
        return occurrenceCount;
    }

    public static String generateNameForAugmentNode(Parsable curData, List<YangNodeIdentifier> targetNodes, TreeWalkListener listener) {
        String curPrefix = AugmentListenerUtil.getParentsPrefix((YangNode)curData);
        YangNodeIdentifier nodeId = targetNodes.get(targetNodes.size() - 1);
        boolean isPrefix = AugmentListenerUtil.isPrefixPresent(nodeId, curPrefix);
        String generateName = AugmentListenerUtil.createValidNameForAugment(nodeId, isPrefix);
        if (listener.getParsedDataStack().peek() instanceof CollisionDetector) {
            try {
                ((CollisionDetector)listener.getParsedDataStack().peek()).detectCollidingChild(generateName, YangConstructType.AUGMENT_DATA);
            }
            catch (DataModelException e) {
                return AugmentListenerUtil.updateNameWhenHasMultipleOuccrrence(nodeId, isPrefix);
            }
        }
        AugmentListenerUtil.clearOccurrenceCount();
        return generateName;
    }

    public static String createValidNameForAugment(YangNodeIdentifier nodeId, boolean isPrefix) {
        AugmentListenerUtil.getAugmentJavaFileNameList().add(AugmentListenerUtil.createName(nodeId, isPrefix));
        AugmentListenerUtil.setAugmentJavaFileNameList(AugmentListenerUtil.getAugmentJavaFileNameList());
        return AugmentListenerUtil.getAugmentJavaFileNameList().get(AugmentListenerUtil.getAugmentJavaFileNameList().size() - 1);
    }

    private static String createName(YangNodeIdentifier nodeId, boolean isPrefix) {
        if (isPrefix) {
            return AUGMENTED + YangIoUtils.getCapitalCase(nodeId.getPrefix()) + YangIoUtils.getCapitalCase(nodeId.getName());
        }
        return AUGMENTED + YangIoUtils.getCapitalCase(nodeId.getName());
    }

    private static void updateOccurenceCount() {
        int count = AugmentListenerUtil.getOccurrenceCount();
        AugmentListenerUtil.setOccurrenceCount(++count);
    }

    public static String updateNameWhenHasMultipleOuccrrence(YangNodeIdentifier nodeId, boolean isPrefix) {
        String name = "";
        AugmentListenerUtil.updateOccurenceCount();
        if (AugmentListenerUtil.getOccurrenceCount() == 2) {
            String previousAugmentsName = AugmentListenerUtil.getAugmentJavaFileNameList().get(AugmentListenerUtil.getAugmentJavaFileNameList().size() - 1);
            AugmentListenerUtil.getAugmentJavaFileNameList().remove(0);
            AugmentListenerUtil.getAugmentJavaFileNameList().add(previousAugmentsName + 1);
            name = AugmentListenerUtil.createName(nodeId, isPrefix) + 2;
        } else {
            name = AugmentListenerUtil.createName(nodeId, isPrefix) + AugmentListenerUtil.getOccurrenceCount();
        }
        AugmentListenerUtil.getAugmentJavaFileNameList().add(name);
        return name;
    }

    public static void clearOccurrenceCount() {
        AugmentListenerUtil.setOccurrenceCount(1);
    }

    private static boolean isPrefixPresent(YangNodeIdentifier nodeId, String parentsPrefix) {
        return nodeId.getPrefix() != null && nodeId.getPrefix() != parentsPrefix;
    }

    public static void validateNodeInTargetPath(YangNode curNode, List<YangNodeIdentifier> targetNodes, GeneratedYangParser.AugmentStatementContext ctx) {
        block10: {
            block9: {
                YangNode tempNode = AugmentListenerUtil.validateCurrentTargetNode(targetNodes, curNode = curNode.getChild());
                if (tempNode == null) break block9;
                switch (tempNode.getNodeType()) {
                    case CONTAINER_NODE: {
                        break block10;
                    }
                    case LIST_NODE: {
                        break block10;
                    }
                    case CHOICE_NODE: {
                        break block10;
                    }
                    case CASE_NODE: {
                        break block10;
                    }
                    case INPUT_NODE: {
                        break block10;
                    }
                    case OUTPUT_NODE: {
                        break block10;
                    }
                    case NOTIFICATION_NODE: {
                        break block10;
                    }
                    default: {
                        throw AugmentListenerUtil.parserException(ctx);
                    }
                }
            }
            throw AugmentListenerUtil.parserException(ctx);
        }
    }

    private static YangNode validateCurrentTargetNode(List<YangNodeIdentifier> targetNodes, YangNode curNode) {
        YangNode tempNode = null;
        while (curNode != null) {
            tempNode = curNode;
            for (int i = 1; i < targetNodes.size(); ++i) {
                if (curNode.getName().equals(targetNodes.get(i).getName())) {
                    if (curNode.getChild() == null || targetNodes.size() - 1 == i) {
                        if (curNode.getChild() != null && targetNodes.size() - 1 == i) {
                            return curNode;
                        }
                        if (curNode.getChild() != null || targetNodes.size() - 1 != i) break;
                        return curNode;
                    }
                } else {
                    curNode = tempNode;
                    break;
                }
                curNode = curNode.getChild();
            }
            curNode = curNode.getNextSibling();
        }
        return null;
    }

    public static ParserException parserException(GeneratedYangParser.AugmentStatementContext ctx) {
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ParserException exception = new ParserException("invalid target node path.");
        exception.setLine(line);
        exception.setCharPosition(charPositionInLine);
        return exception;
    }

    public static String getParentsPrefix(YangNode curNode) {
        String curPrefix = null;
        if (curNode instanceof YangModule) {
            curPrefix = ((YangModule)curNode).getPrefix();
        } else if (curNode instanceof YangSubModule) {
            curPrefix = ((YangSubModule)curNode).getPrefix();
        }
        return curPrefix;
    }
}

