/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.parser.impl.parserutils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangImport;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangPathArgType;
import org.onosproject.yangutils.datamodel.YangPathOperator;
import org.onosproject.yangutils.datamodel.YangPathPredicate;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.YangRelativePath;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;
import org.onosproject.yangutils.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.utils.UtilConstants;

public final class ListenerUtil {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_.-]*");
    private static final String DATE_PATTERN = "[0-9]{4}-([0-9]{2}|[0-9])-([0-9]{2}|[0-9])";
    private static final String NON_NEGATIVE_INTEGER_PATTERN = "[0-9]+";
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[-][0-9]+|[0-9]+");
    private static final Pattern PATH_PREDICATE_PATTERN = Pattern.compile("\\[(.*?)\\]");
    private static final String XML = "xml";
    private static final String ONE = "1";
    private static final int IDENTIFIER_LENGTH = 64;
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final Log log = LogFactory.getLog(ListenerUtil.class);

    private ListenerUtil() {
    }

    public static String removeQuotesAndHandleConcat(String yangStringData) {
        yangStringData = yangStringData.replace("\"", "");
        String[] tmpData = yangStringData.split(Pattern.quote("+"));
        StringBuilder builder = new StringBuilder();
        for (String yangString : tmpData) {
            builder.append(yangString);
        }
        return builder.toString();
    }

    public static String getValidIdentifier(String identifier, YangConstructType yangConstruct, ParserRuleContext ctx) {
        ParserException parserException;
        String identifierString = ListenerUtil.removeQuotesAndHandleConcat(identifier);
        if (identifierString.length() > 64) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + identifierString + " is " + "greater than 64 characters.");
        } else if (!IDENTIFIER_PATTERN.matcher(identifierString).matches()) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + identifierString + " is not " + "valid.");
        } else if (identifierString.toLowerCase().startsWith(XML)) {
            parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " identifier " + identifierString + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        } else {
            return identifierString;
        }
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static String getValidIdentifierForLeafref(String identifier, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        ParserException parserException;
        String identifierString = ListenerUtil.removeQuotesAndHandleConcat(identifier);
        if (identifierString.length() > 64) {
            parserException = new ParserException("YANG file error :  identifier " + identifierString + " in " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " is " + "greater than 64 characters.");
        } else if (!IDENTIFIER_PATTERN.matcher(identifierString).matches()) {
            parserException = new ParserException("YANG file error :  identifier " + identifierString + " in " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " is not " + "valid.");
        } else if (identifierString.toLowerCase().startsWith(XML)) {
            parserException = new ParserException("YANG file error :  identifier " + identifierString + " in " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " must not start with (('X'|'x') ('M'|'m') ('L'|'l')).");
        } else {
            return identifierString;
        }
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static boolean isDateValid(String dateToValidate) {
        if (dateToValidate == null || !dateToValidate.matches(DATE_PATTERN)) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            sdf.parse(dateToValidate);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static byte getValidVersion(GeneratedYangParser.YangVersionStatementContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(ctx.version().getText());
        if (!value.equals(ONE)) {
            ParserException parserException = new ParserException("YANG file error: Input version not supported");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return Byte.valueOf(value);
    }

    public static int getValidNonNegativeIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!value.matches(NON_NEGATIVE_INTEGER_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static int getValidIntegerValue(String integerValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        int valueInInteger;
        String value = ListenerUtil.removeQuotesAndHandleConcat(integerValue);
        if (!INTEGER_PATTERN.matcher(value).matches()) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        try {
            valueInInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " value " + value + " is not " + "valid.");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return valueInInteger;
    }

    public static boolean getValidBooleanValue(String booleanValue, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String value = ListenerUtil.removeQuotesAndHandleConcat(booleanValue);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " value " + value + " is not " + "valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static Date getCurrentDateForRevision() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = new Date();
        String dateInString = dateFormat.format(date);
        try {
            Date now = dateFormat.parse(dateInString);
            return date;
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            throw parserException;
        }
    }

    public static YangNodeIdentifier getValidNodeIdentifier(String nodeIdentifierString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpIdentifierString = ListenerUtil.removeQuotesAndHandleConcat(nodeIdentifierString);
        String[] tmpData = tmpIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(ListenerUtil.getValidIdentifier(tmpData[0], yangConstruct, ctx));
            nodeIdentifier.setName(ListenerUtil.getValidIdentifier(tmpData[1], yangConstruct, ctx));
            return nodeIdentifier;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + nodeIdentifierString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static YangNodeIdentifier getValidNodeIdentifierForLeafref(String nodeIdentifierString, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        String tmpIdentifierString = ListenerUtil.removeQuotesAndHandleConcat(nodeIdentifierString);
        String[] tmpData = tmpIdentifierString.split(Pattern.quote(":"));
        if (tmpData.length == 1) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setName(ListenerUtil.getValidIdentifierForLeafref(tmpData[0], yangConstruct, ctx, yangLeafRef));
            return nodeIdentifier;
        }
        if (tmpData.length == 2) {
            YangNodeIdentifier nodeIdentifier = new YangNodeIdentifier();
            nodeIdentifier.setPrefix(ListenerUtil.getValidIdentifierForLeafref(tmpData[0], yangConstruct, ctx, yangLeafRef));
            nodeIdentifier.setName(ListenerUtil.getValidIdentifierForLeafref(tmpData[1], yangConstruct, ctx, yangLeafRef));
            return nodeIdentifier;
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + yangLeafRef.getPath() + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }

    public static void validatePathArgument(String pathString, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        String completePathString = ListenerUtil.removeQuotesAndHandleConcat(pathString);
        yangLeafRef.setPath(completePathString);
        if (completePathString.startsWith(UtilConstants.SLASH)) {
            yangLeafRef.setPathType(YangPathArgType.ABSOLUTE_PATH);
            List<YangAtomicPath> yangAtomicPathListList = ListenerUtil.validateAbsolutePath(completePathString, yangConstruct, ctx, yangLeafRef);
            ListenerUtil.validatePrefixAndYangNode(yangAtomicPathListList, yangLeafRef);
            yangLeafRef.setAtomicPath(yangAtomicPathListList);
        } else if (completePathString.startsWith("..")) {
            yangLeafRef.setPathType(YangPathArgType.RELATIVE_PATH);
            ListenerUtil.validateRelativePath(completePathString, yangConstruct, ctx, yangLeafRef);
        } else {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + yangLeafRef.getPath() + " does not follow valid path syntax");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    private static void validatePrefixAndYangNode(List<YangAtomicPath> yangAtomicPathList, YangLeafRef yangLeafRef) {
        ListIterator<YangAtomicPath> yangAtomicPathIterator = yangAtomicPathList.listIterator();
        while (yangAtomicPathIterator.hasNext()) {
            YangAtomicPath atomicPath = (YangAtomicPath)yangAtomicPathIterator.next();
            String prefix = atomicPath.getNodeIdentifier().getPrefix();
            YangNode parentNodeOfLeafref = yangLeafRef.getParentNodeOfLeafref();
            YangNode moduleOrSubModule = ListenerUtil.getModuleOrSubmoduleInFileOfTheCurrentNode(parentNodeOfLeafref);
            YangModule moduleNode = null;
            if (moduleOrSubModule instanceof YangModule) {
                moduleNode = (YangModule)moduleOrSubModule;
            }
            if (moduleNode == null) continue;
            ListenerUtil.updatePrefixWithTheImportedList(moduleNode, prefix, yangLeafRef);
        }
    }

    private static void updatePrefixWithTheImportedList(YangModule moduleNode, String prefixInPath, YangLeafRef yangLeafRef) {
        if (prefixInPath != null && prefixInPath != "" && !prefixInPath.equals(moduleNode.getPrefix())) {
            List moduleImportList = moduleNode.getImportList();
            if (moduleImportList != null && !moduleImportList.isEmpty()) {
                ListIterator yangImportIterator = moduleImportList.listIterator();
                while (yangImportIterator.hasNext()) {
                    YangImport yangImport = (YangImport)yangImportIterator.next();
                    if (!yangImport.getPrefixId().equals(prefixInPath)) continue;
                    HashMap<String, String> prefixMap = new HashMap<String, String>();
                    prefixMap.put(prefixInPath, yangImport.getModuleName());
                    yangLeafRef.setPrefixAndItsImportedModule(prefixMap);
                }
            }
        } else {
            HashMap<String, String> prefixMap = new HashMap<String, String>();
            prefixMap.put(prefixInPath, moduleNode.getName());
            yangLeafRef.setPrefixAndItsImportedModule(prefixMap);
        }
    }

    private static YangNode getModuleOrSubmoduleInFileOfTheCurrentNode(YangNode node) {
        while (!(node instanceof YangModule) && !(node instanceof YangSubModule)) {
            if (node == null) {
                throw new ParserException("Internal datamodel error: Datamodel tree is not correct");
            }
            node = node.getParent();
        }
        return node;
    }

    private static List<YangAtomicPath> validateUniqueValues(String uniquePath, String prefixOfFile, ParserRuleContext ctx) {
        String[] pathInUnique;
        LinkedList<YangAtomicPath> atomicPath = new LinkedList<YangAtomicPath>();
        for (String uniqueValue : pathInUnique = uniquePath.split("/")) {
            YangAtomicPath yangAtomicPathPath = new YangAtomicPath();
            YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(uniqueValue, YangConstructType.UNIQUE_DATA, ctx);
            yangAtomicPathPath.setNodeIdentifier(nodeIdentifier);
            atomicPath.add(yangAtomicPathPath);
            if (nodeIdentifier.getPrefix() == null || nodeIdentifier.getPrefix() == prefixOfFile) continue;
            ParserException parserException = new ParserException("YANG file error : A leaf reference, in unique, must refer to a leaf in the list");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        return atomicPath;
    }

    public static void validateUniqueInList(YangList yangList, ParserRuleContext ctx) {
        String prefixOfTheFile = ListenerUtil.getPrefixInFileOfTheCurrentNode((YangNode)yangList);
        List uniques = yangList.getUniqueList();
        if (uniques != null && !uniques.isEmpty()) {
            ListIterator uniqueList = uniques.listIterator();
            while (uniqueList.hasNext()) {
                YangLeaf leaf;
                String pathInUnique = (String)uniqueList.next();
                List<YangAtomicPath> atomicPathInUnique = ListenerUtil.validateUniqueValues(pathInUnique, prefixOfTheFile, ctx);
                YangAtomicPath leafInPath = atomicPathInUnique.get(atomicPathInUnique.size() - 1);
                if (atomicPathInUnique.size() == 1) {
                    leaf = ListenerUtil.getReferenceLeafFromUnique((YangNode)yangList, leafInPath);
                } else {
                    atomicPathInUnique.remove(atomicPathInUnique.size() - 1);
                    YangNode holderOfLeaf = ListenerUtil.getNodeUnderListFromPath(atomicPathInUnique, (YangNode)yangList, ctx);
                    leaf = ListenerUtil.getReferenceLeafFromUnique(holderOfLeaf, leafInPath);
                }
                if (leaf != null) continue;
                ParserException parserException = new ParserException("YANG file error : A leaf reference, in unique, must refer to a leaf under the list");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
        }
    }

    private static YangNode getNodeUnderListFromPath(List<YangAtomicPath> uniquePath, YangNode node, ParserRuleContext ctx) {
        ListIterator<YangAtomicPath> nodesInReference = uniquePath.listIterator();
        YangNode potentialReferredNode = node.getChild();
        while (nodesInReference.hasNext()) {
            YangAtomicPath nodeInUnique = (YangAtomicPath)nodesInReference.next();
            YangNode referredNode = ListenerUtil.getReferredNodeFromTheUniqueNodes(nodeInUnique.getNodeIdentifier(), potentialReferredNode);
            if (referredNode == null) {
                ParserException parserException = new ParserException("YANG file error : The target node in unique reference path is invalid");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
            potentialReferredNode = referredNode.getChild();
        }
        return potentialReferredNode;
    }

    private static YangNode getReferredNodeFromTheUniqueNodes(YangNodeIdentifier nodeInUnique, YangNode potentialReferredNode) {
        while (potentialReferredNode != null) {
            if (potentialReferredNode.getName().equals(nodeInUnique.getName())) {
                return potentialReferredNode;
            }
            potentialReferredNode = potentialReferredNode.getNextSibling();
        }
        return null;
    }

    private static YangLeaf getReferenceLeafFromUnique(YangNode nodeForLeaf, YangAtomicPath leafInUnique) {
        YangLeavesHolder leavesHolder = (YangLeavesHolder)nodeForLeaf;
        List leaves = leavesHolder.getListOfLeaf();
        if (leaves != null && !leaves.isEmpty()) {
            for (YangLeaf leaf : leaves) {
                if (!leafInUnique.getNodeIdentifier().getName().equals(leaf.getName())) continue;
                return leaf;
            }
        }
        return null;
    }

    public static String getPrefixInFileOfTheCurrentNode(YangNode node) {
        String prefixInFile;
        while (!(node instanceof YangReferenceResolver)) {
            if ((node = node.getParent()) != null) continue;
            throw new ParserException("Internal datamodel error: Datamodel tree is not correct");
        }
        if (node instanceof YangModule) {
            YangModule yangModule = (YangModule)node;
            prefixInFile = yangModule.getPrefix();
        } else {
            YangSubModule yangSubModule = (YangSubModule)node;
            prefixInFile = yangSubModule.getPrefix();
        }
        return prefixInFile;
    }

    private static void validateRelativePath(String completePathString, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        YangRelativePath relativePath = new YangRelativePath();
        int numberOfAncestors = 0;
        while (completePathString.startsWith("../")) {
            completePathString = completePathString.replaceFirst("../", "");
            ++numberOfAncestors;
        }
        if (completePathString == null || completePathString.length() == 0) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + yangLeafRef.getPath() + " does not follow valid path syntax");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        relativePath.setAncestorNodeCount(numberOfAncestors);
        List<YangAtomicPath> atomicPath = ListenerUtil.validateAbsolutePath("/" + completePathString, yangConstruct, ctx, yangLeafRef);
        ListenerUtil.validatePrefixAndYangNode(atomicPath, yangLeafRef);
        relativePath.setAtomicPathList(atomicPath);
        yangLeafRef.setRelativePath(relativePath);
    }

    private static List<YangAtomicPath> validateAbsolutePath(String completePathString, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        LinkedList<YangAtomicPath> absolutePathList = new LinkedList<YangAtomicPath>();
        YangPathPredicate yangPathPredicate = new YangPathPredicate();
        while (completePathString != null) {
            YangNodeIdentifier yangNodeIdentifier;
            String nodeIdentifier;
            String path = completePathString.replaceFirst("/", "");
            if (path == null || path.length() == 0) {
                ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " does not follow valid path syntax");
                parserException.setLine(ctx.getStart().getLine());
                parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw parserException;
            }
            String[] differentiate = new String[2];
            int forNodeIdentifier = path.indexOf(47);
            int forPathPredicate = path.indexOf(91);
            if (forPathPredicate < forNodeIdentifier && forPathPredicate != -1) {
                ArrayList<String> pathPredicate = new ArrayList<String>();
                String matchedPathPredicate = ListenerUtil.matchForPathPredicate(path);
                if (matchedPathPredicate == null || matchedPathPredicate.length() == 0) {
                    ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " does not follow valid path syntax");
                    parserException.setLine(ctx.getStart().getLine());
                    parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                    throw parserException;
                }
                int indexOfMatchedFirstOpenBrace = path.indexOf(91);
                differentiate[0] = path.substring(0, indexOfMatchedFirstOpenBrace);
                differentiate[1] = path.substring(indexOfMatchedFirstOpenBrace);
                pathPredicate.add(matchedPathPredicate);
                nodeIdentifier = differentiate[0];
                if (!differentiate[1].isEmpty()) {
                    while (differentiate[1].startsWith("[")) {
                        matchedPathPredicate = ListenerUtil.matchForPathPredicate(differentiate[1]);
                        if (matchedPathPredicate == null || matchedPathPredicate.length() == 0) {
                            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " does not follow valid path syntax");
                            parserException.setLine(ctx.getStart().getLine());
                            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
                            throw parserException;
                        }
                        pathPredicate.add(matchedPathPredicate);
                        differentiate[1] = differentiate[1].substring(matchedPathPredicate.length());
                    }
                }
                List<YangPathPredicate> pathPredicateList = ListenerUtil.validatePathPredicate(pathPredicate, yangConstruct, ctx, yangPathPredicate, yangLeafRef);
                YangAtomicPath atomicPath = new YangAtomicPath();
                yangNodeIdentifier = ListenerUtil.getValidNodeIdentifierForLeafref(nodeIdentifier, yangConstruct, ctx, yangLeafRef);
                atomicPath.setNodeIdentifier(yangNodeIdentifier);
                atomicPath.setPathPredicatesList(pathPredicateList);
                absolutePathList.add(atomicPath);
            } else {
                if (path.contains("/")) {
                    nodeIdentifier = path.substring(0, path.indexOf(47));
                    differentiate[1] = path.substring(path.indexOf(47));
                } else {
                    nodeIdentifier = path;
                    differentiate[1] = null;
                }
                yangNodeIdentifier = ListenerUtil.getValidNodeIdentifierForLeafref(nodeIdentifier, yangConstruct, ctx, yangLeafRef);
                YangAtomicPath atomicPath = new YangAtomicPath();
                atomicPath.setNodeIdentifier(yangNodeIdentifier);
                atomicPath.setPathPredicatesList(null);
                absolutePathList.add(atomicPath);
            }
            if (differentiate[1] == null || differentiate[1].length() == 0) {
                completePathString = null;
                continue;
            }
            completePathString = differentiate[1];
        }
        return absolutePathList;
    }

    private static List<YangPathPredicate> validatePathPredicate(List<String> pathPredicate, YangConstructType yangConstruct, ParserRuleContext ctx, YangPathPredicate yangPathPredicate, YangLeafRef yangLeafRef) {
        Iterator<String> pathPredicateString = pathPredicate.iterator();
        ArrayList<String> pathEqualityExpression = new ArrayList<String>();
        while (pathPredicateString.hasNext()) {
            String pathPredicateForNode = pathPredicateString.next();
            pathPredicateForNode = pathPredicateForNode.substring(1).trim();
            pathPredicateForNode = pathPredicateForNode.substring(0, pathPredicateForNode.indexOf(93));
            pathEqualityExpression.add(pathPredicateForNode);
        }
        List<YangPathPredicate> validatedPathPredicateList = ListenerUtil.validatePathEqualityExpression(pathEqualityExpression, yangConstruct, ctx, yangPathPredicate, yangLeafRef);
        return validatedPathPredicateList;
    }

    private static List<YangPathPredicate> validatePathEqualityExpression(List<String> pathEqualityExpression, YangConstructType yangConstruct, ParserRuleContext ctx, YangPathPredicate yangPathPredicate, YangLeafRef yangLeafRef) {
        Iterator<String> pathEqualityExpressionString = pathEqualityExpression.iterator();
        ArrayList<YangPathPredicate> yangPathPredicateList = new ArrayList<YangPathPredicate>();
        while (pathEqualityExpressionString.hasNext()) {
            String pathEqualityExpressionForNode = pathEqualityExpressionString.next();
            String[] pathEqualityExpressionArray = pathEqualityExpressionForNode.split("[=]");
            YangNodeIdentifier yangNodeIdentifierForPredicate = ListenerUtil.getValidNodeIdentifierForLeafref(pathEqualityExpressionArray[0].trim(), yangConstruct, ctx, yangLeafRef);
            YangRelativePath yangRelativePath = ListenerUtil.validatePathKeyExpression(pathEqualityExpressionArray[1].trim(), yangConstruct, ctx, yangLeafRef);
            yangPathPredicate.setNodeIdentifier(yangNodeIdentifierForPredicate);
            yangPathPredicate.setPathOperator(YangPathOperator.EQUALTO);
            yangPathPredicate.setRightRelativePath(yangRelativePath);
            yangPathPredicateList.add(yangPathPredicate);
        }
        return yangPathPredicateList;
    }

    private static YangRelativePath validatePathKeyExpression(String rightRelativePath, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        YangRelativePath yangRelativePath = new YangRelativePath();
        String[] relativePath = rightRelativePath.split("/");
        ArrayList<String> rightAbsolutePath = new ArrayList<String>();
        int accessAncestor = 0;
        for (String path : relativePath) {
            if (path.trim().equals("..")) {
                ++accessAncestor;
                continue;
            }
            rightAbsolutePath.add(path);
        }
        List<YangAtomicPath> atomicPathInRelativePath = ListenerUtil.validateRelativePathKeyExpression(rightAbsolutePath, yangConstruct, ctx, yangLeafRef);
        yangRelativePath.setAtomicPathList(atomicPathInRelativePath);
        yangRelativePath.setAncestorNodeCount(accessAncestor);
        return yangRelativePath;
    }

    private static List<YangAtomicPath> validateRelativePathKeyExpression(List<String> rightAbsolutePath, YangConstructType yangConstruct, ParserRuleContext ctx, YangLeafRef yangLeafRef) {
        ArrayList<YangAtomicPath> atomicPathList = new ArrayList<YangAtomicPath>();
        Iterator<String> nodes = rightAbsolutePath.iterator();
        String currentInvocationFunction = nodes.next();
        String[] currentFunction = (currentInvocationFunction = currentInvocationFunction.trim()).split("[(]");
        if (!currentFunction[0].trim().equals("current") || !currentFunction[1].trim().equals(")")) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " " + yangLeafRef.getPath() + " does not follow valid path syntax");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        while (nodes.hasNext()) {
            YangAtomicPath atomicPath = new YangAtomicPath();
            String node = nodes.next();
            YangNodeIdentifier yangNodeIdentifier = ListenerUtil.getValidNodeIdentifierForLeafref(node.trim(), yangConstruct, ctx, yangLeafRef);
            atomicPath.setNodeIdentifier(yangNodeIdentifier);
            atomicPathList.add(atomicPath);
        }
        return atomicPathList;
    }

    private static String matchForPathPredicate(String matchRequiredString) {
        String matchedString = null;
        Matcher matcher = PATH_PREDICATE_PATTERN.matcher(matchRequiredString);
        if (matcher.find()) {
            matchedString = matcher.group(0);
        }
        return matchedString;
    }

    public static List<YangAtomicPath> getValidAbsoluteSchemaNodeId(String argumentString, YangConstructType yangConstructType, ParserRuleContext ctx) {
        String[] tmpData;
        ArrayList<YangAtomicPath> targetNodes = new ArrayList<YangAtomicPath>();
        String tmpSchemaNodeId = ListenerUtil.removeQuotesAndHandleConcat(argumentString);
        if (!tmpSchemaNodeId.startsWith(UtilConstants.SLASH)) {
            ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstructType) + " name " + argumentString + "is not valid");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        for (String nodeIdentifiers : tmpData = tmpSchemaNodeId.replaceFirst("^" + UtilConstants.SLASH, "").split(UtilConstants.SLASH)) {
            YangNodeIdentifier yangNodeIdentifier = ListenerUtil.getValidNodeIdentifier(nodeIdentifiers, yangConstructType, ctx);
            YangAtomicPath yangAbsPath = new YangAtomicPath();
            yangAbsPath.setNodeIdentifier(yangNodeIdentifier);
            targetNodes.add(yangAbsPath);
        }
        return targetNodes;
    }

    public static void handleUnsupportedYangConstruct(YangConstructType yangConstructType, ParserRuleContext ctx, String errorInfo, String fileName) {
        ParserException parserException = new ParserException("YANG file error : \"" + YangConstructType.getYangConstructType((YangConstructType)yangConstructType) + "\"" + errorInfo);
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        log.info((Object)(parserException.getMessage() + " at position " + parserException.getCharPositionInLine() + " in line " + parserException.getLineNumber() + " of yang file " + fileName));
    }

    public static Date getValidDateFromString(String dateInString, ParserRuleContext ctx) {
        String dateArgument = ListenerUtil.removeQuotesAndHandleConcat(dateInString);
        if (dateArgument == null || !dateArgument.matches(DATE_PATTERN)) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setLenient(false);
        try {
            Date date = sdf.parse(dateArgument);
            return date;
        }
        catch (ParseException e) {
            ParserException parserException = new ParserException("YANG file error: Input date is not correct");
            parserException.setLine(ctx.getStart().getLine());
            parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
            throw parserException;
        }
    }

    public static String getValidPrefix(String inputString, YangConstructType yangConstruct, ParserRuleContext ctx) {
        String tmpPrefixString = ListenerUtil.removeQuotesAndHandleConcat(inputString);
        String[] tmpData = tmpPrefixString.split(Pattern.quote(":"));
        if (tmpData.length == 2) {
            return tmpData[0];
        }
        ParserException parserException = new ParserException("YANG file error : " + YangConstructType.getYangConstructType((YangConstructType)yangConstruct) + " name " + inputString + " is not valid.");
        parserException.setLine(ctx.getStart().getLine());
        parserException.setCharPosition(ctx.getStart().getCharPositionInLine());
        throw parserException;
    }
}

