/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.plugin.manager.YangFileInfo;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

final class YangPluginUtils {
    private static final Logger log = LoggerFactory.getLogger(YangPluginUtils.class);
    private static final String TARGET_RESOURCE_PATH = UtilConstants.SLASH + "temp" + UtilConstants.SLASH + "yang/resources" + UtilConstants.SLASH;
    private static final String SERIALIZED_FILE_EXTENSION = ".ser";

    private YangPluginUtils() {
    }

    static void addToCompilationRoot(String source, MavenProject project, BuildContext context) {
        project.addCompileSourceRoot(source);
        context.refresh(project.getBasedir());
        log.info("Source directory added to compilation root: " + source);
    }

    static void copyYangFilesToTarget(Set<YangFileInfo> yangFileInfo, String outputDir, MavenProject project) throws IOException {
        List<File> files = YangPluginUtils.getListOfFile(yangFileInfo);
        String path = outputDir + TARGET_RESOURCE_PATH;
        File targetDir = new File(path);
        targetDir.mkdirs();
        for (File file : files) {
            Files.copy(file.toPath(), new File(path + file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        YangPluginUtils.addToProjectResource(outputDir + UtilConstants.SLASH + "temp" + UtilConstants.SLASH, project);
    }

    private static List<File> getListOfFile(Set<YangFileInfo> yangFileInfo) {
        ArrayList<File> files = new ArrayList<File>();
        for (YangFileInfo yangFile : yangFileInfo) {
            if (!yangFile.isForTranslator()) continue;
            files.add(new File(yangFile.getYangFileName()));
        }
        return files;
    }

    static void serializeDataModel(String directory, Set<YangFileInfo> fileInfoSet, MavenProject project, boolean operation) throws IOException {
        String serFileDirPath = directory + TARGET_RESOURCE_PATH;
        File dir = new File(serFileDirPath);
        dir.mkdirs();
        if (operation) {
            YangPluginUtils.addToProjectResource(directory + UtilConstants.SLASH + "temp" + UtilConstants.SLASH, project);
        }
        for (YangFileInfo fileInfo : fileInfoSet) {
            String serFileName = serFileDirPath + fileInfo.getRootNode().getName() + SERIALIZED_FILE_EXTENSION;
            fileInfo.setSerializedFile(serFileName);
            FileOutputStream fileOutputStream = new FileOutputStream(serFileName);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(fileInfo.getRootNode());
            objectOutputStream.close();
            fileOutputStream.close();
        }
    }

    private static List<String> resolveDependencyJarPath(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepos) {
        StringBuilder path = new StringBuilder();
        ArrayList<String> jarPaths = new ArrayList<String>();
        for (Object obj : project.getDependencies()) {
            Dependency dependency = (Dependency)obj;
            path.append(localRepository.getBasedir());
            path.append(UtilConstants.SLASH);
            path.append(YangIoUtils.getPackageDirPathFromJavaJPackage(dependency.getGroupId()));
            path.append(UtilConstants.SLASH);
            path.append(dependency.getArtifactId());
            path.append(UtilConstants.SLASH);
            path.append(dependency.getVersion());
            path.append(UtilConstants.SLASH);
            path.append(dependency.getArtifactId() + "-" + dependency.getVersion() + "." + "jar");
            File jarFile = new File(path.toString());
            if (jarFile.exists()) {
                jarPaths.add(path.toString());
            }
            path.delete(0, path.length());
        }
        for (ArtifactRepository artifactRepository : remoteRepos) {
        }
        return jarPaths;
    }

    static List<YangNode> resolveInterJarDependencies(MavenProject project, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepos, String directory) throws IOException {
        List<String> dependenciesJarPaths = YangPluginUtils.resolveDependencyJarPath(project, localRepository, remoteRepos);
        ArrayList<YangNode> resolvedDataModelNodes = new ArrayList<YangNode>();
        for (String dependency : dependenciesJarPaths) {
            resolvedDataModelNodes.addAll(DataModelUtils.parseJarFile((String)dependency, (String)directory));
        }
        return resolvedDataModelNodes;
    }

    private static void addToProjectResource(String dir, MavenProject project) {
        Resource rsc = new Resource();
        rsc.setDirectory(dir);
        project.addResource(rsc);
    }
}

