/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.plugin.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.onosproject.yangutils.datamodel.ResolvableType;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangReferenceResolver;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.linker.YangLinker;
import org.onosproject.yangutils.linker.exceptions.LinkerException;
import org.onosproject.yangutils.linker.impl.YangLinkerManager;
import org.onosproject.yangutils.linker.impl.YangLinkerUtils;
import org.onosproject.yangutils.parser.YangUtilsParser;
import org.onosproject.yangutils.parser.exceptions.ParserException;
import org.onosproject.yangutils.parser.impl.YangUtilsParserManager;
import org.onosproject.yangutils.plugin.manager.YangFileInfo;
import org.onosproject.yangutils.plugin.manager.YangPluginUtils;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorUtil;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yangutils.utils.io.impl.YangFileScanner;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="yang2java", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class YangUtilManager
extends AbstractMojo {
    private static final String DEFAULT_PKG = UtilConstants.SLASH + YangIoUtils.getPackageDirPathFromJavaJPackage("org.onosproject.yang.gen");
    private YangPluginConfig yangPlugin = new YangPluginConfig();
    private YangNode rootNode;
    private Set<YangFileInfo> yangFileInfoSet = new HashSet<YangFileInfo>();
    private YangUtilsParser yangUtilsParser = new YangUtilsParserManager();
    private YangLinker yangLinker = new YangLinkerManager();
    private YangFileInfo curYangFileInfo = new YangFileInfo();
    private Set<YangNode> yangNodeSet = new HashSet<YangNode>();
    @Parameter(property="yangFilesDir", defaultValue="src/main/yang")
    private String yangFilesDir;
    @Parameter(property="classFileDir", defaultValue="target/generated-sources")
    private String classFileDir;
    @Parameter(property="basedir", defaultValue="${basedir}")
    private String baseDir;
    @Parameter(property="project.build.outputDirectory", required=true, defaultValue="target/classes")
    private String outputDirectory;
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="replacementForPeriod")
    private String replacementForPeriod;
    @Parameter(property="replacementForUnderscore")
    private String replacementForUnderscore;
    @Parameter(property="replacementForHyphen")
    private String replacementForHyphen;
    @Parameter(property="prefixForIdentifier")
    private String prefixForIdentifier;
    @Component
    private BuildContext context;
    @Parameter(readonly=true, defaultValue="${localRepository}")
    private ArtifactRepository localRepository;
    @Parameter(readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepository;
    @Parameter(property="generateJavaFileForSbi", defaultValue="nbi")
    private String generateJavaFileForSbi;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            YangIoUtils.deleteDirectory(YangIoUtils.getDirectory(this.baseDir, this.outputDirectory));
            String searchDir = YangIoUtils.getDirectory(this.baseDir, this.yangFilesDir);
            String codeGenDir = YangIoUtils.getDirectory(this.baseDir, this.classFileDir) + UtilConstants.SLASH;
            YangToJavaNamingConflictUtil conflictResolver = new YangToJavaNamingConflictUtil();
            conflictResolver.setReplacementForPeriod(this.replacementForPeriod);
            conflictResolver.setReplacementForHyphen(this.replacementForHyphen);
            conflictResolver.setReplacementForUnderscore(this.replacementForUnderscore);
            conflictResolver.setPrefixForIdentifier(this.prefixForIdentifier);
            this.yangPlugin.setCodeGenDir(codeGenDir);
            this.yangPlugin.setConflictResolver(conflictResolver);
            this.yangPlugin.setCodeGenerateForSbi(this.generateJavaFileForSbi.toLowerCase());
            this.createYangFileInfoSet(YangFileScanner.getYangFiles(searchDir));
            if (this.getYangFileInfoSet() == null || this.getYangFileInfoSet().isEmpty()) {
                return;
            }
            this.resolveInterJarDependency();
            this.parseYangFileInfoSet();
            this.resolveDependenciesUsingLinker();
            this.translateToJava(this.yangPlugin);
            YangPluginUtils.serializeDataModel(YangIoUtils.getDirectory(this.baseDir, this.outputDirectory), this.getYangFileInfoSet(), this.project, true);
            YangPluginUtils.addToCompilationRoot(codeGenDir, this.project, this.context);
            YangPluginUtils.copyYangFilesToTarget(this.getYangFileInfoSet(), YangIoUtils.getDirectory(this.baseDir, this.outputDirectory), this.project);
        }
        catch (IOException | ParserException e) {
            String fileName = "";
            if (this.getCurYangFileInfo() != null) {
                fileName = this.getCurYangFileInfo().getYangFileName();
            }
            try {
                JavaCodeGeneratorUtil.translatorErrorHandler(this.getRootNode(), this.yangPlugin);
                YangIoUtils.deleteDirectory(YangIoUtils.getDirectory(this.baseDir, this.classFileDir) + DEFAULT_PKG);
            }
            catch (IOException ex) {
                e.printStackTrace();
                throw new MojoExecutionException("Error handler failed to delete files for data model node.");
            }
            e.printStackTrace();
            throw new MojoExecutionException("Exception occurred due to " + e.getLocalizedMessage() + " in " + fileName + " YANG file.");
        }
    }

    Set<YangNode> getYangNodeSet() {
        return this.yangNodeSet;
    }

    private void resolveInterJarDependency() throws IOException {
        try {
            List<YangNode> interJarResolvedNodes = YangPluginUtils.resolveInterJarDependencies(this.project, this.localRepository, this.remoteRepository, YangIoUtils.getDirectory(this.baseDir, this.outputDirectory));
            for (YangNode node : interJarResolvedNodes) {
                YangFileInfo dependentFileInfo = new YangFileInfo();
                node.setToTranslate(false);
                dependentFileInfo.setRootNode(node);
                dependentFileInfo.setForTranslator(false);
                dependentFileInfo.setYangFileName(node.getName());
                this.getYangFileInfoSet().add(dependentFileInfo);
            }
        }
        catch (IOException e) {
            throw new IOException("failed to resolve in inter-jar scenario.");
        }
    }

    public void resolveDependenciesUsingLinker() throws MojoExecutionException {
        this.createYangNodeSet();
        try {
            this.yangLinker.resolveDependencies(this.getYangNodeSet());
        }
        catch (LinkerException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    void createYangNodeSet() {
        for (YangFileInfo yangFileInfo : this.getYangFileInfoSet()) {
            this.getYangNodeSet().add(yangFileInfo.getRootNode());
        }
    }

    public void parseYangFileInfoSet() throws IOException {
        for (YangFileInfo yangFileInfo : this.getYangFileInfoSet()) {
            this.setCurYangFileInfo(yangFileInfo);
            if (!yangFileInfo.isForTranslator()) continue;
            try {
                YangNode yangNode = this.yangUtilsParser.getDataModel(yangFileInfo.getYangFileName());
                yangFileInfo.setRootNode(yangNode);
                this.setRootNode(yangNode);
                YangLinkerUtils.resolveGroupingInDefinationScope((YangReferenceResolver)yangNode);
                try {
                    ((YangReferenceResolver)yangNode).resolveSelfFileLinking(ResolvableType.YANG_DERIVED_DATA_TYPE);
                    ((YangReferenceResolver)yangNode).resolveSelfFileLinking(ResolvableType.YANG_IDENTITYREF);
                }
                catch (DataModelException dataModelException) {}
            }
            catch (ParserException e) {
                String logInfo = "Error in file: " + e.getFileName();
                if (e.getLineNumber() != 0) {
                    logInfo = logInfo + " at line: " + e.getLineNumber() + " at position: " + e.getCharPositionInLine();
                }
                if (e.getMessage() != null) {
                    logInfo = logInfo + "\n" + e.getMessage();
                }
                this.getLog().info((CharSequence)logInfo);
                throw e;
            }
        }
    }

    private YangNode getRootNode() {
        return this.rootNode;
    }

    private void setRootNode(YangNode rootNode) {
        this.rootNode = rootNode;
    }

    public void translateToJava(YangPluginConfig yangPlugin) throws IOException {
        LinkedList<YangNode> yangNodeSortedList = new LinkedList<YangNode>();
        yangNodeSortedList.addAll(this.getYangNodeSet());
        Collections.sort(yangNodeSortedList);
        for (YangNode node : yangNodeSortedList) {
            if (!node.isToTranslate()) continue;
            JavaCodeGeneratorUtil.generateJavaCode(node, yangPlugin);
        }
    }

    public void createYangFileInfoSet(List<String> yangFileList) {
        for (String yangFile : yangFileList) {
            YangFileInfo yangFileInfo = new YangFileInfo();
            yangFileInfo.setYangFileName(yangFile);
            this.getYangFileInfoSet().add(yangFileInfo);
        }
    }

    Set<YangFileInfo> getYangFileInfoSet() {
        return this.yangFileInfoSet;
    }

    void setYangFileInfoSet(Set<YangFileInfo> yangFileInfoSet) {
        this.yangFileInfoSet = yangFileInfoSet;
    }

    private YangFileInfo getCurYangFileInfo() {
        return this.curYangFileInfo;
    }

    private void setCurYangFileInfo(YangFileInfo yangFileInfo) {
        this.curYangFileInfo = yangFileInfo;
    }
}

