/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.onosproject.yangutils.datamodel.TraversalType;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeType;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.GeneratedLanguage;
import org.onosproject.yangutils.translator.exception.InvalidNodeForTranslatorException;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.YangDataModelFactory;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaCodeGeneratorUtil {
    private static final Log log = LogFactory.getLog(JavaCodeGeneratorUtil.class);
    private static YangNode curNode;
    private static YangNode rootNode;
    private static int calls;

    private JavaCodeGeneratorUtil() {
    }

    public static YangNode getCurNode() {
        return curNode;
    }

    public static void setCurNode(YangNode node) {
        curNode = node;
    }

    public static void generateJavaCode(YangNode rootNode, YangPluginConfig yangPlugin) throws TranslatorException, IOException {
        YangNode codeGenNode = rootNode;
        JavaCodeGeneratorUtil.setRootNode(rootNode);
        TraversalType curTraversal = TraversalType.ROOT;
        while (codeGenNode != null) {
            if (codeGenNode instanceof YangAugment && ((YangAugment)codeGenNode).getAugmentedNode() instanceof YangChoice) {
                JavaCodeGeneratorUtil.addCaseNodeToChoiceTarget((YangAugment)codeGenNode);
            }
            if (curTraversal != TraversalType.PARENT) {
                if (!(codeGenNode instanceof JavaCodeGenerator)) {
                    throw new TranslatorException("Unsupported node to generate code");
                }
                JavaCodeGeneratorUtil.setCurNode(codeGenNode);
                try {
                    JavaCodeGeneratorUtil.generateCodeEntry(codeGenNode, yangPlugin);
                    codeGenNode.setNameSpaceAndAddToParentSchemaMap();
                }
                catch (InvalidNodeForTranslatorException e) {
                    if (codeGenNode.getNextSibling() != null) {
                        curTraversal = TraversalType.SIBILING;
                        codeGenNode = codeGenNode.getNextSibling();
                        continue;
                    }
                    curTraversal = TraversalType.PARENT;
                    codeGenNode = codeGenNode.getParent();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin);
                    throw new TranslatorException(e.getMessage());
                }
            }
            if (curTraversal != TraversalType.PARENT && codeGenNode.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                codeGenNode = codeGenNode.getChild();
                continue;
            }
            if (codeGenNode.getNextSibling() != null) {
                try {
                    JavaCodeGeneratorUtil.generateCodeExit(codeGenNode, yangPlugin);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        e.printStackTrace();
                    }
                    JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin);
                    throw new TranslatorException(e.getMessage());
                }
                curTraversal = TraversalType.SIBILING;
                codeGenNode = codeGenNode.getNextSibling();
                continue;
            }
            try {
                JavaCodeGeneratorUtil.generateCodeExit(codeGenNode, yangPlugin);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin);
                throw new TranslatorException(e.getMessage());
            }
            curTraversal = TraversalType.PARENT;
            codeGenNode = codeGenNode.getParent();
        }
    }

    private static void generateCodeEntry(YangNode codeGenNode, YangPluginConfig yangPlugin) throws TranslatorException, IOException {
        if (!(codeGenNode instanceof JavaCodeGenerator)) {
            JavaCodeGeneratorUtil.close(codeGenNode, yangPlugin);
            throw new TranslatorException("Generated data model node cannot be translated to target language code");
        }
        ((JavaCodeGenerator)codeGenNode).generateCodeEntry(yangPlugin);
    }

    private static void generateCodeExit(YangNode codeGenNode, YangPluginConfig pluginConfig) throws TranslatorException, IOException {
        if (!(codeGenNode instanceof JavaCodeGenerator)) {
            JavaCodeGeneratorUtil.close(codeGenNode, pluginConfig);
            throw new TranslatorException("Generated data model node cannot be translated to target language code");
        }
        ((JavaCodeGenerator)codeGenNode).generateCodeExit();
    }

    private static void freeRestResources() {
        YangNode freedNode = JavaCodeGeneratorUtil.getCurNode();
        if (JavaCodeGeneratorUtil.getCurNode() != null) {
            YangNode tempNode = freedNode;
            TraversalType curTraversal = TraversalType.ROOT;
            while (freedNode != tempNode.getParent()) {
                if (curTraversal != TraversalType.PARENT && freedNode.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    freedNode = freedNode.getChild();
                    continue;
                }
                if (freedNode.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBILING;
                    if (freedNode != tempNode) {
                        JavaCodeGeneratorUtil.free(freedNode);
                    }
                    freedNode = freedNode.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                if (freedNode != tempNode) {
                    JavaCodeGeneratorUtil.free(freedNode);
                }
                freedNode = freedNode.getParent();
            }
        }
    }

    private static void free(YangNode node) {
        YangNode parent = node.getParent();
        parent.setChild(null);
        if (node.getNextSibling() != null) {
            parent.setChild(node.getNextSibling());
        } else if (node.getPreviousSibling() != null) {
            parent.setChild(node.getPreviousSibling());
        }
        node = null;
    }

    public static void translatorErrorHandler(YangNode rootNode, YangPluginConfig yangPluginConfig) throws IOException {
        if (rootNode != null) {
            JavaCodeGeneratorUtil.freeRestResources();
            YangNode tempNode = rootNode;
            JavaCodeGeneratorUtil.setCurNode(tempNode.getChild());
            TraversalType curTraversal = TraversalType.ROOT;
            while (tempNode != null) {
                if (curTraversal != TraversalType.PARENT) {
                    JavaCodeGeneratorUtil.close(tempNode, yangPluginConfig);
                }
                if (curTraversal != TraversalType.PARENT && tempNode.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    tempNode = tempNode.getChild();
                    continue;
                }
                if (tempNode.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBILING;
                    tempNode = tempNode.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                tempNode = tempNode.getParent();
            }
            JavaCodeGeneratorUtil.freeRestResources();
        }
    }

    private static void close(YangNode node, YangPluginConfig yangPlugin) throws IOException {
        if (node instanceof JavaCodeGenerator && ((TempJavaCodeFragmentFilesContainer)node).getTempJavaCodeFragmentFiles() != null) {
            ((TempJavaCodeFragmentFilesContainer)node).getTempJavaCodeFragmentFiles().freeTemporaryResources(true);
        } else if (JavaCodeGeneratorUtil.getRootNode() != null) {
            JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)JavaCodeGeneratorUtil.getRootNode()).getJavaFileInfo();
            if (javaFileInfo != null) {
                YangIoUtils.searchAndDeleteTempDir(javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath());
            } else {
                YangIoUtils.searchAndDeleteTempDir(yangPlugin.getCodeGenDir());
            }
        }
    }

    private static YangNode getRootNode() {
        return rootNode;
    }

    private static void setRootNode(YangNode rootNode) {
        JavaCodeGeneratorUtil.rootNode = rootNode;
    }

    public static YangNode searchYangNode(YangNode parentNode, YangNodeType nodeType, String nodeName) {
        YangNode child = parentNode.getChild();
        TraversalType curTraversal = TraversalType.ROOT;
        if (child == null) {
            throw new IllegalArgumentException("Given parent node does not contain any child nodes");
        }
        while (child != null) {
            if (curTraversal != TraversalType.PARENT && (child instanceof YangInput || child instanceof YangOutput ? child.getNodeType().equals((Object)nodeType) : child.getName().equals(nodeName) && child.getNodeType().equals((Object)nodeType))) {
                return child;
            }
            if (curTraversal != TraversalType.PARENT && child.getChild() != null) {
                curTraversal = TraversalType.CHILD;
                child = child.getChild();
                continue;
            }
            if (child.getNextSibling() != null) {
                curTraversal = TraversalType.SIBILING;
                child = child.getNextSibling();
                continue;
            }
            curTraversal = TraversalType.PARENT;
            child = child.getParent();
        }
        return null;
    }

    private static void addCaseNodeToChoiceTarget(YangAugment augment) {
        if (++calls == 1) {
            YangCase javaCase = YangDataModelFactory.getYangCaseNode(GeneratedLanguage.JAVA_GENERATION);
            YangPluginConfig pluginConfig = new YangPluginConfig();
            javaCase.setName(YangJavaModelUtils.getAugmentClassName(augment, pluginConfig) + YangIoUtils.getCapitalCase("case"));
            if (augment.getListOfLeaf() != null) {
                for (YangLeaf leaf : augment.getListOfLeaf()) {
                    javaCase.addLeaf(leaf);
                }
                augment.getListOfLeaf().clear();
            }
            if (augment.getListOfLeafList() != null) {
                for (YangLeafList leafList : augment.getListOfLeafList()) {
                    javaCase.addLeafList(leafList);
                }
                augment.getListOfLeafList().clear();
            }
            ArrayList<YangNode> childNodes = new ArrayList<YangNode>();
            for (YangNode child = augment.getChild(); child != null; child = child.getNextSibling()) {
                child.setParent((YangNode)javaCase);
                childNodes.add(child);
            }
            augment.setChild(null);
            try {
                augment.addChild((YangNode)javaCase);
                for (YangNode node : childNodes) {
                    node.setNextSibling(null);
                    node.setPreviousSibling(null);
                    javaCase.addChild(node);
                }
            }
            catch (DataModelException e) {
                throw new TranslatorException("Failed to add child nodes to case node of augment " + augment.getName());
            }
        }
    }

    static {
        calls = 0;
    }
}

