/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;

public class JavaImportData {
    private boolean isListToImport;
    private boolean isQueueToImport;
    private boolean isSetToImport;
    private SortedSet<JavaQualifiedTypeInfoTranslator> importSet;

    public JavaImportData() {
        this.setImportSet(new TreeSet<JavaQualifiedTypeInfoTranslator>());
    }

    private boolean getIfListImported() {
        return this.isListToImport;
    }

    void setIfListImported(boolean isList) {
        this.isListToImport = isList;
    }

    public boolean isQueueToImport() {
        return this.isQueueToImport;
    }

    public boolean isSetToImport() {
        return this.isSetToImport;
    }

    public void setQueueToImport(boolean queueToImport) {
        this.isQueueToImport = queueToImport;
    }

    public void setSetToImport(boolean setToImport) {
        this.isSetToImport = setToImport;
    }

    public SortedSet<JavaQualifiedTypeInfoTranslator> getImportSet() {
        return this.importSet;
    }

    private void setImportSet(SortedSet<JavaQualifiedTypeInfoTranslator> importSet) {
        this.importSet = importSet;
    }

    public boolean addImportInfo(JavaQualifiedTypeInfoTranslator newImportInfo, String className, String classPkg) {
        if (newImportInfo.getClassInfo().contentEquals(className)) {
            return true;
        }
        if (newImportInfo.getPkgInfo() == null) {
            return false;
        }
        if (newImportInfo.getPkgInfo().contentEquals(classPkg)) {
            return false;
        }
        for (JavaQualifiedTypeInfoTranslator curImportInfo : this.getImportSet()) {
            if (!curImportInfo.getClassInfo().contentEquals(newImportInfo.getClassInfo())) continue;
            return !curImportInfo.getPkgInfo().contentEquals(newImportInfo.getPkgInfo());
        }
        this.getImportSet().add(newImportInfo);
        return false;
    }

    public List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>();
        for (JavaQualifiedTypeInfoTranslator importInfo : this.getImportSet()) {
            if (importInfo.getPkgInfo().equals("") || importInfo.getClassInfo() == null || importInfo.getPkgInfo().equals("java.lang")) continue;
            String importString = "import " + importInfo.getPkgInfo() + "." + importInfo.getClassInfo() + ";" + "\n";
            imports.add(importString);
        }
        if (this.getIfListImported()) {
            imports.add(this.getImportForList());
        }
        if (this.isQueueToImport()) {
            imports.add(this.getImportForQueue());
        }
        if (this.isSetToImport()) {
            imports.add(this.getImportForSet());
        }
        Collections.sort(imports);
        return imports;
    }

    String getImportForHashAndEquals() {
        return "import java.util.Objects;\n";
    }

    String getImportForToString() {
        return "import com.google.common.base.MoreObjects;\n";
    }

    String getImportForToBitSet() {
        return "import java.util.BitSet;\n";
    }

    String getImportForList() {
        return "import java.util.List;\n";
    }

    public String getImportForQueue() {
        return "import java.util.Queue;\n";
    }

    public String getImportForSet() {
        return "import java.util.Set;\n";
    }

    public String getListenerServiceImport() {
        return "import org.onosproject.event.ListenerService;\n";
    }

    public String getListenerRegistryImport() {
        return "import org.onosproject.event.ListenerRegistry;\n";
    }

    String getAbstractEventsImport() {
        return "import org.onosproject.event.AbstractEvent;\n";
    }

    String getEventListenerImport() {
        return "import org.onosproject.event.EventListener;\n";
    }

    String getMapImport() {
        return "import java.util.Map;\n";
    }

    String getHashMapImport() {
        return "import java.util.HashMap;\n";
    }

    public String getBigIntegerImport() {
        return "import java.math.BigInteger;\n";
    }
}

