/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangTypeHolder;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yangutils.utils.io.YangPluginConfig;

public class TempJavaCodeFragmentFiles {
    private TempJavaBeanFragmentFiles beanTempFiles;
    private TempJavaTypeFragmentFiles typeTempFiles;
    private TempJavaServiceFragmentFiles serviceTempFiles;
    private TempJavaEnumerationFragmentFiles enumerationTempFiles;
    private TempJavaEventFragmentFiles tempJavaEventFragmentFiles;

    public TempJavaCodeFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        if ((javaFileInfo.getGeneratedFileTypes() & 0x200F) != 0) {
            this.setBeanTempFiles(new TempJavaBeanFragmentFiles(javaFileInfo));
        }
        if ((javaFileInfo.getGeneratedFileTypes() & 0xC0) != 0) {
            this.setTypeTempFiles(new TempJavaTypeFragmentFiles(javaFileInfo));
        }
        if ((javaFileInfo.getGeneratedFileTypes() & 0x20) != 0) {
            this.setEnumerationTempFiles(new TempJavaEnumerationFragmentFiles(javaFileInfo));
        }
        if ((javaFileInfo.getGeneratedFileTypes() & 0x10) != 0) {
            this.setServiceTempFiles(new TempJavaServiceFragmentFiles(javaFileInfo));
        }
        if ((javaFileInfo.getGeneratedFileTypes() & 0x700) != 0) {
            this.setEventFragmentFiles(new TempJavaEventFragmentFiles(javaFileInfo));
        }
    }

    public TempJavaBeanFragmentFiles getBeanTempFiles() {
        return this.beanTempFiles;
    }

    private void setBeanTempFiles(TempJavaBeanFragmentFiles beanTempFiles) {
        this.beanTempFiles = beanTempFiles;
    }

    public TempJavaTypeFragmentFiles getTypeTempFiles() {
        return this.typeTempFiles;
    }

    private void setTypeTempFiles(TempJavaTypeFragmentFiles typeTempFiles) {
        this.typeTempFiles = typeTempFiles;
    }

    public TempJavaServiceFragmentFiles getServiceTempFiles() {
        return this.serviceTempFiles;
    }

    private void setServiceTempFiles(TempJavaServiceFragmentFiles serviceTempFiles) {
        this.serviceTempFiles = serviceTempFiles;
    }

    public TempJavaEnumerationFragmentFiles getEnumerationTempFiles() {
        return this.enumerationTempFiles;
    }

    private void setEnumerationTempFiles(TempJavaEnumerationFragmentFiles enumerationTempFiles) {
        this.enumerationTempFiles = enumerationTempFiles;
    }

    public TempJavaEventFragmentFiles getEventFragmentFiles() {
        return this.tempJavaEventFragmentFiles;
    }

    private void setEventFragmentFiles(TempJavaEventFragmentFiles tempJavaEventFragmentFiles) {
        this.tempJavaEventFragmentFiles = tempJavaEventFragmentFiles;
    }

    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        if ((fileType & 0x200F) != 0) {
            this.getBeanTempFiles().generateJavaFile(fileType, curNode);
        }
        if ((fileType & 0xC0) != 0) {
            this.getTypeTempFiles().generateJavaFile(fileType, curNode);
        }
        if (fileType == 16) {
            this.getServiceTempFiles().generateJavaFile(16, curNode);
        }
        if (fileType == 1792) {
            this.getEventFragmentFiles().generateJavaFile(1792, curNode);
        }
        if (fileType == 32) {
            this.getEnumerationTempFiles().generateJavaFile(32, curNode);
        }
    }

    void addTypeInfoToTempFiles(YangTypeHolder yangTypeHolder, YangPluginConfig pluginConfig) throws IOException {
        this.getTypeTempFiles().addTypeInfoToTempFiles(yangTypeHolder, pluginConfig);
    }

    public String addBuildMethodForInterface(YangPluginConfig pluginConfig) throws IOException {
        if (this.getBeanTempFiles() != null) {
            return this.getBeanTempFiles().addBuildMethodForInterface(pluginConfig);
        }
        throw new TranslatorException("build method only supported for bean class");
    }

    public String addDefaultConstructor(String modifier, String toAppend, YangPluginConfig pluginConfig, YangNode curNode) throws IOException {
        boolean isSuffix = false;
        if (toAppend.equals("Builder")) {
            isSuffix = true;
        }
        if (this.getTypeTempFiles() != null) {
            return this.getTypeTempFiles().addDefaultConstructor(modifier, toAppend, pluginConfig, isSuffix);
        }
        if (this.getBeanTempFiles() != null) {
            return this.getBeanTempFiles().addDefaultConstructor(modifier, toAppend, pluginConfig, isSuffix);
        }
        throw new TranslatorException("default constructor should not be added");
    }

    public String addBuildMethodImpl(YangNode curNode) throws IOException {
        if (this.getBeanTempFiles() != null) {
            return this.getBeanTempFiles().addBuildMethodImpl();
        }
        throw new TranslatorException("build should not be added");
    }

    void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        if (this.getBeanTempFiles() != null) {
            this.getBeanTempFiles().freeTemporaryResources(isErrorOccurred);
        }
        if (this.getTypeTempFiles() != null) {
            this.getTypeTempFiles().freeTemporaryResources(isErrorOccurred);
        }
        if (this.getEnumerationTempFiles() != null) {
            this.getEnumerationTempFiles().freeTemporaryResources(isErrorOccurred);
        }
        if (this.getServiceTempFiles() != null) {
            this.getServiceTempFiles().freeTemporaryResources(isErrorOccurred);
        }
        if (this.getEventFragmentFiles() != null) {
            this.getEventFragmentFiles().freeTemporaryResources(isErrorOccurred);
        }
    }
}

