/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onosproject.yangutils.datamodel.YangEnum;
import org.onosproject.yangutils.datamodel.YangEnumeration;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaTypeTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaEnumerationFragmentFiles
extends TempJavaFragmentFiles {
    private static final String ENUM_CLASS_TEMP_FILE_NAME = "EnumClass";
    private static final String ENUM_CLASS_FILE_NAME_SUFFIX = "";
    private int enumValue;
    private Map<String, Integer> enumStringMap = new HashMap<String, Integer>();
    private List<String> enumStringList;
    private File enumClassTempFileHandle;
    private File enumClassJavaFileHandle;

    TempJavaEnumerationFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.setEnumSetJavaMap(new HashMap<String, Integer>());
        this.setEnumStringList(new ArrayList<String>());
        this.addGeneratedTempFile(4096);
        this.setEnumClassTempFileHandle(this.getTemporaryFileHandle(ENUM_CLASS_TEMP_FILE_NAME));
    }

    private File getEnumClassJavaFileHandle() {
        return this.enumClassJavaFileHandle;
    }

    private void setEnumClassJavaFileHandle(File enumClassJavaFileHandle) {
        this.enumClassJavaFileHandle = enumClassJavaFileHandle;
    }

    private int getEnumValue() {
        return this.enumValue;
    }

    private void setEnumValue(int enumValue) {
        this.enumValue = enumValue;
    }

    public Map<String, Integer> getEnumSetJavaMap() {
        return this.enumStringMap;
    }

    private void setEnumSetJavaMap(Map<String, Integer> map) {
        this.enumStringMap = map;
    }

    public File getEnumClassTempFileHandle() {
        return this.enumClassTempFileHandle;
    }

    private void setEnumClassTempFileHandle(File enumClassTempFileHandle) {
        this.enumClassTempFileHandle = enumClassTempFileHandle;
    }

    private void addAttributesForEnumClass(String curEnumName, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getEnumClassTempFileHandle(), JavaCodeSnippetGen.generateEnumAttributeString(curEnumName, this.getEnumValue(), pluginConfig));
    }

    void addEnumAttributeToTempFiles(YangNode curNode, YangPluginConfig pluginConfig) throws IOException {
        super.addJavaSnippetInfoToApplicableTempFiles(this.getJavaAttributeForEnum(pluginConfig), pluginConfig);
        if (curNode instanceof YangEnumeration) {
            YangEnumeration enumeration = (YangEnumeration)curNode;
            for (YangEnum curEnum : enumeration.getEnumSet()) {
                String enumName = curEnum.getNamedValue();
                if (enumName.matches("\\d.*")) {
                    String prefixForIdentifier = YangIoUtils.getPrefixForIdentifier(pluginConfig.getConflictResolver());
                    if (prefixForIdentifier != null) {
                        curEnum.setNamedValue(prefixForIdentifier + enumName);
                    } else {
                        curEnum.setNamedValue("yangAutoPrefix" + enumName);
                    }
                }
                this.setEnumValue(curEnum.getValue());
                this.addToEnumStringList(curEnum.getNamedValue());
                this.addToEnumSetJavaMap(curEnum.getNamedValue(), curEnum.getValue());
                this.addJavaSnippetInfoToApplicableTempFiles(curEnum.getNamedValue(), pluginConfig);
            }
        } else {
            throw new TranslatorException("current node should be of enumeration type.");
        }
    }

    public JavaAttributeInfo getJavaAttributeForEnum(YangPluginConfig pluginConfig) {
        YangJavaTypeTranslator javaType = new YangJavaTypeTranslator();
        javaType.setDataType(YangDataTypes.INT32);
        javaType.setDataTypeName("int");
        javaType.updateJavaQualifiedInfo(pluginConfig.getConflictResolver());
        return JavaAttributeInfo.getAttributeInfoForTheData(javaType.getJavaQualifiedInfo(), javaType.getDataTypeName(), javaType, this.getIsQualifiedAccessOrAddToImportList(javaType.getJavaQualifiedInfo()), false);
    }

    private void addToEnumSetJavaMap(String curEnumName, int value) {
        this.getEnumSetJavaMap().put(JavaIdentifierSyntax.getEnumJavaAttribute(curEnumName).toUpperCase(), value);
    }

    private void addJavaSnippetInfoToApplicableTempFiles(String curEnumName, YangPluginConfig pluginConfig) throws IOException {
        this.addAttributesForEnumClass(JavaIdentifierSyntax.getEnumJavaAttribute(curEnumName), pluginConfig);
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        JavaIdentifierSyntax.createPackage(curNode);
        this.setEnumClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName(ENUM_CLASS_FILE_NAME_SUFFIX)));
        this.setEnumClassJavaFileHandle(JavaFileGenerator.generateEnumClassFile(this.getEnumClassJavaFileHandle(), curNode));
        this.freeTemporaryResources(false);
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.getEnumClassJavaFileHandle(), isErrorOccurred);
        FileSystemUtil.closeFile(this.getEnumClassTempFileHandle(), true);
        super.freeTemporaryResources(isErrorOccurred);
    }

    private void addToEnumStringList(String curEnumValue) {
        this.getEnumStringList().add(JavaIdentifierSyntax.getEnumJavaAttribute(curEnumValue).toUpperCase());
    }

    public List<String> getEnumStringList() {
        return this.enumStringList;
    }

    private void setEnumStringList(List<String> enumStringList) {
        this.enumStringList = enumStringList;
    }
}

