/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaEventFragmentFiles
extends TempJavaFragmentFiles {
    private static final String EVENT_SUBJECT_NAME_SUFFIX = "EventSubject";
    private static final String EVENT_ENUM_FILE_NAME = "EventEnum";
    private static final String EVENT_METHOD_FILE_NAME = "EventMethod";
    private static final String EVENT_SUBJECT_ATTRIBUTE_FILE_NAME = "EventSubjectAttribute";
    private static final String EVENT_SUBJECT_GETTER_FILE_NAME = "EventSubjectGetter";
    private static final String EVENT_SUBJECT_SETTER_FILE_NAME = "EventSubjectSetter";
    private static final String EVENT_FILE_NAME_SUFFIX = "Event";
    private static final String EVENT_LISTENER_FILE_NAME_SUFFIX = "EventListener";
    private static final String JAVA_FILE_EXTENSION = ".java";
    private File eventSubjectJavaFileHandle;
    private File eventListenerJavaFileHandle;
    private File eventJavaFileHandle;
    private File eventEnumTempFileHandle;
    private File eventMethodTempFileHandle;
    private File eventSubjectAttributeTempFileHandle;
    private File eventSubjectGetterTempFileHandle;
    private File eventSubjectSetterTempFileHandle;

    TempJavaEventFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
        this.addGeneratedTempFile(32768);
        this.addGeneratedTempFile(65536);
        this.addGeneratedTempFile(131072);
        this.addGeneratedTempFile(262144);
        this.addGeneratedTempFile(524288);
        this.setEventEnumTempFileHandle(this.getTemporaryFileHandle(EVENT_ENUM_FILE_NAME));
        this.setEventMethodTempFileHandle(this.getTemporaryFileHandle(EVENT_METHOD_FILE_NAME));
        this.setEventSubjectAttributeTempFileHandle(this.getTemporaryFileHandle(EVENT_SUBJECT_ATTRIBUTE_FILE_NAME));
        this.setEventSubjectGetterTempFileHandle(this.getTemporaryFileHandle(EVENT_SUBJECT_GETTER_FILE_NAME));
        this.setEventSubjectSetterTempFileHandle(this.getTemporaryFileHandle(EVENT_SUBJECT_SETTER_FILE_NAME));
    }

    private static String getEventFileContents(String eventClassname, String classname) {
        return "\n    /**\n     * Creates " + classname + " event with type and subject.\n" + "     *\n" + "     * @param type event type\n" + "     * @param subject subject " + classname + "\n" + "     */\n" + "    public " + eventClassname + "(Type type, " + YangIoUtils.getCapitalCase(classname) + " subject) {\n" + "        super(type, subject);\n" + "    }\n" + "\n" + "    /**\n" + "     * Creates " + classname + " event with type, subject and time.\n" + "     *\n" + "     * @param type event type\n" + "     * @param subject subject " + classname + "\n" + "     * @param time time of event\n" + "     */\n" + "    public " + eventClassname + "(Type type, " + YangIoUtils.getCapitalCase(classname) + " subject, long time) {\n" + "        super(type, subject, time);\n" + "    }\n" + "\n";
    }

    private File getEventJavaFileHandle() {
        return this.eventJavaFileHandle;
    }

    private void setEventJavaFileHandle(File eventJavaFileHandle) {
        this.eventJavaFileHandle = eventJavaFileHandle;
    }

    private File getEventListenerJavaFileHandle() {
        return this.eventListenerJavaFileHandle;
    }

    private void setEventListenerJavaFileHandle(File eventListenerJavaFileHandle) {
        this.eventListenerJavaFileHandle = eventListenerJavaFileHandle;
    }

    private File getEventSubjectJavaFileHandle() {
        return this.eventSubjectJavaFileHandle;
    }

    private void setEventSubjectJavaFileHandle(File eventSubjectJavaFileHandle) {
        this.eventSubjectJavaFileHandle = eventSubjectJavaFileHandle;
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        this.generateEventJavaFile(curNode);
        this.generateEventListenerJavaFile(curNode);
        this.generateEventSubjectJavaFile(curNode);
        this.freeTemporaryResources(false);
    }

    private void generateEventJavaFile(YangNode curNode) throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getJavaImportData().getAbstractEventsImport());
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName());
        String nodeName = curNodeInfo + EVENT_FILE_NAME_SUFFIX;
        this.addEnumMethod(nodeName, curNodeInfo + EVENT_SUBJECT_NAME_SUFFIX);
        this.setEventJavaFileHandle(this.getJavaFileHandle(curNode, curNodeInfo + EVENT_FILE_NAME_SUFFIX));
        JavaFileGenerator.generateEventFile(this.getEventJavaFileHandle(), curNode, imports);
    }

    private void generateEventListenerJavaFile(YangNode curNode) throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getJavaImportData().getEventListenerImport());
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName());
        this.setEventListenerJavaFileHandle(this.getJavaFileHandle(curNode, curNodeInfo + EVENT_LISTENER_FILE_NAME_SUFFIX));
        JavaFileGenerator.generateEventListenerFile(this.getEventListenerJavaFileHandle(), curNode, imports);
    }

    private void generateEventSubjectJavaFile(YangNode curNode) throws IOException {
        String curNodeInfo = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName());
        this.setEventSubjectJavaFileHandle(this.getJavaFileHandle(curNode, curNodeInfo + EVENT_SUBJECT_NAME_SUFFIX));
        JavaFileGenerator.generateEventSubjectFile(this.getEventSubjectJavaFileHandle(), curNode);
    }

    public File getEventEnumTempFileHandle() {
        return this.eventEnumTempFileHandle;
    }

    private void setEventEnumTempFileHandle(File eventEnumTempFileHandle) {
        this.eventEnumTempFileHandle = eventEnumTempFileHandle;
    }

    public File getEventMethodTempFileHandle() {
        return this.eventMethodTempFileHandle;
    }

    private void setEventMethodTempFileHandle(File eventMethodTempFileHandle) {
        this.eventMethodTempFileHandle = eventMethodTempFileHandle;
    }

    public File getEventSubjectAttributeTempFileHandle() {
        return this.eventSubjectAttributeTempFileHandle;
    }

    private void setEventSubjectAttributeTempFileHandle(File eventSubjectAttributeTempFileHandle) {
        this.eventSubjectAttributeTempFileHandle = eventSubjectAttributeTempFileHandle;
    }

    public File getEventSubjectGetterTempFileHandle() {
        return this.eventSubjectGetterTempFileHandle;
    }

    private void setEventSubjectGetterTempFileHandle(File eventSubjectGetterTempFileHandle) {
        this.eventSubjectGetterTempFileHandle = eventSubjectGetterTempFileHandle;
    }

    public File getEventSubjectSetterTempFileHandle() {
        return this.eventSubjectSetterTempFileHandle;
    }

    private void setEventSubjectSetterTempFileHandle(File eventSubjectSetterTempFileHandle) {
        this.eventSubjectSetterTempFileHandle = eventSubjectSetterTempFileHandle;
    }

    void addJavaSnippetOfEvent(YangNode curNode, YangPluginConfig pluginConfig) throws IOException {
        String currentInfo = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(curNode.getName(), pluginConfig.getConflictResolver()));
        String notificationName = curNode.getName();
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase(currentInfo));
        JavaAttributeInfo javaAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, YangIoUtils.getSmallCase(currentInfo), null, false, false);
        this.addEventEnum(notificationName, pluginConfig);
        this.addEventSubjectAttribute(javaAttributeInfo, pluginConfig);
        this.addEventSubjectGetter(javaAttributeInfo, pluginConfig);
        this.addEventSubjectSetter(javaAttributeInfo, pluginConfig, currentInfo);
    }

    private void addEventEnum(String notificationName, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getEventEnumTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ENUM_ATTRIBUTE, notificationName, false, pluginConfig, null) + "    " + JavaIdentifierSyntax.getEnumJavaAttribute(notificationName).toUpperCase() + "," + "\n");
    }

    private void addEnumMethod(String eventClassname, String className) throws IOException {
        this.appendToFile(this.getEventMethodTempFileHandle(), TempJavaEventFragmentFiles.getEventFileContents(eventClassname, className));
    }

    private void addEventSubjectAttribute(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getEventSubjectAttributeTempFileHandle(), "    " + this.parseAttribute(attr, pluginConfig));
    }

    private void addEventSubjectGetter(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        this.appendToFile(this.getEventSubjectGetterTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, YangIoUtils.getCapitalCase(attr.getAttributeName()), false, pluginConfig, appDataStructure) + MethodsGenerator.getGetterForClass(attr, 1024) + "\n");
    }

    private void addEventSubjectSetter(JavaAttributeInfo attr, YangPluginConfig pluginConfig, String className) throws IOException {
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        this.appendToFile(this.getEventSubjectSetterTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD, YangIoUtils.getCapitalCase(attr.getAttributeName()), false, pluginConfig, appDataStructure) + MethodsGenerator.getSetterForClass(attr, className, 1024) + "\n");
    }

    private File getJavaFileHandle(YangNode curNode, String name) throws IOException {
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        return JavaFileGeneratorUtils.getFileObject(this.getDirPath(parentInfo), name, JAVA_FILE_EXTENSION, parentInfo);
    }

    private String getDirPath(JavaFileInfoTranslator parentInfo) {
        return (parentInfo.getPackageFilePath() + UtilConstants.SLASH + parentInfo.getJavaName()).toLowerCase();
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.getEventJavaFileHandle(), isErrorOccurred);
        FileSystemUtil.closeFile(this.getEventListenerJavaFileHandle(), isErrorOccurred);
        FileSystemUtil.closeFile(this.getEventSubjectJavaFileHandle(), isErrorOccurred);
        FileSystemUtil.closeFile(this.getEventEnumTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getEventSubjectAttributeTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getEventMethodTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getEventSubjectGetterTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getEventSubjectSetterTempFileHandle(), true);
        super.freeTemporaryResources(isErrorOccurred);
    }
}

