/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangLeaf;
import org.onosproject.yangutils.datamodel.YangLeafList;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangList;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.AttributesJavaDataType;
import org.onosproject.yangutils.translator.tojava.javamodel.JavaLeafInfoContainer;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaGroupingTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.SubtreeFilteringMethodsGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaFragmentFiles {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String TEMP_FOLDER_NAME_SUFFIX = "-Temp";
    private static final String GETTER_METHOD_FILE_NAME = "GetterMethod";
    private static final String SETTER_METHOD_FILE_NAME = "SetterMethod";
    private static final String GETTER_METHOD_IMPL_FILE_NAME = "GetterMethodImpl";
    private static final String SETTER_METHOD_IMPL_FILE_NAME = "SetterMethodImpl";
    private static final String ATTRIBUTE_FILE_NAME = "Attributes";
    private static final String TO_STRING_METHOD_FILE_NAME = "ToString";
    private static final String HASH_CODE_METHOD_FILE_NAME = "HashCode";
    private static final String EQUALS_METHOD_FILE_NAME = "Equals";
    private static final String FROM_STRING_METHOD_FILE_NAME = "FromString";
    private static final String ADD_TO_LIST_INTERFACE_METHOD_FILE_NAME = "addToList";
    private static final String ADD_TO_LIST_IMPL_METHOD_FILE_NAME = "addToListImpl";
    private static final String LEAF_IDENTIFIER_ATTRIBUTES_FILE_NAME = "leafIdentifierAtr";
    private static final String FILTER_CONTENT_MATCH_LEAF_FILE_NAME = "isFilterContentMatchLeafMask";
    private static final String FILTER_CONTENT_MATCH_LEAF_LIST_FILE_NAME = "isFilterContentMatchLeafListMask";
    private static final String FILTER_CONTENT_MATCH_NODE_FILE_NAME = "isFilterContentMatchNodeMask";
    private static final String EDIT_CONTENT_FILE_NAME = "editContentFile";
    private static final String INTERFACE_FILE_NAME_SUFFIX = "";
    private static final String BUILDER_INTERFACE_FILE_NAME_SUFFIX = "Builderinterface";
    private static final String BUILDER_CLASS_FILE_NAME_SUFFIX = "Builder";
    private JavaFileInfoTranslator javaFileInfo;
    private JavaImportData javaImportData;
    private int generatedTempFiles;
    private String absoluteDirPath;
    private JavaExtendsListHolder javaExtendsListHolder;
    private File interfaceJavaFileHandle;
    private File builderInterfaceJavaFileHandle;
    private File builderClassJavaFileHandle;
    private File implClassJavaFileHandle;
    private File attributesTempFileHandle;
    private File getterInterfaceTempFileHandle;
    private File setterInterfaceTempFileHandle;
    private File getterImplTempFileHandle;
    private File setterImplTempFileHandle;
    private File hashCodeImplTempFileHandle;
    private File equalsImplTempFileHandle;
    private File toStringImplTempFileHandle;
    private File fromStringImplTempFileHandle;
    private File addToListInterfaceTempFileHandle;
    private File addToListImplTempFileHandle;
    private File leafIdAttributeTempFileHandle;
    private File getSubtreeFilteringForListTempFileHandle;
    private File getSubtreeFilteringForChildNodeTempFileHandle;
    private File subtreeFilteringForLeafTempFileHandle;
    private File editContentTempFileHandle;
    private int leafCount = 0;
    private boolean isRooNode;
    private boolean isAttributePresent;

    TempJavaFragmentFiles() {
    }

    TempJavaFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
        if ((this.getGeneratedJavaFiles() & 1) != 0) {
            this.addGeneratedTempFile(2);
            this.addGeneratedTempFile(0x100000);
            this.addGeneratedTempFile(0x400000);
        }
        if ((this.getGeneratedJavaFiles() & 2) != 0) {
            this.addGeneratedTempFile(2);
            this.addGeneratedTempFile(8);
        }
        if ((this.getGeneratedJavaFiles() & 4) != 0) {
            this.addGeneratedTempFile(1);
            this.addGeneratedTempFile(4);
            this.addGeneratedTempFile(16);
        }
        if ((this.getGeneratedJavaFiles() & 8) != 0) {
            this.addGeneratedTempFile(1);
            this.addGeneratedTempFile(4);
            this.addGeneratedTempFile(64);
            this.addGeneratedTempFile(128);
            this.addGeneratedTempFile(256);
            this.addGeneratedTempFile(0x200000);
            this.addGeneratedTempFile(0x1000000);
            this.addGeneratedTempFile(0x800000);
            this.addGeneratedTempFile(0x2000000);
        }
        if ((this.getGeneratedJavaFiles() & 0xC0) != 0) {
            this.addGeneratedTempFile(1);
            this.addGeneratedTempFile(4);
            this.addGeneratedTempFile(64);
            this.addGeneratedTempFile(128);
            this.addGeneratedTempFile(256);
            this.addGeneratedTempFile(2048);
        }
        if ((this.getGeneratedJavaFiles() & 0x20) != 0) {
            this.addGeneratedTempFile(2048);
        }
        if ((this.getGeneratedTempFiles() & 1) != 0) {
            this.setAttributesTempFileHandle(this.getTemporaryFileHandle(ATTRIBUTE_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 2) != 0) {
            this.setGetterInterfaceTempFileHandle(this.getTemporaryFileHandle(GETTER_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 8) != 0) {
            this.setSetterInterfaceTempFileHandle(this.getTemporaryFileHandle(SETTER_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 4) != 0) {
            this.setGetterImplTempFileHandle(this.getTemporaryFileHandle(GETTER_METHOD_IMPL_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x10) != 0) {
            this.setSetterImplTempFileHandle(this.getTemporaryFileHandle(SETTER_METHOD_IMPL_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x40) != 0) {
            this.setHashCodeImplTempFileHandle(this.getTemporaryFileHandle(HASH_CODE_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x80) != 0) {
            this.setEqualsImplTempFileHandle(this.getTemporaryFileHandle(EQUALS_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x100) != 0) {
            this.setToStringImplTempFileHandle(this.getTemporaryFileHandle(TO_STRING_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x800) != 0) {
            this.setFromStringImplTempFileHandle(this.getTemporaryFileHandle(FROM_STRING_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x100000) != 0) {
            this.setAddToListInterfaceTempFileHandle(this.getTemporaryFileHandle(ADD_TO_LIST_INTERFACE_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x200000) != 0) {
            this.setAddToListImplTempFileHandle(this.getTemporaryFileHandle(ADD_TO_LIST_IMPL_METHOD_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x400000) != 0) {
            this.setLeafIdAttributeTempFileHandle(this.getTemporaryFileHandle(LEAF_IDENTIFIER_ATTRIBUTES_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x800000) != 0) {
            this.setSubtreeFilteringForLeafTempFileHandle(this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_LEAF_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x1000000) != 0) {
            this.setGetSubtreeFilteringForListTempFileHandle(this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_LEAF_LIST_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x2000000) != 0) {
            this.setGetSubtreeFilteringForChildNodeTempFileHandle(this.getTemporaryFileHandle(FILTER_CONTENT_MATCH_NODE_FILE_NAME));
        }
        if ((this.getGeneratedTempFiles() & 0x4000000) != 0) {
            this.setEditContentTempFileHandle(this.getTemporaryFileHandle(EDIT_CONTENT_FILE_NAME));
        }
    }

    static void addCurNodeInfoInParentTempFile(YangNode curNode, boolean isList, YangPluginConfig pluginConfig) throws IOException {
        YangNode parent = DataModelUtils.getParentNodeInGenCode((YangNode)curNode);
        if (!(parent instanceof JavaCodeGenerator)) {
            throw new TranslatorException("missing parent node to contain current node info in generated file");
        }
        if (parent instanceof YangJavaGroupingTranslator) {
            return;
        }
        TempJavaBeanFragmentFiles tempJavaBeanFragmentFiles = ((JavaCodeGeneratorInfo)parent).getTempJavaCodeFragmentFiles().getBeanTempFiles();
        JavaAttributeInfo javaAttributeInfo = TempJavaFragmentFiles.getCurNodeAsAttributeInTarget(curNode, parent, isList, tempJavaBeanFragmentFiles);
        tempJavaBeanFragmentFiles.addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfo, pluginConfig);
    }

    public static JavaAttributeInfo getCurNodeAsAttributeInTarget(YangNode curNode, YangNode targetNode, boolean isListNode, TempJavaFragmentFiles tempJavaFragmentFiles) {
        YangList yangList;
        boolean isQualified;
        String curNodeName = ((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName();
        if (curNodeName == null) {
            AttributesJavaDataType.updateJavaFileInfo(curNode, null);
            curNodeName = ((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName();
        }
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase(curNodeName));
        if (!(targetNode instanceof TempJavaCodeFragmentFilesContainer)) {
            throw new TranslatorException("Parent node does not have file info");
        }
        JavaImportData parentImportData = tempJavaFragmentFiles.getJavaImportData();
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)targetNode).getJavaFileInfo();
        if (tempJavaFragmentFiles instanceof TempJavaServiceFragmentFiles && qualifiedTypeInfo.getClassInfo().contentEquals("Service") || qualifiedTypeInfo.getClassInfo().contentEquals(YangIoUtils.getCapitalCase(fileInfo.getJavaName() + "Service"))) {
            isQualified = true;
        } else {
            String className = tempJavaFragmentFiles instanceof TempJavaServiceFragmentFiles ? YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + "Service" : YangIoUtils.getCapitalCase(fileInfo.getJavaName());
            isQualified = parentImportData.addImportInfo(qualifiedTypeInfo, className, fileInfo.getPackage());
        }
        boolean collectionSetFlag = false;
        if (curNode instanceof YangList && (yangList = (YangList)curNode).getCompilerAnnotation() != null && yangList.getCompilerAnnotation().getYangAppDataStructure() != null) {
            switch (yangList.getCompilerAnnotation().getYangAppDataStructure().getDataStructure()) {
                case QUEUE: {
                    parentImportData.setQueueToImport(true);
                    collectionSetFlag = true;
                    break;
                }
                case SET: {
                    parentImportData.setSetToImport(true);
                    collectionSetFlag = true;
                    break;
                }
            }
        }
        if (isListNode && !collectionSetFlag) {
            parentImportData.setIfListImported(true);
        }
        if (curNode instanceof YangList) {
            return JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, curNodeName, null, isQualified, isListNode, ((YangList)curNode).getCompilerAnnotation());
        }
        return JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, curNodeName, null, isQualified, isListNode);
    }

    private static JavaAttributeInfo getJavaAttributeOfLeaf(TempJavaFragmentFiles tempJavaFragmentFiles, YangLeaf leaf, YangPluginConfig yangPluginConfig) {
        JavaLeafInfoContainer javaLeaf = (JavaLeafInfoContainer)leaf;
        javaLeaf.setConflictResolveConfig(yangPluginConfig.getConflictResolver());
        javaLeaf.updateJavaQualifiedInfo();
        return JavaAttributeInfo.getAttributeInfoForTheData(javaLeaf.getJavaQualifiedInfo(), javaLeaf.getJavaName(yangPluginConfig.getConflictResolver()), javaLeaf.getDataType(), tempJavaFragmentFiles.getIsQualifiedAccessOrAddToImportList(javaLeaf.getJavaQualifiedInfo()), false);
    }

    private static JavaAttributeInfo getJavaAttributeOfLeafList(TempJavaFragmentFiles tempJavaFragmentFiles, YangLeafList leafList, YangPluginConfig yangPluginConfig) {
        JavaLeafInfoContainer javaLeaf = (JavaLeafInfoContainer)leafList;
        javaLeaf.setConflictResolveConfig(yangPluginConfig.getConflictResolver());
        javaLeaf.updateJavaQualifiedInfo();
        tempJavaFragmentFiles.getJavaImportData().setIfListImported(true);
        return JavaAttributeInfo.getAttributeInfoForTheData(javaLeaf.getJavaQualifiedInfo(), javaLeaf.getJavaName(yangPluginConfig.getConflictResolver()), javaLeaf.getDataType(), tempJavaFragmentFiles.getIsQualifiedAccessOrAddToImportList(javaLeaf.getJavaQualifiedInfo()), true);
    }

    private String getAbsoluteDirPath() {
        return this.absoluteDirPath;
    }

    void setAbsoluteDirPath(String absoluteDirPath) {
        this.absoluteDirPath = absoluteDirPath;
    }

    public JavaFileInfoTranslator getJavaFileInfo() {
        return this.javaFileInfo;
    }

    public void setJavaFileInfo(JavaFileInfoTranslator javaFileInfo) {
        this.javaFileInfo = javaFileInfo;
    }

    int getGeneratedTempFiles() {
        return this.generatedTempFiles;
    }

    private void setGeneratedTempFiles(int fileType) {
        this.generatedTempFiles = fileType;
    }

    void addGeneratedTempFile(int generatedTempFile) {
        this.generatedTempFiles |= generatedTempFile;
        this.setGeneratedTempFiles(this.generatedTempFiles);
    }

    int getGeneratedJavaFiles() {
        return this.getJavaFileInfo().getGeneratedFileTypes();
    }

    String getGeneratedJavaClassName() {
        return YangIoUtils.getCapitalCase(this.getJavaFileInfo().getJavaName());
    }

    public JavaImportData getJavaImportData() {
        return this.javaImportData;
    }

    void setJavaImportData(JavaImportData javaImportData) {
        this.javaImportData = javaImportData;
    }

    boolean isAttributePresent() {
        return this.isAttributePresent;
    }

    private void setAttributePresent(boolean attributePresent) {
        this.isAttributePresent = attributePresent;
    }

    public File getGetterInterfaceTempFileHandle() {
        return this.getterInterfaceTempFileHandle;
    }

    private void setGetterInterfaceTempFileHandle(File getterForInterface) {
        this.getterInterfaceTempFileHandle = getterForInterface;
    }

    public File getSetterInterfaceTempFileHandle() {
        return this.setterInterfaceTempFileHandle;
    }

    private void setSetterInterfaceTempFileHandle(File setterForInterface) {
        this.setterInterfaceTempFileHandle = setterForInterface;
    }

    public File getSetterImplTempFileHandle() {
        return this.setterImplTempFileHandle;
    }

    private void setSetterImplTempFileHandle(File setterImpl) {
        this.setterImplTempFileHandle = setterImpl;
    }

    public File getFromStringImplTempFileHandle() {
        return this.fromStringImplTempFileHandle;
    }

    private void setFromStringImplTempFileHandle(File fromStringImplTempFileHandle) {
        this.fromStringImplTempFileHandle = fromStringImplTempFileHandle;
    }

    private File getInterfaceJavaFileHandle() {
        return this.interfaceJavaFileHandle;
    }

    private void setInterfaceJavaFileHandle(File interfaceJavaFileHandle) {
        this.interfaceJavaFileHandle = interfaceJavaFileHandle;
    }

    private File getBuilderInterfaceJavaFileHandle() {
        return this.builderInterfaceJavaFileHandle;
    }

    private void setBuilderInterfaceJavaFileHandle(File builderInterfaceJavaFileHandle) {
        this.builderInterfaceJavaFileHandle = builderInterfaceJavaFileHandle;
    }

    private File getBuilderClassJavaFileHandle() {
        return this.builderClassJavaFileHandle;
    }

    private void setBuilderClassJavaFileHandle(File builderClassJavaFileHandle) {
        this.builderClassJavaFileHandle = builderClassJavaFileHandle;
    }

    private File getImplClassJavaFileHandle() {
        return this.implClassJavaFileHandle;
    }

    private void setImplClassJavaFileHandle(File implClassJavaFileHandle) {
        this.implClassJavaFileHandle = implClassJavaFileHandle;
    }

    public File getAttributesTempFileHandle() {
        return this.attributesTempFileHandle;
    }

    private void setAttributesTempFileHandle(File attributeForClass) {
        this.attributesTempFileHandle = attributeForClass;
    }

    public File getGetterImplTempFileHandle() {
        return this.getterImplTempFileHandle;
    }

    private void setGetterImplTempFileHandle(File getterImpl) {
        this.getterImplTempFileHandle = getterImpl;
    }

    public File getHashCodeImplTempFileHandle() {
        return this.hashCodeImplTempFileHandle;
    }

    private void setHashCodeImplTempFileHandle(File hashCodeMethod) {
        this.hashCodeImplTempFileHandle = hashCodeMethod;
    }

    public File getEqualsImplTempFileHandle() {
        return this.equalsImplTempFileHandle;
    }

    private void setEqualsImplTempFileHandle(File equalsMethod) {
        this.equalsImplTempFileHandle = equalsMethod;
    }

    public File getToStringImplTempFileHandle() {
        return this.toStringImplTempFileHandle;
    }

    private void setToStringImplTempFileHandle(File toStringMethod) {
        this.toStringImplTempFileHandle = toStringMethod;
    }

    public JavaExtendsListHolder getJavaExtendsListHolder() {
        return this.javaExtendsListHolder;
    }

    void setJavaExtendsListHolder(JavaExtendsListHolder javaExtendsListHolder) {
        this.javaExtendsListHolder = javaExtendsListHolder;
    }

    private void addSubTreeFilteringForLeaf(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getSubtreeFilteringForLeafTempFileHandle(), SubtreeFilteringMethodsGenerator.getSubtreeFilteringForLeaf(attr, attr.getAttributeType()) + "\n");
    }

    private void addSubtreeFilteringForLeafList(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getGetSubtreeFilteringForListTempFileHandle(), SubtreeFilteringMethodsGenerator.getSubtreeFilteringForLeafList(attr) + "\n");
    }

    private void addSubtreeFilteringForChildNode(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getGetSubtreeFilteringForChildNodeTempFileHandle(), SubtreeFilteringMethodsGenerator.getSubtreeFilteringForNode(attr) + "\n");
    }

    private void addAttribute(JavaAttributeInfo attr, YangPluginConfig yangPluginConfig) throws IOException {
        this.appendToFile(this.getAttributesTempFileHandle(), this.parseAttribute(attr, yangPluginConfig) + "    ");
    }

    private void addGetterForInterface(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getGetterInterfaceTempFileHandle(), MethodsGenerator.getGetterString(attr, this.getGeneratedJavaFiles(), pluginConfig) + "\n");
    }

    private void addSetterForInterface(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getSetterInterfaceTempFileHandle(), MethodsGenerator.getSetterString(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles(), pluginConfig) + "\n");
    }

    private void addSetterImpl(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        if (this.isRooNode()) {
            this.appendToFile(this.getSetterImplTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.SETTER_METHOD, attr.getAttributeName(), attr.isListAttr(), pluginConfig, null) + MethodsGenerator.getSetterForClass(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles()) + "\n");
        } else {
            this.appendToFile(this.getSetterImplTempFileHandle(), MethodsGenerator.getOverRideString() + MethodsGenerator.getSetterForClass(attr, this.getGeneratedJavaClassName(), this.getGeneratedJavaFiles()) + "\n");
        }
    }

    void addGetterImpl(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        if ((this.getGeneratedJavaFiles() & 4) != 0 || (this.getGeneratedJavaFiles() & 0x10) != 0) {
            if (!this.isRooNode()) {
                this.appendToFile(this.getGetterImplTempFileHandle(), MethodsGenerator.getOverRideString() + MethodsGenerator.getGetterForClass(attr, this.getGeneratedJavaFiles()) + "\n");
            } else {
                this.appendToFile(this.getGetterImplTempFileHandle(), MethodsGenerator.getGetterForClass(attr, this.getGeneratedJavaFiles()) + "\n");
            }
        } else {
            String appDataStructure = null;
            if (attr.getCompilerAnnotation() != null) {
                appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
            }
            this.appendToFile(this.getGetterImplTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, YangIoUtils.getCapitalCase(attr.getAttributeName()), false, pluginConfig, appDataStructure) + MethodsGenerator.getGetterForClass(attr, this.getGeneratedJavaFiles()) + "\n");
        }
    }

    private void addAddToListInterface(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getAddToListInterfaceTempFileHandle(), JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ADD_TO_LIST, YangIoUtils.getCapitalCase(attr.getAttributeName()), false, pluginConfig, null) + MethodsGenerator.getAddToListMethodInterface(attr, this.getGeneratedJavaClassName()) + "\n");
    }

    private void addAddToListImpl(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getAddToListImplTempFileHandle(), MethodsGenerator.getAddToListMethodImpl(attr, this.getGeneratedJavaClassName(), this.isRooNode()) + "\n");
    }

    private void addLeafIdAttributes(JavaAttributeInfo attr, int value, YangPluginConfig yangPluginConfig) throws IOException {
        this.appendToFile(this.getLeafIdAttributeTempFileHandle(), "    " + JavaCodeSnippetGen.generateEnumAttributeString(attr.getAttributeName(), value, yangPluginConfig));
    }

    String addBuildMethodForInterface(YangPluginConfig pluginConfig) throws IOException {
        return MethodsGenerator.parseBuilderInterfaceBuildMethodString(this.getGeneratedJavaClassName(), pluginConfig);
    }

    String addBuildMethodImpl() throws IOException {
        return MethodsGenerator.getBuildString(this.getGeneratedJavaClassName(), this.isRooNode()) + "\n";
    }

    String addDefaultConstructor(String modifier, String toAppend, YangPluginConfig pluginConfig, boolean isSuffix) throws IOException {
        String name = this.getGeneratedJavaClassName();
        if (this.isRooNode() && !toAppend.equals(BUILDER_CLASS_FILE_NAME_SUFFIX)) {
            name = name + "OpParam";
            return "\n" + MethodsGenerator.getDefaultConstructorString(name, modifier, pluginConfig);
        }
        if (isSuffix) {
            return "\n" + MethodsGenerator.getDefaultConstructorString(name + toAppend, modifier, pluginConfig);
        }
        String appended = toAppend.equals("default") ? YangIoUtils.getCapitalCase(toAppend) : toAppend;
        return "\n" + MethodsGenerator.getDefaultConstructorString(appended + name, modifier, pluginConfig);
    }

    private void addHashCodeMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getHashCodeImplTempFileHandle(), MethodsGenerator.getHashCodeMethod(attr) + "\n");
    }

    private void addEqualsMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getEqualsImplTempFileHandle(), MethodsGenerator.getEqualsMethod(attr) + "\n");
    }

    private void addToStringMethod(JavaAttributeInfo attr) throws IOException {
        this.appendToFile(this.getToStringImplTempFileHandle(), MethodsGenerator.getToStringMethod(attr) + "\n");
    }

    void addFromStringMethod(JavaAttributeInfo javaAttributeInfo, JavaAttributeInfo fromStringAttributeInfo) throws IOException {
        this.appendToFile(this.getFromStringImplTempFileHandle(), MethodsGenerator.getFromStringMethod(javaAttributeInfo, fromStringAttributeInfo) + "\n");
    }

    File getTemporaryFileHandle(String fileName) throws IOException {
        boolean isCreated;
        String path = this.getTempDirPath(this.getAbsoluteDirPath());
        File dir = new File(path);
        if (!dir.exists() && !(isCreated = dir.mkdirs())) {
            throw new IOException("failed to create temporary directory for " + fileName);
        }
        File file = new File(path + fileName + TEMP_FILE_EXTENSION);
        if (!file.exists()) {
            isCreated = file.createNewFile();
            if (!isCreated) {
                throw new IOException("failed to create temporary file for " + fileName);
            }
        } else {
            throw new IOException(fileName + " is reused due to YANG naming");
        }
        return file;
    }

    File getJavaFileHandle(String fileName) throws IOException {
        return JavaFileGeneratorUtils.getFileObject(this.getDirPath(), fileName, JAVA_FILE_EXTENSION, this.getJavaFileInfo());
    }

    public String getTemporaryDataFromFileHandle(File file, String absolutePath) throws IOException {
        String path = this.getTempDirPath(absolutePath);
        if (new File(path + file.getName()).exists()) {
            return FileSystemUtil.readAppendFile(path + file.getName(), INTERFACE_FILE_NAME_SUFFIX);
        }
        throw new IOException("Unable to get data from the given " + file.getName() + " file for " + this.getGeneratedJavaClassName() + ".");
    }

    private String getTempDirPath(String absolutePath) {
        return YangIoUtils.getPackageDirPathFromJavaJPackage(absolutePath) + UtilConstants.SLASH + this.getGeneratedJavaClassName() + TEMP_FOLDER_NAME_SUFFIX + UtilConstants.SLASH;
    }

    String parseAttribute(JavaAttributeInfo attr, YangPluginConfig pluginConfig) {
        String attributeName = YangIoUtils.getCamelCase(attr.getAttributeName(), pluginConfig.getConflictResolver());
        String attributeAccessType = "private";
        if ((this.javaFileInfo.getGeneratedFileTypes() & 0x200F) != 0) {
            attributeAccessType = "protected";
        }
        if (attr.isQualifiedName()) {
            return JavaCodeSnippetGen.getJavaAttributeDefinition(attr.getImportInfo().getPkgInfo(), attr.getImportInfo().getClassInfo(), attributeName, attr.isListAttr(), attributeAccessType, attr.getCompilerAnnotation());
        }
        return JavaCodeSnippetGen.getJavaAttributeDefinition(null, attr.getImportInfo().getClassInfo(), attributeName, attr.isListAttr(), attributeAccessType, attr.getCompilerAnnotation());
    }

    void appendToFile(File file, String data) throws IOException {
        try {
            YangIoUtils.insertDataIntoJavaFile(file, data);
        }
        catch (IOException ex) {
            throw new IOException("failed to write in temp file.");
        }
    }

    void addParentInfoInCurNodeTempFile(YangNode curNode, YangPluginConfig pluginConfig) {
        JavaQualifiedTypeInfoTranslator caseImportInfo = new JavaQualifiedTypeInfoTranslator();
        YangNode parent = DataModelUtils.getParentNodeInGenCode((YangNode)curNode);
        if (curNode instanceof YangCase && parent instanceof YangAugment) {
            return;
        }
        if (!(parent instanceof JavaCodeGenerator)) {
            throw new TranslatorException("missing parent node to contain current node info in generated file");
        }
        if (!(curNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("missing java file information to get the package details of attribute corresponding to child node");
        }
        caseImportInfo.setClassInfo(YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(parent.getName(), pluginConfig.getConflictResolver())));
        caseImportInfo.setPkgInfo(((JavaFileInfoContainer)parent).getJavaFileInfo().getPackage());
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaImportData().addImportInfo(caseImportInfo, YangIoUtils.getCapitalCase(fileInfo.getJavaName()), fileInfo.getPackage());
    }

    private void addLeavesInfoToTempFiles(List<YangLeaf> listOfLeaves, YangPluginConfig yangPluginConfig, YangNode curNode) throws IOException {
        if (listOfLeaves != null) {
            for (YangLeaf leaf : listOfLeaves) {
                if (!(leaf instanceof JavaLeafInfoContainer)) {
                    throw new TranslatorException("Leaf does not have java information");
                }
                if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
                    TempJavaBeanFragmentFiles tempJavaBeanFragmentFiles = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles();
                    this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeaf(tempJavaBeanFragmentFiles, leaf, yangPluginConfig), yangPluginConfig);
                    continue;
                }
                this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeaf(this, leaf, yangPluginConfig), yangPluginConfig);
            }
        }
    }

    private void addLeafListInfoToTempFiles(List<YangLeafList> listOfLeafList, YangPluginConfig yangPluginConfig, YangNode curNode) throws IOException {
        if (listOfLeafList != null) {
            for (YangLeafList leafList : listOfLeafList) {
                if (!(leafList instanceof JavaLeafInfoContainer)) {
                    throw new TranslatorException("Leaf-list does not have java information");
                }
                if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
                    TempJavaBeanFragmentFiles tempJavaBeanFragmentFiles = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles();
                    this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeafList(tempJavaBeanFragmentFiles, leafList, yangPluginConfig), yangPluginConfig);
                    continue;
                }
                this.addJavaSnippetInfoToApplicableTempFiles(TempJavaFragmentFiles.getJavaAttributeOfLeafList(this, leafList, yangPluginConfig), yangPluginConfig);
            }
        }
    }

    void addCurNodeLeavesInfoToTempFiles(YangNode curNode, YangPluginConfig yangPluginConfig) throws IOException {
        if (!(curNode instanceof YangLeavesHolder)) {
            throw new TranslatorException("Data model node does not have any leaves");
        }
        YangLeavesHolder leavesHolder = (YangLeavesHolder)curNode;
        this.addLeavesInfoToTempFiles(leavesHolder.getListOfLeaf(), yangPluginConfig, curNode);
        this.addLeafListInfoToTempFiles(leavesHolder.getListOfLeafList(), yangPluginConfig, curNode);
    }

    void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo newAttrInfo, YangPluginConfig pluginConfig) throws IOException {
        this.setAttributePresent(true);
        if ((this.getGeneratedTempFiles() & 1) != 0) {
            this.addAttribute(newAttrInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 2) != 0) {
            this.addGetterForInterface(newAttrInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 8) != 0) {
            this.addSetterForInterface(newAttrInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 0x10) != 0) {
            this.addSetterImpl(newAttrInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 0x40) != 0) {
            this.addHashCodeMethod(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x80) != 0) {
            this.addEqualsMethod(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x100) != 0) {
            this.addToStringMethod(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x4000000) != 0) {
            // empty if block
        }
        if ((this.getGeneratedTempFiles() & 0x200000) != 0 && newAttrInfo.isListAttr()) {
            this.addAddToListImpl(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x100000) != 0 && newAttrInfo.isListAttr()) {
            this.addAddToListInterface(newAttrInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 0x2000000) != 0 && newAttrInfo.getAttributeType() == null) {
            this.addSubtreeFilteringForChildNode(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x800000) != 0 && !newAttrInfo.isListAttr() && newAttrInfo.getAttributeType() != null) {
            this.addSubTreeFilteringForLeaf(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x1000000) != 0 && newAttrInfo.isListAttr() && newAttrInfo.getAttributeType() != null) {
            this.addSubtreeFilteringForLeafList(newAttrInfo);
        }
        if ((this.getGeneratedTempFiles() & 0x400000) != 0 && !newAttrInfo.isListAttr() && newAttrInfo.getAttributeType() != null) {
            ++this.leafCount;
            this.addLeafIdAttributes(newAttrInfo, this.leafCount, pluginConfig);
        }
        if (!newAttrInfo.isIntConflict() && !newAttrInfo.isLongConflict()) {
            if ((this.getGeneratedTempFiles() & 4) != 0) {
                this.addGetterImpl(newAttrInfo, pluginConfig);
            }
            if ((this.getGeneratedTempFiles() & 0x800) != 0) {
                JavaQualifiedTypeInfoTranslator qualifiedInfoOfFromString = JavaQualifiedTypeInfoTranslator.getQualifiedInfoOfFromString(newAttrInfo, pluginConfig.getConflictResolver());
                JavaAttributeInfo fromStringAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedInfoOfFromString, newAttrInfo.getAttributeName(), newAttrInfo.getAttributeType(), this.getIsQualifiedAccessOrAddToImportList(qualifiedInfoOfFromString), false);
                this.addFromStringMethod(newAttrInfo, fromStringAttributeInfo);
            }
        }
    }

    String getJavaClassName(String suffix) {
        return YangIoUtils.getCapitalCase(this.getJavaFileInfo().getJavaName()) + suffix;
    }

    private String getImplClassName(YangNode node) {
        if (node instanceof YangModule || node instanceof YangSubModule) {
            return YangIoUtils.getCapitalCase(this.getJavaFileInfo().getJavaName()) + "OpParam";
        }
        return YangIoUtils.getCapitalCase("default") + YangIoUtils.getCapitalCase(this.getJavaFileInfo().getJavaName());
    }

    private String getDirPath() {
        return this.getJavaFileInfo().getPackageFilePath();
    }

    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        List<String> imports = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaImportData().getImports();
        if (curNode instanceof YangAugmentableNode) {
            this.addImportsForAugmentableClass(imports, true, true, curNode);
        }
        JavaIdentifierSyntax.createPackage(curNode);
        if ((fileType & 1) != 0 || (fileType & 2) != 0) {
            this.setInterfaceJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName(INTERFACE_FILE_NAME_SUFFIX)));
            this.setInterfaceJavaFileHandle(JavaFileGenerator.generateInterfaceFile(this.getInterfaceJavaFileHandle(), imports, curNode, this.isAttributePresent()));
            if (!(curNode instanceof YangModule) && !(curNode instanceof YangSubModule) && (fileType & 2) != 0) {
                this.setBuilderInterfaceJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName(BUILDER_INTERFACE_FILE_NAME_SUFFIX)));
                this.setBuilderInterfaceJavaFileHandle(JavaFileGenerator.generateBuilderInterfaceFile(this.getBuilderInterfaceJavaFileHandle(), curNode, this.isAttributePresent()));
                YangIoUtils.mergeJavaFiles(this.getBuilderInterfaceJavaFileHandle(), this.getInterfaceJavaFileHandle());
            }
            YangIoUtils.insertDataIntoJavaFile(this.getInterfaceJavaFileHandle(), JavaCodeSnippetGen.getJavaClassDefClose());
            YangIoUtils.validateLineLength(this.getInterfaceJavaFileHandle());
            if (curNode instanceof YangAugmentableNode) {
                this.addImportsForAugmentableClass(imports, false, true, curNode);
            }
        }
        if ((fileType & 4) != 0 || (fileType & 8) != 0) {
            if (this.isAttributePresent()) {
                this.addImportsToStringAndHasCodeMethods(imports, true);
                this.addArrayListImport(imports);
            }
            if (curNode instanceof YangLeavesHolder) {
                boolean isLeavesPresent;
                YangLeavesHolder leavesHolder = (YangLeavesHolder)curNode;
                boolean bl = isLeavesPresent = leavesHolder.getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty() || leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty();
                if (isLeavesPresent) {
                    this.addBitsetImport(imports);
                }
            }
            if (curNode instanceof YangAugmentableNode) {
                this.addImportsForAugmentableClass(imports, true, false, curNode);
                this.addInvocationExceptionImport(imports);
            }
            JavaCodeSnippetGen.sortImports(imports);
            this.setImplClassJavaFileHandle(this.getJavaFileHandle(this.getImplClassName(curNode)));
            this.setImplClassJavaFileHandle(JavaFileGenerator.generateDefaultClassFile(this.getImplClassJavaFileHandle(), curNode, this.isAttributePresent(), imports));
            if ((fileType & 4) != 0) {
                this.setBuilderClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName(BUILDER_CLASS_FILE_NAME_SUFFIX)));
                this.setBuilderClassJavaFileHandle(JavaFileGenerator.generateBuilderClassFile(this.getBuilderClassJavaFileHandle(), curNode, this.isAttributePresent()));
                YangIoUtils.mergeJavaFiles(this.getBuilderClassJavaFileHandle(), this.getImplClassJavaFileHandle());
            }
            YangIoUtils.insertDataIntoJavaFile(this.getImplClassJavaFileHandle(), JavaCodeSnippetGen.getJavaClassDefClose());
            YangIoUtils.validateLineLength(this.getImplClassJavaFileHandle());
        }
        this.freeTemporaryResources(false);
    }

    private void addArrayListImport(List<String> imports) {
        if (imports.contains(this.getJavaImportData().getImportForList())) {
            imports.add("import java.util.ArrayList;\n");
        }
    }

    private void addBitsetImport(List<String> imports) {
        imports.add(this.getJavaImportData().getImportForToBitSet());
    }

    void addImportsToStringAndHasCodeMethods(List<String> imports, boolean operation) {
        if (operation) {
            imports.add(this.getJavaImportData().getImportForHashAndEquals());
            imports.add(this.getJavaImportData().getImportForToString());
        } else {
            imports.remove(this.getJavaImportData().getImportForHashAndEquals());
            imports.remove(this.getJavaImportData().getImportForToString());
        }
    }

    private void addImportsForAugmentableClass(List<String> imports, boolean operations, boolean isInterfaceFile, YangNode curNode) {
        if (operations) {
            if (!isInterfaceFile) {
                imports.add(this.getJavaImportData().getHashMapImport());
            }
            if (!(curNode instanceof YangChoice)) {
                imports.add(this.getJavaImportData().getMapImport());
            }
        } else {
            if (!isInterfaceFile) {
                imports.remove(this.getJavaImportData().getHashMapImport());
            }
            imports.remove(this.getJavaImportData().getMapImport());
        }
        JavaCodeSnippetGen.sortImports(imports);
    }

    private void addInvocationExceptionImport(List<String> imports) {
        imports.add("import java.lang.reflect.InvocationTargetException;\n");
    }

    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        if ((this.getGeneratedJavaFiles() & 1) != 0) {
            FileSystemUtil.closeFile(this.getInterfaceJavaFileHandle(), isErrorOccurred);
        }
        if ((this.getGeneratedJavaFiles() & 4) != 0) {
            FileSystemUtil.closeFile(this.getBuilderClassJavaFileHandle(), true);
        }
        if ((this.getGeneratedJavaFiles() & 2) != 0) {
            FileSystemUtil.closeFile(this.getBuilderInterfaceJavaFileHandle(), true);
        }
        if ((this.getGeneratedJavaFiles() & 8) != 0) {
            FileSystemUtil.closeFile(this.getImplClassJavaFileHandle(), isErrorOccurred);
        }
        if ((this.getGeneratedTempFiles() & 4) != 0) {
            FileSystemUtil.closeFile(this.getGetterImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 1) != 0) {
            FileSystemUtil.closeFile(this.getAttributesTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x40) != 0) {
            FileSystemUtil.closeFile(this.getHashCodeImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x100) != 0) {
            FileSystemUtil.closeFile(this.getToStringImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x80) != 0) {
            FileSystemUtil.closeFile(this.getEqualsImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x800) != 0) {
            FileSystemUtil.closeFile(this.getFromStringImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x200000) != 0) {
            FileSystemUtil.closeFile(this.getAddToListImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x100000) != 0) {
            FileSystemUtil.closeFile(this.getAddToListInterfaceTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x400000) != 0) {
            FileSystemUtil.closeFile(this.getLeafIdAttributeTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x800000) != 0) {
            FileSystemUtil.closeFile(this.getSubtreeFilteringForLeafTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x1000000) != 0) {
            FileSystemUtil.closeFile(this.getGetSubtreeFilteringForListTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x2000000) != 0) {
            FileSystemUtil.closeFile(this.getGetSubtreeFilteringForChildNodeTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x4000000) != 0) {
            FileSystemUtil.closeFile(this.getEditContentTempFileHandle(), true);
        }
    }

    boolean getIsQualifiedAccessOrAddToImportList(JavaQualifiedTypeInfoTranslator importInfo) {
        return this.getJavaImportData().addImportInfo(importInfo, this.getGeneratedJavaClassName(), this.getJavaFileInfo().getPackage());
    }

    public File getAddToListInterfaceTempFileHandle() {
        return this.addToListInterfaceTempFileHandle;
    }

    private void setAddToListInterfaceTempFileHandle(File addToListInterfaceTempFileHandle) {
        this.addToListInterfaceTempFileHandle = addToListInterfaceTempFileHandle;
    }

    public File getAddToListImplTempFileHandle() {
        return this.addToListImplTempFileHandle;
    }

    private void setAddToListImplTempFileHandle(File addToListImplTempFileHandle) {
        this.addToListImplTempFileHandle = addToListImplTempFileHandle;
    }

    public File getLeafIdAttributeTempFileHandle() {
        return this.leafIdAttributeTempFileHandle;
    }

    private void setLeafIdAttributeTempFileHandle(File leafIdAttributeTempFileHandle) {
        this.leafIdAttributeTempFileHandle = leafIdAttributeTempFileHandle;
    }

    private boolean isRooNode() {
        return this.isRooNode;
    }

    void setRooNode(boolean rooNode) {
        this.isRooNode = rooNode;
    }

    public File getSubtreeFilteringForLeafTempFileHandle() {
        return this.subtreeFilteringForLeafTempFileHandle;
    }

    private void setSubtreeFilteringForLeafTempFileHandle(File subtreeFilteringForLeafTempFileHandle) {
        this.subtreeFilteringForLeafTempFileHandle = subtreeFilteringForLeafTempFileHandle;
    }

    public File getEditContentTempFileHandle() {
        return this.editContentTempFileHandle;
    }

    private void setEditContentTempFileHandle(File editContentTempFileHandle) {
        this.editContentTempFileHandle = editContentTempFileHandle;
    }

    public File getGetSubtreeFilteringForListTempFileHandle() {
        return this.getSubtreeFilteringForListTempFileHandle;
    }

    private void setGetSubtreeFilteringForListTempFileHandle(File getSubtreeFilteringForListTempFileHandle) {
        this.getSubtreeFilteringForListTempFileHandle = getSubtreeFilteringForListTempFileHandle;
    }

    public File getGetSubtreeFilteringForChildNodeTempFileHandle() {
        return this.getSubtreeFilteringForChildNodeTempFileHandle;
    }

    private void setGetSubtreeFilteringForChildNodeTempFileHandle(File getSubtreeFilteringForChildNodeTempFileHandle) {
        this.getSubtreeFilteringForChildNodeTempFileHandle = getSubtreeFilteringForChildNodeTempFileHandle;
    }
}

