/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaServiceFragmentFiles
extends TempJavaFragmentFiles {
    private static final String RPC_INTERFACE_FILE_NAME = "Rpc";
    private static final String RPC_IMPL_FILE_NAME = "RpcImpl";
    private static final String SERVICE_FILE_NAME_SUFFIX = "Service";
    private File rpcInterfaceTempFileHandle;
    private File rpcImplTempFileHandle;
    private File serviceInterfaceJavaFileHandle;

    TempJavaServiceFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        this.setJavaExtendsListHolder(new JavaExtendsListHolder());
        this.setJavaImportData(new JavaImportData());
        this.setJavaFileInfo(javaFileInfo);
        this.setAbsoluteDirPath(YangIoUtils.getAbsolutePackagePath(this.getJavaFileInfo().getBaseCodeGenPath(), this.getJavaFileInfo().getPackageFilePath()));
        this.addGeneratedTempFile(8192);
        this.addGeneratedTempFile(16384);
        this.setRpcInterfaceTempFileHandle(this.getTemporaryFileHandle(RPC_INTERFACE_FILE_NAME));
        this.setRpcImplTempFileHandle(this.getTemporaryFileHandle(RPC_IMPL_FILE_NAME));
    }

    private File getServiceInterfaceJavaFileHandle() {
        return this.serviceInterfaceJavaFileHandle;
    }

    private void setServiceInterfaceJavaFileHandle(File serviceInterfaceJavaFileHandle) {
        this.serviceInterfaceJavaFileHandle = serviceInterfaceJavaFileHandle;
    }

    public File getRpcInterfaceTempFileHandle() {
        return this.rpcInterfaceTempFileHandle;
    }

    private void setRpcInterfaceTempFileHandle(File rpcInterfaceTempFileHandle) {
        this.rpcInterfaceTempFileHandle = rpcInterfaceTempFileHandle;
    }

    public File getRpcImplTempFileHandle() {
        return this.rpcImplTempFileHandle;
    }

    private void setRpcImplTempFileHandle(File rpcImplTempFileHandle) {
        this.rpcImplTempFileHandle = rpcImplTempFileHandle;
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        JavaFileGeneratorUtils.addResolvedAugmentedDataNodeImports(curNode);
        List<String> imports = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getServiceTempFiles().getJavaImportData().getImports();
        JavaIdentifierSyntax.createPackage(curNode);
        boolean isNotification = false;
        if (curNode instanceof YangJavaModuleTranslator) {
            if (!((YangJavaModuleTranslator)curNode).getNotificationNodes().isEmpty()) {
                isNotification = true;
            }
        } else if (curNode instanceof YangJavaSubModuleTranslator && !((YangJavaSubModuleTranslator)curNode).getNotificationNodes().isEmpty()) {
            isNotification = true;
        }
        if (isNotification) {
            JavaCodeSnippetGen.addListenersImport(curNode, imports, true, "ListenerService");
        }
        this.setServiceInterfaceJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName(SERVICE_FILE_NAME_SUFFIX)));
        JavaFileGenerator.generateServiceInterfaceFile(this.getServiceInterfaceJavaFileHandle(), curNode, imports);
        this.freeTemporaryResources(false);
    }

    private void addRpcString(JavaAttributeInfo javaAttributeInfoOfInput, JavaAttributeInfo javaAttributeInfoOfOutput, YangPluginConfig pluginConfig, String rpcName) throws IOException {
        String rpcInput = "";
        String rpcOutput = "void";
        String rpcInputJavaDoc = "";
        if (javaAttributeInfoOfInput != null) {
            rpcInput = YangIoUtils.getCapitalCase(javaAttributeInfoOfInput.getAttributeName());
        }
        if (javaAttributeInfoOfOutput != null) {
            rpcOutput = YangIoUtils.getCapitalCase(javaAttributeInfoOfOutput.getAttributeName());
        }
        if (!rpcInput.equals("")) {
            rpcInputJavaDoc = "inputVar";
        }
        this.appendToFile(this.getRpcInterfaceTempFileHandle(), JavaDocGen.generateJavaDocForRpc(rpcName, rpcInputJavaDoc, rpcOutput, pluginConfig) + MethodsGenerator.getRpcServiceMethod(rpcName, rpcInput, rpcOutput, pluginConfig) + "\n");
        this.appendToFile(this.getRpcImplTempFileHandle(), MethodsGenerator.getRpcManagerMethod(rpcName, rpcInput, rpcOutput, pluginConfig) + "\n");
    }

    public void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo javaAttributeInfoOfInput, JavaAttributeInfo javaAttributeInfoOfOutput, YangPluginConfig pluginConfig, String rpcName) throws IOException {
        this.addRpcString(javaAttributeInfoOfInput, javaAttributeInfoOfOutput, pluginConfig, rpcName);
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        FileSystemUtil.closeFile(this.getServiceInterfaceJavaFileHandle(), isErrorOccurred);
        FileSystemUtil.closeFile(this.getRpcInterfaceTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getRpcImplTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getGetterInterfaceTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getSetterInterfaceTempFileHandle(), true);
        FileSystemUtil.closeFile(this.getSetterImplTempFileHandle(), true);
        super.freeTemporaryResources(isErrorOccurred);
    }
}

