/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeHolder;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaTypeTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGenerator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.ValidatorTypeForUnionTypes;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.FileSystemUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class TempJavaTypeFragmentFiles
extends TempJavaFragmentFiles {
    private static final String OF_STRING_METHOD_FILE_NAME = "OfString";
    private static final String CONSTRUCTOR_FOR_TYPE_FILE_NAME = "ConstructorForType";
    private static final String TYPEDEF_CLASS_FILE_NAME_SUFFIX = "";
    private static final String UNION_TYPE_CLASS_FILE_NAME_SUFFIX = "";
    private int intIndex = 0;
    private int uIntIndex = 0;
    private int longIndex = 0;
    private int uLongIndex = 0;
    private File ofStringImplTempFileHandle;
    private File constructorForTypeTempFileHandle;
    private File typedefClassJavaFileHandle;
    private File typeClassJavaFileHandle;
    private JavaAttributeInfo intAttribute;
    private JavaAttributeInfo longAttribute;
    private JavaAttributeInfo uIntAttribute;
    private JavaAttributeInfo uLongAttribute;

    TempJavaTypeFragmentFiles(JavaFileInfoTranslator javaFileInfo) throws IOException {
        super(javaFileInfo);
        this.addGeneratedTempFile(512);
        this.addGeneratedTempFile(1024);
        this.addGeneratedTempFile(2048);
        this.setOfStringImplTempFileHandle(this.getTemporaryFileHandle(OF_STRING_METHOD_FILE_NAME));
        this.setConstructorForTypeTempFileHandle(this.getTemporaryFileHandle(CONSTRUCTOR_FOR_TYPE_FILE_NAME));
    }

    public File getConstructorForTypeTempFileHandle() {
        return this.constructorForTypeTempFileHandle;
    }

    private void setConstructorForTypeTempFileHandle(File constructorForTypeTempFileHandle) {
        this.constructorForTypeTempFileHandle = constructorForTypeTempFileHandle;
    }

    private File getTypedefClassJavaFileHandle() {
        return this.typedefClassJavaFileHandle;
    }

    private void setTypedefClassJavaFileHandle(File typedefClassJavaFileHandle) {
        this.typedefClassJavaFileHandle = typedefClassJavaFileHandle;
    }

    private File getTypeClassJavaFileHandle() {
        return this.typeClassJavaFileHandle;
    }

    private void setTypeClassJavaFileHandle(File typeClassJavaFileHandle) {
        this.typeClassJavaFileHandle = typeClassJavaFileHandle;
    }

    public File getOfStringImplTempFileHandle() {
        return this.ofStringImplTempFileHandle;
    }

    private void setOfStringImplTempFileHandle(File ofStringImplTempFileHandle) {
        this.ofStringImplTempFileHandle = ofStringImplTempFileHandle;
    }

    void addTypeInfoToTempFiles(YangTypeHolder yangTypeHolder, YangPluginConfig pluginConfig) throws IOException {
        List typeList = yangTypeHolder.getTypeList();
        if (typeList != null) {
            for (YangType yangType : typeList) {
                if (!(yangType instanceof YangJavaTypeTranslator)) {
                    throw new TranslatorException("Type does not have Java info");
                }
                JavaAttributeInfo javaAttributeInfo = this.getAttributeForType(yangType, pluginConfig);
                this.addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfo, pluginConfig, typeList);
            }
            this.addTypeConstructor(pluginConfig);
            this.addMethodsInConflictCase(pluginConfig);
        }
    }

    private JavaAttributeInfo getAttributeForType(YangType yangType, YangPluginConfig pluginConfig) {
        YangJavaTypeTranslator javaType = (YangJavaTypeTranslator)yangType;
        javaType.updateJavaQualifiedInfo(pluginConfig.getConflictResolver());
        String typeName = javaType.getDataTypeName();
        typeName = YangIoUtils.getCamelCase(typeName, pluginConfig.getConflictResolver());
        return JavaAttributeInfo.getAttributeInfoForTheData(javaType.getJavaQualifiedInfo(), typeName, javaType, this.getIsQualifiedAccessOrAddToImportList(javaType.getJavaQualifiedInfo()), false);
    }

    private void addJavaSnippetInfoToApplicableTempFiles(JavaAttributeInfo javaAttributeInfo, YangPluginConfig pluginConfig, List<YangType<?>> typeList) throws IOException {
        YangDataTypes attrType = javaAttributeInfo.getAttributeType().getDataType();
        if (attrType == YangDataTypes.INT32 || attrType == YangDataTypes.UINT16) {
            boolean isIntConflict = this.validateForConflictingIntTypes(typeList);
            javaAttributeInfo.setIntConflict(isIntConflict);
            this.updateAttributeCondition(javaAttributeInfo);
            if (!isIntConflict) {
                this.addMethodsWhenNoConflictingTypes(javaAttributeInfo, pluginConfig);
            }
        } else if (attrType == YangDataTypes.INT64 || attrType == YangDataTypes.UINT32) {
            boolean isLongConflict = this.validateForConflictingLongTypes(typeList);
            javaAttributeInfo.setLongConflict(isLongConflict);
            this.updateAttributeCondition(javaAttributeInfo);
            if (!isLongConflict) {
                this.addMethodsWhenNoConflictingTypes(javaAttributeInfo, pluginConfig);
            }
        } else {
            this.addMethodsWhenNoConflictingTypes(javaAttributeInfo, pluginConfig);
        }
        super.addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfo, pluginConfig);
    }

    private void addMethodsWhenNoConflictingTypes(JavaAttributeInfo javaAttributeInfo, YangPluginConfig pluginConfig) throws IOException {
        if ((this.getGeneratedTempFiles() & 0x200) != 0) {
            this.addOfStringMethod(javaAttributeInfo, pluginConfig);
        }
        if ((this.getGeneratedTempFiles() & 0x400) != 0) {
            this.addTypeConstructor(javaAttributeInfo, pluginConfig);
        }
    }

    private void addMethodsInConflictCase(YangPluginConfig pluginConfig) throws IOException {
        JavaAttributeInfo attr = this.getIntAttribute();
        if (attr != null) {
            attr = this.getUIntAttribute();
        }
        if (attr != null && attr.isIntConflict()) {
            if (this.getIntIndex() < this.getUIntIndex()) {
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getIntAttribute(), this.getGeneratedJavaClassName(), pluginConfig) + "\n");
                this.addGetterImpl(this.getIntAttribute(), pluginConfig);
                this.addFromStringMethod(this.getIntAttribute(), pluginConfig);
            } else {
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getUIntAttribute(), this.getGeneratedJavaClassName(), pluginConfig) + "\n");
                this.addGetterImpl(this.getUIntAttribute(), pluginConfig);
                this.addFromStringMethod(this.getUIntAttribute(), pluginConfig);
            }
        }
        if ((attr = this.getLongAttribute()) != null) {
            attr = this.getULongAttribute();
        }
        if (attr != null && attr.isLongConflict()) {
            if (this.getLongIndex() < this.getULongIndex()) {
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getLongAttribute(), this.getGeneratedJavaClassName(), pluginConfig) + "\n");
                this.addGetterImpl(this.getLongAttribute(), pluginConfig);
                this.addFromStringMethod(this.getLongAttribute(), pluginConfig);
            } else {
                this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(this.getULongAttribute(), this.getGeneratedJavaClassName(), pluginConfig) + "\n");
                this.addGetterImpl(this.getULongAttribute(), pluginConfig);
                this.addFromStringMethod(this.getULongAttribute(), pluginConfig);
            }
        }
    }

    private void addFromStringMethod(JavaAttributeInfo newAttrInfo, YangPluginConfig pluginConfig) throws IOException {
        JavaQualifiedTypeInfoTranslator qualifiedInfoOfFromString = JavaQualifiedTypeInfoTranslator.getQualifiedInfoOfFromString(newAttrInfo, pluginConfig.getConflictResolver());
        JavaAttributeInfo fromStringAttributeInfo = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedInfoOfFromString, newAttrInfo.getAttributeName(), newAttrInfo.getAttributeType(), this.getIsQualifiedAccessOrAddToImportList(qualifiedInfoOfFromString), false);
        this.addFromStringMethod(newAttrInfo, fromStringAttributeInfo);
    }

    private void addTypeConstructor(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(attr, this.getGeneratedJavaClassName(), pluginConfig) + "\n");
    }

    private void addTypeConstructor(YangPluginConfig pluginConfig) throws IOException {
        JavaAttributeInfo attr = this.getIntAttribute();
        if (attr != null) {
            attr = this.getUIntAttribute();
        }
        if (attr != null && attr.isIntConflict()) {
            this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(this.getIntAttribute(), this.getUIntAttribute(), this.getGeneratedJavaClassName(), pluginConfig, ValidatorTypeForUnionTypes.INT_TYPE_CONFLICT, this.getIntIndex() < this.getUIntIndex()) + "\n");
        }
        if ((attr = this.getLongAttribute()) != null) {
            attr = this.getULongAttribute();
        }
        if (attr != null && attr.isLongConflict()) {
            this.appendToFile(this.getConstructorForTypeTempFileHandle(), MethodsGenerator.getTypeConstructorStringAndJavaDoc(this.getLongAttribute(), this.getULongAttribute(), this.getGeneratedJavaClassName(), pluginConfig, ValidatorTypeForUnionTypes.LONG_TYPE_CONFLICT, this.getLongIndex() < this.getULongIndex()) + "\n");
        }
    }

    private void addOfStringMethod(JavaAttributeInfo attr, YangPluginConfig pluginConfig) throws IOException {
        this.appendToFile(this.getOfStringImplTempFileHandle(), MethodsGenerator.getOfMethodStringAndJavaDoc(attr, this.getGeneratedJavaClassName(), pluginConfig) + "\n");
    }

    @Override
    public void freeTemporaryResources(boolean isErrorOccurred) throws IOException {
        if ((this.getGeneratedJavaFiles() & 0x40) != 0) {
            FileSystemUtil.closeFile(this.getTypedefClassJavaFileHandle(), isErrorOccurred);
        }
        if ((this.getGeneratedJavaFiles() & 0x80) != 0) {
            FileSystemUtil.closeFile(this.getTypeClassJavaFileHandle(), isErrorOccurred);
        }
        if ((this.getGeneratedTempFiles() & 0x400) != 0) {
            FileSystemUtil.closeFile(this.getConstructorForTypeTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x200) != 0) {
            FileSystemUtil.closeFile(this.getOfStringImplTempFileHandle(), true);
        }
        if ((this.getGeneratedTempFiles() & 0x800) != 0) {
            FileSystemUtil.closeFile(this.getFromStringImplTempFileHandle(), true);
        }
        super.freeTemporaryResources(isErrorOccurred);
    }

    @Override
    public void generateJavaFile(int fileType, YangNode curNode) throws IOException {
        ArrayList<String> imports = new ArrayList();
        if (this.isAttributePresent()) {
            imports = this.getJavaImportData().getImports();
        }
        JavaIdentifierSyntax.createPackage(curNode);
        if ((fileType & 0x40) != 0) {
            YangType yangType;
            this.addImportsToStringAndHasCodeMethods(imports, true);
            this.setTypedefClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName("")));
            if (curNode instanceof YangTypeHolder && (yangType = (YangType)((YangTypeHolder)curNode).getTypeList().get(0)).getDataType() == YangDataTypes.BINARY) {
                imports.remove(this.getJavaImportData().getImportForToString());
            }
            JavaFileGenerator.generateTypeDefClassFile(this.getTypedefClassJavaFileHandle(), curNode, imports);
        }
        if ((fileType & 0x80) != 0) {
            this.addImportsToStringAndHasCodeMethods(imports, true);
            this.setTypeClassJavaFileHandle(this.getJavaFileHandle(this.getJavaClassName("")));
            JavaFileGenerator.generateUnionClassFile(this.getTypeClassJavaFileHandle(), curNode, imports);
        }
        this.freeTemporaryResources(false);
    }

    public int getIntIndex() {
        return this.intIndex;
    }

    private void setIntIndex(int intIndex) {
        this.intIndex = intIndex;
    }

    public int getUIntIndex() {
        return this.uIntIndex;
    }

    private void setUIntIndex(int uIntIndex) {
        this.uIntIndex = uIntIndex;
    }

    public int getLongIndex() {
        return this.longIndex;
    }

    private void setLongIndex(int longIndex) {
        this.longIndex = longIndex;
    }

    public int getULongIndex() {
        return this.uLongIndex;
    }

    private void setULongIndex(int uLongIndex) {
        this.uLongIndex = uLongIndex;
    }

    private boolean validateForConflictingIntTypes(List<YangType<?>> typeList) {
        boolean isIntPresent = false;
        boolean isUIntPresent = false;
        for (YangType<?> type : typeList) {
            if (type.getDataType().equals((Object)YangDataTypes.INT32)) {
                this.setIntIndex(typeList.indexOf(type));
                isIntPresent = true;
            }
            if (!type.getDataType().equals((Object)YangDataTypes.UINT16)) continue;
            this.setUIntIndex(typeList.indexOf(type));
            isUIntPresent = true;
        }
        return isIntPresent && isUIntPresent;
    }

    private boolean validateForConflictingLongTypes(List<YangType<?>> typeList) {
        boolean isLongPresent = false;
        boolean isULongPresent = false;
        for (YangType<?> type : typeList) {
            if (type.getDataType().equals((Object)YangDataTypes.INT64)) {
                this.setLongIndex(typeList.indexOf(type));
                isLongPresent = true;
            }
            if (!type.getDataType().equals((Object)YangDataTypes.UINT32)) continue;
            this.setULongIndex(typeList.indexOf(type));
            isULongPresent = true;
        }
        return isLongPresent && isULongPresent;
    }

    private void updateAttributeCondition(JavaAttributeInfo javaAttributeInfo) {
        if (javaAttributeInfo.isIntConflict()) {
            if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.UINT16) {
                this.setUIntAttribute(javaAttributeInfo);
            } else if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.INT32) {
                this.setIntAttribute(javaAttributeInfo);
            }
        }
        if (javaAttributeInfo.isLongConflict()) {
            if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.UINT32) {
                this.setULongAttribute(javaAttributeInfo);
            } else if (javaAttributeInfo.getAttributeType().getDataType() == YangDataTypes.INT64) {
                this.setLongAttribute(javaAttributeInfo);
            }
        }
    }

    public JavaAttributeInfo getIntAttribute() {
        return this.intAttribute;
    }

    private void setIntAttribute(JavaAttributeInfo intAttribute) {
        this.intAttribute = intAttribute;
    }

    public JavaAttributeInfo getLongAttribute() {
        return this.longAttribute;
    }

    private void setLongAttribute(JavaAttributeInfo longAttribute) {
        this.longAttribute = longAttribute;
    }

    public JavaAttributeInfo getUIntAttribute() {
        return this.uIntAttribute;
    }

    private void setUIntAttribute(JavaAttributeInfo uIntAttribute) {
        this.uIntAttribute = uIntAttribute;
    }

    public JavaAttributeInfo getULongAttribute() {
        return this.uLongAttribute;
    }

    private void setULongAttribute(JavaAttributeInfo uLongAttribute) {
        this.uLongAttribute = uLongAttribute;
    }
}

