/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava;

import java.io.IOException;
import java.util.ArrayList;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangTranslatorOperatorNode;
import org.onosproject.yangutils.datamodel.YangTypeHolder;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaAugmentTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaEnumerationTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class YangJavaModelUtils {
    private YangJavaModelUtils() {
    }

    public static void updatePackageInfo(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        if (javaCodeGeneratorInfo instanceof YangJavaAugmentTranslator) {
            YangJavaModelUtils.updatePackageForAugmentInfo(javaCodeGeneratorInfo, yangPluginConfig);
        } else {
            javaCodeGeneratorInfo.getJavaFileInfo().setJavaName(YangIoUtils.getCamelCase(((YangNode)javaCodeGeneratorInfo).getName(), yangPluginConfig.getConflictResolver()));
            javaCodeGeneratorInfo.getJavaFileInfo().setPackage(YangJavaModelUtils.getCurNodePackage((YangNode)javaCodeGeneratorInfo));
        }
        javaCodeGeneratorInfo.getJavaFileInfo().setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(javaCodeGeneratorInfo.getJavaFileInfo().getPackage()));
        javaCodeGeneratorInfo.getJavaFileInfo().setBaseCodeGenPath(yangPluginConfig.getCodeGenDir());
        javaCodeGeneratorInfo.getJavaFileInfo().setPluginConfig(yangPluginConfig);
    }

    private static void updatePackageForAugmentInfo(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        javaCodeGeneratorInfo.getJavaFileInfo().setJavaName(YangJavaModelUtils.getAugmentClassName((YangAugment)((YangJavaAugmentTranslator)javaCodeGeneratorInfo), yangPluginConfig));
        javaCodeGeneratorInfo.getJavaFileInfo().setPackage(YangJavaModelUtils.getAugmentsNodePackage((YangNode)javaCodeGeneratorInfo, yangPluginConfig));
        javaCodeGeneratorInfo.getJavaFileInfo().setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(javaCodeGeneratorInfo.getJavaFileInfo().getPackage()));
        javaCodeGeneratorInfo.getJavaFileInfo().setBaseCodeGenPath(yangPluginConfig.getCodeGenDir());
        javaCodeGeneratorInfo.getJavaFileInfo().setPluginConfig(yangPluginConfig);
    }

    private static String getAugmentsNodePackage(YangNode yangNode, YangPluginConfig yangPluginConfig) {
        YangAugment augment = (YangAugment)yangNode;
        StringBuilder augmentPkg = new StringBuilder();
        augmentPkg.append(YangJavaModelUtils.getCurNodePackage((YangNode)augment));
        String pkg = ".";
        for (YangAtomicPath atomicPath : augment.getTargetNode()) {
            pkg = pkg + YangIoUtils.getCamelCase(atomicPath.getNodeIdentifier().getName(), yangPluginConfig.getConflictResolver()) + ".";
        }
        pkg = YangIoUtils.trimAtLast(pkg, ".");
        augmentPkg.append(pkg.toLowerCase());
        return augmentPkg.toString();
    }

    private static void updatePackageInfo(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPlugin, String pkg) throws IOException {
        javaCodeGeneratorInfo.getJavaFileInfo().setJavaName(YangIoUtils.getCamelCase(((YangNode)javaCodeGeneratorInfo).getName(), yangPlugin.getConflictResolver()));
        javaCodeGeneratorInfo.getJavaFileInfo().setPackage(pkg);
        javaCodeGeneratorInfo.getJavaFileInfo().setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(javaCodeGeneratorInfo.getJavaFileInfo().getPackage()));
        javaCodeGeneratorInfo.getJavaFileInfo().setBaseCodeGenPath(yangPlugin.getCodeGenDir());
        javaCodeGeneratorInfo.getJavaFileInfo().setPluginConfig(yangPlugin);
    }

    private static void createTempFragmentFile(JavaCodeGeneratorInfo javaCodeGeneratorInfo) throws IOException {
        javaCodeGeneratorInfo.setTempJavaCodeFragmentFiles(new TempJavaCodeFragmentFiles(javaCodeGeneratorInfo.getJavaFileInfo()));
    }

    private static void updateTempFragmentFiles(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        if (javaCodeGeneratorInfo instanceof YangModule || javaCodeGeneratorInfo instanceof YangSubModule) {
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getBeanTempFiles().setRooNode(true);
        }
        if (javaCodeGeneratorInfo instanceof RpcNotificationContainer) {
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getServiceTempFiles().addCurNodeLeavesInfoToTempFiles((YangNode)javaCodeGeneratorInfo, yangPluginConfig);
            if (javaCodeGeneratorInfo instanceof YangJavaModuleTranslator) {
                if (!((YangJavaModuleTranslator)javaCodeGeneratorInfo).getNotificationNodes().isEmpty()) {
                    YangJavaModelUtils.updateNotificationNodeInfo(javaCodeGeneratorInfo, yangPluginConfig);
                }
            } else if (javaCodeGeneratorInfo instanceof YangJavaSubModuleTranslator && !((YangJavaSubModuleTranslator)javaCodeGeneratorInfo).getNotificationNodes().isEmpty()) {
                YangJavaModelUtils.updateNotificationNodeInfo(javaCodeGeneratorInfo, yangPluginConfig);
            }
        }
        if (javaCodeGeneratorInfo instanceof YangLeavesHolder) {
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getBeanTempFiles().addCurNodeLeavesInfoToTempFiles((YangNode)javaCodeGeneratorInfo, yangPluginConfig);
        } else if (javaCodeGeneratorInfo instanceof YangTypeHolder) {
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().addTypeInfoToTempFiles((YangTypeHolder)javaCodeGeneratorInfo, yangPluginConfig);
        } else if (javaCodeGeneratorInfo instanceof YangJavaEnumerationTranslator) {
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getEnumerationTempFiles().addEnumAttributeToTempFiles((YangNode)javaCodeGeneratorInfo, yangPluginConfig);
        } else if (!(javaCodeGeneratorInfo instanceof YangChoice)) {
            throw new TranslatorException("Unsupported Node Translation");
        }
    }

    private static void generateTempFiles(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        if (!(javaCodeGeneratorInfo instanceof YangNode)) {
            throw new TranslatorException("translation is not supported for the node");
        }
        YangJavaModelUtils.createTempFragmentFile(javaCodeGeneratorInfo);
        YangJavaModelUtils.updateTempFragmentFiles(javaCodeGeneratorInfo, yangPluginConfig);
    }

    private static void updateNotificationNodeInfo(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        if (javaCodeGeneratorInfo instanceof YangJavaModuleTranslator) {
            for (YangNode notification : ((YangJavaModuleTranslator)javaCodeGeneratorInfo).getNotificationNodes()) {
                javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getEventFragmentFiles().addJavaSnippetOfEvent(notification, yangPluginConfig);
            }
        }
        if (javaCodeGeneratorInfo instanceof YangJavaSubModuleTranslator) {
            for (YangNode notification : ((YangJavaSubModuleTranslator)javaCodeGeneratorInfo).getNotificationNodes()) {
                javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getEventFragmentFiles().addJavaSnippetOfEvent(notification, yangPluginConfig);
            }
        }
    }

    public static void generateCodeAndUpdateInParent(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPlugin, boolean isMultiInstance) throws IOException {
        if (!(javaCodeGeneratorInfo instanceof YangNode)) {
            throw new TranslatorException("Invalid node for translation");
        }
        YangJavaModelUtils.generateCodeOfAugmentableNode(javaCodeGeneratorInfo, yangPlugin);
        TempJavaFragmentFiles.addCurNodeInfoInParentTempFile((YangNode)javaCodeGeneratorInfo, isMultiInstance, yangPlugin);
    }

    public static void generateCodeOfAugmentableNode(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPlugin) throws IOException {
        if (!(javaCodeGeneratorInfo instanceof YangNode)) {
            throw new TranslatorException("invalid node for translation");
        }
        YangJavaModelUtils.generateCodeOfNode(javaCodeGeneratorInfo, yangPlugin);
        TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles = javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles();
        if (javaCodeGeneratorInfo instanceof YangCase) {
            YangNode parent = ((YangCase)javaCodeGeneratorInfo).getParent();
            JavaQualifiedTypeInfoTranslator parentsInfo = YangJavaModelUtils.getQualifierInfoForCasesParent(parent, yangPlugin);
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaExtendsListHolder().addToExtendsList(parentsInfo, (YangNode)javaCodeGeneratorInfo, tempJavaCodeFragmentFiles.getBeanTempFiles());
            javaCodeGeneratorInfo.getTempJavaCodeFragmentFiles().getBeanTempFiles().addParentInfoInCurNodeTempFile((YangNode)javaCodeGeneratorInfo, yangPlugin);
        }
    }

    public static JavaQualifiedTypeInfoTranslator getQualifierInfoForCasesParent(YangNode parent, YangPluginConfig yangPluginConfig) {
        String parentPkg;
        String parentName;
        JavaFileInfoTranslator parentInfo;
        JavaQualifiedTypeInfoTranslator parentsInfo = new JavaQualifiedTypeInfoTranslator();
        if (parent instanceof YangChoice) {
            parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        } else {
            parent = ((YangAugment)parent).getAugmentedNode();
            parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        }
        if (parentInfo.getPackage() != null) {
            parentName = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            parentPkg = parentInfo.getPackage();
        } else {
            parentName = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(parent.getName(), yangPluginConfig.getConflictResolver()));
            parentPkg = YangJavaModelUtils.getNodesPackage(parent, yangPluginConfig);
        }
        parentsInfo.setClassInfo(parentName);
        parentsInfo.setPkgInfo(parentPkg);
        return parentsInfo;
    }

    public static void generateCodeOfNode(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig) throws IOException {
        if (!(javaCodeGeneratorInfo instanceof YangNode)) {
            throw new TranslatorException("invalid node for translation");
        }
        YangJavaModelUtils.updatePackageInfo(javaCodeGeneratorInfo, yangPluginConfig);
        YangJavaModelUtils.generateTempFiles(javaCodeGeneratorInfo, yangPluginConfig);
    }

    public static void generateCodeOfRootNode(JavaCodeGeneratorInfo javaCodeGeneratorInfo, YangPluginConfig yangPluginConfig, String rootPkg) throws IOException {
        if (!(javaCodeGeneratorInfo instanceof YangNode)) {
            throw new TranslatorException("invalid node for translation");
        }
        YangJavaModelUtils.updatePackageInfo(javaCodeGeneratorInfo, yangPluginConfig, rootPkg);
        if (DataModelUtils.isRpcChildNodePresent((YangNode)((YangNode)javaCodeGeneratorInfo))) {
            javaCodeGeneratorInfo.getJavaFileInfo().addGeneratedFileTypes(16);
        }
        YangJavaModelUtils.generateTempFiles(javaCodeGeneratorInfo, yangPluginConfig);
    }

    public static String getCurNodePackage(YangNode curNode) {
        if (!(curNode instanceof JavaFileInfoContainer) || curNode.getParent() == null) {
            throw new TranslatorException("missing parent node to get current node's package");
        }
        YangNode parentNode = DataModelUtils.getParentNodeInGenCode((YangNode)curNode);
        if (!(parentNode instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("missing parent java node to get current node's package");
        }
        JavaFileInfoTranslator parentJavaFileHandle = ((JavaFileInfoContainer)parentNode).getJavaFileInfo();
        String pkg = parentJavaFileHandle.getPackage() + "." + parentJavaFileHandle.getJavaName();
        return pkg.toLowerCase();
    }

    public static boolean isRootNodesCodeGenRequired(YangNode node) {
        ArrayList<YangNode> childNodes = new ArrayList<YangNode>();
        for (YangNode tempNode = node.getChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            childNodes.add(tempNode);
        }
        if (childNodes.size() == 0) {
            YangLeavesHolder leavesHolder = (YangLeavesHolder)node;
            return !leavesHolder.getListOfLeaf().isEmpty() || !leavesHolder.getListOfLeafList().isEmpty();
        }
        if (childNodes.size() == 1) {
            return !(childNodes.get(0) instanceof YangTranslatorOperatorNode);
        }
        ArrayList<Boolean> booleanData = new ArrayList<Boolean>();
        for (YangNode child : childNodes) {
            if (child instanceof YangTranslatorOperatorNode) {
                booleanData.add(false);
                continue;
            }
            booleanData.add(true);
        }
        return booleanData.contains(true);
    }

    public static String getNodesPackage(YangNode node, YangPluginConfig yangPluginConfig) {
        ArrayList<String> clsInfo = new ArrayList<String>();
        while (node.getParent() != null) {
            if (node instanceof YangJavaAugmentTranslator) {
                clsInfo.add(YangJavaModelUtils.getAugmentClassName((YangAugment)node, yangPluginConfig));
            } else {
                clsInfo.add(YangIoUtils.getCamelCase(node.getName(), yangPluginConfig.getConflictResolver()));
            }
            node = node.getParent();
        }
        StringBuilder pkg = new StringBuilder();
        if (node instanceof YangJavaModuleTranslator) {
            YangJavaModuleTranslator module = (YangJavaModuleTranslator)node;
            pkg.append(JavaIdentifierSyntax.getRootPackage(module.getVersion(), module.getNameSpace(), module.getRevision().getRevDate(), yangPluginConfig.getConflictResolver()));
        } else if (node instanceof YangJavaSubModuleTranslator) {
            YangJavaSubModuleTranslator subModule = (YangJavaSubModuleTranslator)node;
            pkg.append(JavaIdentifierSyntax.getRootPackage(subModule.getVersion(), subModule.getNameSpaceFromModule(subModule.getBelongsTo()), subModule.getRevision().getRevDate(), yangPluginConfig.getConflictResolver()));
        }
        String concat = "";
        for (int i = 1; i <= clsInfo.size(); ++i) {
            concat = concat + "." + (String)clsInfo.get(clsInfo.size() - i);
        }
        pkg.append(concat);
        return pkg.toString().toLowerCase();
    }

    static String getAugmentClassName(YangAugment augment, YangPluginConfig yangPluginConfig) {
        YangNodeIdentifier yangNodeIdentifier = ((YangAtomicPath)augment.getTargetNode().get(augment.getTargetNode().size() - 1)).getNodeIdentifier();
        String name = YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(yangNodeIdentifier.getName(), yangPluginConfig.getConflictResolver()));
        if (yangNodeIdentifier.getPrefix() != null) {
            return "Augmented" + YangIoUtils.getCapitalCase(yangNodeIdentifier.getPrefix()) + name;
        }
        return "Augmented" + name;
    }
}

