/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.util.Stack;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangEnumeration;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangIdentityRef;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangUnion;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaEnumerationTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaIdentityTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaModuleTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaSubModuleTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaTypeDefTranslator;
import org.onosproject.yangutils.translator.tojava.javamodel.YangJavaUnionTranslator;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangToJavaNamingConflictUtil;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class AttributesJavaDataType {
    private AttributesJavaDataType() {
    }

    public static String getJavaDataType(YangType<?> yangType) {
        YangDataTypes type = yangType.getDataType();
        switch (type) {
            case INT8: {
                return "byte";
            }
            case INT16: {
                return "short";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "long";
            }
            case UINT8: {
                return "short";
            }
            case UINT16: {
                return "int";
            }
            case UINT32: {
                return "long";
            }
            case UINT64: {
                return "BigInteger";
            }
            case BITS: {
                return "BitSet";
            }
            case BINARY: {
                return "byte[]";
            }
            case DECIMAL64: {
                return "BigDecimal";
            }
            case STRING: {
                return "String";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case INSTANCE_IDENTIFIER: {
                return "String";
            }
            case LEAFREF: {
                return AttributesJavaDataType.getJavaDataType(AttributesJavaDataType.getReferredTypeFromLeafref(yangType));
            }
        }
        throw new TranslatorException("given data type is not supported.");
    }

    public static String getJavaImportClass(YangType<?> yangType, boolean isListAttr, YangToJavaNamingConflictUtil pluginConfig) {
        YangDataTypes type = yangType.getDataType();
        if (isListAttr) {
            switch (type) {
                case INT8: {
                    return "Byte";
                }
                case INT16: {
                    return "Short";
                }
                case INT32: {
                    return "Integer";
                }
                case INT64: {
                    return "Long";
                }
                case UINT8: {
                    return "Short";
                }
                case UINT16: {
                    return "Integer";
                }
                case UINT32: {
                    return "Long";
                }
                case UINT64: {
                    return "BigInteger";
                }
                case DECIMAL64: {
                    return "BigDecimal";
                }
                case STRING: {
                    return "String";
                }
                case BOOLEAN: {
                    return "Boolean";
                }
                case ENUMERATION: {
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaEnumerationTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
                }
                case BITS: {
                    return "BitSet";
                }
                case BINARY: {
                    return "byte[]";
                }
                case LEAFREF: {
                    YangType<?> referredType = AttributesJavaDataType.getReferredTypeFromLeafref(yangType);
                    return AttributesJavaDataType.getJavaImportClass(referredType, true, pluginConfig);
                }
                case IDENTITYREF: {
                    YangIdentityRef identityRef = (YangIdentityRef)yangType.getDataTypeExtendedInfo();
                    YangIdentity identity = identityRef.getReferredIdentity();
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(identity.getName(), pluginConfig));
                }
                case EMPTY: {
                    return "Boolean";
                }
                case UNION: {
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaUnionTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
                }
                case INSTANCE_IDENTIFIER: {
                    return "String";
                }
                case DERIVED: {
                    return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(yangType.getDataTypeName(), pluginConfig));
                }
            }
            throw new TranslatorException("given data type is not supported.");
        }
        switch (type) {
            case UINT64: {
                return "BigInteger";
            }
            case STRING: {
                return "String";
            }
            case ENUMERATION: {
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaEnumerationTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
            }
            case BITS: {
                return "BitSet";
            }
            case DECIMAL64: {
                return "BigDecimal";
            }
            case LEAFREF: {
                YangType<?> referredType = AttributesJavaDataType.getReferredTypeFromLeafref(yangType);
                return AttributesJavaDataType.getJavaImportClass(referredType, false, pluginConfig);
            }
            case IDENTITYREF: {
                YangIdentityRef identityRef = (YangIdentityRef)yangType.getDataTypeExtendedInfo();
                YangIdentity identity = identityRef.getReferredIdentity();
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(identity.getName(), pluginConfig));
            }
            case EMPTY: {
                return "boolean";
            }
            case UNION: {
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangJavaUnionTranslator)yangType.getDataTypeExtendedInfo()).getName(), pluginConfig));
            }
            case INSTANCE_IDENTIFIER: {
                return "String";
            }
            case DERIVED: {
                return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(yangType.getDataTypeName(), pluginConfig));
            }
        }
        return null;
    }

    public static String getJavaImportPackage(YangType<?> yangType, boolean isListAttr, YangToJavaNamingConflictUtil conflictResolver) {
        YangDataTypes type = yangType.getDataType();
        if (isListAttr) {
            switch (type) {
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case BINARY: 
                case STRING: 
                case BOOLEAN: 
                case EMPTY: {
                    return "java.lang";
                }
                case UINT64: 
                case DECIMAL64: {
                    return "java.math";
                }
                case ENUMERATION: {
                    return AttributesJavaDataType.getEnumsPackage(yangType, conflictResolver);
                }
                case BITS: {
                    return "java.util";
                }
                case LEAFREF: {
                    YangType<?> referredType = AttributesJavaDataType.getReferredTypeFromLeafref(yangType);
                    return AttributesJavaDataType.getJavaImportPackage(referredType, true, conflictResolver);
                }
                case IDENTITYREF: {
                    return AttributesJavaDataType.getIdentityRefPackage(yangType, conflictResolver);
                }
                case UNION: {
                    return AttributesJavaDataType.getUnionPackage(yangType, conflictResolver);
                }
                case INSTANCE_IDENTIFIER: {
                    return "java.lang";
                }
                case DERIVED: {
                    return AttributesJavaDataType.getTypeDefsPackage(yangType, conflictResolver);
                }
            }
            throw new TranslatorException("given data type is not supported.");
        }
        switch (type) {
            case UINT64: 
            case DECIMAL64: {
                return "java.math";
            }
            case STRING: 
            case EMPTY: {
                return "java.lang";
            }
            case ENUMERATION: {
                return AttributesJavaDataType.getEnumsPackage(yangType, conflictResolver);
            }
            case BITS: {
                return "java.util";
            }
            case LEAFREF: {
                YangType<?> referredType = AttributesJavaDataType.getReferredTypeFromLeafref(yangType);
                return AttributesJavaDataType.getJavaImportPackage(referredType, false, conflictResolver);
            }
            case IDENTITYREF: {
                return AttributesJavaDataType.getIdentityRefPackage(yangType, conflictResolver);
            }
            case UNION: {
                return AttributesJavaDataType.getUnionPackage(yangType, conflictResolver);
            }
            case INSTANCE_IDENTIFIER: {
                return "java.lang";
            }
            case DERIVED: {
                return AttributesJavaDataType.getTypeDefsPackage(yangType, conflictResolver);
            }
        }
        return null;
    }

    private static String getTypeDefsPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        Object var = type.getDataTypeExtendedInfo();
        if (!(var instanceof YangDerivedInfo)) {
            throw new TranslatorException("type should have been derived.");
        }
        if (((YangDerivedInfo)var).getReferredTypeDef() == null) {
            throw new TranslatorException("derived info is not an instance of typedef.");
        }
        YangJavaTypeDefTranslator typedef = (YangJavaTypeDefTranslator)((YangDerivedInfo)var).getReferredTypeDef();
        if (typedef.getJavaFileInfo().getPackage() == null) {
            return AttributesJavaDataType.getPackageFromParent(typedef.getParent(), conflictResolver);
        }
        return typedef.getJavaFileInfo().getPackage();
    }

    private static String getUnionPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangUnion)) {
            throw new TranslatorException("type should have been union.");
        }
        YangJavaUnionTranslator union = (YangJavaUnionTranslator)type.getDataTypeExtendedInfo();
        if (union.getJavaFileInfo().getPackage() == null) {
            return AttributesJavaDataType.getPackageFromParent(union.getParent(), conflictResolver);
        }
        return union.getJavaFileInfo().getPackage();
    }

    private static String getEnumsPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangEnumeration)) {
            throw new TranslatorException("type should have been enumeration.");
        }
        YangJavaEnumerationTranslator enumeration = (YangJavaEnumerationTranslator)type.getDataTypeExtendedInfo();
        if (enumeration.getJavaFileInfo().getPackage() == null) {
            return AttributesJavaDataType.getPackageFromParent(enumeration.getParent(), conflictResolver);
        }
        return enumeration.getJavaFileInfo().getPackage();
    }

    private static String getIdentityRefPackage(YangType<?> type, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(type.getDataTypeExtendedInfo() instanceof YangIdentityRef)) {
            throw new TranslatorException("type should have been identityref.");
        }
        YangIdentityRef identityRef = (YangIdentityRef)type.getDataTypeExtendedInfo();
        YangJavaIdentityTranslator identity = (YangJavaIdentityTranslator)identityRef.getReferredIdentity();
        if (identity.getJavaFileInfo().getPackage() == null) {
            return AttributesJavaDataType.getPackageFromParent(identity.getParent(), conflictResolver);
        }
        return identity.getJavaFileInfo().getPackage();
    }

    private static String getPackageFromParent(YangNode parent, YangToJavaNamingConflictUtil conflictResolver) {
        if (!(parent instanceof JavaFileInfoContainer)) {
            throw new TranslatorException("invalid child node is being processed.");
        }
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        if (parentInfo.getPackage() == null) {
            AttributesJavaDataType.updateJavaFileInfo(parent, conflictResolver);
        }
        return parentInfo.getPackage() + "." + parentInfo.getJavaName().toLowerCase();
    }

    public static void updateJavaFileInfo(YangNode yangNode, YangToJavaNamingConflictUtil conflictResolver) {
        Stack<YangNode> nodesToUpdatePackage = new Stack<YangNode>();
        while (yangNode != null && ((JavaFileInfoContainer)yangNode).getJavaFileInfo().getPackage() == null) {
            nodesToUpdatePackage.push(yangNode);
            yangNode = yangNode.getParent();
        }
        if (yangNode == null) {
            String pkg;
            yangNode = (YangNode)nodesToUpdatePackage.pop();
            if (yangNode instanceof YangJavaModuleTranslator) {
                YangJavaModuleTranslator module = (YangJavaModuleTranslator)yangNode;
                pkg = JavaIdentifierSyntax.getRootPackage(module.getVersion(), module.getNameSpace(), module.getRevision().getRevDate(), conflictResolver);
            } else if (yangNode instanceof YangJavaSubModuleTranslator) {
                YangJavaSubModuleTranslator submodule = (YangJavaSubModuleTranslator)yangNode;
                pkg = JavaIdentifierSyntax.getRootPackage(submodule.getVersion(), submodule.getNameSpaceFromModule(submodule.getBelongsTo()), submodule.getRevision().getRevDate(), conflictResolver);
            } else {
                throw new TranslatorException("Invalid root node of data model tree");
            }
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setJavaName(YangIoUtils.getCamelCase(yangNode.getName(), conflictResolver));
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setPackage(pkg);
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().getPackage()));
        }
        while (nodesToUpdatePackage.size() != 0) {
            yangNode = (YangNode)nodesToUpdatePackage.pop();
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setJavaName(YangIoUtils.getCamelCase(yangNode.getName(), conflictResolver));
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setPackage(YangJavaModelUtils.getCurNodePackage(yangNode));
            ((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().setPackageFilePath(YangIoUtils.getPackageDirPathFromJavaJPackage(((JavaCodeGeneratorInfo)yangNode).getJavaFileInfo().getPackage()));
        }
    }

    private static YangType<?> getReferredTypeFromLeafref(YangType type) {
        YangLeafRef leafRefInfo = (YangLeafRef)type.getDataTypeExtendedInfo();
        return leafRefInfo.getEffectiveDataType();
    }
}

