/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaModule;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class YangJavaModuleTranslator
extends YangJavaModule
implements JavaCodeGeneratorInfo,
JavaCodeGenerator {
    private static final long serialVersionUID = 806201625L;
    private transient TempJavaCodeFragmentFiles tempFileHandle;
    private transient List<YangNode> notificationNodes;

    public YangJavaModuleTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
        this.setNotificationNodes(new ArrayList<YangNode>());
        this.getJavaFileInfo().setGeneratedFileTypes(8223);
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("Missing java info in java datamodel node");
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempFileHandle;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempFileHandle = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        String modulePkg = JavaIdentifierSyntax.getRootPackage(this.getVersion(), this.getNameSpace(), this.getRevision().getRevDate(), yangPlugin.getConflictResolver());
        if (this.isNotificationChildNodePresent((YangNode)this)) {
            this.getJavaFileInfo().setGeneratedFileTypes(this.getJavaFileInfo().getGeneratedFileTypes() | 0x700);
        }
        try {
            YangJavaModelUtils.generateCodeOfRootNode(this, yangPlugin, modulePkg);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code entry for module node " + this.getName());
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        try {
            if ((this.getJavaFileInfo().getGeneratedFileTypes() & 0x700) != 0) {
                this.getTempJavaCodeFragmentFiles().generateJavaFile(1792, (YangNode)this);
            }
            if (YangJavaModelUtils.isRootNodesCodeGenRequired((YangNode)this)) {
                this.getTempJavaCodeFragmentFiles().generateJavaFile(8207, (YangNode)this);
                if (this.getJavaFileInfo().getPluginConfig().getCodeGenerateForSbi() == null || !this.getJavaFileInfo().getPluginConfig().getCodeGenerateForSbi().equals("sbi")) {
                    this.getTempJavaCodeFragmentFiles().generateJavaFile(16, (YangNode)this);
                }
            }
            YangIoUtils.searchAndDeleteTempDir(this.getJavaFileInfo().getBaseCodeGenPath() + this.getJavaFileInfo().getPackageFilePath());
            YangIoUtils.searchAndDeleteTempDir(this.getJavaFileInfo().getPluginConfig().getCodeGenDir() + this.getJavaFileInfo().getPackageFilePath());
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to generate code for module node " + this.getName());
        }
    }

    public List<YangNode> getNotificationNodes() {
        return this.notificationNodes;
    }

    private void setNotificationNodes(List<YangNode> notificationNodes) {
        this.notificationNodes = notificationNodes;
    }

    private void addToNotificationList(YangNode curNode) {
        this.getNotificationNodes().add(curNode);
    }

    private boolean isNotificationChildNodePresent(YangNode rootNode) {
        for (YangNode childNode = rootNode.getChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!(childNode instanceof YangNotification)) continue;
            this.addToNotificationList(childNode);
        }
        return !this.getNotificationNodes().isEmpty();
    }
}

