/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.javamodel;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.RpcNotificationContainer;
import org.onosproject.yangutils.datamodel.YangInput;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangOutput;
import org.onosproject.yangutils.datamodel.javadatamodel.YangJavaRpc;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGenerator;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public class YangJavaRpcTranslator
extends YangJavaRpc
implements JavaCodeGenerator,
JavaCodeGeneratorInfo {
    private static final long serialVersionUID = 806201622L;
    private transient TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles;

    public YangJavaRpcTranslator() {
        this.setJavaFileInfo(new JavaFileInfoTranslator());
    }

    @Override
    public JavaFileInfoTranslator getJavaFileInfo() {
        if (this.javaFileInfo == null) {
            throw new TranslatorException("missing java info in java datamodel node");
        }
        return (JavaFileInfoTranslator)this.javaFileInfo;
    }

    @Override
    public void setJavaFileInfo(JavaFileInfoTranslator javaInfo) {
        this.javaFileInfo = javaInfo;
    }

    @Override
    public TempJavaCodeFragmentFiles getTempJavaCodeFragmentFiles() {
        return this.tempJavaCodeFragmentFiles;
    }

    @Override
    public void setTempJavaCodeFragmentFiles(TempJavaCodeFragmentFiles fileHandle) {
        this.tempJavaCodeFragmentFiles = fileHandle;
    }

    @Override
    public void generateCodeEntry(YangPluginConfig yangPlugin) throws TranslatorException {
        try {
            YangJavaModelUtils.updatePackageInfo(this, yangPlugin);
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to prepare generate code entry for RPC node " + this.getName());
        }
    }

    @Override
    public void generateCodeExit() throws TranslatorException {
        YangNode parent = DataModelUtils.getParentNodeInGenCode((YangNode)this);
        if (!(parent instanceof RpcNotificationContainer)) {
            throw new TranslatorException("parent node of rpc can only be module or sub-module");
        }
        JavaAttributeInfo javaAttributeInfoOfInput = null;
        JavaAttributeInfo javaAttributeInfoOfOutput = null;
        for (YangNode yangNode = this.getChild(); yangNode != null; yangNode = yangNode.getNextSibling()) {
            if (yangNode instanceof YangInput) {
                javaAttributeInfoOfInput = this.getChildNodeAsAttributeInParentService(yangNode, (YangNode)this);
                continue;
            }
            if (yangNode instanceof YangOutput) {
                javaAttributeInfoOfOutput = this.getChildNodeAsAttributeInParentService(yangNode, (YangNode)this);
                continue;
            }
            throw new TranslatorException("RPC should contain only input/output child nodes.");
        }
        if (!(parent instanceof TempJavaCodeFragmentFilesContainer)) {
            throw new TranslatorException("missing parent temp file handle");
        }
        try {
            ((TempJavaCodeFragmentFilesContainer)parent).getTempJavaCodeFragmentFiles().getServiceTempFiles().addJavaSnippetInfoToApplicableTempFiles(javaAttributeInfoOfInput, javaAttributeInfoOfOutput, ((JavaFileInfoContainer)parent).getJavaFileInfo().getPluginConfig(), this.getName());
        }
        catch (IOException e) {
            throw new TranslatorException("Failed to generate code for RPC node " + this.getName());
        }
    }

    private JavaAttributeInfo getChildNodeAsAttributeInParentService(YangNode childNode, YangNode currentNode) {
        YangNode parentNode = DataModelUtils.getParentNodeInGenCode((YangNode)currentNode);
        String childNodeName = ((JavaFileInfoContainer)childNode).getJavaFileInfo().getJavaName();
        JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(childNode, YangIoUtils.getCapitalCase(childNodeName));
        if (!(parentNode instanceof TempJavaCodeFragmentFilesContainer)) {
            throw new TranslatorException("Parent node does not have file info");
        }
        TempJavaServiceFragmentFiles tempJavaFragmentFiles = ((TempJavaCodeFragmentFilesContainer)parentNode).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        if (tempJavaFragmentFiles == null) {
            throw new TranslatorException("Parent node does not have service file info");
        }
        boolean isQualified = this.addImportToService(qualifiedTypeInfo);
        return JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, childNodeName, null, isQualified, false);
    }

    private boolean addImportToService(JavaQualifiedTypeInfoTranslator importInfo) {
        JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)this.getParent()).getJavaFileInfo();
        if (importInfo.getClassInfo().contentEquals("Service") || importInfo.getClassInfo().contentEquals(YangIoUtils.getCapitalCase(fileInfo.getJavaName() + "Service"))) {
            return true;
        }
        String className = YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + "Service";
        return ((TempJavaCodeFragmentFilesContainer)this.getParent()).getTempJavaCodeFragmentFiles().getServiceTempFiles().getJavaImportData().addImportInfo(importInfo, className, fileInfo.getPackage());
    }
}

