/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangIdentity;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNotification;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.utils.JavaExtendsListHolder;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

final class ClassDefinitionGenerator {
    private ClassDefinitionGenerator() {
    }

    static String generateClassDefinition(int genFileTypes, String yangName) {
        switch (genFileTypes) {
            case 64: 
            case 128: {
                return ClassDefinitionGenerator.getTypeClassDefinition(yangName);
            }
            case 32: {
                return ClassDefinitionGenerator.getEnumClassDefinition(yangName);
            }
        }
        return null;
    }

    static String generateClassDefinition(int genFileTypes, String yangName, YangNode curNode) {
        switch (genFileTypes) {
            case 1: {
                return ClassDefinitionGenerator.getInterfaceDefinition(yangName, curNode);
            }
            case 4: {
                return ClassDefinitionGenerator.getBuilderClassDefinition(yangName, curNode);
            }
            case 8: {
                return ClassDefinitionGenerator.getImplClassDefinition(yangName, curNode);
            }
            case 2: {
                return ClassDefinitionGenerator.getBuilderInterfaceDefinition(yangName, curNode);
            }
            case 16: {
                return ClassDefinitionGenerator.getRpcInterfaceDefinition(yangName, curNode);
            }
            case 256: {
                String eventName = yangName + "Subject";
                return ClassDefinitionGenerator.getEventDefinition(yangName, eventName);
            }
            case 512: {
                return ClassDefinitionGenerator.getEventListenerDefinition(yangName);
            }
            case 1024: {
                return ClassDefinitionGenerator.getClassDefinition(yangName);
            }
            case 2048: {
                return ClassDefinitionGenerator.getIdentityClassDefinition(yangName, curNode);
            }
        }
        return null;
    }

    private static String getEnumClassDefinition(String yangName) {
        return "public enum " + yangName + " " + "{" + "\n";
    }

    private static String getInterfaceDefinition(String yangName, YangNode curNode) {
        String clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 1);
        if (clsDef != null) {
            return clsDef;
        }
        return "public interface " + yangName + " " + "{" + "\n";
    }

    private static String getBuilderInterfaceDefinition(String yangName, YangNode curNode) {
        String clsDef;
        if (!(curNode instanceof YangCase) && !(curNode instanceof YangAugment) && (clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 2)) != null) {
            return clsDef;
        }
        return "interface " + yangName + "Builder" + " " + "{" + "\n" + "\n";
    }

    private static String getBuilderClassDefinition(String yangName, YangNode curNode) {
        String clsDef;
        if (!(curNode instanceof YangCase) && (clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 4)) != null) {
            return clsDef;
        }
        if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
            return "public static class " + yangName + "Builder" + " " + "{" + "\n";
        }
        return "public static class " + yangName + "Builder" + " " + "implements" + " " + yangName + "." + yangName + "Builder" + " " + "{" + "\n";
    }

    private static String getImplClassDefinition(String yangName, YangNode curNode) {
        String clsDef;
        if (!(curNode instanceof YangCase) && (clsDef = ClassDefinitionGenerator.getClassDefinitionForWhenExtended(curNode, yangName, 8)) != null) {
            return clsDef;
        }
        if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
            return "public class " + yangName + "OpParam" + " " + "implements" + " " + yangName + " " + "{" + "\n";
        }
        return "public class " + YangIoUtils.getCapitalCase("default") + yangName + " " + "implements" + " " + yangName + " " + "{" + "\n";
    }

    private static String getClassDefinition(String yangName) {
        return "public class " + yangName + " " + "{" + "\n";
    }

    private static String getIdentityClassDefinition(String yangName, YangNode curNode) {
        if (!(curNode instanceof YangIdentity)) {
            throw new TranslatorException("Expected java identity instance node");
        }
        YangIdentity identity = (YangIdentity)curNode;
        if (identity.getBaseNode() != null) {
            YangIdentity baseIdentity = identity.getBaseNode().getReferredIdentity();
            if (baseIdentity == null) {
                throw new TranslatorException("Expected java identity instance node");
            }
            JavaFileInfoTranslator fileInfo = ((JavaFileInfoContainer)baseIdentity).getJavaFileInfo();
            return "public abstract class " + yangName + " " + "extends" + " " + YangIoUtils.getCapitalCase(fileInfo.getJavaName()) + " " + "{" + "\n";
        }
        return "public abstract class " + yangName + " " + "{" + "\n";
    }

    private static String getTypeClassDefinition(String yangName) {
        return "public final class " + yangName + " " + "{" + "\n";
    }

    private static String getRpcInterfaceDefinition(String yangName, YangNode curNode) {
        JavaExtendsListHolder holder = ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getServiceTempFiles().getJavaExtendsListHolder();
        if (holder.getExtendsList() != null && !holder.getExtendsList().isEmpty()) {
            for (curNode = curNode.getChild(); curNode != null; curNode = curNode.getNextSibling()) {
                if (!(curNode instanceof YangNotification)) continue;
                return ClassDefinitionGenerator.getRpcInterfaceDefinitionWhenItExtends(yangName);
            }
        }
        if (yangName.matches(".+Service")) {
            return "public interface " + yangName + " " + "{" + "\n";
        }
        return "public class " + yangName + " " + "implements" + " " + yangName.substring(0, yangName.length() - 7) + "Service" + " " + "{" + "\n";
    }

    private static String getRpcInterfaceDefinitionWhenItExtends(String yangName) {
        if (yangName.matches(".+Service")) {
            StringBuilder newString = new StringBuilder(yangName);
            newString.replace(yangName.lastIndexOf("Service"), yangName.lastIndexOf("Service") + 7, "");
            return "public interface " + yangName + "\n" + "        " + "extends" + " " + "ListenerService" + "<" + newString + "Event" + "," + " " + newString + "EventListener" + ">" + " " + "{" + "\n";
        }
        yangName = yangName.substring(0, yangName.length() - 7);
        return "public class " + yangName + "Manager" + "\n" + "        " + "extends" + " " + "ListenerRegistry" + "<" + yangName + "Event" + "," + " " + yangName + "EventListener" + ">" + "\n" + "        " + "implements" + " " + yangName + "Service" + " " + "{" + "\n";
    }

    private static String getEventDefinition(String javaName, String eventName) {
        return "public class " + javaName + " " + "extends AbstractEvent<" + javaName + ".Type, " + eventName + ">" + " " + "{" + "\n";
    }

    private static String getEventListenerDefinition(String javaName) {
        String interfaceDef = "public interface " + javaName + " " + "extends EventListener<" + javaName;
        if (interfaceDef.length() < 8) {
            throw new RuntimeException("Event listener interface name is error");
        }
        interfaceDef = interfaceDef.substring(0, interfaceDef.length() - 8);
        interfaceDef = interfaceDef + ">" + " " + "{" + "\n";
        return interfaceDef;
    }

    private static String getClassDefinitionForWhenExtended(YangNode curNode, String yangName, int genFileTypes) {
        JavaExtendsListHolder holder = ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles().getJavaExtendsListHolder();
        if (holder.getExtendsList() != null && !holder.getExtendsList().isEmpty()) {
            String def = "public ";
            switch (genFileTypes) {
                case 1: {
                    def = def + "interface" + " " + yangName + " " + "extends" + " ";
                    def = ClassDefinitionGenerator.getDefinitionString(def, holder);
                    return def + " " + "{" + "\n";
                }
                case 2: {
                    String builderDef = "interface " + yangName + "Builder" + " " + "extends" + " ";
                    builderDef = ClassDefinitionGenerator.getDefinitionString(builderDef, holder);
                    return builderDef + " " + "{" + "\n";
                }
                case 4: {
                    def = def + "static" + " " + "class" + " " + yangName + "Builder" + " " + "extends" + " ";
                    def = ClassDefinitionGenerator.getDefinitionString(def, holder);
                    if (curNode instanceof YangSubModule || curNode instanceof YangModule) {
                        return def + " " + "{" + "\n";
                    }
                    return def + " " + "implements" + " " + yangName + "." + yangName + "Builder" + " " + "{" + "\n";
                }
                case 8: {
                    def = curNode instanceof YangSubModule || curNode instanceof YangModule ? def + "class" + " " + yangName + "OpParam" + " " + "extends" + " " : def + "class" + " " + YangIoUtils.getCapitalCase("default") + yangName + " " + "extends" + " ";
                    def = ClassDefinitionGenerator.getDefinitionString(def, holder);
                    return def + " " + "implements" + " " + yangName + " " + "{" + "\n";
                }
            }
            return null;
        }
        return null;
    }

    private static String getDefinitionString(String def, JavaExtendsListHolder holder) {
        for (JavaQualifiedTypeInfoTranslator info : holder.getExtendsList()) {
            if (!holder.getExtendedClassStore().get(info).booleanValue()) {
                def = def + info.getClassInfo() + "," + " ";
                continue;
            }
            def = def + info.getPkgInfo() + "." + info.getClassInfo() + "," + " ";
        }
        return YangIoUtils.trimAtLast(def, ",");
    }
}

