/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.util.Collections;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.utils.JavaIdentifierSyntax;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaCodeSnippetGen {
    private JavaCodeSnippetGen() {
    }

    public static String getFileHeaderComment() {
        return null;
    }

    static String getImportText(JavaQualifiedTypeInfoTranslator importInfo) {
        return "import " + importInfo.getPkgInfo() + "." + importInfo.getClassInfo() + ";" + "\n";
    }

    public static String getJavaAttributeDefinition(String javaAttributeTypePkg, String javaAttributeType, String javaAttributeName, boolean isList, String attributeAccessType, YangCompilerAnnotation compilerAnnotation) {
        String attributeDefinition = attributeAccessType + " ";
        if (!isList) {
            if (javaAttributeTypePkg != null) {
                attributeDefinition = attributeDefinition + javaAttributeTypePkg + ".";
            }
            attributeDefinition = attributeDefinition + javaAttributeType + " " + javaAttributeName + ";" + "\n";
        } else {
            if (compilerAnnotation != null && compilerAnnotation.getYangAppDataStructure() != null) {
                switch (compilerAnnotation.getYangAppDataStructure().getDataStructure()) {
                    case QUEUE: {
                        attributeDefinition = attributeDefinition + "Queue" + "<";
                        break;
                    }
                    case SET: {
                        attributeDefinition = attributeDefinition + "Set" + "<";
                        break;
                    }
                    default: {
                        attributeDefinition = attributeDefinition + "List" + "<";
                        break;
                    }
                }
            } else {
                attributeDefinition = attributeDefinition + "List" + "<";
            }
            if (javaAttributeTypePkg != null) {
                attributeDefinition = attributeDefinition + javaAttributeTypePkg + ".";
            }
            attributeDefinition = attributeDefinition + javaAttributeType;
            if (compilerAnnotation != null && compilerAnnotation.getYangAppDataStructure() != null) {
                switch (compilerAnnotation.getYangAppDataStructure().getDataStructure()) {
                    default: 
                }
                attributeDefinition = attributeDefinition + ">" + " " + javaAttributeName + ";" + "\n";
            } else {
                attributeDefinition = attributeDefinition + ">" + " " + javaAttributeName + " " + "=" + " " + "new" + " " + "ArrayList<>()" + ";" + "\n";
            }
        }
        return attributeDefinition;
    }

    public static String getJavaClassDefClose() {
        return "}";
    }

    public static String generateEnumAttributeString(String name, int value, YangPluginConfig pluginConfig) {
        return "\n" + JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.ENUM_ATTRIBUTE, name, false, pluginConfig, null) + "        " + JavaIdentifierSyntax.getEnumJavaAttribute(name).toUpperCase() + "(" + value + ")" + "," + "\n";
    }

    public static List<String> sortImports(List<String> imports) {
        Collections.sort(imports);
        return imports;
    }

    static String getEventEnumTypeStart() {
        return "    public enum Type {\n";
    }

    public static void addListenersImport(YangNode curNode, List<String> imports, boolean operation, String classInfo) {
        TempJavaServiceFragmentFiles tempJavaServiceFragmentFiles = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        if (classInfo.equals("ListenerService")) {
            String thisImport = tempJavaServiceFragmentFiles.getJavaImportData().getListenerServiceImport();
            JavaCodeSnippetGen.performOperationOnImports(imports, thisImport, operation);
        } else {
            String thisImport = tempJavaServiceFragmentFiles.getJavaImportData().getListenerRegistryImport();
            JavaCodeSnippetGen.performOperationOnImports(imports, thisImport, operation);
        }
    }

    private static List<String> performOperationOnImports(List<String> imports, String curImport, boolean operation) {
        if (operation) {
            imports.add(curImport);
        } else {
            imports.remove(curImport);
        }
        JavaCodeSnippetGen.sortImports(imports);
        return imports;
    }

    static String getEnumsValueAttribute(String className) {
        return "\n    private int " + YangIoUtils.getSmallCase(className) + ";" + "\n";
    }

    static String addAugmentationAttribute() {
        return "\n    protected Map<Class<?>, Object> " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + " " + "=" + " " + "new" + " " + "HashMap" + "<" + ">" + "(" + ")" + ";";
    }

    static String addStaticAttributeIntRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return "\n    " + modifier + " " + "static final int INT32_MIN_RANGE = -2147483648;\n" + "    " + modifier + " " + "static final int INT32_MAX_RANGE = 2147483647;";
        }
        return "\n    " + modifier + " " + "static final int UINT16_MIN_RANGE = 0;\n" + "    " + modifier + " " + "static final int UINT16_MAX_RANGE = 2147483647;";
    }

    static String addStaticAttributeLongRange(String modifier, boolean addFirst) {
        if (addFirst) {
            return "\n    " + modifier + " " + "static final BigInteger INT64_MIN_RANGE = new BigInteger(\"-9223372036854775808\");\n" + "    " + modifier + " " + "static final BigInteger INT64_MAX_RANGE = new BigInteger(\"9223372036854775807\");";
        }
        return "\n    " + modifier + " " + "static final BigInteger UINT32_MIN_RANGE = new BigInteger(\"0\");\n" + "    " + modifier + " " + "static final BigInteger UINT32_MAX_RANGE = new BigInteger(\"9223372036854775807\");";
    }

    static String getOperationTypeEnum() {
        return "\n    /**\n     * Specify the node specific operation in protocols like NETCONF.\n     * Applicable in protocol edit operation, not applicable in query operation\n     */\n    public enum OperationType {\n        MERGE,\n        REPLACE,\n        CREATE,\n        DELETE,\n        REMOVE\n    }\n";
    }

    static String getOperationAttributes() {
        return "    /**\n     * Identify the leafs whose value are explicitly set\n     * Applicable in protocol edit and query operation\n     */\n    private BitSet valueLeafFlags = new BitSet();\n\n    /**\n     * Identify the leafs to be selected, in a query operation\n     */\n    private BitSet selectLeafFlags = new BitSet();\n";
    }

    static String getOperationTypeAttr() {
        return "\n    /**\n     * Specify the node specific operation in protocols like NETCONF.\n     * Applicable in protocol edit operation, will be ignored in query operation\n     */\n    private OperationType operationType;\n\n";
    }

    static String getOperationAttributeForConstructor() {
        return "        this.valueLeafFlags = builderObject.getValueLeafFlags();\n        this.selectLeafFlags = builderObject.getSelectLeafFlags();\n";
    }

    static String getOperationTypeForConstructor() {
        return "        this.operationType = builderObject.getOperationType();\n";
    }
}

