/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangAugmentableNode;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangDerivedInfo;
import org.onosproject.yangutils.datamodel.YangLeavesHolder;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.YangTypeDef;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.JavaCodeSnippetGen;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.translator.tojava.utils.SubtreeFilteringMethodsGenerator;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaFileGenerator {
    private JavaFileGenerator() {
    }

    public static File generateInterfaceFile(File file, List<String> imports, YangNode curNode, boolean isAttrPresent) throws IOException {
        YangLeavesHolder leavesHolder;
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String path = curNode instanceof YangModule || curNode instanceof YangSubModule ? javaFileInfo.getPluginConfig().getCodeGenDir() + javaFileInfo.getPackageFilePath() : javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        String className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        boolean isLeavesPresent = curNode instanceof YangLeavesHolder ? (leavesHolder = (YangLeavesHolder)curNode).getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty() || leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty() : false;
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 1, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        if (isAttrPresent) {
            try {
                if (isLeavesPresent) {
                    YangIoUtils.insertDataIntoJavaFile(file, "\n" + MethodsGenerator.getInterfaceLeafIdEnumSignature(className) + "\n" + YangIoUtils.trimAtLast(YangIoUtils.replaceLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(0x400000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path), ",", ";"), "\n") + "\n" + "\n" + MethodsGenerator.getInterfaceLeafIdEnumMethods());
                }
                YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(2, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while interface file generation");
            }
        }
        if (curNode instanceof YangAugmentableNode && !(curNode instanceof YangChoice)) {
            methods.add(MethodsGenerator.getYangAugmentInfoInterface());
            methods.add(MethodsGenerator.getYangAugmentInfoMapInterface(javaFileInfo.getPluginConfig()));
        }
        if (curNode instanceof YangCase) {
            YangNode caseParent = curNode.getParent();
            JavaQualifiedTypeInfoTranslator qualifiedTypeInfo = YangJavaModelUtils.getQualifierInfoForCasesParent(caseParent, javaFileInfo.getPluginConfig());
            methods.add("\n" + MethodsGenerator.processSubtreeFilteringInterface(qualifiedTypeInfo.getClassInfo()));
        } else {
            methods.add("\n" + MethodsGenerator.processSubtreeFilteringInterface(className));
        }
        if (isLeavesPresent) {
            methods.add("\n" + MethodsGenerator.isLeafValueSetInterface());
            methods.add("\n" + MethodsGenerator.isSelectLeafSetInterface());
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        return file;
    }

    public static File generateBuilderInterfaceFile(File file, YangNode curNode, boolean isAttrPresent) throws IOException {
        YangLeavesHolder leavesHolder;
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        YangPluginConfig pluginConfig = javaFileInfo.getPluginConfig();
        boolean isLeavesPresent = curNode instanceof YangLeavesHolder ? (leavesHolder = (YangLeavesHolder)curNode).getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty() || leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty() : false;
        String className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String path = curNode instanceof YangModule || curNode instanceof YangSubModule ? javaFileInfo.getPluginConfig().getCodeGenDir() + javaFileInfo.getPackageFilePath() : javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 2, null, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        if (isAttrPresent) {
            try {
                methods.add("    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(2, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                methods.add("\n");
                methods.add("    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(8, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                methods.add("\n");
                YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(0x100000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while builder interface file generation");
            }
        }
        if (curNode instanceof YangAugmentableNode && !(curNode instanceof YangChoice)) {
            methods.add(MethodsGenerator.getAddAugmentInfoMethodInterface());
            methods.add(MethodsGenerator.getYangAugmentInfoInterface());
            methods.add(MethodsGenerator.getYangAugmentInfoMapInterface(javaFileInfo.getPluginConfig()));
        }
        if (isLeavesPresent) {
            methods.add("\n" + MethodsGenerator.setSelectLeafSetInterface(className));
        }
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addBuildMethodForInterface(pluginConfig));
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return file;
    }

    /*
     * Unable to fully structure code
     */
    public static File generateBuilderClassFile(File file, YangNode curNode, boolean isAttrPresent) throws IOException {
        javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        pluginConfig = javaFileInfo.getPluginConfig();
        isLeavesPresent = curNode instanceof YangLeavesHolder != false ? (leavesHolder = (YangLeavesHolder)curNode).getListOfLeaf() != null && leavesHolder.getListOfLeaf().isEmpty() == false || leavesHolder.getListOfLeafList() != null && leavesHolder.getListOfLeafList().isEmpty() == false : false;
        className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        isRootNode = false;
        if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
            isRootNode = true;
            path = javaFileInfo.getPluginConfig().getCodeGenDir() + javaFileInfo.getPackageFilePath();
        } else {
            path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 4, null, curNode, className);
        methods = new ArrayList<String>();
        if (curNode instanceof YangAugmentableNode) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addAugmentationAttribute());
        }
        if (isAttrPresent) {
            try {
                YangIoUtils.insertDataIntoJavaFile(file, "\n    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(1, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while builder class file generation");
            }
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getOperationTypeAttr());
            if (isLeavesPresent) {
                YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getOperationAttributes());
            }
            try {
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(16, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(0x200000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                YangIoUtils.insertDataIntoJavaFile(file, "\n");
                methods.add(MethodsGenerator.getGetterForOperationType());
                methods.add(MethodsGenerator.getSetterForOperationType(className));
                if (!isLeavesPresent) ** GOTO lbl45
                methods.add(MethodsGenerator.getOperationAttributesGetters() + "\n");
                methods.add(MethodsGenerator.getSetterForSelectLeaf(className, isRootNode));
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while builder class file generation");
            }
        } else {
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
        }
lbl45:
        // 3 sources

        if (curNode instanceof YangAugmentableNode) {
            methods.add(MethodsGenerator.getAddAugmentInfoMethodImpl());
            methods.add(MethodsGenerator.getYangAugmentInfoImpl());
            methods.add(MethodsGenerator.getYangAugmentInfoMapImpl());
        }
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addBuildMethodImpl(curNode));
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addDefaultConstructor("public", "Builder", pluginConfig, curNode));
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}");
        return file;
    }

    public static File generateDefaultClassFile(File file, YangNode curNode, boolean isAttrPresent, List<String> imports) throws IOException {
        String path;
        String className;
        YangLeavesHolder leavesHolder;
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        YangPluginConfig pluginConfig = javaFileInfo.getPluginConfig();
        boolean isLeavesPresent = curNode instanceof YangLeavesHolder ? (leavesHolder = (YangLeavesHolder)curNode).getListOfLeaf() != null && !leavesHolder.getListOfLeaf().isEmpty() || leavesHolder.getListOfLeafList() != null && !leavesHolder.getListOfLeafList().isEmpty() : false;
        boolean isRootNode = false;
        String opParamClassName = className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        if (curNode instanceof YangModule || curNode instanceof YangSubModule) {
            opParamClassName = className + "OpParam";
            isRootNode = true;
            path = javaFileInfo.getPluginConfig().getCodeGenDir() + javaFileInfo.getPackageFilePath();
        } else {
            path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 8, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        if (curNode instanceof YangAugmentableNode) {
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addAugmentationAttribute());
        }
        if (isAttrPresent) {
            try {
                YangIoUtils.insertDataIntoJavaFile(file, "\n    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(1, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while impl class file generation");
            }
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getOperationTypeEnum());
            YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getOperationTypeAttr());
            if (isLeavesPresent) {
                YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getOperationAttributes());
            }
            try {
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path));
                methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path).replace("\n", "")));
                if (isRootNode) {
                    methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(opParamClassName) + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path)));
                } else {
                    methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(YangIoUtils.getCapitalCase("default") + className) + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path)));
                }
                methods.add(MethodsGenerator.getToStringMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(256, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path) + MethodsGenerator.getToStringMethodClose());
            }
            catch (IOException e) {
                throw new IOException("No data found in temporary java code fragment files for " + className + " while impl class file generation");
            }
        }
        YangIoUtils.insertDataIntoJavaFile(file, "\n");
        if (curNode instanceof YangAugmentableNode) {
            methods.add(MethodsGenerator.getYangAugmentInfoImpl());
            methods.add(MethodsGenerator.getYangAugmentInfoMapImpl());
        }
        try {
            String constructor = MethodsGenerator.getConstructorStart(className, pluginConfig, isRootNode);
            constructor = constructor + JavaFileGeneratorUtils.getDataFromTempFileHandle(32, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path);
            if (isAttrPresent) {
                constructor = constructor + JavaCodeSnippetGen.getOperationTypeForConstructor();
            }
            if (isLeavesPresent) {
                constructor = constructor + JavaCodeSnippetGen.getOperationAttributeForConstructor();
            }
            methods.add(constructor + "    " + "}" + "\n");
            String augmentableSubTreeFiltering = "";
            if (curNode instanceof YangAugmentableNode) {
                augmentableSubTreeFiltering = SubtreeFilteringMethodsGenerator.getAugmentableSubTreeFiltering();
            }
            methods.add(SubtreeFilteringMethodsGenerator.getProcessSubtreeFilteringStart(curNode, pluginConfig) + SubtreeFilteringMethodsGenerator.getProcessSubtreeFunctionBody() + augmentableSubTreeFiltering + SubtreeFilteringMethodsGenerator.getProcessSubTreeFilteringEnd() + SubtreeFilteringMethodsGenerator.getProcessLeafSubtreeFiltering(curNode, pluginConfig, path) + SubtreeFilteringMethodsGenerator.getProcessLeafListSubtreeFiltering(curNode, pluginConfig, path) + SubtreeFilteringMethodsGenerator.getProcessChildNodeSubtreeFiltering(curNode, pluginConfig, path));
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while impl class file generation");
        }
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addDefaultConstructor("protected", "default", pluginConfig, curNode));
        methods.add(MethodsGenerator.builderMethod(className) + "\n");
        if (isLeavesPresent) {
            methods.add(MethodsGenerator.getOperationAttributesGetters());
            methods.add(MethodsGenerator.getGettersForValueAndSelectLeaf());
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        return file;
    }

    public static File generateTypeDefClassFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        YangPluginConfig pluginConfig = javaFileInfo.getPluginConfig();
        String className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        YangTypeDef typeDef = (YangTypeDef)curNode;
        List types = typeDef.getTypeList();
        YangType type = (YangType)types.get(0);
        YangDataTypes yangDataTypes = type.getDataType();
        if (type.getDataType().equals((Object)YangDataTypes.BINARY)) {
            imports.add("import java.util.Base64;\n");
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, className, 64, imports, path, pluginConfig);
        ArrayList<String> methods = new ArrayList<String>();
        try {
            YangIoUtils.insertDataIntoJavaFile(file, "\n    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(1, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while type def class file generation");
        }
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addDefaultConstructor("private", "", pluginConfig, curNode));
        try {
            String bitsToStringMethod;
            String attributeName;
            JavaAttributeInfo attr;
            JavaQualifiedTypeInfoTranslator qualifiedTypeInfo;
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(1024, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(512, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path).replace("\n", "")));
            methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(className + "") + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path)));
            if (type.getDataType().equals((Object)YangDataTypes.BINARY)) {
                qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase("binary"));
                attr = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, "binary", null, false, false);
                attributeName = attr.getAttributeName();
                bitsToStringMethod = MethodsGenerator.getOverRideString() + "    " + "public" + " " + "String" + " " + "to" + "String" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "Base64" + "." + "getEncoder" + "(" + ")" + "." + "encodeToString" + "(" + attributeName + ")" + ";" + "\n" + "    " + "}" + "\n";
                methods.add(bitsToStringMethod);
            } else if (type.getDataType().equals((Object)YangDataTypes.BITS)) {
                qualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(curNode, YangIoUtils.getCapitalCase("bits"));
                attr = JavaAttributeInfo.getAttributeInfoForTheData(qualifiedTypeInfo, "bits", null, false, false);
                attributeName = attr.getAttributeName();
                bitsToStringMethod = MethodsGenerator.getOverRideString() + "    " + "public" + " " + "String" + " " + "to" + "String" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + attributeName + "." + "to" + "String" + "(" + ")" + ";" + "\n" + "    " + "}" + "\n";
                methods.add(bitsToStringMethod);
            } else {
                methods.add(MethodsGenerator.getToStringMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(256, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path) + MethodsGenerator.getToStringMethodClose());
            }
            JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)curNode;
            if (type.getDataType().equals((Object)YangDataTypes.DERIVED) && ((YangDerivedInfo)type.getDataTypeExtendedInfo()).getEffectiveBuiltInType().equals((Object)YangDataTypes.IDENTITYREF)) {
                yangDataTypes = YangDataTypes.IDENTITYREF;
            }
            if (type.getDataType().equals((Object)YangDataTypes.IDENTITYREF)) {
                yangDataTypes = YangDataTypes.IDENTITYREF;
            }
            if (!yangDataTypes.equals((Object)YangDataTypes.IDENTITYREF)) {
                methods.add(MethodsGenerator.getFromStringMethodSignature(className, pluginConfig) + JavaFileGeneratorUtils.getDataFromTempFileHandle(2048, javaGenInfo.getTempJavaCodeFragmentFiles().getTypeTempFiles(), path) + MethodsGenerator.getFromStringMethodClose());
            }
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while type def class file generation");
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.validateLineLength(file);
    }

    public static File generateUnionClassFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaAttributeInfo longAttr;
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        YangPluginConfig pluginConfig = javaFileInfo.getPluginConfig();
        String className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        TempJavaTypeFragmentFiles tempJavaTypeFragmentFiles = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles();
        boolean isIntConflict = false;
        boolean isLongConflict = false;
        JavaAttributeInfo intAttr = tempJavaTypeFragmentFiles.getIntAttribute();
        if (intAttr == null) {
            intAttr = tempJavaTypeFragmentFiles.getUIntAttribute();
        }
        if ((longAttr = tempJavaTypeFragmentFiles.getLongAttribute()) == null) {
            longAttr = tempJavaTypeFragmentFiles.getULongAttribute();
        }
        if (intAttr != null) {
            isIntConflict = intAttr.isIntConflict();
        }
        if (longAttr != null) {
            isLongConflict = longAttr.isLongConflict();
        }
        if (isLongConflict) {
            imports.add(tempJavaTypeFragmentFiles.getJavaImportData().getBigIntegerImport());
            Collections.sort(imports);
        }
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, className, 128, imports, path, pluginConfig);
        ArrayList<String> methods = new ArrayList<String>();
        try {
            if (isIntConflict) {
                YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addStaticAttributeIntRange("private", tempJavaTypeFragmentFiles.getIntIndex() < tempJavaTypeFragmentFiles.getUIntIndex()));
            }
            if (isLongConflict) {
                YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.addStaticAttributeLongRange("private", tempJavaTypeFragmentFiles.getLongIndex() < tempJavaTypeFragmentFiles.getULongIndex()));
            }
            YangIoUtils.insertDataIntoJavaFile(file, "\n    " + JavaFileGeneratorUtils.getDataFromTempFileHandle(1, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while union class file generation");
        }
        methods.add(((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().addDefaultConstructor("private", "", pluginConfig, curNode));
        try {
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(1024, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(512, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(4, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path));
            methods.add(MethodsGenerator.getHashCodeMethodClose(MethodsGenerator.getHashCodeMethodOpen() + JavaFileGeneratorUtils.getDataFromTempFileHandle(64, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path).replace("\n", "")));
            methods.add(MethodsGenerator.getEqualsMethodClose(MethodsGenerator.getEqualsMethodOpen(className + "") + JavaFileGeneratorUtils.getDataFromTempFileHandle(128, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path)));
            methods.add(MethodsGenerator.getToStringMethodOpen() + MethodsGenerator.getOmitNullValueString() + JavaFileGeneratorUtils.getDataFromTempFileHandle(256, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path) + MethodsGenerator.getToStringMethodClose());
            methods.add(MethodsGenerator.getFromStringMethodSignature(className, pluginConfig) + JavaFileGeneratorUtils.getDataFromTempFileHandle(2048, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getTypeTempFiles(), path) + MethodsGenerator.getFromStringMethodClose());
            if (isIntConflict) {
                methods.add(MethodsGenerator.getRangeValidatorMethodForUnion("int"));
            }
            if (isLongConflict) {
                methods.add(MethodsGenerator.getRangeValidatorMethodForUnion("BigInteger"));
            }
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while union class file generation");
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.validateLineLength(file);
    }

    public static File generateEnumClassFile(File file, YangNode curNode) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        YangPluginConfig pluginConfig = javaFileInfo.getPluginConfig();
        String className = javaFileInfo.getJavaName();
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, YangIoUtils.getCapitalCase(className), 32, null, path, pluginConfig);
        try {
            JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)curNode;
            YangIoUtils.insertDataIntoJavaFile(file, YangIoUtils.trimAtLast(YangIoUtils.trimAtLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(4096, javaGenInfo.getTempJavaCodeFragmentFiles().getEnumerationTempFiles(), path), ","), "\n") + ";" + "\n");
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + YangIoUtils.getCapitalCase(className) + " while enum class file generation");
        }
        YangIoUtils.insertDataIntoJavaFile(file, JavaCodeSnippetGen.getEnumsValueAttribute(YangIoUtils.getCapitalCase(className)));
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, className, false, pluginConfig, null) + MethodsGenerator.getEnumsConstructor(YangIoUtils.getCapitalCase(className)) + "\n");
        TempJavaEnumerationFragmentFiles enumFragFiles = ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getEnumerationTempFiles();
        YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getEnumsOfMethod(className, enumFragFiles.getJavaAttributeForEnum(pluginConfig), enumFragFiles.getEnumSetJavaMap(), enumFragFiles.getEnumStringList(), pluginConfig) + "\n");
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, className, false, pluginConfig, null) + MethodsGenerator.getGetter("int", className, 32) + "\n");
        try {
            YangIoUtils.insertDataIntoJavaFile(file, MethodsGenerator.getFromStringMethodSignature(YangIoUtils.getCapitalCase(className), pluginConfig) + JavaFileGeneratorUtils.getDataFromTempFileHandle(2048, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getEnumerationTempFiles(), path) + MethodsGenerator.getFromStringMethodClose());
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + YangIoUtils.getCapitalCase(className) + " while enum class file generation");
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.validateLineLength(file);
    }

    public static File generateServiceInterfaceFile(File file, YangNode curNode, List<String> imports) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        TempJavaServiceFragmentFiles tempJavaServiceFragmentFiles = ((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String className = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName()) + "Service";
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 16, imports, curNode, className);
        ArrayList<String> methods = new ArrayList<String>();
        JavaAttributeInfo rootAttribute = TempJavaFragmentFiles.getCurNodeAsAttributeInTarget(curNode, curNode, false, tempJavaServiceFragmentFiles);
        try {
            methods.add(MethodsGenerator.getGetterString(rootAttribute, 16, javaFileInfo.getPluginConfig()) + "\n");
            methods.add(MethodsGenerator.getSetterString(rootAttribute, className, 16, javaFileInfo.getPluginConfig()) + "\n");
            methods.add(MethodsGenerator.getAugmentsDataMethodForService(curNode) + "\n");
            if (((JavaCodeGeneratorInfo)curNode).getTempJavaCodeFragmentFiles().getServiceTempFiles() != null) {
                JavaCodeGeneratorInfo javaGenInfo = (JavaCodeGeneratorInfo)curNode;
                methods.add(JavaFileGeneratorUtils.getDataFromTempFileHandle(8192, javaGenInfo.getTempJavaCodeFragmentFiles().getServiceTempFiles(), path));
            }
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while rpc class file generation");
        }
        for (String method : methods) {
            YangIoUtils.insertDataIntoJavaFile(file, method);
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        return YangIoUtils.validateLineLength(file);
    }

    public static void generateEventFile(File file, YangNode curNode, List<String> imports) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName()) + "Event";
        TempJavaEventFragmentFiles tempFiles = ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getEventFragmentFiles();
        String path = ((JavaFileInfoContainer)curNode).getJavaFileInfo().getBaseCodeGenPath() + ((JavaFileInfoContainer)curNode).getJavaFileInfo().getPackageFilePath();
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 256, imports, curNode, className);
        try {
            YangIoUtils.insertDataIntoJavaFile(file, "\n" + JavaCodeSnippetGen.getEventEnumTypeStart() + YangIoUtils.trimAtLast(JavaFileGeneratorUtils.getDataFromTempFileHandle(32768, tempFiles, path), ",") + "    " + "}" + "\n");
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(65536, tempFiles, path));
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while event class file generation");
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.validateLineLength(file);
    }

    public static void generateEventListenerFile(File file, YangNode curNode, List<String> imports) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName()) + "EventListener";
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 512, imports, curNode, className);
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.validateLineLength(file);
    }

    public static void generateEventSubjectFile(File file, YangNode curNode) throws IOException {
        String className = YangIoUtils.getCapitalCase(((JavaFileInfoContainer)curNode).getJavaFileInfo().getJavaName()) + "EventSubject";
        JavaFileGeneratorUtils.initiateJavaFileGeneration(file, 1024, null, curNode, className);
        String path = ((JavaFileInfoContainer)curNode).getJavaFileInfo().getBaseCodeGenPath() + ((JavaFileInfoContainer)curNode).getJavaFileInfo().getPackageFilePath();
        TempJavaEventFragmentFiles tempFiles = ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getEventFragmentFiles();
        YangIoUtils.insertDataIntoJavaFile(file, "\n");
        try {
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(131072, tempFiles, path));
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(262144, tempFiles, path));
            YangIoUtils.insertDataIntoJavaFile(file, JavaFileGeneratorUtils.getDataFromTempFileHandle(524288, tempFiles, path));
        }
        catch (IOException e) {
            throw new IOException("No data found in temporary java code fragment files for " + className + " while event class file generation");
        }
        YangIoUtils.insertDataIntoJavaFile(file, "}\n");
        YangIoUtils.validateLineLength(file);
    }
}

