/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangNodeIdentifier;
import org.onosproject.yangutils.datamodel.YangSubModule;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaCodeGeneratorInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.JavaImportData;
import org.onosproject.yangutils.translator.tojava.JavaQualifiedTypeInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaBeanFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaEnumerationFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaEventFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaServiceFragmentFiles;
import org.onosproject.yangutils.translator.tojava.TempJavaTypeFragmentFiles;
import org.onosproject.yangutils.translator.tojava.YangJavaModelUtils;
import org.onosproject.yangutils.translator.tojava.utils.ClassDefinitionGenerator;
import org.onosproject.yangutils.utils.UtilConstants;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.CopyrightHeader;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaFileGeneratorUtils {
    private JavaFileGeneratorUtils() {
    }

    public static File getFileObject(String filePath, String fileName, String extension, JavaFileInfoTranslator handler) {
        return new File(handler.getBaseCodeGenPath() + filePath + UtilConstants.SLASH + fileName + extension);
    }

    static String getDataFromTempFileHandle(int generatedTempFiles, TempJavaFragmentFiles tempJavaFragmentFiles, String absolutePath) throws IOException {
        TempJavaTypeFragmentFiles typeFragmentFiles = null;
        if (tempJavaFragmentFiles instanceof TempJavaTypeFragmentFiles) {
            typeFragmentFiles = (TempJavaTypeFragmentFiles)tempJavaFragmentFiles;
        }
        TempJavaBeanFragmentFiles beanFragmentFiles = null;
        if (tempJavaFragmentFiles instanceof TempJavaBeanFragmentFiles) {
            beanFragmentFiles = (TempJavaBeanFragmentFiles)tempJavaFragmentFiles;
        }
        TempJavaServiceFragmentFiles serviceFragmentFiles = null;
        if (tempJavaFragmentFiles instanceof TempJavaServiceFragmentFiles) {
            serviceFragmentFiles = (TempJavaServiceFragmentFiles)tempJavaFragmentFiles;
        }
        TempJavaEventFragmentFiles eventFragmentFiles = null;
        if (tempJavaFragmentFiles instanceof TempJavaEventFragmentFiles) {
            eventFragmentFiles = (TempJavaEventFragmentFiles)tempJavaFragmentFiles;
        }
        if ((generatedTempFiles & 1) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getAttributesTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 2) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getGetterInterfaceTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 8) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getSetterInterfaceTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 4) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getGetterImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x10) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getSetterImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x100000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getAddToListInterfaceTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x200000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getAddToListImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x800000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getSubtreeFilteringForLeafTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x1000000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getGetSubtreeFilteringForListTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x2000000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getGetSubtreeFilteringForChildNodeTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x4000000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getEditContentTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x400000) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getLeafIdAttributeTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x20) != 0) {
            if (beanFragmentFiles == null) {
                throw new TranslatorException("Required constructor info is missing.");
            }
            return beanFragmentFiles.getTemporaryDataFromFileHandle(beanFragmentFiles.getConstructorImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x40) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getHashCodeImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x80) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getEqualsImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x100) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getToStringImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x200) != 0) {
            if (typeFragmentFiles == null) {
                throw new TranslatorException("Required of string implementation info is missing.");
            }
            return typeFragmentFiles.getTemporaryDataFromFileHandle(typeFragmentFiles.getOfStringImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x400) != 0) {
            if (typeFragmentFiles == null) {
                throw new TranslatorException("Required constructor implementation info is missing.");
            }
            return typeFragmentFiles.getTemporaryDataFromFileHandle(typeFragmentFiles.getConstructorForTypeTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x800) != 0) {
            return tempJavaFragmentFiles.getTemporaryDataFromFileHandle(tempJavaFragmentFiles.getFromStringImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x1000) != 0) {
            if (!(tempJavaFragmentFiles instanceof TempJavaEnumerationFragmentFiles)) {
                throw new TranslatorException("Required enum info is missing.");
            }
            TempJavaEnumerationFragmentFiles enumFragmentFiles = (TempJavaEnumerationFragmentFiles)tempJavaFragmentFiles;
            return enumFragmentFiles.getTemporaryDataFromFileHandle(enumFragmentFiles.getEnumClassTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x2000) != 0) {
            if (serviceFragmentFiles == null) {
                throw new TranslatorException("Required rpc interface info is missing.");
            }
            return serviceFragmentFiles.getTemporaryDataFromFileHandle(serviceFragmentFiles.getRpcInterfaceTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x4000) != 0) {
            if (serviceFragmentFiles == null) {
                throw new TranslatorException("Required rpc implementation info is missing.");
            }
            return serviceFragmentFiles.getTemporaryDataFromFileHandle(serviceFragmentFiles.getRpcImplTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x8000) != 0) {
            if (eventFragmentFiles == null) {
                throw new TranslatorException("Required event enum implementation info is missing.");
            }
            return eventFragmentFiles.getTemporaryDataFromFileHandle(eventFragmentFiles.getEventEnumTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x10000) != 0) {
            if (eventFragmentFiles == null) {
                throw new TranslatorException("Required event method implementation info is missing.");
            }
            return eventFragmentFiles.getTemporaryDataFromFileHandle(eventFragmentFiles.getEventMethodTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x40000) != 0) {
            if (eventFragmentFiles == null) {
                throw new TranslatorException("Required event subject getter implementation info is missing.");
            }
            return eventFragmentFiles.getTemporaryDataFromFileHandle(eventFragmentFiles.getEventSubjectGetterTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x80000) != 0) {
            if (eventFragmentFiles == null) {
                throw new TranslatorException("Required event subject setter implementation info is missing.");
            }
            return eventFragmentFiles.getTemporaryDataFromFileHandle(eventFragmentFiles.getEventSubjectSetterTempFileHandle(), absolutePath);
        }
        if ((generatedTempFiles & 0x20000) != 0) {
            if (eventFragmentFiles == null) {
                throw new TranslatorException("Required event subject attribute implementation info is missing.");
            }
            return eventFragmentFiles.getTemporaryDataFromFileHandle(eventFragmentFiles.getEventSubjectAttributeTempFileHandle(), absolutePath);
        }
        return null;
    }

    public static void initiateJavaFileGeneration(File file, String className, int genType, List<String> imports, String pkg, YangPluginConfig pluginConfig) throws IOException {
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new IOException("Failed to create " + file.getName() + " class file.");
            }
            JavaFileGeneratorUtils.appendContents(file, className, genType, imports, pkg, pluginConfig);
        }
        catch (IOException e) {
            throw new IOException("Failed to append contents in " + file.getName() + " class file.");
        }
    }

    public static void initiateJavaFileGeneration(File file, int genType, List<String> imports, YangNode curNode, String className) throws IOException {
        try {
            boolean isFileCreated = file.createNewFile();
            if (!isFileCreated) {
                throw new IOException("Failed to create " + file.getName() + " class file.");
            }
            JavaFileGeneratorUtils.appendContents(file, genType, imports, curNode, className);
        }
        catch (IOException e) {
            throw new IOException("Failed to append contents in " + file.getName() + " class file.");
        }
    }

    private static void appendContents(File file, int genType, List<String> importsList, YangNode curNode, String className) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String name = javaFileInfo.getJavaName();
        String path = javaFileInfo.getBaseCodeGenPath() + javaFileInfo.getPackageFilePath();
        String pkgString = genType == 256 || genType == 512 || genType == 1024 ? JavaFileGeneratorUtils.parsePackageString((path + "." + name).toLowerCase(), importsList) : JavaFileGeneratorUtils.parsePackageString(path, importsList);
        switch (genType) {
            case 1: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.INTERFACE, curNode, className);
                break;
            }
            case 8: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.IMPL_CLASS, curNode, className);
                break;
            }
            case 4: {
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.BUILDER_CLASS, curNode, className);
                break;
            }
            case 2: {
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.BUILDER_INTERFACE, curNode, className);
                break;
            }
            case 16: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.RPC_INTERFACE, curNode, className);
                break;
            }
            case 256: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT, curNode, className);
                break;
            }
            case 512: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_LISTENER, curNode, className);
                break;
            }
            case 1024: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_SUBJECT_CLASS, curNode, className);
                break;
            }
            case 2048: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, genType, JavaDocGen.JavaDocType.EVENT_SUBJECT_CLASS, curNode, className);
                YangIoUtils.insertDataIntoJavaFile(file, "}");
                break;
            }
        }
    }

    private static void appendContents(File file, String fileName, int genType, List<String> importsList, String pkg, YangPluginConfig pluginConfig) throws IOException {
        String pkgString = JavaFileGeneratorUtils.parsePackageString(pkg, importsList);
        switch (genType) {
            case 64: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.IMPL_CLASS, pluginConfig);
                break;
            }
            case 128: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.IMPL_CLASS, pluginConfig);
                break;
            }
            case 32: {
                JavaFileGeneratorUtils.appendHeaderContents(file, pkgString, importsList);
                JavaFileGeneratorUtils.write(file, fileName, genType, JavaDocGen.JavaDocType.ENUM_CLASS, pluginConfig);
                break;
            }
        }
    }

    private static String parsePackageString(String javaPkg, List<String> importsList) {
        javaPkg = YangIoUtils.parsePkg(YangIoUtils.getJavaPackageFromPackagePath(javaPkg));
        if (importsList != null) {
            if (!importsList.isEmpty()) {
                return "package " + javaPkg + ";" + "\n";
            }
            return "package " + javaPkg + ";";
        }
        return "package " + javaPkg + ";";
    }

    private static void appendHeaderContents(File file, String pkg, List<String> importsList) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, CopyrightHeader.getCopyrightHeader());
        YangIoUtils.insertDataIntoJavaFile(file, pkg);
        if (importsList != null) {
            YangIoUtils.insertDataIntoJavaFile(file, "\n");
            for (String imports : importsList) {
                YangIoUtils.insertDataIntoJavaFile(file, imports);
            }
        }
    }

    private static void write(File file, int genType, JavaDocGen.JavaDocType javaDocType, YangNode curNode, String fileName) throws IOException {
        YangPluginConfig pluginConfig = ((JavaFileInfoContainer)curNode).getJavaFileInfo().getPluginConfig();
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(javaDocType, fileName, false, pluginConfig, null));
        YangIoUtils.insertDataIntoJavaFile(file, ClassDefinitionGenerator.generateClassDefinition(genType, fileName, curNode));
    }

    private static void write(File file, String fileName, int genType, JavaDocGen.JavaDocType javaDocType, YangPluginConfig pluginConfig) throws IOException {
        YangIoUtils.insertDataIntoJavaFile(file, JavaDocGen.getJavaDoc(javaDocType, fileName, false, pluginConfig, null));
        YangIoUtils.insertDataIntoJavaFile(file, ClassDefinitionGenerator.generateClassDefinition(genType, fileName));
    }

    static List<YangAtomicPath> getSetOfNodeIdentifiers(YangNode parent) {
        ArrayList<YangAtomicPath> targets = new ArrayList<YangAtomicPath>();
        List<YangAugment> augments = JavaFileGeneratorUtils.getListOfAugments(parent);
        for (YangAugment augment : augments) {
            YangNodeIdentifier nodeId = ((YangAtomicPath)augment.getTargetNode().get(0)).getNodeIdentifier();
            if (!JavaFileGeneratorUtils.validateNodeIdentifierInSet(nodeId, targets)) continue;
            targets.add((YangAtomicPath)augment.getTargetNode().get(0));
        }
        return targets;
    }

    private static List<YangAugment> getListOfAugments(YangNode parent) {
        ArrayList<YangAugment> augments = new ArrayList<YangAugment>();
        for (YangNode child = parent.getChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof YangAugment)) continue;
            augments.add((YangAugment)child);
        }
        return augments;
    }

    private static boolean validateNodeIdentifierInSet(YangNodeIdentifier nodeId, List<YangAtomicPath> targets) {
        boolean isPresent = true;
        for (YangAtomicPath target : targets) {
            if (!target.getNodeIdentifier().getName().equals(nodeId.getName())) continue;
            if (target.getNodeIdentifier().getPrefix() != null) {
                isPresent = !target.getNodeIdentifier().getPrefix().equals(nodeId.getPrefix());
                continue;
            }
            isPresent = nodeId.getPrefix() != null;
        }
        return isPresent;
    }

    public static void addResolvedAugmentedDataNodeImports(YangNode parent) {
        List<YangAtomicPath> targets = JavaFileGeneratorUtils.getSetOfNodeIdentifiers(parent);
        TempJavaCodeFragmentFiles tempJavaCodeFragmentFiles = ((JavaCodeGeneratorInfo)parent).getTempJavaCodeFragmentFiles();
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        for (YangAtomicPath nodeId : targets) {
            YangNode augmentedNode = nodeId.getResolvedNode().getParent();
            String curNodeName = ((JavaFileInfoContainer)augmentedNode).getJavaFileInfo().getJavaName() != null ? ((JavaFileInfoContainer)augmentedNode).getJavaFileInfo().getJavaName() : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(augmentedNode.getName(), parentInfo.getPluginConfig().getConflictResolver()));
            JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo = JavaFileGeneratorUtils.getQualifiedTypeInfoOfAugmentedNode(augmentedNode, YangIoUtils.getCapitalCase(curNodeName), parentInfo.getPluginConfig());
            tempJavaCodeFragmentFiles.getServiceTempFiles().getJavaImportData().addImportInfo(javaQualifiedTypeInfo, parentInfo.getJavaName(), parentInfo.getPackage());
            if (!(augmentedNode instanceof YangModule) && !(augmentedNode instanceof YangSubModule)) continue;
            javaQualifiedTypeInfo = JavaFileGeneratorUtils.getQualifiedTypeInfoOfAugmentedNode(augmentedNode, YangIoUtils.getCapitalCase(curNodeName) + "OpParam", parentInfo.getPluginConfig());
            tempJavaCodeFragmentFiles.getServiceTempFiles().getJavaImportData().addImportInfo(javaQualifiedTypeInfo, parentInfo.getJavaName(), parentInfo.getPackage());
        }
    }

    private static JavaQualifiedTypeInfoTranslator getQualifiedTypeInfoOfAugmentedNode(YangNode augmentedNode, String curNodeName, YangPluginConfig pluginConfig) {
        JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo = JavaQualifiedTypeInfoTranslator.getQualifiedTypeInfoOfCurNode(augmentedNode, YangIoUtils.getCapitalCase(curNodeName));
        if (javaQualifiedTypeInfo.getPkgInfo() == null) {
            javaQualifiedTypeInfo.setPkgInfo(YangJavaModelUtils.getNodesPackage(augmentedNode, pluginConfig));
        }
        return javaQualifiedTypeInfo;
    }

    private static boolean validateQualifiedInfoOfAugmentedNode(JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo, JavaImportData importData) {
        for (JavaQualifiedTypeInfoTranslator curImportInfo : importData.getImportSet()) {
            if (!curImportInfo.getClassInfo().contentEquals(javaQualifiedTypeInfo.getClassInfo())) continue;
            return curImportInfo.getPkgInfo().contentEquals(javaQualifiedTypeInfo.getPkgInfo());
        }
        return true;
    }

    static String getAugmentedClassNameForDataMethods(YangNode augmentedNode, YangNode parent) {
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        YangPluginConfig pluginConfig = parentInfo.getPluginConfig();
        TempJavaServiceFragmentFiles tempJavaServiceFragmentFiles = ((JavaCodeGeneratorInfo)parent).getTempJavaCodeFragmentFiles().getServiceTempFiles();
        String curNodeName = ((JavaFileInfoContainer)augmentedNode).getJavaFileInfo().getJavaName() != null ? ((JavaFileInfoContainer)augmentedNode).getJavaFileInfo().getJavaName() : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(augmentedNode.getName(), pluginConfig.getConflictResolver()));
        JavaQualifiedTypeInfoTranslator javaQualifiedTypeInfo = JavaFileGeneratorUtils.getQualifiedTypeInfoOfAugmentedNode(augmentedNode, YangIoUtils.getCapitalCase(curNodeName), parentInfo.getPluginConfig());
        if (JavaFileGeneratorUtils.validateQualifiedInfoOfAugmentedNode(javaQualifiedTypeInfo, tempJavaServiceFragmentFiles.getJavaImportData())) {
            return javaQualifiedTypeInfo.getClassInfo();
        }
        return javaQualifiedTypeInfo.getPkgInfo() + "." + javaQualifiedTypeInfo.getClassInfo();
    }

    static String getParentNodeNameForDataMethods(YangNode parent, YangPluginConfig pluginConfig) {
        JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
        if (parentInfo.getJavaName() != null) {
            return YangIoUtils.getCapitalCase(parentInfo.getJavaName());
        }
        return YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(parent.getName(), pluginConfig.getConflictResolver()));
    }

    public static String isTypeNameLeafref(String attributeName, YangType<?> attributeType) {
        if (attributeName.equalsIgnoreCase("leafref")) {
            return attributeType.getDataTypeName();
        }
        return attributeName;
    }

    public static YangType isTypeLeafref(YangType<?> attributeType) {
        if (attributeType.getDataType() == YangDataTypes.LEAFREF) {
            YangLeafRef leafRef = (YangLeafRef)attributeType.getDataTypeExtendedInfo();
            return leafRef.getEffectiveDataType();
        }
        return attributeType;
    }
}

