/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.util.List;
import java.util.Map;
import org.onosproject.yangutils.datamodel.YangAtomicPath;
import org.onosproject.yangutils.datamodel.YangCompilerAnnotation;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.exception.TranslatorException;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.ValidatorTypeForUnionTypes;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.JavaDocGen;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class MethodsGenerator {
    private static final String BITS_STRING_ARRAY_VAR = "bitsTemp";
    private static final String BIT_TEMP_VAR = "bitTemp";

    private MethodsGenerator() {
    }

    public static String parseBuilderInterfaceBuildMethodString(String name, YangPluginConfig pluginConfig) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.BUILD_METHOD, name, false, pluginConfig, null) + MethodsGenerator.getBuildForInterface(name);
    }

    public static String getGetterString(JavaAttributeInfo attr, int generatedJavaFiles, YangPluginConfig pluginConfig) {
        String returnType = MethodsGenerator.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        if (generatedJavaFiles == 16) {
            return JavaDocGen.generateForGetMethodWithAttribute(returnType) + MethodsGenerator.getGetterForInterface(attributeName, returnType, attr.isListAttr(), generatedJavaFiles, attr.getCompilerAnnotation());
        }
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, attributeName, attr.isListAttr(), pluginConfig, appDataStructure) + MethodsGenerator.getGetterForInterface(attributeName, returnType, attr.isListAttr(), generatedJavaFiles, attr.getCompilerAnnotation());
    }

    public static String getSetterString(JavaAttributeInfo attr, String className, int generatedJavaFiles, YangPluginConfig pluginConfig) {
        String attrType = MethodsGenerator.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        JavaDocGen.JavaDocType type = generatedJavaFiles == 16 ? JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD : JavaDocGen.JavaDocType.SETTER_METHOD;
        String appDataStructure = null;
        if (attr.getCompilerAnnotation() != null) {
            appDataStructure = attr.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        return JavaDocGen.getJavaDoc(type, attributeName, attr.isListAttr(), pluginConfig, appDataStructure) + MethodsGenerator.getSetterForInterface(attributeName, attrType, className, attr.isListAttr(), generatedJavaFiles, attr.getCompilerAnnotation());
    }

    private static String getConstructorString(String name, YangPluginConfig pluginConfig) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.CONSTRUCTOR, name, false, pluginConfig, null);
    }

    public static String getDefaultConstructorString(String name, String modifierType, YangPluginConfig pluginConfig) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.DEFAULT_CONSTRUCTOR, name, false, pluginConfig, null) + MethodsGenerator.getDefaultConstructor(name, modifierType) + "\n";
    }

    static String getCheckNotNull(String name) {
        return "        checkNotNull(" + name + "," + " " + name + ")" + ";" + "\n";
    }

    public static String getBuildString(String name, boolean isRootNode) {
        if (isRootNode) {
            return "\n" + MethodsGenerator.getBuild(name, true);
        }
        return "    @Override\n" + MethodsGenerator.getBuild(name, false);
    }

    public static String getGetterForClass(JavaAttributeInfo attr, int generatedJavaFiles) {
        String attrQualifiedType = MethodsGenerator.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        if (!attr.isListAttr()) {
            return MethodsGenerator.getGetter(attrQualifiedType, attributeName, generatedJavaFiles);
        }
        String attrParam = MethodsGenerator.getListAttribute(attrQualifiedType, attr.getCompilerAnnotation());
        return MethodsGenerator.getGetter(attrParam, attributeName, generatedJavaFiles);
    }

    static String getGetter(String type, String name, int generatedJavaFiles) {
        String ret = MethodsGenerator.parseTypeForReturnValue(type);
        if (generatedJavaFiles == 16) {
            return "    public " + type + " " + "get" + YangIoUtils.getCapitalCase(name) + "(" + ")" + " " + "{" + "\n" + "        " + "//TODO: YANG utils generated code" + "\n" + "        " + "return" + " " + ret + ";" + "\n" + "    " + "}";
        }
        return "    public " + type + " " + name + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + name + ";" + "\n" + "    " + "}";
    }

    private static String parseTypeForReturnValue(String type) {
        switch (type) {
            case "byte": 
            case "int": 
            case "short": 
            case "long": 
            case "double": {
                return "0";
            }
            case "boolean": {
                return "false";
            }
        }
        return null;
    }

    public static String getSetterForClass(JavaAttributeInfo attr, String className, int generatedJavaFiles) {
        String attrQualifiedType = MethodsGenerator.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        boolean isTypeNull = false;
        if (attr.getAttributeType() == null) {
            isTypeNull = true;
        }
        if (!attr.isListAttr()) {
            return MethodsGenerator.getSetter(className, attributeName, attrQualifiedType, generatedJavaFiles, isTypeNull, false);
        }
        String attrParam = MethodsGenerator.getListAttribute(attrQualifiedType, attr.getCompilerAnnotation());
        return MethodsGenerator.getSetter(className, attributeName, attrParam, generatedJavaFiles, isTypeNull, true);
    }

    private static String getSetter(String className, String name, String type, int generatedJavaFiles, boolean isTypeNull, boolean isList) {
        if (generatedJavaFiles == 16) {
            return "    public void set" + YangIoUtils.getCapitalCase(name) + "(" + type + " " + name + ")" + " " + "{" + "\n" + "        " + "//TODO: YANG utils generated code" + "\n" + "    " + "}";
        }
        if (generatedJavaFiles == 1024) {
            return "    public void " + name + "(" + type + " " + name + ")" + " " + "{" + "\n" + "        " + "this" + "." + name + " " + "=" + " " + name + ";" + "\n" + "    " + "}";
        }
        String method = "    public " + className + "Builder" + " " + name + "(" + type + " " + name + ")" + " " + "{";
        method = !isTypeNull && !isList ? method + MethodsGenerator.getValueLeafSetString(name) : method + "";
        return method + "\n" + "        " + "this" + "." + name + " " + "=" + " " + name + ";" + "\n" + "        " + "return" + " " + "this" + ";" + "\n" + "    " + "}";
    }

    private static String getValueLeafSetString(String name) {
        return "\n        getValueLeafFlags().set(LeafIdentifier." + name.toUpperCase() + ".getLeafIndex());";
    }

    static String getSetterForTypeDefClass(JavaAttributeInfo attr) {
        String attrQualifiedType = MethodsGenerator.getReturnType(attr);
        String attributeName = attr.getAttributeName();
        return MethodsGenerator.getTypeDefSetter(attrQualifiedType, attributeName);
    }

    private static String getTypeDefSetter(String type, String name) {
        return "    public void set" + YangIoUtils.getCapitalCase(name) + "(" + type + " " + "value" + ")" + " " + "{" + "\n" + "        " + "this" + "." + name + " " + "=" + " " + "value" + ";" + "\n" + "    " + "}";
    }

    public static String getOverRideString() {
        return "\n    @Override\n";
    }

    static String getGetterForInterface(String yangName, String returnType, boolean isList, int generatedJavaFiles, YangCompilerAnnotation compilerAnnotation) {
        if (!isList) {
            return MethodsGenerator.getGetterInterfaceString(returnType, yangName, generatedJavaFiles);
        }
        String listAttr = MethodsGenerator.getListAttribute(returnType, compilerAnnotation);
        return MethodsGenerator.getGetterInterfaceString(listAttr, yangName, generatedJavaFiles);
    }

    private static String getGetterInterfaceString(String returnType, String yangName, int generatedJavaFiles) {
        if (generatedJavaFiles == 16) {
            return MethodsGenerator.getGetMethodWithArgument(returnType, yangName);
        }
        return "    " + returnType + " " + yangName + "(" + ")" + ";";
    }

    static String getSetterForInterface(String attrName, String attrType, String className, boolean isList, int generatedJavaFiles, YangCompilerAnnotation compilerAnnotation) {
        if (!isList) {
            return MethodsGenerator.getSetterInterfaceString(className, attrName, attrType, generatedJavaFiles);
        }
        String listAttr = MethodsGenerator.getListAttribute(attrType, compilerAnnotation);
        return MethodsGenerator.getSetterInterfaceString(className, attrName, listAttr, generatedJavaFiles);
    }

    private static String getSetterInterfaceString(String className, String attrName, String attrType, int generatedJavaFiles) {
        if (generatedJavaFiles == 16) {
            return "    void set" + YangIoUtils.getCapitalCase(attrName) + "(" + attrType + " " + attrName + ")" + ";";
        }
        return "    " + className + "Builder" + " " + attrName + "(" + attrType + " " + attrName + ")" + ";";
    }

    private static String getListString() {
        return "List<";
    }

    private static String getReturnType(JavaAttributeInfo attr) {
        String returnType = "";
        if (attr.isQualifiedName() && attr.getImportInfo().getPkgInfo() != null) {
            returnType = attr.getImportInfo().getPkgInfo() + ".";
        }
        returnType = returnType + attr.getImportInfo().getClassInfo();
        return returnType;
    }

    static String getBuildForInterface(String yangName) {
        return "    " + yangName + " " + "build" + "(" + ")" + ";" + "\n";
    }

    static String getConstructorStart(String yangName, YangPluginConfig pluginConfig, boolean isRootNode) {
        String javadoc = MethodsGenerator.getConstructorString(yangName, pluginConfig);
        String returnType = YangIoUtils.getCapitalCase("default") + yangName;
        if (isRootNode) {
            returnType = yangName + "OpParam";
        }
        String constructor = "    protected " + returnType + "(" + yangName + "Builder" + " " + "Builder".toLowerCase() + "Object" + ")" + " " + "{" + "\n";
        return javadoc + constructor;
    }

    public static String getConstructor(JavaAttributeInfo attr, int generatedJavaFiles, YangPluginConfig pluginConfig) {
        String attributeName = attr.getAttributeName();
        String constructor = generatedJavaFiles == 16 ? "        this." + YangIoUtils.getCamelCase(attributeName, pluginConfig.getConflictResolver()) + " " + "=" + " " + "Builder".toLowerCase() + "Object" + "." + "get" + YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(attributeName, pluginConfig.getConflictResolver())) + "(" + ")" + ";" + "\n" : "        this." + YangIoUtils.getCamelCase(attributeName, pluginConfig.getConflictResolver()) + " " + "=" + " " + "Builder".toLowerCase() + "Object" + "." + YangIoUtils.getCamelCase(attributeName, pluginConfig.getConflictResolver()) + "(" + ")" + ";" + "\n";
        return constructor;
    }

    public static String getRpcServiceMethod(String rpcName, String inputName, String outputName, YangPluginConfig pluginConfig) {
        rpcName = YangIoUtils.getCamelCase(rpcName, pluginConfig.getConflictResolver());
        if (!inputName.equals("")) {
            inputName = inputName + " " + "inputVar";
        }
        return "    " + outputName + " " + rpcName + "(" + inputName + ")" + ";";
    }

    public static String getRpcManagerMethod(String rpcName, String inputName, String outputName, YangPluginConfig pluginConfig) {
        rpcName = YangIoUtils.getCamelCase(rpcName, pluginConfig.getConflictResolver());
        if (!inputName.equals("")) {
            inputName = inputName + " " + "inputVar";
        }
        String method = MethodsGenerator.getOverRideString() + "    " + "public" + " " + outputName + " " + rpcName + "(" + inputName + ")" + " " + "{" + "\n" + "        " + "//TODO: YANG utils generated code" + "\n";
        if (!outputName.contentEquals("void")) {
            method = method + "        return " + MethodsGenerator.parseTypeForReturnValue(outputName) + ";" + "\n";
        }
        method = method + "    }";
        return method;
    }

    static String getBuild(String yangName, boolean isRootNode) {
        String type = YangIoUtils.getCapitalCase("default") + yangName;
        if (isRootNode) {
            type = yangName + "OpParam";
        }
        return "    public " + yangName + " " + "build" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "new" + " " + type + "(" + "this" + ")" + ";" + "\n" + "    " + "}";
    }

    private static String getDefaultConstructor(String name, String modifierType) {
        return "    " + modifierType + " " + name + "(" + ")" + " " + "{" + "\n" + "    " + "}";
    }

    static String getToStringMethodOpen() {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "String" + " " + "to" + "String" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " MoreObjects.toStringHelper(getClass())" + "\n";
    }

    static boolean isPrimitiveDataType(YangDataTypes dataType) {
        return dataType == YangDataTypes.INT8 || dataType == YangDataTypes.INT16 || dataType == YangDataTypes.INT32 || dataType == YangDataTypes.INT64 || dataType == YangDataTypes.UINT8 || dataType == YangDataTypes.UINT16 || dataType == YangDataTypes.UINT32 || dataType == YangDataTypes.UINT64 || dataType == YangDataTypes.DECIMAL64 || dataType == YangDataTypes.BOOLEAN || dataType == YangDataTypes.EMPTY;
    }

    static String getIfConditionBegin(String indentation, String condition) {
        return indentation + "if" + " " + "(" + condition + ")" + " " + "{" + "\n";
    }

    static String getElseIfConditionBegin(String indentation, String condition) {
        return indentation + "}" + " " + "else" + " " + MethodsGenerator.getIfConditionBegin("", condition);
    }

    static String getBlockEnd(String indentation) {
        return indentation + "}" + "\n";
    }

    static String getCollectionIteratorForLoopBegin(String indentation, String loopVar, String collection) {
        return indentation + "for" + " " + "(" + loopVar + " " + ":" + " " + collection + ")" + " " + "{" + "\n";
    }

    static String getOmitNullValueString() {
        return "            .omitNullValues()\n";
    }

    static String getToStringMethodClose() {
        return "            .toString();\n    }\n";
    }

    public static String getToStringMethod(JavaAttributeInfo attr) {
        String attributeName = attr.getAttributeName();
        return "            .add(\"" + attributeName + "\"" + "," + " " + attributeName + ")";
    }

    static String getFromStringMethodSignature(String className, YangPluginConfig pluginConfig) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.FROM_METHOD, className, false, pluginConfig, null) + "    " + "public" + " " + "static" + " " + className + " " + "fromString" + "(" + "String" + " " + "valInString" + ")" + " " + "{" + "\n";
    }

    static String getFromStringMethodClose() {
        return "        return null;\n    }\n";
    }

    public static String getFromStringMethod(JavaAttributeInfo attr, JavaAttributeInfo fromStringAttributeInfo) {
        return "        " + MethodsGenerator.getTrySubString() + "\n" + "            " + MethodsGenerator.getParsedSubString(attr, fromStringAttributeInfo) + "\n" + "            " + MethodsGenerator.getReturnOfSubString() + "\n" + "        " + MethodsGenerator.getCatchSubString() + "\n" + "        " + "}";
    }

    private static String getTrySubString() {
        return "try {";
    }

    private static String getReturnOfSubString() {
        return "return of(tmpVal);";
    }

    private static String getCatchSubString() {
        return "} catch (Exception e) {";
    }

    private static String getParsedSubString(JavaAttributeInfo attr, JavaAttributeInfo fromStringAttributeInfo) {
        String targetDataType = MethodsGenerator.getReturnType(attr);
        if (fromStringAttributeInfo.getAttributeType().getDataType() == YangDataTypes.BITS) {
            String lines = targetDataType + " " + "tmpVal" + " " + "=" + " " + "new" + " " + targetDataType + "(" + ")" + ";" + "\n";
            lines = lines + "            valInString = valInString.replace('{', ' ');\n";
            lines = lines + "            valInString = valInString.replace('}', ' ');\n";
            lines = lines + "            valInString = valInString.trim();\n";
            lines = lines + "            String[] bitsTemp = valInString.split(\",\", 0);\n";
            lines = lines + "            for (String bitTemp : bitsTemp) {\n";
            lines = lines + "                bitTemp = bitTemp.trim();\n";
            lines = lines + "                tmpVal.set(Integer.parseInt(bitTemp));\n";
            lines = lines + "            }";
            return lines;
        }
        if (attr.getAttributeType().getDataType() == YangDataTypes.BINARY) {
            return targetDataType + " " + "tmpVal" + " " + "=" + " " + "Base64" + "." + "getDecoder" + "(" + ")" + "." + "decode" + "(" + "valInString" + ")" + ";";
        }
        String parseFromStringMethod = MethodsGenerator.getParseFromStringMethod(targetDataType, fromStringAttributeInfo.getAttributeType());
        return targetDataType + " " + "tmpVal" + " " + "=" + " " + parseFromStringMethod + "(" + "valInString" + ")" + ";";
    }

    static String getHashCodeMethodOpen() {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "int" + " " + "hashCode" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "Object" + "s" + "." + "hash" + "(";
    }

    static String getHashCodeMethodClose(String hashcodeString) {
        hashcodeString = YangIoUtils.trimAtLast(hashcodeString, ",");
        hashcodeString = YangIoUtils.trimAtLast(hashcodeString, " ");
        return hashcodeString + ")" + ";" + "\n" + "    " + "}" + "\n";
    }

    public static String getHashCodeMethod(JavaAttributeInfo attr) {
        return attr.getAttributeName() + "," + " ";
    }

    static String getEqualsMethodOpen(String className) {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "boolean" + " " + "equals" + "(" + "Object" + " " + "obj" + ")" + " " + "{" + "\n" + MethodsGenerator.getEqualsMethodsCommonIfCondition() + MethodsGenerator.getEqualsMethodsSpecificIfCondition(className);
    }

    private static String getEqualsMethodsCommonIfCondition() {
        return "        if (this == obj) {\n            return true;\n        }\n";
    }

    private static String getEqualsMethodsSpecificIfCondition(String className) {
        return "        if (obj instanceof " + className + ")" + " " + "{" + "\n" + "            " + className + " " + "other" + " " + "=" + " " + "(" + className + ")" + " " + "obj" + ";" + "\n" + "            " + "return" + "\n";
    }

    static String getEqualsMethodClose(String equalMethodString) {
        equalMethodString = YangIoUtils.trimAtLast(equalMethodString, "&");
        equalMethodString = YangIoUtils.trimAtLast(equalMethodString, "&");
        equalMethodString = YangIoUtils.trimAtLast(equalMethodString, " ");
        equalMethodString = YangIoUtils.trimAtLast(equalMethodString, "\n") + ";" + "\n";
        return equalMethodString + "        " + "}" + "\n" + "        " + "return" + " " + "false" + ";" + "\n" + "    " + "}" + "\n";
    }

    public static String getEqualsMethod(JavaAttributeInfo attr) {
        String attributeName = attr.getAttributeName();
        return "                 Objects.equals(" + attributeName + "," + " " + "other" + "." + attributeName + ")" + " " + "&" + "&";
    }

    static String getOfMethod(String name, JavaAttributeInfo attr) {
        String attrQualifiedType = MethodsGenerator.getReturnType(attr);
        return "    public static " + name + " " + "of" + "(" + attrQualifiedType + " " + "value" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "new" + " " + name + "(" + "value" + ")" + ";" + "\n" + "    " + "}" + "\n";
    }

    public static String getOfMethodStringAndJavaDoc(JavaAttributeInfo attr, String generatedJavaClassName, YangPluginConfig pluginConfig) {
        String attrType = MethodsGenerator.getReturnType(attr);
        String attrName = attr.getAttributeName();
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.OF_METHOD, generatedJavaClassName + " for type " + attrName, false, pluginConfig, null) + MethodsGenerator.getOfMethodString(attrType, generatedJavaClassName);
    }

    private static String getOfMethodString(String type, String className) {
        return "    public static " + className + " " + "of" + "(" + type + " " + "value" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "new" + " " + className + "(" + "value" + ")" + ";" + "\n" + "    " + "}";
    }

    public static String getTypeConstructorStringAndJavaDoc(JavaAttributeInfo attr, String generatedJavaClassName, YangPluginConfig pluginConfig) {
        String attrType = MethodsGenerator.getReturnType(attr);
        String attrName = attr.getAttributeName();
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, generatedJavaClassName + " for type " + attrName, false, pluginConfig, null) + MethodsGenerator.getTypeConstructorString(attrType, attrName, generatedJavaClassName);
    }

    public static String getTypeConstructorStringAndJavaDoc(JavaAttributeInfo attr1, JavaAttributeInfo attr2, String generatedJavaClassName, YangPluginConfig pluginConfig, ValidatorTypeForUnionTypes type, boolean addFirst) {
        String attrType = MethodsGenerator.getReturnType(attr1);
        String attrName1 = "";
        String attrName2 = "";
        if (attr1 != null) {
            attrName1 = attr1.getAttributeName();
        }
        if (attr2 != null) {
            attrName2 = attr2.getAttributeName();
        }
        String appDataStructure = null;
        if (attr1.getCompilerAnnotation() != null) {
            appDataStructure = attr1.getCompilerAnnotation().getYangAppDataStructure().getDataStructure().name();
        }
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.TYPE_CONSTRUCTOR, generatedJavaClassName + " for type " + attrName1, false, pluginConfig, appDataStructure) + MethodsGenerator.getTypeConstructorString(attrType, attrName1, attrName2, generatedJavaClassName, type, addFirst);
    }

    private static String getTypeConstructorString(String type, String name, String className) {
        return "    public " + className + "(" + type + " " + "value" + ")" + " " + "{" + "\n" + "        " + "this" + "." + name + " " + "=" + " " + "value" + ";" + "\n" + "    " + "}";
    }

    private static String getTypeConstructorString(String type, String attr1, String attr2, String className, ValidatorTypeForUnionTypes validatorType, boolean addInt) {
        String name2;
        String name1;
        String constructor = "    public " + className + "(" + type + " " + "value" + ")" + " " + "{" + "\n";
        if (addInt) {
            name1 = attr1;
            name2 = attr2;
        } else {
            name1 = attr2;
            name2 = attr1;
        }
        constructor = constructor + MethodsGenerator.ifConditionForIntInTypeDefConstructor(validatorType, addInt) + "            " + "this" + "." + name1 + " " + "=" + " " + "value" + ";" + "\n" + "        " + "}" + " " + "else" + " " + "{" + "\n" + "            " + "this" + "." + name2 + " " + "=" + " " + "value" + ";" + "\n" + "        " + "}" + "\n" + "    " + "}";
        return constructor;
    }

    static String getAddAugmentInfoMethodInterface() {
        return JavaDocGen.generateForAddAugmentation() + "    " + "void" + " " + "add" + "YangAugmentedInfo" + "(" + "Object" + " " + "value" + "," + " " + "Class" + " " + "class" + "Object" + ")" + ";" + "\n";
    }

    static String getAddAugmentInfoMethodImpl() {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "void" + " " + "add" + "YangAugmentedInfo" + "(" + "Object" + " " + "value" + "," + " " + "Class" + " " + "class" + "Object" + ")" + " " + "{" + "\n" + "        " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "." + "put" + "(" + "class" + "Object" + "," + " " + "value" + ")" + ";" + "\n" + "    " + "}" + "\n";
    }

    static String getYangAugmentInfoInterface() {
        return JavaDocGen.generateForGetAugmentation() + "    " + "Object" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "(" + "Class" + " " + "class" + "Object" + ")" + ";" + "\n";
    }

    static String getYangAugmentInfoImpl() {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "Object" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "(" + "Class" + " " + "class" + "Object" + ")" + " " + "{" + "\n" + "        " + "return" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "." + "get" + "(" + "class" + "Object" + ")" + ";" + "\n" + "    " + "}" + "\n";
    }

    static String getYangAugmentInfoMapInterface(YangPluginConfig pluginConfig) {
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.GETTER_METHOD, YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map", false, pluginConfig, null) + "    " + "Map" + "<" + "Class" + "<" + "?" + ">" + "," + " " + "Object" + ">" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "(" + ")" + ";" + "\n";
    }

    static String getYangAugmentInfoMapImpl() {
        return MethodsGenerator.getOverRideString() + "    " + "public" + " " + "Map" + "<" + "Class" + "<" + "?" + ">" + "," + " " + "Object" + ">" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + ";" + "\n" + "    " + "}" + "\n";
    }

    static String getEnumsConstructor(String className) {
        return "    " + className + "(" + "int" + " " + "value" + ")" + " " + "{" + "\n" + "        " + YangIoUtils.getSmallCase(className) + " " + "=" + " " + "value" + ";" + "\n" + "    " + "}";
    }

    static String getEnumsOfMethod(String className, JavaAttributeInfo attr, Map<String, Integer> enumMap, List<String> enumList, YangPluginConfig pluginConfig) {
        String attrType = MethodsGenerator.getReturnType(attr);
        String attrName = attr.getAttributeName();
        String method = "    public static " + YangIoUtils.getCapitalCase(className) + " " + "of" + "(" + attrType + " " + "value" + ")" + " " + "{" + "\n" + "        " + "switch" + " " + "(" + "value" + ")" + " " + "{" + "\n";
        for (String str : enumList) {
            int value = enumMap.get(str);
            method = method + "            " + "case" + " " + value + ":" + "\n" + "                " + "return" + " " + YangIoUtils.getCapitalCase(className) + "." + str + ";" + "\n";
        }
        method = method + "            " + "default" + " " + ":" + "\n" + "                " + "return" + " " + "null" + ";" + "\n" + "        " + "}" + "\n" + "    " + "}";
        return JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.OF_METHOD, YangIoUtils.getCapitalCase(className) + " for type " + attrName, false, pluginConfig, null) + method;
    }

    private static String getParseFromStringMethod(String targetDataType, YangType<?> yangType) {
        YangDataTypes type = yangType.getDataType();
        switch (type) {
            case INT8: {
                return "Byte.parseByte";
            }
            case INT16: {
                return "Short.parseShort";
            }
            case INT32: {
                return "Integer.parseInt";
            }
            case INT64: {
                return "Long.parseLong";
            }
            case UINT8: {
                return "Short.parseShort";
            }
            case UINT16: {
                return "Integer.parseInt";
            }
            case UINT32: {
                return "Long.parseLong";
            }
            case UINT64: {
                return "new BigInteger";
            }
            case DECIMAL64: {
                return "new BigDecimal";
            }
            case STRING: 
            case IDENTITYREF: {
                return "";
            }
            case EMPTY: 
            case BOOLEAN: {
                return "Boolean.parseBoolean";
            }
            case BITS: 
            case UNION: 
            case ENUMERATION: 
            case DERIVED: {
                return targetDataType + "." + "fromString";
            }
        }
        throw new TranslatorException("given data type is not supported.");
    }

    static String getAugmentsDataMethodForService(YangNode parent) {
        List<YangAtomicPath> targets = JavaFileGeneratorUtils.getSetOfNodeIdentifiers(parent);
        StringBuilder methods = new StringBuilder();
        YangPluginConfig pluginConfig = ((JavaFileInfoContainer)parent).getJavaFileInfo().getPluginConfig();
        for (YangAtomicPath nodeId : targets) {
            YangNode augmentedNode = nodeId.getResolvedNode().getParent();
            YangNode methodNode = nodeId.getResolvedNode();
            String curNodeName = ((JavaFileInfoContainer)methodNode).getJavaFileInfo().getJavaName() != null ? ((JavaFileInfoContainer)methodNode).getJavaFileInfo().getJavaName() : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(methodNode.getName(), pluginConfig.getConflictResolver()));
            String returnType = JavaFileGeneratorUtils.getAugmentedClassNameForDataMethods(augmentedNode, parent);
            String parentName = JavaFileGeneratorUtils.getParentNodeNameForDataMethods(augmentedNode, pluginConfig);
            String method = JavaDocGen.generateForGetMethodWithAttribute(returnType) + MethodsGenerator.getGetMethodWithArgument(returnType, "Augmented" + parentName + YangIoUtils.getCapitalCase(curNodeName)) + "\n";
            methods.append(method);
            method = JavaDocGen.getJavaDoc(JavaDocGen.JavaDocType.MANAGER_SETTER_METHOD, "Augmented" + YangIoUtils.getCapitalCase(parentName) + YangIoUtils.getCapitalCase(curNodeName), false, pluginConfig, null) + MethodsGenerator.getSetterForInterface(YangIoUtils.getSmallCase("Augmented") + parentName + YangIoUtils.getCapitalCase(curNodeName), returnType, parentName, false, 16, null) + "\n";
            methods.append(method);
        }
        return methods.toString();
    }

    static String getRangeValidatorMethodForUnion(String type) {
        String newType = type.contentEquals("BigInteger") ? "long" : "int";
        String method = JavaDocGen.generateForValidatorMethod() + "    " + "private" + " " + "boolean" + " " + "validateRange" + "(" + type + " " + "minRange" + "," + " " + type + " " + "maxRange" + "," + " " + newType + " " + "value" + ")" + " " + "{" + "\n";
        method = type.contentEquals("BigInteger") ? method + "        " + "BigInteger" + " " + YangIoUtils.getSmallCase("BigInteger") + " " + "=" + " " + "new" + " " + "BigInteger" + "(" + "\"" + " " + "\"" + " " + "+" + " " + "value" + ")" + ";" + "\n" + "        " + "return" + " " + YangIoUtils.getSmallCase("BigInteger") + "." + "compareTo" + "(" + "minRange" + ")" + " " + "=" + "=" + " 1" + " " + "&" + "&" + " " + YangIoUtils.getSmallCase("BigInteger") + "." + "compareTo" + "(" + "maxRange" + ")" + " " + "=" + "=" + " 1" + ";" + "\n" : method + "        " + "return" + " " + "value" + " " + ">" + "=" + " " + "minRange" + " " + "&" + "&" + " " + "value" + "<" + "=" + " " + "maxRange" + ";" + "\n";
        return method + "    " + "}" + "\n";
    }

    private static String ifConditionForIntInTypeDefConstructor(ValidatorTypeForUnionTypes type, boolean addFirst) {
        String condition = "        if (validateRange(";
        condition = type == ValidatorTypeForUnionTypes.INT_TYPE_CONFLICT ? (addFirst ? condition + "INT32_MIN_RANGE" + "," + " " + "INT32_MAX_RANGE" + "," + " " + "value" : condition + "UINT16_MIN_RANGE" + "," + " " + "UINT16_MAX_RANGE" + "," + " " + "value") : (addFirst ? condition + "INT64_MIN_RANGE" + "," + " " + "INT64_MAX_RANGE" + "," + " " + "value" : condition + "UINT32_MIN_RANGE" + "," + " " + "UINT32_MAX_RANGE" + "," + " " + "value");
        return condition + ")" + ")" + " " + "{" + "\n";
    }

    private static String getGetMethodWithArgument(String returnType, String yangName) {
        return "    " + returnType + " " + "get" + YangIoUtils.getCapitalCase(yangName) + "(" + returnType + "OpParam" + " " + YangIoUtils.getSmallCase(returnType) + ")" + ";";
    }

    public static String getAddToListMethodInterface(JavaAttributeInfo attr, String className) {
        return "    " + className + "Builder" + " " + "add" + YangIoUtils.getCapitalCase("to") + YangIoUtils.getCapitalCase(attr.getAttributeName()) + "(" + MethodsGenerator.getReturnType(attr) + " " + "value" + ")" + ";";
    }

    public static String getAddToListMethodImpl(JavaAttributeInfo attr, String generatedJavaClassName, boolean isRoot) {
        String retString = "";
        if (!isRoot) {
            retString = MethodsGenerator.getOverRideString();
        }
        return retString + "    " + "public" + " " + generatedJavaClassName + "Builder" + " " + "add" + YangIoUtils.getCapitalCase("to") + YangIoUtils.getCapitalCase(attr.getAttributeName()) + "(" + MethodsGenerator.getReturnType(attr) + " " + "value" + ")" + " " + "{" + "\n" + "        " + attr.getAttributeName() + "(" + ")" + "." + "add" + "(" + "value" + ")" + ";" + "\n" + "        " + "return" + " " + "this" + ";" + "\n" + "    " + "}";
    }

    static String builderMethod(String name) {
        return "\n" + JavaDocGen.generateForBuilderMethod(name) + "    " + "public" + " " + "static" + " " + name + "Builder" + " " + YangIoUtils.getSmallCase("Builder") + "(" + ")" + " " + "{" + "\n" + "        " + "return" + " " + "new" + " " + name + "Builder" + "(" + ")" + ";" + "\n" + "    " + "}";
    }

    static String processSubtreeFilteringInterface(String name) {
        String method = "    /**\n     * Checks if the passed " + name + " maps the content match query condition.\n" + "     *\n" + "     * @param " + YangIoUtils.getSmallCase(name) + " " + YangIoUtils.getSmallCase(name) + " " + "being passed to check" + " for" + " content match\n" + "     * @return match result\n" + "     */\n";
        return method + "    " + name + " " + "processSubtreeFiltering" + "(" + name + " " + YangIoUtils.getSmallCase(name) + "," + " " + "boolean" + " " + "isSelectAllSchemaChild" + ")" + ";" + "\n";
    }

    static String isLeafValueSetInterface() {
        String method = "    /**\n     * Checks if the leaf value is set.\n     *\n     * @param leaf leaf whose value status needs to checked\n     * @return result of leaf value set in object\n     */\n";
        return method + "    " + "boolean" + " " + "isLeafValueSet" + "(" + "LeafIdentifier" + " " + "leaf" + ")" + ";" + "\n";
    }

    static String isSelectLeafSetInterface() {
        String method = "    /**\n     * Checks if the leaf is set to be a selected leaf.\n     *\n     * @param leaf if leaf needs to be selected\n     * @return result of leaf value set in object\n     */\n";
        return method + "    " + "boolean" + " " + "isSelectLeaf" + "(" + "LeafIdentifier" + " " + "leaf" + ")" + ";" + "\n";
    }

    static String setSelectLeafSetInterface(String name) {
        String method = "    /**\n     * Set a leaf to be selected.\n     *\n     * @param leaf leaf needs to be selected\n     */\n";
        return method + "    " + name + "Builder" + " " + "selectLeaf" + "(" + "LeafIdentifier" + " " + "leaf" + ")" + ";" + "\n";
    }

    static String getInterfaceLeafIdEnumSignature(String name) {
        String start = "    /**\n     * Identify the leaf of " + name + "." + "\n" + "     */\n";
        return start + "    " + "public" + " " + "enum" + " " + "LeafIdentifier" + " " + "{" + "\n";
    }

    static String getInterfaceLeafIdEnumMethods() {
        return "        private int leafIndex;\n\n        public int getLeafIndex() {\n            return leafIndex;\n        }\n\n        LeafIdentifier(int value) {\n            this.leafIndex = value;\n        }\n    }\n";
    }

    static String getOperationAttributesGetters() {
        return "\n    /**\n     * Returns the valueLeafFlags.\n     *\n     * @return value of valueLeafFlags\n     */\n    public BitSet getValueLeafFlags() {\n        return valueLeafFlags;\n    }\n\n    /**\n     * Returns the selectLeafFlags.\n     *\n     * @return value of selectLeafFlags\n     */\n    public BitSet getSelectLeafFlags() {\n        return selectLeafFlags;\n    }\n\n";
    }

    static String getGetterForOperationType() {
        return "    /**\n     * Returns the operationType.\n     *\n     * @return value of operationType\n     */\n    public OperationType getOperationType() {\n        return operationType;\n    }\n";
    }

    static String getGettersForValueAndSelectLeaf() {
        return "\n    @Override\n    public boolean isLeafValueSet(LeafIdentifier leaf) {\n        return getValueLeafFlags().get(leaf.getLeafIndex());\n    }\n\n    @Override\n    public boolean isSelectLeaf(LeafIdentifier leaf) {\n        return getSelectLeafFlags().get(leaf.getLeafIndex());\n    }\n";
    }

    static String getSetterForOperationType(String name) {
        return "    /**\n     * Set operation type.\n     *\n     * @param operationType operation type\n     */\n    public " + name + "Builder" + " setOperationType(OperationType operationType) {\n" + "       this.operationType = operationType;\n" + "       return this;\n" + "    }\n";
    }

    static String getSetterForSelectLeaf(String name, boolean isRootNode) {
        String append = "@Override";
        if (isRootNode) {
            append = "";
        }
        return "\n    " + append + "\n" + "    public " + name + "Builder" + " selectLeaf(LeafIdentifier leaf) {\n" + "        getSelectLeafFlags().set(leaf.getLeafIndex());\n" + "        return this;\n" + "    }\n";
    }

    private static String getListAttribute(String attrType, YangCompilerAnnotation compilerAnnotation) {
        String listAttr;
        if (compilerAnnotation != null && compilerAnnotation.getYangAppDataStructure() != null) {
            switch (compilerAnnotation.getYangAppDataStructure().getDataStructure()) {
                case QUEUE: {
                    listAttr = "Queue<" + attrType + ">";
                    break;
                }
                case SET: {
                    listAttr = "Set<" + attrType + ">";
                    break;
                }
                case LIST: {
                    listAttr = MethodsGenerator.getListString() + attrType + ">";
                    break;
                }
                default: {
                    listAttr = MethodsGenerator.getListString() + attrType + ">";
                    break;
                }
            }
        } else {
            listAttr = MethodsGenerator.getListString() + attrType + ">";
        }
        return listAttr;
    }
}

