/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.translator.tojava.utils;

import java.io.IOException;
import org.onosproject.yangutils.datamodel.YangAugment;
import org.onosproject.yangutils.datamodel.YangCase;
import org.onosproject.yangutils.datamodel.YangChoice;
import org.onosproject.yangutils.datamodel.YangLeafRef;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.YangType;
import org.onosproject.yangutils.datamodel.utils.builtindatatype.YangDataTypes;
import org.onosproject.yangutils.translator.tojava.JavaAttributeInfo;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoContainer;
import org.onosproject.yangutils.translator.tojava.JavaFileInfoTranslator;
import org.onosproject.yangutils.translator.tojava.TempJavaCodeFragmentFilesContainer;
import org.onosproject.yangutils.translator.tojava.utils.JavaFileGeneratorUtils;
import org.onosproject.yangutils.translator.tojava.utils.MethodsGenerator;
import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class SubtreeFilteringMethodsGenerator {
    private SubtreeFilteringMethodsGenerator() {
    }

    public static String getSubtreeFilteringForLeaf(JavaAttributeInfo javaAttributeInfo, YangType<?> type) {
        String attributeName = javaAttributeInfo.getAttributeName();
        String attrQualifiedType = SubtreeFilteringMethodsGenerator.getIfFilterContentMatchMethodImpl(attributeName, type);
        return "        if (getValueLeafFlags().get(LeafIdentifier." + attributeName.toUpperCase() + "." + "getLeafIndex()" + ")" + ")" + " " + "{" + "\n" + "            " + "if" + " " + "(" + attrQualifiedType + ")" + " " + "{" + "\n" + "                " + "return" + " " + "false" + ";" + "\n" + "            " + "}" + " " + "else" + " " + "{" + "\n" + "                " + "subTreeFilteringResultBuilder" + "." + attributeName + "(" + "appInstance" + "." + attributeName + "(" + ")" + ")" + ";" + "\n" + "            " + "}" + "\n" + "        " + "}" + " " + "else" + " " + "if" + " " + "(" + "getSelectLeafFlags" + "()" + "." + "get" + "(" + "LeafIdentifier" + "." + attributeName.toUpperCase() + "." + "getLeafIndex()" + ")" + " " + "||" + " " + "isSelectAllSchemaChild" + ")" + " " + "{" + "\n" + "            " + "isAnySelectOrContainmentNode" + " " + "=" + " " + "true" + ";" + "\n" + "            " + "subTreeFilteringResultBuilder" + "." + attributeName + "(" + "appInstance" + "." + attributeName + "()" + ")" + ";" + "\n" + "        " + "}" + "\n";
    }

    private static String getAttrTypeForFilterContentMatchWhenPrimitiveDataType(String attributeName) {
        return "appInstance." + attributeName + "(" + ")" + " " + "!" + "=" + " " + attributeName + "(" + ")";
    }

    private static String getAttrTypeForFilterContentMatchWhenNonPrimitiveDataTypes(String attributeName) {
        return "appInstance." + attributeName + "(" + ")" + " " + "=" + "=" + " " + "null" + " " + "||" + " " + "!" + "(" + attributeName + "(" + ")" + "." + "equals" + "(" + "appInstance" + "." + attributeName + "(" + ")" + ")" + ")";
    }

    private static String getIfFilterContentMatchMethodImpl(String attributeName, YangType dataType) {
        YangType type;
        String attrQualifiedType = MethodsGenerator.isPrimitiveDataType(dataType.getDataType()) ? SubtreeFilteringMethodsGenerator.getAttrTypeForFilterContentMatchWhenPrimitiveDataType(attributeName) : (dataType.getDataType() == YangDataTypes.LEAFREF ? (MethodsGenerator.isPrimitiveDataType((type = ((YangLeafRef)dataType.getDataTypeExtendedInfo()).getEffectiveDataType()).getDataType()) ? SubtreeFilteringMethodsGenerator.getAttrTypeForFilterContentMatchWhenPrimitiveDataType(attributeName) : SubtreeFilteringMethodsGenerator.getAttrTypeForFilterContentMatchWhenNonPrimitiveDataTypes(attributeName)) : SubtreeFilteringMethodsGenerator.getAttrTypeForFilterContentMatchWhenNonPrimitiveDataTypes(attributeName));
        return attrQualifiedType;
    }

    public static String getSubtreeFilteringForLeafList(JavaAttributeInfo javaAttributeInfo) {
        return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForList(javaAttributeInfo, true);
    }

    static String getProcessChildNodeSubtreeFiltering(YangNode curNode, YangPluginConfig pluginConfig, String path) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        if (curNode instanceof YangCase) {
            instance = "instance";
            YangNode parent = curNode.getParent();
            if (parent instanceof YangChoice) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                name = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            } else if (parent instanceof YangAugment) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((YangAugment)parent).getAugmentedNode()).getJavaFileInfo();
                name = parentInfo != null ? YangIoUtils.getCapitalCase(parentInfo.getJavaName()) : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangAugment)parent).getAugmentedNode().getName(), pluginConfig.getConflictResolver()));
            }
        }
        String processSubtreeFilteringMethod = "    private boolean processChildNodesSubTreeFiltering(" + name + " " + instance + "," + " " + builderNamePrefix + "Builder" + " " + "subTreeFilteringResultBuilder" + "," + "\n" + "            " + "Boolean isAnySelectOrContainmentNode, " + "boolean isSelectAllSchemaChild" + ")" + " " + "{" + "\n";
        if (curNode instanceof YangCase) {
            String caseName = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
            processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        " + caseName + " " + "appInstance" + " " + "=" + " " + "(" + caseName + ")" + " " + instance + ";" + "\n";
        }
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + JavaFileGeneratorUtils.getDataFromTempFileHandle(0x2000000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path);
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        return true;\n    }\n\n";
        return processSubtreeFilteringMethod;
    }

    static String getProcessLeafListSubtreeFiltering(YangNode curNode, YangPluginConfig pluginConfig, String path) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        if (curNode instanceof YangCase) {
            instance = "instance";
            YangNode parent = curNode.getParent();
            if (parent instanceof YangChoice) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                name = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            } else if (parent instanceof YangAugment) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((YangAugment)parent).getAugmentedNode()).getJavaFileInfo();
                name = parentInfo != null ? YangIoUtils.getCapitalCase(parentInfo.getJavaName()) : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangAugment)parent).getAugmentedNode().getName(), pluginConfig.getConflictResolver()));
            }
        }
        String processSubtreeFilteringMethod = "    private boolean processLeafListSubTreeFiltering(" + name + " " + instance + "," + " " + builderNamePrefix + "Builder" + " " + "subTreeFilteringResultBuilder" + "," + "\n" + "            " + "Boolean isAnySelectOrContainmentNode, " + "boolean isSelectAllSchemaChild" + ")" + " " + "{" + "\n";
        if (curNode instanceof YangCase) {
            String caseName = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
            processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        " + caseName + " " + "appInstance" + " " + "=" + " " + "(" + caseName + ")" + " " + instance + ";" + "\n";
        }
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + JavaFileGeneratorUtils.getDataFromTempFileHandle(0x1000000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path);
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        return true;\n    }\n\n";
        return processSubtreeFilteringMethod;
    }

    static String getProcessLeafSubtreeFiltering(YangNode curNode, YangPluginConfig pluginConfig, String path) throws IOException {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        if (curNode instanceof YangCase) {
            instance = "instance";
            YangNode parent = curNode.getParent();
            if (parent instanceof YangChoice) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                name = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            } else if (parent instanceof YangAugment) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((YangAugment)parent).getAugmentedNode()).getJavaFileInfo();
                name = parentInfo != null ? YangIoUtils.getCapitalCase(parentInfo.getJavaName()) : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangAugment)parent).getAugmentedNode().getName(), pluginConfig.getConflictResolver()));
            }
        }
        String processSubtreeFilteringMethod = "    private boolean processLeafSubtreeFiltering(" + name + " " + instance + "," + " " + builderNamePrefix + "Builder" + " " + "subTreeFilteringResultBuilder" + "," + "\n" + "            " + "Boolean isAnySelectOrContainmentNode, " + "boolean isSelectAllSchemaChild" + ")" + " " + "{" + "\n";
        if (curNode instanceof YangCase) {
            String caseName = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
            processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        " + caseName + " " + "appInstance" + " " + "=" + " " + "(" + caseName + ")" + " " + instance + ";" + "\n";
        }
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + JavaFileGeneratorUtils.getDataFromTempFileHandle(0x800000, ((TempJavaCodeFragmentFilesContainer)curNode).getTempJavaCodeFragmentFiles().getBeanTempFiles(), path);
        processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        return true;\n    }\n\n";
        return processSubtreeFilteringMethod;
    }

    static String getProcessSubtreeFilteringStart(YangNode curNode, YangPluginConfig pluginConfig) {
        JavaFileInfoTranslator javaFileInfo = ((JavaFileInfoContainer)curNode).getJavaFileInfo();
        String instance = "appInstance";
        String name = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        String builderNamePrefix = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
        if (curNode instanceof YangCase) {
            instance = "instance";
            YangNode parent = curNode.getParent();
            if (parent instanceof YangChoice) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)parent).getJavaFileInfo();
                name = YangIoUtils.getCapitalCase(parentInfo.getJavaName());
            } else if (parent instanceof YangAugment) {
                JavaFileInfoTranslator parentInfo = ((JavaFileInfoContainer)((YangAugment)parent).getAugmentedNode()).getJavaFileInfo();
                name = parentInfo != null ? YangIoUtils.getCapitalCase(parentInfo.getJavaName()) : YangIoUtils.getCapitalCase(YangIoUtils.getCamelCase(((YangAugment)parent).getAugmentedNode().getName(), pluginConfig.getConflictResolver()));
            }
        }
        String processSubtreeFilteringMethod = MethodsGenerator.getOverRideString() + "    " + "public" + " " + name + " " + "processSubtreeFiltering" + "(" + name + " " + instance + "," + " " + "boolean" + " " + "isSelectAllSchemaChild" + ")" + " " + "{" + "\n" + "        " + builderNamePrefix + "Builder" + " " + "subTreeFilteringResultBuilder" + " " + "=" + " " + "new" + " " + builderNamePrefix + "Builder" + "(" + ")" + ";" + "\n" + "        " + "Boolean" + " " + "isAnySelectOrContainmentNode" + " " + "=" + " " + "false" + ";" + "\n";
        if (curNode instanceof YangCase) {
            String caseName = YangIoUtils.getCapitalCase(javaFileInfo.getJavaName());
            processSubtreeFilteringMethod = processSubtreeFilteringMethod + "        " + caseName + " " + "appInstance" + " " + "=" + " " + "(" + caseName + ")" + " " + instance + ";" + "\n";
        }
        return processSubtreeFilteringMethod;
    }

    static String getProcessSubtreeFunctionBody() {
        String method = MethodsGenerator.getIfConditionBegin("        ", "!processLeafSubtreeFiltering(appInstance, subTreeFilteringResultBuilder,\n            isAnySelectOrContainmentNode, isSelectAllSchemaChild)");
        method = method + "            return null;\n";
        method = method + MethodsGenerator.getBlockEnd("        ");
        method = method + MethodsGenerator.getIfConditionBegin("        ", "!processLeafListSubTreeFiltering(appInstance, subTreeFilteringResultBuilder,\n            isAnySelectOrContainmentNode, isSelectAllSchemaChild)");
        method = method + "            return null;\n";
        method = method + MethodsGenerator.getBlockEnd("        ");
        method = method + MethodsGenerator.getIfConditionBegin("        ", "!processChildNodesSubTreeFiltering(appInstance, subTreeFilteringResultBuilder,\n            isAnySelectOrContainmentNode, isSelectAllSchemaChild)");
        method = method + "            return null;\n";
        method = method + MethodsGenerator.getBlockEnd("        ");
        return method;
    }

    public static String getSubtreeFilteringForNode(JavaAttributeInfo attr) {
        boolean isList = attr.isListAttr();
        if (isList) {
            return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForList(attr, false);
        }
        return SubtreeFilteringMethodsGenerator.getSubtreeFilteringForChildNode(attr);
    }

    static String getProcessSubTreeFilteringEnd() {
        String method = MethodsGenerator.getIfConditionBegin("        ", "!isSelectAllSchemaChild && !isAnySelectOrContainmentNode");
        method = method + "            return processSubtreeFiltering(appInstance, true);\n";
        method = method + MethodsGenerator.getBlockEnd("        ");
        method = method + "        return subTreeFilteringResultBuilder.build();\n    }\n";
        return method;
    }

    private static String getSubtreeFilteringForChildNode(JavaAttributeInfo javaAttributeInfo) {
        String name = javaAttributeInfo.getAttributeName();
        name = YangIoUtils.getSmallCase(name);
        String type = javaAttributeInfo.getImportInfo().getClassInfo();
        if (javaAttributeInfo.isQualifiedName()) {
            type = javaAttributeInfo.getImportInfo().getPkgInfo() + "." + type;
        }
        String method = MethodsGenerator.getIfConditionBegin("        ", name + "()  != null");
        method = method + "            isAnySelectOrContainmentNode = true;\n";
        method = method + "            if (appInstance." + name + "(" + ")" + " " + "!" + "=" + " " + "null" + ")" + " " + "{" + "\n";
        method = method + "                " + type + " " + "result = " + name + "." + "processSubtreeFiltering" + "(" + "appInstance" + "." + name + "()" + "," + " " + "false" + ")" + ";" + "\n";
        method = method + "                if (result != null) {\n";
        method = method + "                    subTreeFilteringResultBuilder." + name + "(" + "result" + ")" + ";" + "\n" + "                " + "}" + "\n";
        method = method + MethodsGenerator.getBlockEnd("            ");
        method = method + MethodsGenerator.getBlockEnd("        ");
        return method;
    }

    private static String getSubtreeFilteringForList(JavaAttributeInfo javaAttributeInfo, boolean isLeafList) {
        String capitalCaseName = YangIoUtils.getCapitalCase(javaAttributeInfo.getAttributeName());
        String name = javaAttributeInfo.getAttributeName();
        String type = javaAttributeInfo.getImportInfo().getClassInfo();
        if (javaAttributeInfo.isQualifiedName()) {
            type = javaAttributeInfo.getImportInfo().getPkgInfo() + "." + type;
        }
        String method = MethodsGenerator.getIfConditionBegin("        ", "isSelectAllSchemaChild");
        method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("            ", type + " " + name, "appInstance." + name + "()");
        method = method + "                " + "subTreeFilteringResultBuilder" + "." + "add" + YangIoUtils.getCapitalCase("to") + capitalCaseName + "(" + name + ")" + ";" + "\n";
        method = method + MethodsGenerator.getBlockEnd("            ");
        method = method + MethodsGenerator.getElseIfConditionBegin("        ", name + "()" + " " + "!" + "=" + " " + "null");
        if (!isLeafList) {
            method = method + "            isAnySelectOrContainmentNode = true;\n";
        }
        method = method + MethodsGenerator.getIfConditionBegin("            ", "!" + name + "()" + "." + "isEmpty()");
        if (isLeafList) {
            method = method + MethodsGenerator.getIfConditionBegin("                ", "appInstance." + name + "()" + " " + "=" + "=" + " " + "null" + " " + "||" + " " + "appInstance" + "." + name + "()" + "." + "isEmpty()");
            method = method + "                    return false;\n";
            method = method + MethodsGenerator.getBlockEnd("                ");
            method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("                ", type + " " + name, name + "()");
            method = method + "                    boolean flag = false;\n";
            method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("                    ", type + " " + name + "2", "appInstance." + name + "()");
            method = method + MethodsGenerator.getIfConditionBegin("                        ", name + "." + "equals" + "(" + name + "2" + ")");
            method = method + "                            flag = true;\n";
            method = method + "                            subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + capitalCaseName + "(" + name + "2" + ")" + ";" + "\n" + "                            " + "break" + ";" + "\n";
            method = method + MethodsGenerator.getBlockEnd("                        ");
            method = method + MethodsGenerator.getBlockEnd("                    ");
            method = method + MethodsGenerator.getIfConditionBegin("                    ", "!flag");
            method = method + "                        return false;\n";
            method = method + MethodsGenerator.getBlockEnd("                    ");
            method = method + MethodsGenerator.getBlockEnd("                ");
        } else {
            method = method + MethodsGenerator.getIfConditionBegin("                ", "appInstance." + name + "()" + " " + "!" + "=" + " " + "null" + " " + "&&" + " " + "!" + "appInstance" + "." + name + "()" + "." + "isEmpty()");
            method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("                    ", type + " " + name, name + "()");
            method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("                        ", type + " " + name + "2", "appInstance." + name + "()");
            method = method + "                            " + type + " " + "result = " + name + "." + "processSubtreeFiltering" + "(" + name + "2" + "," + " " + "false" + ")" + ";" + "\n";
            method = method + "                            if (result != null) {\n";
            method = method + "                                subTreeFilteringResultBuilder.add" + YangIoUtils.getCapitalCase("to") + capitalCaseName + "(" + "result" + ")" + ";" + "\n" + "                            " + "}" + "\n";
            method = method + MethodsGenerator.getBlockEnd("                        ");
            method = method + MethodsGenerator.getBlockEnd("                    ");
            method = method + MethodsGenerator.getBlockEnd("                ");
        }
        method = method + "            } else {\n";
        if (isLeafList) {
            method = method + "                isAnySelectOrContainmentNode = true;\n";
        }
        method = method + MethodsGenerator.getIfConditionBegin("                ", "appInstance." + name + "()" + " " + "!" + "=" + " " + "null" + " " + "&&" + " " + "!" + "appInstance" + "." + name + "()" + "." + "isEmpty()");
        method = method + MethodsGenerator.getCollectionIteratorForLoopBegin("                    ", type + " " + name, "appInstance." + name + "()");
        method = method + "                        " + "subTreeFilteringResultBuilder" + "." + "add" + YangIoUtils.getCapitalCase("to") + capitalCaseName + "(" + name + ")" + ";" + "\n";
        method = method + MethodsGenerator.getBlockEnd("                    ");
        method = method + MethodsGenerator.getBlockEnd("                ");
        method = method + MethodsGenerator.getBlockEnd("            ");
        method = method + MethodsGenerator.getBlockEnd("        ");
        return method;
    }

    static String getAugmentableSubTreeFiltering() {
        return "        for (Object " + YangIoUtils.getSmallCase("YangAugmentedInfo") + " " + ":" + " " + "this" + "." + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "(" + ")" + "." + "value" + "s" + "(" + ")" + ")" + " " + "{" + "\n" + "            " + "Object" + " " + YangIoUtils.getSmallCase("YangAugmentedOpParamInfo") + " " + "=" + " " + "appInstance" + "." + YangIoUtils.getSmallCase("YangAugmentedInfo") + "(" + YangIoUtils.getSmallCase("YangAugmentedInfo") + "." + "getClass()" + ")" + ";" + "\n" + "            " + "Object" + " " + "processSubtreeFiltering" + ";" + "\n" + "            " + "try" + " " + "{" + "\n" + "                " + "Class<?>[] interfaces = " + YangIoUtils.getSmallCase("YangAugmentedInfo") + ".getClass().getInterfaces();" + "\n" + "                " + "processSubtreeFiltering" + " " + "=" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "." + "getClass()" + "\n" + "                    " + "." + "getMethod" + "(" + "\"" + "processSubtreeFiltering" + "\"" + "," + " " + "interfaces[0]" + ")" + "." + "invoke" + "(" + YangIoUtils.getSmallCase("YangAugmentedInfo") + "," + "\n" + "                        " + YangIoUtils.getSmallCase("YangAugmentedOpParamInfo") + ")" + ";" + "\n" + "                " + "if" + " " + "(" + "processSubtreeFiltering" + " " + "!" + "=" + " " + "null" + ")" + " " + "{" + "\n" + "                    " + "subTreeFilteringResultBuilder" + "." + "add" + "YangAugmentedInfo" + "(" + "processSubtreeFiltering" + "," + " " + "processSubtreeFiltering" + "." + "getClass()" + ")" + ";" + "\n" + "                " + "}" + "\n" + "            " + "}" + " " + "catch" + " " + "(" + "NoSuchMethodException" + " | " + "InvocationTargetException" + " | " + "IllegalAccessException" + " " + "e" + ")" + " " + "{" + "\n" + "                " + "continue" + ";" + "\n" + "            " + "}" + "\n" + "        " + "}" + "\n";
    }
}

