/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    static void appendFileContents(File toAppend, File srcFile) throws IOException {
        FileSystemUtil.updateFileHandle(srcFile, "\n" + FileSystemUtil.readAppendFile(toAppend.toString(), "    "), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAppendFile(String toAppend, String spaces) throws IOException {
        FileReader fileReader = new FileReader(toAppend);
        BufferedReader bufferReader = new BufferedReader(fileReader);
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String line = bufferReader.readLine();
            while (line != null) {
                switch (line) {
                    case " ": 
                    case "": 
                    case "        ": 
                    case "\n\n": {
                        stringBuilder.append("\n");
                        break;
                    }
                    case "    ": {
                        stringBuilder.append("");
                        break;
                    }
                    default: {
                        String append = spaces + line;
                        stringBuilder.append(append);
                        stringBuilder.append("\n");
                    }
                }
                line = bufferReader.readLine();
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            fileReader.close();
            bufferReader.close();
        }
    }

    static void updateFileHandle(File inputFile, String contentTobeAdded, boolean isClose) throws IOException {
        ArrayList<FileWriter> fileWriterStore = new ArrayList<FileWriter>();
        FileWriter fileWriter = new FileWriter(inputFile, true);
        fileWriterStore.add(fileWriter);
        PrintWriter outputPrintWriter = new PrintWriter((Writer)fileWriter, true);
        if (!isClose) {
            outputPrintWriter.write(contentTobeAdded);
            outputPrintWriter.flush();
            outputPrintWriter.close();
        } else {
            for (FileWriter curWriter : fileWriterStore) {
                curWriter.flush();
                curWriter.close();
            }
        }
    }

    public static void closeFile(File file, boolean toBeDeleted) throws IOException {
        if (file != null) {
            boolean deleted;
            FileSystemUtil.updateFileHandle(file, null, true);
            if (toBeDeleted && !(deleted = file.delete())) {
                throw new IOException("Failed to delete temporary file " + file.getName());
            }
        }
    }
}

