/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.utils.io.impl;

import org.onosproject.yangutils.utils.io.YangPluginConfig;
import org.onosproject.yangutils.utils.io.impl.YangIoUtils;

public final class JavaDocGen {
    private JavaDocGen() {
    }

    public static String getJavaDoc(JavaDocType type, String name, boolean isList, YangPluginConfig pluginConfig, String compilerAnnotation) {
        name = YangIoUtils.getSmallCase(YangIoUtils.getCamelCase(name, pluginConfig.getConflictResolver()));
        switch (type) {
            case IMPL_CLASS: {
                return JavaDocGen.generateForClass(name);
            }
            case BUILDER_CLASS: {
                return JavaDocGen.generateForBuilderClass(name);
            }
            case OPERATION_CLASS: {
                return JavaDocGen.generateForOpParamClass(name);
            }
            case OPERATION_BUILDER_CLASS: {
                return JavaDocGen.generateForOpParamClass(name);
            }
            case INTERFACE: {
                return JavaDocGen.generateForInterface(name);
            }
            case BUILDER_INTERFACE: {
                return JavaDocGen.generateForBuilderInterface(name);
            }
            case PACKAGE_INFO: {
                return JavaDocGen.generateForPackage(name, isList);
            }
            case GETTER_METHOD: {
                return JavaDocGen.generateForGetters(name, isList, compilerAnnotation);
            }
            case TYPE_DEF_SETTER_METHOD: {
                return JavaDocGen.generateForTypeDefSetter(name);
            }
            case SETTER_METHOD: {
                return JavaDocGen.generateForSetters(name, isList, compilerAnnotation);
            }
            case MANAGER_SETTER_METHOD: {
                return JavaDocGen.generateForManagerSetters(name, isList, compilerAnnotation);
            }
            case OF_METHOD: {
                return JavaDocGen.generateForOf(name);
            }
            case DEFAULT_CONSTRUCTOR: {
                return JavaDocGen.generateForDefaultConstructors(name);
            }
            case BUILD_METHOD: {
                return JavaDocGen.generateForBuild(name);
            }
            case TYPE_CONSTRUCTOR: {
                return JavaDocGen.generateForTypeConstructor(name);
            }
            case FROM_METHOD: {
                return JavaDocGen.generateForFromString(name);
            }
            case ENUM_CLASS: {
                return JavaDocGen.generateForEnum(name);
            }
            case ENUM_ATTRIBUTE: {
                return JavaDocGen.generateForEnumAttr(name);
            }
            case RPC_INTERFACE: {
                return JavaDocGen.generateForRpcService(name);
            }
            case RPC_MANAGER: {
                return JavaDocGen.generateForClass(name);
            }
            case EVENT: {
                return JavaDocGen.generateForEvent(name);
            }
            case EVENT_LISTENER: {
                return JavaDocGen.generateForEventListener(name);
            }
            case EVENT_SUBJECT_CLASS: {
                return JavaDocGen.generateForClass(name);
            }
            case ADD_TO_LIST: {
                return JavaDocGen.generateForAddToList(name);
            }
        }
        return JavaDocGen.generateForConstructors(name);
    }

    private static String generateForEnumAttr(String name) {
        return "        /**\n         * Represents " + name + "." + "\n" + "        " + " */\n";
    }

    public static String generateJavaDocForRpc(String rpcName, String inputName, String outputName, YangPluginConfig pluginConfig) {
        rpcName = YangIoUtils.getCamelCase(rpcName, pluginConfig.getConflictResolver());
        String javadoc = "\n    /**\n     * Service interface of " + rpcName + "." + "\n" + "    " + " *\n";
        if (!inputName.equals("")) {
            javadoc = javadoc + JavaDocGen.getInputString(inputName, rpcName);
        }
        if (!outputName.equals("void")) {
            javadoc = javadoc + JavaDocGen.getOutputString(outputName, rpcName);
        }
        return javadoc + "    " + " */\n";
    }

    private static String getOutputString(String outputName, String rpcName) {
        return "     * @return " + outputName + " " + "output of service interface " + rpcName + "\n";
    }

    private static String getInputString(String inputName, String rpcName) {
        if (inputName.equals("")) {
            return null;
        }
        return "     * @param " + inputName + " " + "input of service interface " + rpcName + "\n";
    }

    private static String generateForRpcService(String interfaceName) {
        return "\n/**\n * Abstraction of an entity which represents the functionality of " + interfaceName + "." + "\n" + " */\n";
    }

    private static String generateForEvent(String eventClassName) {
        return "\n/**\n * Represents event implementation of " + eventClassName + "." + "\n" + " */\n";
    }

    private static String generateForEventListener(String eventListenerInterfaceName) {
        return "\n/**\n * Abstraction for event listener of " + eventListenerInterfaceName + "." + "\n" + " */\n";
    }

    private static String generateForGetters(String attribute, boolean isList, String compilerAnnotation) {
        String getter = "\n    /**\n     * Returns the attribute " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @return ";
        if (isList) {
            String attrParam;
            if (compilerAnnotation != null) {
                switch (compilerAnnotation) {
                    case "Queue": {
                        attrParam = "Queue".toLowerCase() + " " + "of" + " ";
                        break;
                    }
                    case "Set": {
                        attrParam = "Set".toLowerCase() + " " + "of" + " ";
                        break;
                    }
                    case "List": {
                        attrParam = "List".toLowerCase() + " " + "of" + " ";
                        break;
                    }
                    default: {
                        attrParam = "List".toLowerCase() + " " + "of" + " ";
                        break;
                    }
                }
            } else {
                attrParam = "List".toLowerCase() + " " + "of" + " ";
            }
            getter = getter + attrParam;
        } else {
            getter = getter + "value" + " " + "of" + " ";
        }
        getter = getter + attribute + "\n" + "    " + " */\n";
        return getter;
    }

    private static String generateForSetters(String attribute, boolean isList, String compilerAnnotation) {
        String setter = "\n    /**\n     * Returns the builder object of " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + attribute + " ";
        if (compilerAnnotation != null) {
            switch (compilerAnnotation) {
                case "Queue": {
                    String attributeParam = "Queue".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "Set": {
                    String attributeParam = "Set".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "List": {
                    String attributeParam = "List".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
            }
        } else if (isList) {
            String attributeParam = "List".toLowerCase() + " " + "of" + " ";
            setter = setter + attributeParam;
        } else {
            setter = setter + "value" + " " + "of" + " ";
        }
        setter = setter + attribute + "\n" + "    " + " * @return " + "builder object of " + attribute + "\n" + "    " + " */\n";
        return setter;
    }

    private static String generateForManagerSetters(String attribute, boolean isList, String compilerAnnotation) {
        String setter = "\n    /**\n     * Sets the value to attribute " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + attribute + " ";
        if (compilerAnnotation != null) {
            switch (compilerAnnotation) {
                case "Queue": {
                    String attributeParam = "Queue".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "Set": {
                    String attributeParam = "Set".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
                case "List": {
                    String attributeParam = "List".toLowerCase() + " " + "of" + " ";
                    setter = setter + attributeParam;
                    break;
                }
            }
        } else if (isList) {
            String attributeParam = "List".toLowerCase() + " " + "of" + " ";
            setter = setter + attributeParam;
        } else {
            setter = setter + "value" + " " + "of" + " ";
        }
        setter = setter + attribute + "\n" + "    " + " */\n";
        return setter;
    }

    private static String generateForOf(String attribute) {
        return "\n    /**\n     * Returns the object of " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "value" + " " + "value" + " " + "of" + " " + attribute + "\n" + "    " + " * @return " + "Object" + " " + "of" + " " + attribute + "\n" + "    " + " */\n";
    }

    private static String generateForFromString(String attribute) {
        return "\n    /**\n     * Returns the object of " + attribute + " " + "fromString" + " " + "input" + " " + "String" + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "valInString" + " " + "input" + " " + "String" + "\n" + "    " + " * @return " + "Object" + " " + "of" + " " + attribute + "\n" + "    " + " */\n";
    }

    private static String generateForTypeDefSetter(String attribute) {
        return "\n    /**\n     * Sets the value of " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "value" + " " + "value" + " " + "of" + " " + attribute + "\n" + "    " + " */\n";
    }

    private static String generateForClass(String className) {
        return "\n/**\n * Represents the implementation of " + className + "." + "\n" + " */\n";
    }

    private static String generateForEnum(String className) {
        return "\n\n/**\n * Represents ENUM data of " + className + "." + "\n" + " */\n";
    }

    private static String generateForBuilderClass(String className) {
        return "\n/**\n * Represents the builder implementation of " + className + "." + "\n" + " */\n";
    }

    private static String generateForOpParamClass(String className) {
        return "\n/**\n * Represents operation parameter implementation of " + className + "." + "\n" + " */\n";
    }

    private static String generateForInterface(String interfaceName) {
        return "\n/**\n * Abstraction of an entity which represents the functionality of " + interfaceName + "." + "\n" + " */\n";
    }

    private static String generateForBuilderInterface(String builderForName) {
        return "/**\n * Builder for " + builderForName + "." + "\n" + " */\n";
    }

    private static String generateForPackage(String packageName, boolean isChildNode) {
        String javaDoc = "/**\n * Implementation of YANG node " + packageName;
        if (isChildNode) {
            javaDoc = javaDoc + "'s children nodes";
        }
        return javaDoc + "." + "\n" + " */\n";
    }

    private static String generateForDefaultConstructors(String className) {
        return "    /**\n     * Creates an instance of " + className + "." + "\n" + "    " + " */\n";
    }

    private static String generateForConstructors(String className) {
        return "\n    /**\n     * Creates an instance of " + className + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "Builder".toLowerCase() + "Object" + " " + "builder object of " + className + "\n" + "    " + " */\n";
    }

    private static String generateForBuild(String buildName) {
        return "\n    /**\n     * Builds object of " + buildName + "." + "\n" + "    " + " *\n" + "    " + " * @return " + "object of " + buildName + "." + "\n" + "    " + " */\n";
    }

    private static String generateForTypeConstructor(String attribute) {
        return "\n    /**\n     * Creates an instance of " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "value" + " " + "value" + " " + "of" + " " + attribute + "\n" + "    " + " */\n";
    }

    public static String generateForAddAugmentation() {
        return "\n    /**\n     * Sets the value of " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "Map" + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "value" + " " + "value" + " " + "of" + " " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "\n" + "    " + " * @param " + "class" + "Object" + " " + "value" + " " + "of" + " " + "Augmented" + "class" + "\n" + "    " + " */\n";
    }

    public static String generateForGetAugmentation() {
        return "\n    /**\n     * Returns the attribute " + YangIoUtils.getSmallCase("YangAugmentedInfo") + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "class" + "Object" + " " + "value" + " " + "of" + " " + "Augmented" + "class" + "\n" + "    " + " * @return " + "value" + " " + "of" + " " + "YangAugmentedInfo" + "\n" + "    " + " */\n";
    }

    public static String generateForValidatorMethod() {
        return "\n    /**\n     * Validates if value is in given range.\n     *\n     * @param minRange minRange of value\n     * @param maxRange maxRange of value\n     * @param value value\n     * @return true if value is in range\n     */\n";
    }

    public static String generateForGetMethodWithAttribute(String attribute) {
        return "\n    /**\n     * Returns the attribute " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + YangIoUtils.getSmallCase(attribute) + " " + "value" + " " + "of" + " " + attribute + "\n" + "    " + " * @return " + "value" + " " + "of" + " " + attribute + "\n" + "    " + " */\n";
    }

    private static String generateForAddToList(String attribute) {
        String javadoc = "\n    /**\n     * Adds to the list of " + attribute + "." + "\n" + "    " + " *\n" + "    " + " * @param " + "value" + " ";
        javadoc = javadoc + "value" + " " + "of" + " ";
        javadoc = javadoc + attribute + "\n" + "    " + " */\n";
        return javadoc;
    }

    public static String generateForBuilderMethod(String attribute) {
        String javadoc = "    /**\n     * Returns the attribute " + attribute + "Builder" + "." + "\n" + "    " + " *\n" + "    " + " * @return ";
        javadoc = javadoc + "value" + " " + "of" + " ";
        javadoc = javadoc + attribute + "Builder" + "\n" + "    " + " */\n";
        return javadoc;
    }

    public static enum JavaDocType {
        IMPL_CLASS,
        BUILDER_CLASS,
        INTERFACE,
        BUILDER_INTERFACE,
        PACKAGE_INFO,
        GETTER_METHOD,
        RPC_INTERFACE,
        RPC_MANAGER,
        EVENT,
        EVENT_LISTENER,
        SETTER_METHOD,
        TYPE_DEF_SETTER_METHOD,
        OF_METHOD,
        DEFAULT_CONSTRUCTOR,
        CONSTRUCTOR,
        FROM_METHOD,
        TYPE_CONSTRUCTOR,
        BUILD_METHOD,
        ENUM_CLASS,
        ENUM_ATTRIBUTE,
        MANAGER_SETTER_METHOD,
        EVENT_SUBJECT_CLASS,
        OPERATION_CLASS,
        OPERATION_BUILDER_CLASS,
        ADD_TO_LIST;

    }
}

