/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.app;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangRevision;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.plugin.utils.YangApacheUtils;
import org.onosproject.yang.runtime.app.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.app.TestYangSchemaNodeProvider;

public class DefaultYangModelRegistryTest {
    private static final String SERVICE_NAME_3 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network3.rev20151208.IetfNetwork3Service";
    private static final String SCHEMA_NAME_3 = "ietf-network3";
    private static final String INTERFACE_NAME_3 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network3.rev20151208.IetfNetwork3";
    private static final String OP_PARAM_NAME_3 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network3.rev20151208.IetfNetwork3OpParam";
    private static final String SCHEMA_NAME_4_14 = "ietf-network4@2014-00-08";
    private static final String SCHEMA_NAME_4_15 = "ietf-network4@2015-00-08";
    private static final String SCHEMA_NAME_4_16 = "ietf-network4@2016-00-08";
    private static final String SCHEMA_NAME_4_17 = "ietf-network4@2017-00-08";
    private static final String SCHEMA_NAME_4 = "ietf-network4";
    private static final String SERVICE_NAME_REV_14 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20141208.IetfNetwork4Service";
    private static final String INTERFACE_NAME_REV_14 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20141208.IetfNetwork4";
    private static final String OP_PARAM_NAME_REV_14 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20141208.IetfNetwork4OpParam";
    private static final String SERVICE_NAME_REV_15 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20151208.IetfNetwork4Service";
    private static final String INTERFACE_NAME_REV_15 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20151208.IetfNetwork4";
    private static final String OP_PARAM_NAME_REV_15 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20151208.IetfNetwork4OpParam";
    private static final String SERVICE_NAME_REV_16 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20161208.IetfNetwork4Service";
    private static final String INTERFACE_NAME_REV_16 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20161208.IetfNetwork4";
    private static final String OP_PARAM_NAME_REV_16 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20161208.IetfNetwork4OpParam";
    private static final String SERVICE_NAME_REV_17 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20171208.IetfNetwork4Service";
    private static final String INTERFACE_NAME_REV_17 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20171208.IetfNetwork4";
    private static final String OP_PARAM_NAME_REV_17 = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.rev20171208.IetfNetwork4OpParam";
    private static final String SERVICE_NAME_NO_REV = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.IetfNetwork4Service";
    private static final String INTERFACE_NAME_NO_REV = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.IetfNetwork4";
    private static final String OP_PARAM_NAME_NO_REV = "org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.network4.IetfNetwork4OpParam";
    private static final String UN_REG_SCHEMA_NAME = "ietf-routing";
    private static final String UN_REG_INTERFACE_NAME = "IetfRouting";
    private static final String UN_REG_OP_PARAM_NAME = "IetfRoutingOpParam";
    private static final String UN_REG_SERVICE_NAME = "IetfRoutingService";
    private static final String CHECK = "check";
    private static final String DATE_NAMESPACE = "2015-00-08";
    private static final String NAMESPACE = "urn:ietf:params:xml:ns:yang:ietf-network4:check:namespace";
    private final TestYangSchemaNodeProvider provider = new TestYangSchemaNodeProvider();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testForGetSchemaNode() throws IOException {
        this.provider.processSchemaRegistry();
        DefaultYangModelRegistry registry = this.provider.registry();
        YangSchemaNode yangNode = registry.getForSchemaName(SCHEMA_NAME_3);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_3.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_3);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_3.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_3);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_3.equals(yangNode.getName())));
    }

    @Test
    public void testForGetSchemaNodeWhenNoRevision() throws IOException {
        this.provider.processSchemaRegistry();
        DefaultYangModelRegistry registry = this.provider.registry();
        YangSchemaNode yangNode = registry.getForSchemaName(SCHEMA_NAME_4_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(((YangNode)yangNode).getRevision() == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForAppName(SERVICE_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode != null ? 1 : 0)));
    }

    public void testForGetSchemaNodeWhenMultiRevision() throws IOException {
        this.provider.processSchemaRegistry();
        DefaultYangModelRegistry registry = this.provider.registry();
        YangSchemaNode yangNode = registry.getForSchemaName(SCHEMA_NAME_4_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        Class object = registry.getRegisteredClass(yangNode);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(object == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_15);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(((YangNode)yangNode).getRevision() == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_16);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4_16);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_REV_16);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_REV_16);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        object = registry.getRegisteredClass(yangNode);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(object == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_16);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(((YangNode)yangNode).getRevision() == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_17);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4_17);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_REV_17);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_REV_17);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        object = registry.getRegisteredClass(yangNode);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(object == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_17);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(((YangNode)yangNode).getRevision() == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        object = registry.getRegisteredClass(yangNode);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(object == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_NO_REV);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode != null ? 1 : 0)));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(((YangNode)yangNode).getRevision() != null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_14);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForSchemaName(SCHEMA_NAME_4_14);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForInterfaceFileName(INTERFACE_NAME_REV_14);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        yangNode = registry.getForOpPramFileName(OP_PARAM_NAME_REV_14);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)SCHEMA_NAME_4.equals(yangNode.getName())));
        object = registry.getRegisteredClass(yangNode);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(object == null ? 1 : 0)));
        yangNode = registry.getForAppName(SERVICE_NAME_REV_14);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(yangNode == null ? 1 : 0)));
    }

    @Test
    public void testGetNodeWrtNamespace() {
        this.provider.processSchemaRegistry();
        DefaultYangModelRegistry registry = this.provider.registry();
        YangSchemaNode yangNode = registry.getForNameSpace(NAMESPACE);
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)CHECK.equals(yangNode.getName())));
        YangRevision rev = ((YangNode)yangNode).getRevision();
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)(rev != null ? 1 : 0)));
        String date = YangApacheUtils.getDateInStringFormat((YangNode)((YangNode)yangNode));
        MatcherAssert.assertThat((Object)true, (Matcher)Is.is((Object)DATE_NAMESPACE.equals(date)));
    }
}

